<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Units extends CI_Controller
{
  public $page_data = array();

  function __construct()
  {
    parent::__construct();
    $this->initial();
  }

  public function initial()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");

    $this->load->model('User_model', 'User');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Client_model', 'Client');
    $this->load->model('Supplier_model', 'Supplier');
    $this->load->model('Material_model', 'Material');
    $this->load->model('Settings_model', 'Settings');

    //        Check User Logged in or Not
    $allowed_user_roles = array("auditor","madmin","admin","supervisor","general_manager","purchase_manager","accounts_manager","qs","qs_manager","procurement_engineer","project_manager","operation_manager");
    if($this->User->is_logged_in($allowed_user_roles)==false){
      redirect(base_url(), 'refresh');
    }
    //        File Directory
    $this->page_data['directory'] = "materials";

  }

  public function index()
  {
    $this->view();
  }

  public function view()
  {
    $this->page_data['page_name'] = 'measure_units';
    $this->load->view('Index', $this->page_data);
  }
  public function select_units(){

    $json_data=array();
    $j=0;

    $data=array();
    $data['delete_status'] = 0;
    $result	= $this->Material->select_unit("",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();

    foreach($result_array as $row):
      $btn_edit='';
      if($this->session->userdata('branch_id') == 0){
        if($this->session->userdata('user_role')!='auditor'){
          $btn_edit='<a style="margin-left: 5px;margin-right: 5px" id="unit_edit_btn" href="#unit_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
          <i class="la la-edit"></i>
          </a>';
        }
      }

      $array[$j][]=$row->unit_id;
      $array[$j][]=$row->unit_name;
      $array[$j][]=$btn_edit;



      $j++;
    endforeach;

    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }
  public function create()
  {
    $json_data = array();
    $data2['unit_name'] = $this->security->xss_clean($this->input->post('name'));
    $count = $this->Material->select_unit("unit_id",array('unit_name' => $data2['unit_name']))->num_rows();
    if($count==0){
      $result2 = $this->Material->create_unit($data2);
      $flash_data['status'] = $result2['status'];
      if ($flash_data['status'] == 1) {
        $flash_data['flashdata_msg'] = 'Measure Unit Created Successfully!.';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';

      } else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    }else {
      $flash_data['status'] = 2;
      $flash_data['flashdata_msg'] = 'Sorry.. Submitted Unit Already Exists!';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }
    $flash_data['message'] = $flash_data['flashdata_msg'];
    echo json_encode($flash_data);
  }
  public function update()
  {
    $json_data = array();
    $data2['unit_id'] = $this->security->xss_clean($this->input->post('unit_id'));
    $data2['unit_name'] = $this->security->xss_clean($this->input->post('unit_name'));
    $count = $this->Material->select_unit("unit_id",array('unit_name' => $data2['unit_name'],'unit_id !=' => $data2['unit_id']))->num_rows();
    if($count==0) {
      $result2 = $this->Material->update_unit($data2);
      $json_data['status'] = $result2;
      $flash_data['status'] = $result2;
      if ($flash_data['status'] == 1) {
        $flash_data['flashdata_msg'] = 'Measure Unit Updated Successfully!.';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';

      } else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    }else {
      $flash_data['status'] = 2;
      $flash_data['flashdata_msg'] = 'Sorry.. Submitted Unit Already Exists!';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }
    echo json_encode($flash_data);

  }
  public function select(){
    $data['mu.delete_status'] = 0;
    if(isset($_POST['id']) && $_POST['id']!=""){
      $data['mu.unit_id'] = $_POST['id'];
    }
    $result	= $this->Material->select_unit("",$data);
    if($result->num_rows()>0) {
      foreach ($result->result() as $row):
        $id[] = $row->unit_id;
        $name[]  = $row->unit_name;
      endforeach;
      echo json_encode(array("count" => $result->num_rows(),"id" => $id,"name" => $name));
    }else{
      echo json_encode(array("count" => $result->num_rows()));
    }
  }
}
?>
