<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Settings extends CI_Controller
{
  public $page_data = array();

  function __construct()
  {
    parent::__construct();
    $this->initial();
  }

  public function initial()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");

    //        File Directory
    $this->page_data['directory'] = "settings";
    $this->load->model('Settings_model', 'Settings');
  }

  public function index()
  {

  }
  public function app_config()
  {
    $this->page_data['page_name'] = 'app_config';
    $this->load->view('Index',$this->page_data);
  }
  public function tax_types()
  {
    $this->page_data['page_name'] = 'tax_types';
    $this->load->view('Index',$this->page_data);
  }
  public function bank_accounts()
  {
    $this->page_data['page_name'] = 'bank_accounts';
    $this->load->view('Index',$this->page_data);
  }
  public function holidays()
  {
    $this->page_data['page_name'] = 'holidays';
    $this->load->view('Index',$this->page_data);
  }
  public function billing_address()
  {
    $this->page_data['page_name'] = 'billing_address';
    $this->load->view('Index',$this->page_data);
  }
  public function update()
  {
    $update_data['value'] = $this->security->xss_clean($this->input->post('calendar_date_restriction'));
    if($update_data['value']=='on'){
      $update_data['value'] = 1;
    }else{
      $update_data['value'] = 0;
    }
    $update_where['settings_name'] = 'calendar_date_restriction_enabled';
    $update_where['settings_category'] = 'User';
    $result = $this->Settings->update_settings_2($update_where,$update_data);
    if ($result == 1) {
      $flash_data['flashdata_msg'] = 'Settings Updated Successfully! ';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    $this->session->set_flashdata($flash_data);
    redirect(base_url().'settings/app_config','refresh');
  }

  public function create_tax_type()
  {
    $data['tax_percentage'] = $this->security->xss_clean($this->input->post('total_tax_percent'));
    $data['tax1_percent'] = $this->security->xss_clean($this->input->post('tax1_percent'));
    $data['tax2_percent'] = $this->security->xss_clean($this->input->post('tax2_percent'));
    $data['tax3_percent'] = $this->security->xss_clean($this->input->post('tax3_percent'));
    $count = $this->Settings->select_tax_types("",$data)->num_rows();
    if($count==0){
      $result = $this->Settings->insert_tax_types($data);
      $flash_data['status'] = $result['status'];
      if ($flash_data['status'] == 1) {
        $flash_data['flashdata_msg'] = 'Tax Type Added Successfully! ';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';
      } else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    }else {
      $flash_data['status'] = 2;
      $flash_data['flashdata_msg'] = 'Sorry.. Same Tax Type Already Exist!';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }
    echo(json_encode($flash_data));
  }
  public function delete_tax_type()
  {
    $data['tax_id'] = $this->security->xss_clean($this->input->post('tax_id'));
    $data['delete_status'] = 1;

    $result = $this->Settings->update_tax_types($data);
    $flash_data['status'] = $result;
    if ($flash_data['status'] == 1) {
      $flash_data['flashdata_msg'] = 'Tax Type Deleted Successfully! ';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo(json_encode($flash_data));
  }
  public function select_tax_types()
  {
    $json_data=array();
    $j=0;
    $sl_no=0;
    $data=array();

    $result = $this->Settings->select_tax_types("",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();

    foreach($result_array as $row):

      $btn_edit=$btn_delete='';

      if($this->session->userdata('user_role')!='auditor'){
        $btn_delete='<a style="margin-left: 5px;margin-right: 5px" id="tax_type_delete_btn" href="#tax_type_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air">
        <i class="la la-trash"></i>
        </a>';
      }

      $tax1_name = $this->config->item('Tax_tax1_name');
      $tax2_name = $this->config->item('Tax_tax2_name');
      $tax3_name = $this->config->item('Tax_tax3_name');
      $tax_name = $row->tax_percentage."%";
      $tax_name_split = '';
      if($row->tax1_percent!=0){
        $tax_name_split .= $tax1_name.'@'.$row->tax1_percent.'%, ';
      }
      if($row->tax2_percent!=0){
        $tax_name_split .= $tax2_name.'@'.$row->tax2_percent.'%, ';
      }
      if($row->tax3_percent!=0){
        $tax_name_split .= $tax3_name.'@'.$row->tax3_percent.'%, ';
      }
      if($tax_name_split!=''){
        $tax_name_split = rtrim($tax_name_split, ', ');
        $tax_name .= " (".$tax_name_split.")";
      }

      $sl_no++;

      $array[$j][]=$row->tax_id;
      $array[$j][]=$sl_no;
      $array[$j][]=$tax_name;
      $array[$j][]=$row->tax_percentage;
      $array[$j][]=$row->tax1_percent;
      $array[$j][]=$row->tax2_percent;
      $array[$j][]=$row->tax3_percent;
      $array[$j][]=$btn_edit.$btn_delete;
      $j++;
    endforeach;

    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }

  public function create_bank_account_details()
  {
    $data['company_name'] = $this->security->xss_clean($this->input->post('company_name'));
    $data['bank_name'] = $this->security->xss_clean($this->input->post('bank_name'));
    $data['bank_account_no'] = $this->security->xss_clean($this->input->post('account_no'));
    $data['bank_ifsc'] = $this->security->xss_clean($this->input->post('ifsc'));
    $data['bank_branch'] = $this->security->xss_clean($this->input->post('branch'));
    $data['bank_swift_code'] = $this->security->xss_clean($this->input->post('swift_code'));
    if($this->session->userdata('branch_id')!=0){
      $data['branch_id'] = $this->session->userdata('branch_id');
    }

    $result = $this->Settings->insert_bank_account_detail($data);
    $flash_data['status'] = $result['status'];
    if ($flash_data['status'] == 1) {
      $flash_data['flashdata_msg'] = 'Bank Account Added Successfully! ';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo(json_encode($flash_data));
  }
  public function update_bank_account_details()
  {
    $data['account_id'] = $this->security->xss_clean($this->input->post('account_id'));
    $data['company_name'] = $this->security->xss_clean($this->input->post('company_name'));
    $data['bank_name'] = $this->security->xss_clean($this->input->post('bank_name'));
    $data['bank_account_no'] = $this->security->xss_clean($this->input->post('account_no'));
    $data['bank_ifsc'] = $this->security->xss_clean($this->input->post('ifsc'));
    $data['bank_branch'] = $this->security->xss_clean($this->input->post('branch'));
    $data['bank_swift_code'] = $this->security->xss_clean($this->input->post('swift_code'));
    $result = $this->Settings->update_bank_account_detail($data);
    $flash_data['status'] = $result;
    if ($flash_data['status'] == 1) {
      $flash_data['flashdata_msg'] = 'Bank Account Details Updated Successfully! ';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo(json_encode($flash_data));
  }
  public function delete_bank_account_details()
  {
    $data['account_id'] = $this->security->xss_clean($this->input->post('account_id'));
    $data['delete_status'] = 1;

    $result = $this->Settings->update_bank_account_detail($data);
    $flash_data['status'] = $result;
    if ($flash_data['status'] == 1) {
      $flash_data['flashdata_msg'] = 'Bank Account Deleted Successfully! ';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo(json_encode($flash_data));
  }
  public function select_bank_account_details()
  {
    $json_data=array();
    $j=0;
    $sl_no=0;
    $data=array();

    if(isset($_POST['branch_id']) && $_POST['branch_id']!='' && $_POST['branch_id']!='all'){
      $data['ba.branch_id'] = $_POST['branch_id'];
    }

    $result = $this->Settings->select_bank_account_details("",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();

    foreach($result_array as $row):

      $btn_edit=$btn_delete='';

      if($this->session->userdata('user_role')=='admin'){
        $btn_edit='<a style="margin-left: 5px;margin-right: 5px" id="bank_account_edit_btn" href="#bank_account_edit_modal" data-toggle="modal" class="btn btn-primary m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air">
        <i class="la la-edit"></i>
        </a>';
        $btn_delete='<a style="margin-left: 5px;margin-right: 5px" id="bank_account_delete_btn" href="#bank_account_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air">
        <i class="la la-trash"></i>
        </a>';
      }

      $array[$j][]=$row->account_id;
      $array[$j][]=$j+1;
      $array[$j][]=($row->branch_id==0)?'No Branch':$this->Branches->select_branches('*',array('branch_id'=>$row->branch_id))->row()->branch_name;
      $array[$j][]=$row->company_name;
      $array[$j][]=$row->bank_name;
      $array[$j][]=$row->bank_account_no;
      $array[$j][]=$row->bank_ifsc;
      $array[$j][]=$row->bank_branch;
      $array[$j][]=$row->bank_swift_code;
      $array[$j][]=$btn_edit.$btn_delete;
      $j++;
    endforeach;

    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }

  public function create_holiday()
  {
    $data['holiday_name'] = $this->security->xss_clean($this->input->post('name'));
    $data['holiday_date'] = date('Y-m-d',strtotime($this->input->post('date')));
    $count = $this->Settings->select_holidays("",array("holiday_date"=>$data['holiday_date']))->num_rows();
    if($count==0){
      $result = $this->Settings->insert_holidays($data);
      $flash_data['status'] = $result['status'];
      if ($flash_data['status'] == 1) {
        $flash_data['flashdata_msg'] = 'Holiday Added Successfully! ';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';
      } else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    }else{
      $flash_data['status'] = 2;
      $flash_data['flashdata_msg'] = 'Sorry.. Selected Date Already Added!';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }
    echo(json_encode($flash_data));
  }
  public function update_holiday()
  {
    $data['id'] = $this->security->xss_clean($this->input->post('holiday_id'));
    $data['holiday_name'] = $this->security->xss_clean($this->input->post('name'));
    $data['holiday_date'] = date('Y-m-d',strtotime($this->input->post('date')));
    $count = $this->Settings->select_holidays("",array("id !="=>$data['id'],"holiday_date"=>$data['holiday_date']))->num_rows();
    if($count==0){
      $result = $this->Settings->update_holidays($data);
      $flash_data['status'] = $result;
      if ($flash_data['status'] == 1) {
        $flash_data['flashdata_msg'] = 'Holiday Details Updated Successfully! ';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';
      } else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    }else{
      $flash_data['status'] = 2;
      $flash_data['flashdata_msg'] = 'Sorry.. Selected Date Already Added!';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }
    echo(json_encode($flash_data));
  }
  public function delete_holiday()
  {
    $data['id'] = $this->security->xss_clean($this->input->post('holiday_id'));
    $data['delete_status'] = 1;
    $result = $this->Settings->update_holidays($data);
    $flash_data['status'] = $result;
    if ($flash_data['status'] == 1) {
      $flash_data['flashdata_msg'] = 'Holiday Deleted Successfully! ';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo(json_encode($flash_data));
  }
  public function select_holidays()
  {
    $json_data=array();
    $j=0;
    $sl_no=0;
    $data=array();
    if(isset($_POST['month']) && $_POST['month']!=''){
      $data["holiday_date >="] = date('Y-m-01', strtotime($_POST['month']));
      $data["holiday_date <="] = date('Y-m-t', strtotime($_POST['month']));
    }
    $result = $this->Settings->select_holidays("",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();

    foreach($result_array as $row):

      $btn_edit=$btn_delete='';

      if($this->session->userdata('user_role')=='admin'){
        $btn_edit='<a style="margin-left: 5px;margin-right: 5px" id="holiday_edit_btn" href="#holiday_edit_modal" data-toggle="modal" class="btn btn-primary m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air">
        <i class="la la-edit"></i>
        </a>';
        $btn_delete='<a style="margin-left: 5px;margin-right: 5px" id="holiday_delete_btn" href="#holiday_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air">
        <i class="la la-trash"></i>
        </a>';
      }

      $array[$j][]=$row->id;
      $array[$j][]=$j+1;
      $array[$j][]=$row->holiday_name;
      $array[$j][]=date('d-m-Y',strtotime($row->holiday_date));
      $array[$j][]=$btn_edit.$btn_delete;
      $j++;
    endforeach;

    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }

  public function create_billing_address()
  {
    $data['title'] = $this->security->xss_clean($this->input->post('title'));
    $data['billing_address'] = $this->security->xss_clean($this->input->post('address'));
    $count = $this->Settings->select_billing_address("",array("title"=>$data['title']))->num_rows();
    if($count==0){
      $result = $this->Settings->insert_billing_address($data);
      $flash_data['status'] = $result['status'];
      if ($flash_data['status'] == 1) {
        $flash_data['flashdata_msg'] = 'Billing Address Added Successfully! ';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';
      } else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    }else{
      $flash_data['status'] = 2;
      $flash_data['flashdata_msg'] = 'Sorry.. Title Already Added!';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }
    echo(json_encode($flash_data));
  }
  public function update_billing_address()
  {
    $data['id'] = $this->security->xss_clean($this->input->post('billing_address_id'));
    $data['title'] = $this->security->xss_clean($this->input->post('title'));
    $data['billing_address'] = $this->security->xss_clean($this->input->post('address'));
    $count = $this->Settings->select_billing_address("",array("id !="=>$data['id'],"title"=>$data['title']))->num_rows();
    if($count==0){
      $result = $this->Settings->update_billing_address($data);
      $flash_data['status'] = $result;
      if ($flash_data['status'] == 1) {
        $flash_data['flashdata_msg'] = 'Billing Address Details Updated Successfully! ';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';
      } else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    }else{
      $flash_data['status'] = 2;
      $flash_data['flashdata_msg'] = 'Sorry.. Title Already Added!';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }
    echo(json_encode($flash_data));
  }
  public function delete_billing_address()
  {
    $data['id'] = $this->security->xss_clean($this->input->post('billing_address_id'));
    $data['delete_status'] = 1;
    $result = $this->Settings->update_billing_address($data);
    $flash_data['status'] = $result;
    if ($flash_data['status'] == 1) {
      $flash_data['flashdata_msg'] = 'Billing Address Deleted Successfully! ';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo(json_encode($flash_data));
  }
  public function select_billing_address()
  {
    $json_data=array();
    $j=0;
    $sl_no=0;
    $data=array();
    $result = $this->Settings->select_billing_address("",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();

    foreach($result_array as $row):

      $btn_edit=$btn_delete='';

      if($this->session->userdata('user_role')=='admin'){
        $btn_edit='<a style="margin-left: 5px;margin-right: 5px" id="billing_address_edit_btn" href="#billing_address_edit_modal" data-toggle="modal" class="btn btn-primary m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air">
        <i class="la la-edit"></i>
        </a>';
        $btn_delete='<a style="margin-left: 5px;margin-right: 5px" id="billing_address_delete_btn" href="#billing_address_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air">
        <i class="la la-trash"></i>
        </a>';
      }

      $array[$j][]=$row->id;
      $array[$j][]=$j+1;
      $array[$j][]=$row->title;
      $array[$j][]=nl2br($row->billing_address);
      $array[$j][]=$btn_edit.$btn_delete;
      $j++;
    endforeach;

    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }
}
?>
