<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Services extends CI_Controller {

  public $page_data=array();

  function __construct()
  {
    parent::__construct();
    //Calling Initial Functions
    $this->initial();
  }

  public function initial()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");

    $this->load->model('User_model','User');

    $this->load->model('Customers_model','Customers');
    $this->load->model('Services_model','Services');


    //        File Directory
    $this->page_data['directory'] = "services";

  }
  public function index()
  {
    $this->view();
  }
  public function view()
  {
    //        Check User Logged in or Not
    $allowed_user_roles = array("auditor","madmin","admin","sales_manager","sales_staff","accounts_manager","general_manager","operation_manager");
    if($this->User->is_logged_in($allowed_user_roles)==false){
      redirect(base_url(), 'refresh');
    }

    $this->page_data['page_name'] = 'services_view';
    $this->load->view('Index',$this->page_data);
  }

  public function create()
  {
    $data['service_name']=$service_where['service_name']=$this->security->xss_clean($this->input->post('service'));
    $count = $this->Services->select_services("",$service_where)->num_rows();
    if($count == 0) {
      $data['service_name'] = $this->security->xss_clean($this->input->post('service'));
      $status = $this->security->xss_clean($this->input->post('status'));
      if($status=='on'){
        $data['active_status'] = 1;
      }else{
        $data['active_status'] = 0;
      }

      $result = $this->Services->insert_service($data);

      $flash_data['status'] = $result['status'];
      if ($flash_data['status'] == 1) {
        $flash_data['flashdata_msg'] = 'Service Added Successfully!.';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';
      }else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }

    }else {
      $flash_data['status'] = 0;
      $flash_data['flashdata_msg'] = 'Sorry.. A Service with Same name Already Exist!';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }
    echo(json_encode($flash_data));

  }

  public function update()
  {

    $data['service_name']=$service_where['service_name']=$this->security->xss_clean($this->input->post('service'));
    $data['service_id'] = $service_where['service_id !='] = $this->security->xss_clean($this->input->post('service_id'));
    $count = $this->Services->select_services("",$service_where)->num_rows();
    if($count == 0) {
      $data['service_name'] = $this->security->xss_clean($this->input->post('service'));
      $status = $this->security->xss_clean($this->input->post('status'));
      if($status=='on'){
        $data['active_status'] = 1;
      }else{
        $data['active_status'] = 0;
      }

      $result = $this->Services->update_service($data);

      $flash_data['status'] = $result;
      if ($flash_data['status'] == 1) {
        $flash_data['flashdata_msg'] = 'Service Updated Successfully!.';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';
      }else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }

    }else {
      $flash_data['status'] = 0;
      $flash_data['flashdata_msg'] = 'Sorry.. A Service with name Already Exist!';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }
    echo(json_encode($flash_data));

  }

  public function select()
  {
    $json_data=array();
    $j=0;
    $sl_no=0;
    $data=array();

    $result = $this->Services->select_services("",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();

    foreach($result_array as $row):

     $btn_edit=$btn_delete='';

     if($this->session->userdata('user_role')!='auditor'){
      $btn_edit='<a style="margin-left: 5px;margin-right: 5px" id="service_edit_btn" href="#service_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
      <i class="la la-edit"></i>
      </a>';
      $btn_delete='<a style="margin-left: 5px;margin-right: 5px" id="service_delete_btn" href="#service_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air">
      <i class="la la-trash"></i>
      </a>';
    }

    $sl_no++;

    if($row->active_status==1){
      $active_status = "<span class='m-badge m-badge--success m-badge--wide'></i>Active</span>";
    }else{
      $active_status = "<span class='m-badge m-badge--danger m-badge--wide'></i>Deactive</span>";
    }

    $array[$j][]=$row->service_id;
    $array[$j][]=$sl_no;
    $array[$j][]=$row->service_name;
    $array[$j][]=$active_status;
    $array[$j][]=$btn_edit.$btn_delete;
    $array[$j][]=$row->active_status;

    $j++;
  endforeach;

  $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }

  public function delete()
  {
    $data['service_id']=$this->security->xss_clean($this->input->post('service_id'));
    $data['delete_status']=1;
    $result = $this->Services->update_service($data);
    $flash_data['status'] = $result;
    if ($result == 1 ) {
      $flash_data['flashdata_msg'] = 'Service Deleted Successfully!';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !!';
    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo(json_encode($flash_data));
  }


  public function select_service_types()
  {
    $json_data=array();
    $j=0;
    $sl_no=0;
    $data=array();

    $result = $this->Services->select_service_types("",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();

    foreach($result_array as $row):

     $btn_edit=$btn_delete='';

     if($this->session->userdata('user_role')!='auditor'){
      $btn_edit='<a style="margin-left: 5px;margin-right: 5px" id="service_type_edit_btn" href="#service_type_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
      <i class="la la-edit"></i>
      </a>';
    }

    $sl_no++;

    $array[$j][]=$row->stype_id;
    $array[$j][]=$sl_no;
    $array[$j][]=$row->service_type_name;
    $array[$j][]=$btn_edit.$btn_delete;

    $j++;
  endforeach;

  $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }
  public function create_service_type()
  {
    $data['service_type_name']=$service_where['service_type_name']=$this->security->xss_clean($this->input->post('service_type'));
    $count = $this->Services->select_service_types("",$service_where)->num_rows();
    if($count == 0) {
      $result = $this->Services->insert_service_type($data);

      $flash_data['status'] = $result['status'];
      if ($flash_data['status'] == 1) {
        $flash_data['flashdata_msg'] = 'Service Type Added Successfully!.';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';
      }else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }

    }else {
      $flash_data['status'] = 0;
      $flash_data['flashdata_msg'] = 'Sorry.. A Service type with Same name Already Exist!';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }
    echo(json_encode($flash_data));

  }

  public function update_service_type()
  {

    $data['service_type_name']=$service_where['service_type_name']=$this->security->xss_clean($this->input->post('service_type'));
    $data['stype_id'] = $service_where['stype_id !='] = $this->security->xss_clean($this->input->post('service_type_id'));
    $count = $this->Services->select_service_types("",$service_where)->num_rows();
    if($count == 0) {
      $result = $this->Services->update_service_type($data);

      $flash_data['status'] = $result;
      if ($flash_data['status'] == 1) {
        $flash_data['flashdata_msg'] = 'Service type Updated Successfully!.';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';
      }else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }

    }else {
      $flash_data['status'] = 0;
      $flash_data['flashdata_msg'] = 'Sorry.. A Service with name Already Exist!';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }
    echo(json_encode($flash_data));

  }

}
?>
