<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Reminders extends CI_Controller
{
  public $page_data = array();

  function __construct()
  {
    parent::__construct();
    $this->initial();
  }
  public function initial()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");

    $this->load->model('User_model', 'User');
    $this->load->model('Reminders_model', 'Reminders');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Vehicle_model', 'Vehicle');
    $this->load->model('Labour_model', 'Labour');
    $this->load->model('Employees_model', 'Employee');
    $this->load->library('Projects_management','projects_management');

    // Check User Logged in or Not
    $allowed_user_roles = array("madmin","admin","supervisor","general_manager","boq_manager","sales_manager","purchase_manager","sales_manager","auditor","accounts_manager","qs","qs_manager","operation_manager");
    if($this->User->is_logged_in($allowed_user_roles)==false){
      redirect(base_url(), 'refresh');
    }
    //        File Directory
    $this->page_data['directory'] = "reminders";

  }
  public function index()
  {
    $this->view();
  }

  public function view()
  {
    $this->page_data['employees'] = $this->Employee->select_employee("e.*,ed.department_name")->result();
    $this->page_data['labours'] = $this->Labour->select_labours()->result();
    $this->page_data['vehicles'] = $this->Vehicle->select_vehicle()->result();
    $this->page_data['work_contracts'] = $this->Work->select_work("*")->result();
    $this->page_data['users'] = $this->User->select_user("","")->result();

    $this->page_data['page_name'] = 'reminders_view';
    $this->load->view('Index',$this->page_data);
  }

  public function select_reminders($list_type=""){

    $json_data=array();
    $j=0;
    $sl_no=0;
    $total_amount=0;
    $data=array();

    if(isset($_POST['user']) && $_POST['user']!='' && $_POST['user']!='all'){
      $data['r.created_by'] = $_POST['user'];
    }
    if(isset($_POST['reminder_type']) && $_POST['reminder_type']!='' && $_POST['reminder_type']!='all'){
      $data['r.reminder_type'] = $_POST['reminder_type'];
    }
    if(isset($_POST['start_date']) && $_POST['start_date']!='' && $_POST['start_date']!='all'){
      $data['r.reminder_date >='] = date('Y-m-d', strtotime($_POST['start_date']));
    }
    if(isset($_POST['end_date']) && $_POST['end_date']!='' && $_POST['end_date']!='all'){
      $data['r.reminder_date <='] = date('Y-m-d', strtotime($_POST['end_date']));
    }
    $result	= $this->Reminders->select_reminders("r.*,u.user_alias,wc.work_name,e.employee_name,e.user_designation,l.labour_name,v.vehicle_no,v.vehicle_name,r.created_by as pd_created_by",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();


    foreach($result_array as $row):
      $file = '';
      if($row->file!=''){
        $filename = base_url().'uploads/documents/'.$row->file;
        $file = '<a target="_blank"  style="margin-left: 5px;margin-right: 5px"  href="'.$filename.'" >Click To view</a>';
      }
      if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='general_manager' || $this->session->userdata('user_id')== $row->pd_created_by ) {
        $btn_edit = '<a  style="margin-left: 5px;margin-right: 5px" id="reminder_edit_btn" href="#reminder_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-edit"></i>
        </a>';
        $btn_delete='<a style="margin-left: 5px;margin-right: 5px" id="reminder_delete_btn" href="#reminder_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-trash"></i>
        </a>';
      }else{
        $btn_edit=$btn_delete='';
      }

      $reference='';
      if($row->reminder_type!='Others'){
        if($row->reminder_type=='Project'){
          $reference="#".$row->reference_id.' - '.$row->work_name;
        }elseif($row->reminder_type=='Vehicle'){
          $reference="#".$row->reference_id.' - '.$row->vehicle_no." [".$row->vehicle_name."]";
        }elseif($row->reminder_type=='Labour'){
          $reference="#".$row->reference_id.' - '.$row->labour_name;
        }elseif($row->reminder_type=='Employee'){
          $reference="#".$row->reference_id.' - '.$row->employee_name." [".$row->user_designation."]";
        }
      }

      $sl_no++;
      $array[$j][]=$sl_no;
      $array[$j][]=$row->reminder_id;
      $array[$j][]=$row->reminder_type;
      $array[$j][]=$reference;
      $array[$j][]=$row->reminder_title;
      $array[$j][]=$row->reminder_description;
      $array[$j][]=date('d-m-Y',strtotime($row->reminder_date));
      $array[$j][]=$file;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]='<ul style="padding: .75rem;margin-bottom: 0"><li>Created on : '.date('d-m-Y',strtotime($row->created_date))."</li><li>Created By : ".$row->user_alias."</li>";
      }else{
        $array[$j][]='<ul style="padding: .75rem;margin-bottom: 0"><li>Created By : '.$row->user_alias.'</li>';
      }
      $array[$j][]=$btn_edit.$btn_delete;
      $array[$j][]=$row->reference_id;
      $array[$j][]=$row->file;


      $j++;
    endforeach;

    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }
  public function select(){
    $data = array();
    if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
      $data['pd.work_id'] = $_POST['work'];
    }
    $result	= $this->Reminders->select_reminders("*,pd.created_date AS pd_created_date,pd.created_by AS pd_created_by",$data);
    if($result->num_rows()>0) {
      echo json_encode(array("count" => $result->num_rows(),"data" => $result->result()));
    }else{
      echo json_encode(array("count" => $result->num_rows()));
    }
  }
  public function create()
  {
    $data['reminder_type'] = $this->security->xss_clean($this->input->post('reminder_type'));
    $data['reminder_title'] = $this->security->xss_clean($this->input->post('title'));
    $data['reminder_description'] = $this->security->xss_clean($this->input->post('description'));
    $data['file'] = $this->security->xss_clean($this->input->post('file'));
    if($this->input->post('reference_id')){
      $reference_id = explode('_',$this->input->post('reference_id'));
      $data['reference_id'] = $reference_id[1];
    }
    $data['reminder_date'] = date('Y-m-d',strtotime($this->input->post('reminder_date')));
    $data['created_date'] = date('Y-m-d H:i:s');
    $data['created_by'] = $this->session->userdata('user_id');

    $result = $this->Reminders->create_reminder($data);
    $flash_data['status'] = $result['status'];
    if ($flash_data['status'] == 1) {
      $flash_data['flashdata_type'] = 'success';
      $flash_data['flashdata_msg'] = 'Reminder Added Succesfully';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    }
    else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo json_encode($flash_data);
  }
  public function update()
  {
    $data['reminder_type'] = $this->security->xss_clean($this->input->post('reminder_type'));
    $data['reminder_title'] = $this->security->xss_clean($this->input->post('title'));
    $data['reminder_description'] = $this->security->xss_clean($this->input->post('description'));
    $data['file'] = $this->security->xss_clean($this->input->post('file'));
    if($this->input->post('reference_id')){
      $reference_id = explode('_',$this->input->post('reference_id'));
      $data['reference_id'] = $reference_id[1];
    }
    $data['reminder_date'] = date('Y-m-d',strtotime($this->input->post('reminder_date')));
    $data['reminder_id'] = $this->security->xss_clean($this->input->post('reminder_id'));
    $data['updated_date'] = date('Y-m-d H:i:s');
    $data['updated_by'] = $this->session->userdata('user_id');
    $result = $this->Reminders->update_reminder($data);
    $flash_data['status'] = $result;
    if ($result== 1) {
      $flash_data['flashdata_type'] = 'success';
      $flash_data['flashdata_msg'] = 'Reminder Updated Succesfully';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo json_encode($flash_data);
  }
  public function delete()
  {
    //  Delete Received Amount
    $redirect_url= $this->security->xss_clean($this->input->post('redirect_url'));
    $data['reminder_id'] = $this->security->xss_clean($this->input->post('reminder_id'));
    $data['delete_status']=1;
    $result2 = $this->Reminders->update_reminder($data);

    $flash_data['status'] = $result2;
    if ($result2 == 1) {
      $flash_data['flashdata_type'] = 'success';
      $flash_data['flashdata_msg'] = 'Project Reminder Deleted Succesfully';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo json_encode($flash_data);
  }

}
?>
