<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Project_tasks extends CI_Controller
{
  public $page_data = array();

  function __construct()
  {
    parent::__construct();
    $this->initial();
  }
  public function initial()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");

    $this->load->model('User_model', 'User');
    $this->load->model('Project_tasks_model', 'Project_tasks');
    $this->load->model('Work_model', 'Work');
    $this->load->library('Projects_management','projects_management');

    // Check User Logged in or Not
    $allowed_user_roles = array("madmin","admin","supervisor","general_manager","boq_manager","sales_manager","purchase_manager","sales_manager","auditor","qs","qs_manager","accounts_manager","operation_manager");
    if($this->User->is_logged_in($allowed_user_roles)==false){
      redirect(base_url(), 'refresh');
    }
    //        File Directory
    $this->page_data['directory'] = "project_tasks";

  }
  // public function index()
  // {
  //   $this->view();
  // }

  // public function view()
  // {
  //   // Check Module is Enabled or Not

  //   $this->page_data['page_name'] = 'Project_tasks_view';
  //   $this->page_data['work_contracts'] = $this->Work->select_work("*")->result();
  //   $this->page_data['tasks'] = $this->Project_tasks->select_tasks("pt.*")->result();
  //   $this->page_data['users'] = $this->User->select_user("","")->result();
  //   $this->load->view('Index',$this->page_data);
  // }

  public function select_tasks($list_type="",$work_id='',$chart_type=''){

    $json_data=array();
    $j=$k=$p=$l=0;
    $sl_no=$sl_no2=1;
    $total_amount=0;
    $data=array();

    if(isset($_POST['date']) && $_POST['date']!=''){
      $date=array();
      $date=explode('-',$_POST['date']);
      $planned_start_date=date('Y-m-d', strtotime($date[0]));
      $planned_end_date=date('Y-m-d', strtotime($date[1]));
      $data["STR_TO_DATE(pt.created_date,'%Y-%m-%d') <="]= $planned_end_date;
      $data["STR_TO_DATE(pt.created_date,'%Y-%m-%d') >="]= $planned_start_date;
    }
    if(isset($_POST['user']) && $_POST['user']!='' && $_POST['user']!='all'){
      $data['pt.created_by'] = $_POST['user'];
    }
    if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
      $data['pt.work_id'] = $_POST['work'];
    }
    if(isset($_POST['work_ids']) && $_POST['work_ids']!='' && $_POST['work_ids']!='all'){
      $this->db->where_in('pt.work_id',explode(',',$_POST['work_ids']));
    }
    if(isset($work_id) && $work_id!='' && $work_id!='all'){
      $data['pt.work_id'] = $work_id;
    }
    if($this->session->userdata('user_role')=='supervisor' && $this->session->userdata('user_role_id')!=20){
      $data['pt.user_id'] = $this->session->userdata('user_id');
    }
    if(isset($_POST['task_id']) && $_POST['task_id']!='' && $_POST['task_id']!='all'){
      $data['pt.task_id'] = $_POST['task_id'];
    }
    if(isset($_POST['parent_id']) && $_POST['parent_id']!='' && $_POST['parent_id']!='all'){
      $data['pt.parent_id'] = $_POST['parent_id'];
    }
    if(!isset($data['pt.task_id']) && !isset($data['pt.parent_id'])){
      $data['pt.parent_id'] = 0;
    }
    $result = $this->Project_tasks->select_tasks("pt.*,wc.work_name,pt.created_date AS pt_created_date,u1.user_alias AS pt_created_by,u1.user_id AS pt_created_by_id,u2.user_alias AS supervisor,u2.user_id AS supervisor_id",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=$gantt_chart=$gantt_chart_link[]=array();
    $tasks_table='';
    $task_count=$result->num_rows();

    $parent_id = 0;

    if($task_count>0){
      if($result_array[0]->work_id!='0'){
        $gantt_chart[$p]['id'] = "project_".$result_array[0]->work_id;
        $gantt_chart[$p]['text'] = "Project : ".$result_array[0]->work_name;
        $gantt_chart[$p]['parent'] = 0;
        $gantt_chart[$p]['open'] = true;
        $gantt_chart[$p]['type'] = 'project';
        $p++;
      }
    }
    $array2 = array();
    foreach($result_array as $row):

      $data['pt.parent_id'] = $row->task_id;
      $result = $this->Project_tasks->select_tasks("pt.*",$data);
      $subtask_count=$result->num_rows();
      $subtask_result_array=$result->result();

      if($subtask_count>0){
        $btn_update_progress='';
      }
      else{
        if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='general_manager' || $this->session->userdata('user_id') == $row->pt_created_by_id ) {
          $btn_update_progress='<a style="margin-left: 5px;margin-right: 5px" id="project_task_progress_update_btn" href="#project_task_progress_update_modal" data-toggle="modal" class="btn btn-primary m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
          <i class="la la-forward"></i>
          </a>';
        }
        else{
          $btn_update_progress = '';
        }
      }
      if($row->progress<100){

        if($row->progress<20 && $row->progress>0){
          $progress_style = 'bg-warning';
        }
        else{
          $progress_style = '';
        }
      }
      else{
        $progress_style = 'bg-success';
      }

      $progress='<div class="progress"><div class="progress-bar progress-bar-striped '.$progress_style.' progress-bar-animated" role="progressbar" aria-valuenow="'.$row->progress.'" aria-valuemin="0" aria-valuemax="100" style="width: '.$row->progress.'%">'.$row->progress.' %</div></div>';

      if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='general_manager' || $this->session->userdata('user_id')== $row->pt_created_by_id ) {

        $btn_edit = '<a style="margin-left: 5px;margin-right: 5px" id="project_task_edit_btn" href="#project_task_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-edit"></i>
        </a>';
        $btn_delete='<a  style="margin-left: 5px;margin-right: 5px" id="project_task_delete_btn" href="#project_task_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-trash"></i>
        </a>';

      }else{
        $btn_edit=$btn_delete='';

      }

      $btn_add_activity='<a  style="margin-left: 5px;margin-right: 5px" id="add_activity_btn_task" href="#project_task_activity_add_modal" data-toggle="modal" class="btn btn-success m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
      <i class="la la-plus"></i>
      </a>';

      $activities = $this->Project_tasks->select_task_activity("pta.id",array("pt.task_id"=>$row->task_id));
      if($activities->num_rows()>0){
        $btn_activity='<button type="button" style="margin-left: 5px;margin-right: 5px" data-task-id='.$row->task_id.'  class=" schedule_task_view_btn btn btn-sm btn-info m-btn m-btn--icon  m-btn--pill m-btn--air">
        <i class="fa fa-tasks"></i> View '.$activities->num_rows().' Acivities </button>';
      }else{
        $btn_activity="<span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-times-circle'></i> No Activities</span>";
      }


      if($row->task_status==1){
        $task_status="<span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> Completed</span>";
      }elseif($row->task_status==2){
        $task_status="<span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-ellipsis-h'></i> In Progress</span>";
      }else{
        $task_status="<span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-times-circle'></i> Pending</span>";
      }
      if($row->task_status!=1){
        if(date("Y-m-d") > $row->planned_end_date){
          $task_status.="<br/><span style='margin-top: 5px;width: 100%' class='m-spinner m-spinner--focus m-badge m-badge--focus m-badge--wide'> Overdue</span>";
        }
      }

      $start_date = "Planned : ".date('d-m-Y',strtotime($row->planned_start_date));
      if($row->actual_start_date!='0000-00-00'){
        $start_date .= "<br/>Actual : ".date('d-m-Y',strtotime($row->actual_start_date));
      }elseif($row->planned_start_date!='0000-00-00' && date('Y-m-d')>$row->planned_start_date && $row->task_status!=1){
        $start_date .= "<br/><span class='m-badge m-badge--warning m-badge--wide'>Not Started Yet</span>";
      }
      $end_date = "Planned : ".date('d-m-Y',strtotime($row->planned_end_date));
      if($row->actual_end_date!='0000-00-00'){
        $end_date .= "<br/>Actual : ".date('d-m-Y',strtotime($row->actual_end_date));
      }elseif($row->planned_end_date!='0000-00-00' && date('Y-m-d')>$row->planned_end_date && $row->task_status!=1){
        $end_date .= "<br/><span class='m-badge m-badge--warning m-badge--wide'>Not Finished Yet</span>";
      }

      // if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_id')== $row->pt_created_by){
      $actual_start_date = $actual_end_date = '';
      if($row->actual_start_date!='0000-00-00'){
        $actual_start_date =  date('d-m-Y',strtotime($row->actual_start_date));
      }
      if($row->actual_end_date!='0000-00-00'){
        $actual_end_date =  date('d-m-Y',strtotime($row->actual_end_date));
      }

      $array[$j][] = $sl_no;
      $array[$j][] = $row->work_name;
      $array[$j][] = '<a href="javascript:;" data-task-id="'.$row->task_id.'" class="schedule_task_view_btn">'.$row->task_title.'</a>';
      $array[$j][] = $row->task_description;
      $array[$j][] = $start_date;
      $array[$j][] = $end_date;
      $array[$j][] = $progress;
      $array[$j][] = $row->supervisor;
      $array[$j][] = $task_status;
      $array[$j][] = $btn_activity;
      $array[$j][] = $row->pt_created_by;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][] = date('d-m-Y',strtotime($row->pt_created_date));
      }else{
        $array[$j][] = '';
      }
      $array[$j][] = $btn_add_activity.$btn_update_progress.$btn_edit.$btn_delete;
      $array[$j][] = $row->task_id;
      $array[$j][] = $row->work_id;
      $array[$j][] = $row->progress;
      $array[$j][] = $row->parent_id;
      $array[$j][] = date('d-m-Y',strtotime($row->planned_start_date));
      $array[$j][] = date('d-m-Y',strtotime($row->planned_end_date));
      $array[$j][] = $row->supervisor_id;
      $array[$j][] = $actual_start_date;
      $array[$j][] = $actual_end_date;

      $data_array['from'] = "1328832000000";
      $data_array['to'] = "1322401600000";
      $data_array['label'] = "Label 1";
      $data_array['desc']="Value Description 1";
      $data_array['customClass']="custom-1";
      $data_array['dataObj']="";

      $array2[$j]['id'] = $row->task_id;
      $array2[$j]['name'] = $row->task_title;
      $array2[$j]['assigned_to'] = $row->supervisor;
      $array2[$j]['start_date_planned'] = date('d-m-Y',strtotime($row->planned_start_date));
      $array2[$j]['end_date_planned'] = date('d-m-Y',strtotime($row->planned_end_date));
      $array2[$j]['start_date_actual'] = $array2[$j]['end_date_actual'] = '0000-00-00';
      if($row->actual_start_date!='0000-00-00'){
        $array2[$j]['start_date_actual'] = date('d-m-Y',strtotime($row->actual_start_date));
      }
      else{
        $array2[$j]['start_date_actual'] = 'Not Started yet';
      }
      if($row->actual_end_date!='0000-00-00'){
        $array2[$j]['end_date_actual'] = date('d-m-Y',strtotime($row->actual_end_date));
      }
      else{
        $array2[$j]['end_date_actual'] = 'Not Started yet';
      }
      $array2[$j]['progress'] = $row->progress;
      $array2[$j]['parent_id'] = $row->parent_id;
      $array2[$j]['task_desc'] = $row->task_description;
      $array2[$j]['supervisor'] = $row->supervisor;
      $array2[$j]['supervisor_id'] = $row->supervisor_id;
      $btn_edit_subtask = '<a style="margin-left: 5px;margin-right: 5px;zoom:80%" id="project_task_edit_btn_subtask" href="#project_task_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
      <i class="la la-edit"></i>
      </a>';
      $btn_delete__subtask ='<a  style="margin-left: 5px;margin-right: 5px;zoom:80%" id="project_task_delete_btn_subtask" href="#project_task_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
      <i class="la la-trash"></i>
      </a>';
      $progress_btn = '<a  style="margin-left: 5px;margin-right: 5px;zoom:80%" data-progress="'.$row->progress.'" id="project_task_progress_update_btn_subtask" href="#project_task_progress_update_modal" data-toggle="modal" class="btn btn-primary m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
      <i class="la la-forward"></i></a>';
      $array2[$j]['action_btn'] = $btn_edit_subtask.$btn_delete__subtask.$progress_btn;
      $array2[$j]['description'] = $row->task_description;


      // Declare and define two dates
      $sdate = new DateTime(date("Y-m-d",strtotime($row->planned_start_date)));
      $edate = new DateTime(date("Y-m-d",strtotime($row->planned_end_date)));
      $days = $sdate->diff($edate)->format("%r%a");

      $gantt_chart[$p]['id'] = $row->task_id;
      if($row->actual_start_date!='0000-00-00'){
        $gantt_chart[$p]['start_date'] = $row->actual_start_date;
      }else{
        $gantt_chart[$p]['start_date'] = $row->planned_start_date;
      }
      // if($row->actual_end_date!='0000-00-00'){
      //   $gantt_chart[$p]['end_date'] = $row->actual_end_date;
      // }else{
      //   $gantt_chart[$p]['end_date'] = $row->planned_end_date;
      // }
      $gantt_chart[$p]['planned_start'] = $row->planned_start_date;
      $gantt_chart[$p]['planned_end'] = $row->planned_end_date;
      $gantt_chart[$p]['duration'] = $days;
      $gantt_chart[$p]['text'] = $row->task_title;
      $gantt_chart[$p]['progress'] = $row->progress/100;
      $gantt_chart[$p]['sortorder'] =0;
      $gantt_chart[$p]['parent'] = "project_".$row->work_id;
      if($row->parent_id!=0){
        $gantt_chart[$p]['parent'] = $row->parent_id;
        $gantt_chart[$p]['render'] = "split";
      }
      $gantt_chart[$p]['open'] = true;
      $gantt_chart[$p]['type'] = "task";
      // $gantt_chart[$p]['supervisor_id'] = "1";

      $id[] = $row->task_id;
      $title[] = $row->task_title;
      $planned_start_date[] = date('d-m-Y',strtotime($row->planned_start_date));
      $planned_end_date[] = date('d-m-Y',strtotime($row->planned_end_date));
      $percentage[] = $row->progress;
      $parent_id_l[] =  $row->parent_id;

      //child links
      for ($l=0; $l < count($id)-1; $l++) {
        $gantt_chart_link[$l]['id'] = $l;
        $gantt_chart_link[$l]['source'] = $parent_id_l[$l];
        $gantt_chart_link[$l]['target'] = $id[$l];
        $gantt_chart_link[$l]['type'] = 1;

      }
      $sl_no++;
      // }
      $p++;
      $j++;
      $l++;

    endforeach;
    if($list_type=='chart'){
      if($result->num_rows()>0){
        if($chart_type=='gantt'){
          echo json_encode(array("count" => $result->num_rows(),"data"=>$gantt_chart,"links"=>$gantt_chart_link));
        }else{
          echo json_encode(array("count" => $result->num_rows(),"id" => $id,"title" => $title,"planned_start_date" => $planned_start_date,"planned_end_date" => $planned_end_date,"percentage" => $percentage));
        }
      }else{
        echo json_encode(array("count" => $result->num_rows(),"data"=>$gantt_chart,"links"=>$gantt_chart_link));
      }
    } elseif($list_type=='task_info') {
      $json_data2['data']=$array2;
      echo json_encode($json_data2);
    }
    else {
      $json_data['data']=$array;
      echo json_encode($json_data);  // send data as json format
    }
  }
  public function select_tasks_and_activities(){
    $work_id = $_POST['work_id'];

    $data=array('pt.work_id'=>$work_id);
    $result = $this->Project_tasks->select_tasks("pt.*,pt.created_date AS pt_created_date,pt.created_by AS pt_created_by",$data);
    $result_array=$result->result();
    $tasks_table_body='';
    // $total_task_done=$this->Project_tasks->select_task_activity("COALESCE(SUM(pta.activity_progress),0) as total_progress",array("pt.work_id"=>$id))->row()->total_progress;
    $task_count=$result->num_rows();
    if($task_count>0){
      $sl_no=1;
      foreach($result_array as $row):
        $btn_update_progress='';
        if($row->progress<100){
          $btn_update_progress='<a  style="margin-left: 5px;margin-right: 5px" id="project_task_progress_update_btn" href="#project_task_progress_update_modal" data-toggle="modal" class="btn btn-primary m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
          <i class="la la-forward"></i>
          </a>';
          if($row->progress<20 && $row->progress>0){
            $progress_style = 'bg-warning';
          }
          else{
            $progress_style = '';
          }
        }
        else{
          $progress_style = 'bg-success';
        }

        $progress='<div class="progress"><div class="progress-bar progress-bar-striped '.$progress_style.' progress-bar-animated" role="progressbar" aria-valuenow="'.$row->progress.'" aria-valuemin="0" aria-valuemax="100" style="width: '.$row->progress.'%">'.$row->progress.' %</div></div>';

        if($this->session->userdata('user_role')=='admin' || ($this->session->userdata('user_role')=='general_manager') || $this->session->userdata('user_id')== $row->pt_created_by ) {

          $btn_edit = '<a style="margin-left: 5px;margin-right: 5px" id="project_task_edit_btn" href="#project_task_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
          <i class="la la-edit"></i>
          </a>';
          $btn_delete='<a  style="margin-left: 5px;margin-right: 5px" id="project_task_delete_btn" href="#project_task_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
          <i class="la la-trash"></i>
          </a>';

        }else{
          $btn_edit=$btn_delete='';

        }
        $btn_add_activity='<a  style="margin-left: 5px;margin-right: 5px" id="add_activity_btn_task" href="#project_task_activity_add_modal" data-toggle="modal" class="btn btn-success m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-plus"></i>
        </a>';
        if(date('d-m-Y',strtotime($row->planned_end_date))<date('d-m-Y')){
          if($row->progress==0){
            $task_status = 'Not Started <br> Over Due ';
          }
          else{
            $task_status = 'Over Due';
          }
        }
        else{
          $task_status = $row->task_status;
        }
        if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_id')== $row->pt_created_by){
          $tasks_table_body.=
          '<tr>'.
          '<td colspan="10" class="right" style="font-weight: 500;background-color: #afafaf;">Task : '.$row->task_title.'</td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '</tr>';
          $tasks_table_body.=
          '<tr>'.
          '<td>'.$sl_no.'</td>'.
          '<td>'.$row->task_title.'</td>'.
          '<td>'.$row->task_description.'</td>'.
          '<td>'.date('d-m-Y',strtotime($row->planned_start_date)).'</td>'.
          '<td>'.date('d-m-Y',strtotime($row->planned_end_date)).'</td>'.
          '<td>'.$progress.'</td>'.
          '<td>'.$task_status.'</td>'.
          '<td>'.$row->user_alias.'</td>'.
          '<td>'.date('d-m-Y',strtotime($row->created_date)).'</td>'.
          '<td>'.$btn_add_activity.$btn_update_progress.$btn_edit.$btn_delete.'</td>'.
          '<td style="display: none">'.$row->task_id.'</td>'.
          '<td style="display: none">'.$row->work_id.'</td>'.
          '<td style="display: none">'.$row->progress.'</td>'.
          '</tr>';
        }

        $data2=array('pta.task_id'=>$row->task_id);
        $result2 = $this->Project_tasks->select_task_activity("pta.*,u2.*",$data2);
        $result_array2=$result2->result();
        $activity_count=$result2->num_rows();
        if($activity_count>0){
          $tasks_table_body.=
          '<tr>'.
          '<td colspan="10" class="right" style="font-weight: 500;background-color: #eaeaea;">Activities of Task : '.$row->task_title.'</td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '</tr>';
          $btn_edit2=$btn_delete2='';
          $sl_no2=1;
          foreach($result_array2 as $row2):
            if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_id')== $row2->created_by){

              $btn_edit2 = '<a style="margin-left: 5px;margin-right: 5px" id="project_task_activity_edit_btn" href="#project_task_activity_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
              <i class="la la-edit"></i>
              </a>';
              $btn_delete2 ='<a  style="margin-left: 5px;margin-right: 5px" id="project_task_activity_delete_btn" href="#project_task_activity_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
              <i class="la la-trash"></i>
              </a>';

              $tasks_table_body.=
              '<tr>'.
              '<td>'.$sl_no.'.'.$sl_no2.'</td>'.
              '<td>'.$row2->activity_title.'</td>'.
              '<td>'.$row2->activity_description.'</td>'.
              '<td colspan="4">'.date('d-m-Y',strtotime($row2->activity_date)).'</td>'.
              '<td style="display: none"></td>'.
              '<td style="display: none"></td>'.
              '<td style="display: none"></td>'.
              '<td>'.$row2->user_alias.'</td>'.
              '<td>'.date('d-m-Y',strtotime($row2->created_date)).'</td>'.
              '<td>'.$btn_edit2.$btn_delete2.'</td>'.
              '<td style="display: none">'.$row2->id.'</td>'.
              '<td style="display: none">'.$row->task_id.'</td>'.
              '<td style="display: none"></td>'.
              '</tr>';
              $sl_no2++;
            }
          endforeach;
        }
        $sl_no++;
      endforeach;

      echo json_encode(array("task_count"=>$task_count,"content"=>$tasks_table_body));
    }
    else{
      echo json_encode(array("task_count"=>0));
    }
  }

  public function select_activities(){
    $json_data=array();
    $j=$k=$sl_no=0;
    $data=array();
    if(isset($_POST['date']) && $_POST['date']!=''){
      $date=array();
      $date=explode('-',$_POST['date']);
      $planned_start_date=date('Y-m-d', strtotime($date[0]));
      $planned_end_date=date('Y-m-d', strtotime($date[1]));
      $data["STR_TO_DATE(pta.created_date,'%Y-%m-%d') <="]= $planned_end_date;
      $data["STR_TO_DATE(pta.created_date,'%Y-%m-%d') >="]= $planned_start_date;
    }
    if(isset($_POST['user']) && $_POST['user']!='' && $_POST['user']!='all'){
      $data['pta.created_by'] = $_POST['user'];
    }
    if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
      $data['pt.work_id'] = $_POST['work'];
    }
    if(isset($work_id) && $work_id!='' && $work_id!='all'){
      $data['pt.work_id'] = $work_id;
    }
    if($this->session->userdata('user_role')=='supervisor'){
      $data['pt.user_id'] = $this->session->userdata('user_id');
    }
    $result = $this->Project_tasks->select_task_activity("pt.task_id,pt.task_title,pt.work_id,pta.*,u2.*",$data);
    $result_array=$result->result();
    $activity_count=$result->num_rows();
    $array = array();

    foreach($result_array as $row):

      $sl_no++;
      if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_id')== $row->created_by ) {

        $btn_edit = '<a style="margin-left: 5px;margin-right: 5px" id="project_task_activity_edit_btn" href="#project_task_activity_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-edit"></i>
        </a>';
        $btn_delete='<a  style="margin-left: 5px;margin-right: 5px" id="project_task_activity_delete_btn" href="#project_task_activity_delete_modal" data-toggle="modal" dats-dismiss="project_task_popup_modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-trash"></i>
        </a>';

      }else{
        $btn_edit=$btn_delete='';

      }

      $array[$j][] = $sl_no;
      $array[$j][] = $row->id;
      $array[$j][] = $row->work_id;
      $array[$j][] = $row->task_id;
      $array[$j][] = $row->task_title;
      $array[$j][] = "";
      $array[$j][] = date('d-m-Y',strtotime($row->activity_date));
      $array[$j][] = $row->activity_title;
      $array[$j][] = $row->activity_description;
      $array[$j][] = "";
      $array[$j][] = $row->user_alias;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][] = date('d-m-Y H:i:s',strtotime($row->created_date));
      }else{
        $array[$j][] = '';
      }
      $array[$j][] = $btn_edit.$btn_delete;

      $j++;

    endforeach;
    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }
  public function select_tasks_activities(){
    $data['pta.task_id']=$_POST['task_id'];
    $result = $this->Project_tasks->select_task_activity("pt.task_id,pta.*,u2.user_id AS activity_created_by,u2.user_alias AS activity_created",$data);
    $result_array=$result->result();
    $activity_table_body='';
    $activity_count=$result->num_rows();
    if($activity_count>0){
      $sl_no=1;
      foreach($result_array as $row):
        if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='general_manager' || $this->session->userdata('user_id')== $row->activity_created_by ) {
          $btn_edit = '<a style="margin-left: 5px;margin-right: 5px" id="project_task_activity_edit_btn" href="#project_task_activity_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
          <i class="la la-edit"></i>
          </a>';
          $btn_delete='<a  style="margin-left: 5px;margin-right: 5px" id="project_task_activity_delete_btn" href="#project_task_activity_delete_modal" data-toggle="modal" dats-dismiss="project_task_popup_modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
          <i class="la la-trash"></i>
          </a>';
        }else{
          $btn_edit=$btn_delete='';
        }
        if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='general_manager' || $this->session->userdata('user_id')== $row->activity_created_by ) {
          $activity_table_body.=
          '<tr>'.
          '<td>'.$sl_no.'</td>'.
          '<td>'.$row->activity_title.'</td>'.
          '<td>'.$row->activity_description.'</td>'.
          '<td>'.date('d-m-Y',strtotime($row->activity_date)).'</td>'.
          '<td>'.$row->activity_created.'</td>'.
          '<td>'.date('d-m-Y',strtotime($row->created_date)).'</td>'.
          '<td>'.$btn_edit.$btn_delete.'</td>'.
          '<td style="display: none">'.$row->id.'</td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none">'.$row->task_id.'</td>'.
          '</tr>';
        }
        $sl_no++;
      endforeach;
      echo json_encode(array("activity_count"=>$activity_count,"content"=>$activity_table_body));
    }
    else{
      echo json_encode(array("activity_count"=>0));
    }
  }
  public function create()
  {
    $data['task_title'] = $this->security->xss_clean($this->input->post('title'));
    $data['task_description'] = $this->security->xss_clean($this->input->post('description'));
    $data['planned_start_date'] = date('Y-m-d',strtotime($this->security->xss_clean($this->input->post('planned_start_date'))));
    $data['planned_end_date'] = date('Y-m-d',strtotime($this->security->xss_clean($this->input->post('planned_end_date'))));
    $data['work_id'] = $this->security->xss_clean($this->input->post('project_task_work_id'));
    $data['user_id'] = $this->security->xss_clean($this->input->post('task_assigned_to'));
    $data['parent_id'] = $this->security->xss_clean($this->input->post('parent_task_id'));
    $data['task_status'] = 0;
    $data['created_date'] = date('Y-m-d H:i:s');
    $data['project_stage_id'] = $this->projects_management->get_project_stage_id($data['work_id']);
    if($this->session->userdata('user_role')=='supervisor' && $this->session->userdata('user_role_id')!=20){
      $data['user_id'] = $this->session->userdata('user_id');
    }
    $data['created_by'] = $this->session->userdata('user_id');
    $result = $this->Project_tasks->create_task($data);

    $flash_data['status'] = $result['status'];
    if ($flash_data['status'] == 1) {
      $flash_data['flashdata_type'] = 'success';
      $flash_data['flashdata_msg'] = 'Project Taks Created Succesfully';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
      if($data['parent_id']==0){
        $flash_data['parent_task_id'] = $result['insert_id'];
      }else{
        $flash_data['parent_task_id'] = $data['parent_id'];
      }

      // Add User Activity
      $this->User->add_user_activity('Project Task',$result['insert_id'],'Project Task Created');

      // Update Project Progress
      $this->projects_management->update_project_progress($data['work_id']);
    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo json_encode($flash_data);
  }
  public function update()
  {

    $data2['task_title'] = $this->security->xss_clean($this->input->post('title'));
    $data2['task_description'] = $this->security->xss_clean($this->input->post('description'));
    $data2['planned_start_date'] = date('Y-m-d',strtotime($this->security->xss_clean($this->input->post('start_date'))));
    $data2['planned_end_date'] = date('Y-m-d',strtotime($this->security->xss_clean($this->input->post('end_date'))));
    $data2['user_id'] = $this->security->xss_clean($this->input->post('task_assigned_to_edit'));

    $data3['task_id']=$data2['task_id'] = $this->security->xss_clean($this->input->post('project_task_id_edit'));
    $task_data = $this->Project_tasks->select_tasks("pt.*",array("pt.task_id"=>$data3['task_id']));
    if($this->session->userdata('user_role')=='admin' && $this->input->post('start_date_actual') && $this->input->post('start_date_actual')!='' && $this->input->post('start_date_actual')!='00-00-0000'){
      $data2['actual_start_date'] = date('Y-m-d',strtotime($this->security->xss_clean($this->input->post('start_date_actual'))));
    }
    if($this->session->userdata('user_role')=='admin' && $this->input->post('end_date_actual') && $this->input->post('end_date_actual')!='' && $this->input->post('end_date_actual')!='00-00-0000'){
      $data2['actual_end_date'] = date('Y-m-d',strtotime($this->security->xss_clean($this->input->post('end_date_actual'))));
    }
    // $result = $this->Project_tasks->select_tasks("pt.progress",$data3)->result();
    $data2['updated_date'] = date('Y-m-d H:i:s');
    $data2['updated_by'] = $this->session->userdata('user_id');
    $result2 = $this->Project_tasks->update_task($data2);

    $flash_data['status'] = $result2;
    if ($result2 == 1) {
      $flash_data['flashdata_type'] = 'success';
      $flash_data['flashdata_msg'] = 'Project Task Updated Succesfully';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
      if($task_data->row()->parent_id==0){
        $flash_data['parent_task_id'] = $task_data->row()->task_id;
      }else{
        $flash_data['parent_task_id'] = $task_data->row()->parent_id;
      }

      // Add User Activity
      $this->User->add_user_activity('Project Task',$data2['task_id'],'Project Task Details Updated');

      // Update Project Progress
      $this->projects_management->update_project_progress($task_data->row()->work_id);
    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo json_encode($flash_data);
  }
  public function delete()
  {
    $data2['task_id'] = $this->security->xss_clean($this->input->post('project_task_id_delete'));
    $task_data = $this->Project_tasks->select_tasks("pt.*",array("pt.task_id"=>$data2['task_id']));
    $data2['updated_date'] = date('Y-m-d H:i:s');
    $data2['updated_by'] = $this->session->userdata('user_id');
    $data2['delete_status'] = 1;
    $result2 = $this->Project_tasks->update_task($data2);

    $flash_data['status'] = $result2;
    if ($result2 == 1) {
      $flash_data['flashdata_type'] = 'success';
      $flash_data['flashdata_msg'] = 'Project Task Deleted Succesfully';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';

      // Update Project Progress
      $this->projects_management->update_project_progress($task_data->row()->work_id);

      // Add User Activity
      $this->User->add_user_activity('Project Task',$data2['task_id'],'Project Task Deleted');
    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo json_encode($flash_data);
  }

  public function create_activity()
  {
    $data['task_id'] = $this->security->xss_clean($this->input->post('activity_add_task_id_value'));
    $data['activity_title'] = $this->security->xss_clean($this->input->post('activity_title'));
    $data['activity_description'] = $this->security->xss_clean($this->input->post('activity_description'));
    $data['activity_date'] = date('Y-m-d',strtotime($this->security->xss_clean($this->input->post('activity_date'))));
    $data['created_date'] = date('Y-m-d H:i:s');
    $data['created_by'] = $this->session->userdata('user_id');
    $project_data = $this->Project_tasks->select_tasks("wc.actual_start_date,wc.work_id",array("pt.task_id"=>$data['task_id']))->row();
    $data['project_stage_id'] = $this->projects_management->get_project_stage_id($project_data->work_id);
    $result = $this->Project_tasks->create_task_activity($data);
    $flash_data['status'] = $result['status'];
    if ($result['status'] == 1) {
      $flash_data['flashdata_type'] = 'success';
      $flash_data['flashdata_msg'] = 'Project Taks Activity Created Succesfully';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';

      // Update Task Actual STart Date If Not Updated
      $task_data = $this->Project_tasks->select_tasks("pt.actual_start_date,pt.parent_id,pt.task_id",array("pt.task_id"=>$data['task_id']))->row();
      if($task_data->actual_start_date=='0000-00-00'){
        $task_update_data['actual_start_date'] = date('Y-m-d');
        $task_update_data['task_id'] = $data['task_id'];
        $this->Project_tasks->update_task($task_update_data);
      }
      if($task_data->parent_id!=0){
        $parent_task_data = $this->Project_tasks->select_tasks("pt.*",array("pt.task_id"=>$task_data->parent_id));
        if($parent_task_data->num_rows()==1){
          $parent_task_data = $parent_task_data->row();
          if($parent_task_data->actual_start_date=='0000-00-00'){
            $parent_task_update_data['actual_start_date'] = date('Y-m-d');
            $parent_task_update_data['task_id'] = $parent_task_data->task_id;
            $this->Project_tasks->update_task($parent_task_update_data);
          }
        }
      }
      if($task_data->parent_id==0){
        $flash_data['parent_task_id'] = $task_data->task_id;
      }else{
        $flash_data['parent_task_id'] = $task_data->parent_id;
      }
      // Update Project Actual STart Date If Not Updated
      if($project_data->actual_start_date=='0000-00-00'){
        $project_update_data['actual_start_date'] = date('Y-m-d');
        $project_update_data['work_id'] = $project_data->work_id;
        $this->Work->update_work($project_update_data);
      }

      // Add User Activity
      $this->User->add_user_activity('Project Task Activity',$result['insert_id'],'Project Task Activity Created');

    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo json_encode($flash_data);
  }
  public function update_activity()
  {

    $data2['activity_title'] = $this->security->xss_clean($this->input->post('activity_title'));
    $data2['activity_description'] = $this->security->xss_clean($this->input->post('activity_description'));
    $data2['activity_date'] = date('Y-m-d',strtotime($this->security->xss_clean($this->input->post('activity_date'))));
    // $data2['task_id'] = $this->security->xss_clean($this->input->post('activity_task_id'));
    $data2['id'] = $this->security->xss_clean($this->input->post('activity_id_edit'));


    $data2['updated_date'] = date('Y-m-d H:i:s');
    $data2['updated_by'] = $this->session->userdata('user_id');
    $result2 = $this->Project_tasks->update_task_activity($data2);

    $flash_data['status'] = $result2;
    if ($result2 == 1) {
      $flash_data['flashdata_type'] = 'success';
      $flash_data['flashdata_msg'] = 'Project Task Activity Updated Succesfully';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';

      // $task_data = $this->Project_tasks->select_tasks("pt.actual_start_date,pt.parent_id",array("pt.task_id"=>$data2['task_id']))->row();
      //
      // if($task_data->row()->parent_id==0){
      //   $flash_data['parent_task_id'] = $task_data->row()->task_id;
      // }else{
      //   $flash_data['parent_task_id'] = $task_data->row()->parent_id;
      // }
      // Add User Activity
      $this->User->add_user_activity('Project Task Activity',$data2['id'],'Project Task Activity Details Updated');
    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo json_encode($flash_data);
  }
  public function delete_activity()
  {
    $data2['id'] = $this->security->xss_clean($this->input->post('project_task_activity_id_delete'));
    $data2['updated_date'] = date('Y-m-d H:i:s');
    $data2['updated_by'] = $this->session->userdata('user_id');
    $data2['delete_status'] = 1;
    $result2 = $this->Project_tasks->update_task_activity($data2);

    $flash_data['status'] = $result2;
    if ($result2 == 1) {
      $flash_data['flashdata_type'] = 'success';
      $flash_data['flashdata_msg'] = 'Project Task Activity Deleted Succesfully';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';

      // Add User Activity
      $this->User->add_user_activity('Project Task Activity',$data2['id'],'Project Task Activity Deleted');
    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo json_encode($flash_data);
  }

  public function update_task_progess()
  {
    if($this->input->post('task_progress')!='NaN'){
      $data2['progress'] = $this->security->xss_clean($this->input->post('task_progress'));
    }else{
      $data2['progress'] = 0;
    }
    $data2['task_id'] = $this->security->xss_clean($this->input->post('task_id'));
    $task_data = $this->Project_tasks->select_tasks("pt.*",array("pt.task_id"=>$data2['task_id']));
    $task_data_result_array=$task_data->result();
    if($data2['progress']==100){
      $data2['task_status'] = 1;
      // Update Task Actual End Date If Not Updated
      if($task_data->row()->actual_end_date=='0000-00-00'){
        $data2['actual_end_date'] = date('Y-m-d');
      }
    }elseif($data2['progress']==0){
      $data2['task_status'] = 0;
    }else{
      $data2['task_status'] = 2;
    }
    // Update Task Actual STart Date If Not Updated
    if($task_data->row()->actual_start_date=='0000-00-00'){
      $data2['actual_start_date'] = date('Y-m-d');
    }
    $result2 = $this->Project_tasks->update_task($data2);

    $flash_data['status'] = $result2;
    if ($result2 == 1) {

      //if this task is subtask, updating it parent task progress
      $parent_task_id = $data3['pt.parent_id'] = $task_data_result_array[0]->parent_id;
      if($parent_task_id>0){
        $parent_task_data = $this->Project_tasks->select_tasks("pt.*",array("pt.task_id"=>$parent_task_id));
        if($parent_task_data->num_rows()==1){
          $result2 = $this->Project_tasks->select_tasks("pt.*",$data3);
          $subtask_count=$result2->num_rows();
          $subtask_result_array=$result2->result();

          foreach($subtask_result_array as $row2):
            if($row2->progress>0){
              $main_task_progress[] = $row2->progress;
            }
            else{
              $main_task_progress[] = 0;
            }
          endforeach;
          // $main_task_progress = array_filter($main_task_progress);

          $final_progress = array_sum($main_task_progress)/count($main_task_progress);
          $data_parent['progress'] = $final_progress;
          $data_parent['task_id'] = $parent_task_id;
          if($parent_task_data->row()->actual_start_date=='0000-00-00'){
            $data_parent['actual_start_date'] = date('Y-m-d');
          }
          if($data_parent['progress']==100){
            $data_parent['task_status'] = 1;
            // Update Task Actual End Date If Not Updated
            if($parent_task_data->row()->actual_end_date=='0000-00-00'){
              $data_parent['actual_end_date'] = date('Y-m-d');
            }
          }elseif($data_parent['progress']==0){
            $data_parent['task_status'] = 0;
          }else{
            $data_parent['task_status'] = 2;
          }
          $result2 = $this->Project_tasks->update_task($data_parent);

          // Add to Progress Update Log
          $progress_log_data_1['reference_id'] = $data_parent['task_id'];
          $progress_log_data_1['reference_type'] = "project_task";
          $progress_log_data_1['old_value'] = $parent_task_data->row()->progress;
          $progress_log_data_1['new_value'] = $data_parent['progress'];
          $progress_log_data_1['variation'] = $data_parent['progress']-$parent_task_data->row()->progress;
          $progress_log_data_1['created_date'] = date('Y-m-d H:i:s');
          $progress_log_data_1['created_by'] = $this->session->userdata('user_id');
          $this->Work->insert_progress_log($progress_log_data_1);
        }
      }

      //end of parent update
      if($task_data_result_array[0]->parent_id!=0){
        $flash_data['main_task_id'] = $task_data_result_array[0]->parent_id;
      }else{
        $flash_data['main_task_id'] = $data2['task_id'];
      }

      $flash_data['flashdata_type'] = 'success';
      $flash_data['flashdata_msg'] = 'Project Task Progress Updated Succesfully';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';

      // Add to Progress Update Log
      $progress_log_data['reference_id'] = $data2['task_id'];
      $progress_log_data['reference_type'] = "project_task";
      $progress_log_data['old_value'] = $task_data->row()->progress;
      $progress_log_data['new_value'] = $data2['progress'];
      $progress_log_data['variation'] = $data2['progress']-$task_data->row()->progress;
      $progress_log_data['created_date'] = date('Y-m-d H:i:s');
      $progress_log_data['created_by'] = $this->session->userdata('user_id');
      $this->Work->insert_progress_log($progress_log_data);

      // Update Project Progress
      $this->projects_management->update_project_progress($task_data->row()->work_id);

      // Add User Activity
      $this->User->add_user_activity('Project Task',$data2['task_id'],'Project Task Progress Updated');
    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo json_encode($flash_data);
  }

  public function get_tasks(){
    $data = array();
    if(isset($_POST['work_id']) && $_POST['work_id']!=""){
      $data['pt.work_id'] = $_POST['work_id'];
    }
    $result = $this->Project_tasks->select_tasks("pt.*,pt.created_date AS pt_created_date,pt.created_by AS pt_created_by",$data);
    if($result->num_rows()>0) {
      foreach ($result->result() as $row):
        $id[] = $row->task_id;
        $name[] = $row->task_title;
      endforeach;
      echo json_encode(array("count" => $result->num_rows(),"id" => $id,"name" => $name,));
    }else{
      echo json_encode(array("count" => $result->num_rows()));
    }
  }

  public function copy_project_schedule(){
    $success = $main_tasks_copied = $sub_tasks_copied = 0;
    // Select Main Tasks
    $data['pt.work_id'] = $this->security->xss_clean($this->input->post('from_work_id'));
    $data['pt.parent_id'] = 0;
    $project_tasks = $this->Project_tasks->select_tasks("pt.*",$data);
    foreach ($project_tasks->result() as $key => $value) {
      $task_data['task_title'] = $value->task_title;
      $task_data['task_description'] =  $value->task_description;
      $task_data['planned_start_date'] =  $value->planned_start_date;
      $task_data['planned_end_date'] =  $value->planned_end_date;
      $task_data['work_id'] = $this->security->xss_clean($this->input->post('to_work_id'));
      $task_data['parent_id'] =  $value->parent_id;
      $task_data['task_status'] = 0;
      $task_data['created_date'] = date('Y-m-d H:i:s');
      $task_data['user_id'] = $this->security->xss_clean($this->input->post('task_assigned_to'));;
      $task_data['created_by'] = $this->session->userdata('user_id');
      $task_result = $this->Project_tasks->create_task($task_data);
      if($task_result['status']==1){
        $main_tasks_copied++;

        //Check for subtasks
        $sub_data['pt.work_id'] = $this->security->xss_clean($this->input->post('from_work_id'));
        $sub_data['pt.parent_id'] = $value->task_id;
        $project_sub_tasks = $this->Project_tasks->select_tasks("pt.*",$sub_data)->result();
        foreach ($project_sub_tasks as $key2 => $value2) {
          $sub_task_data['task_title'] = $value2->task_title;
          $sub_task_data['task_description'] =  $value2->task_description;
          $sub_task_data['planned_start_date'] =  $value2->planned_start_date;
          $sub_task_data['planned_end_date'] =  $value2->planned_end_date;
          $sub_task_data['work_id'] = $this->security->xss_clean($this->input->post('to_work_id'));
          $sub_task_data['parent_id'] =  $task_result['insert_id'];
          $sub_task_data['task_status'] = 0;
          $sub_task_data['created_date'] = date('Y-m-d H:i:s');
          $sub_task_data['user_id'] = $this->security->xss_clean($this->input->post('task_assigned_to'));
          $sub_task_data['created_by'] = $this->session->userdata('user_id');
          $sub_task_result = $this->Project_tasks->create_task($sub_task_data);
          if($sub_task_result['status']==1){
            $sub_tasks_copied++;
          }
        }
      }
    }
    if($main_tasks_copied>0){
      $success=1;
    }
    $flash_data['status'] = $success;
    if ($success == 1) {
      $flash_data['flashdata_type'] = 'success';
      $flash_data['flashdata_msg'] = 'Project Schedule Copied Succesfully. Main Tasks('.$main_tasks_copied.') and Sub Tasks('.$sub_tasks_copied.")";
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    }elseif ($project_tasks->num_rows() == 0) {
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['flashdata_msg'] = 'No Project Schedule Tasks Found with Selected Project!!';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'No Schedule Found !';
    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    $this->session->set_flashdata($flash_data);
    redirect(base_url(). 'work/profile/'.$this->input->post('to_work_id'),'refresh');
  }
}
?>
