<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Material extends CI_Controller
{
  public $page_data = array();

  function __construct()
  {
    parent::__construct();
    $this->initial();
  }

  public function initial()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");

    $this->load->model('User_model', 'User');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Client_model', 'Client');
    $this->load->model('Supplier_model', 'Supplier');
    $this->load->model('Material_model', 'Material');
    $this->load->model('Settings_model', 'Settings');

    //        Check User Logged in or Not
    $allowed_user_roles = array("auditor","madmin","admin","supervisor","general_manager","purchase_manager","boq_manager","accounts_manager","qs","qs_manager","procurement_engineer","project_manager","operation_manager");
    if($this->User->is_logged_in($allowed_user_roles)==false){
      redirect(base_url(), 'refresh');
    }
    //        File Directory
    $this->page_data['directory'] = "materials";

  }

  public function index()
  {
    $this->view();
  }

  public function view()
  {
    $this->page_data['measure_units'] = $this->Material->select_unit()->result();
    $this->page_data['page_name'] = 'materials';
    $this->load->view('Index', $this->page_data);
  }
  public function categories()
  {
    $this->page_data['page_name'] = 'material_categories';
    $this->load->view('Index', $this->page_data);
  }
  public function select_material(){

    $json_data=array();
    $j=0;

    $data=array();
    if(isset($_POST['category']) && $_POST['category']!='' && $_POST['category']!='all'){
      $data['m.category'] = $_POST['category'];
    }
    $result	= $this->Material->select_material("",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();

    foreach($result_array as $row):
      $btn_edit = $btn_delete="";
      if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='madmin' || $this->session->userdata('user_role')=='purchase_manager' || $this->session->userdata('user_role')=='general_manager' || $this->session->userdata('user_role')=='operation_manager' ) {
        $btn_edit='<a style="margin-left: 5px;margin-right: 5px" id="material_edit_btn" href="#material_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-edit"></i>
        </a>';
      }
      if ($this->session->userdata('branch_id') == 0 || ($this->session->userdata('branch_id') != 0 && $row->material_branch_id==$this->session->userdata('branch_id'))) {
        if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='madmin' ){
          $btn_delete='<a  style="margin-left: 5px;margin-right: 5px" id="material_delete_btn" href="#material_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
          <i class="la la-trash"></i>
          </a>';
        }
      }
      $sale_price1 = $sale_price2 = $sale_price3 = $sale_price4 = $sale_price5 = $sale_price6 = 0;
      if ($this->config->item('app_module_sales_invoice') == 1){
        // Get Sale Prices
        $where_data['mp.material_id'] = $row->material_id;
        $where_data['mp.branch_id'] = $this->session->userdata('branch_id');
        $material_sale_price = $this->Material->select_material_prices("",$where_data);
        if($material_sale_price->num_rows()==1){
          $material_sale_price = $material_sale_price->row();
          $sale_price1 = $material_sale_price->sale_price1;
          $sale_price2 = $material_sale_price->sale_price2;
          $sale_price3 = $material_sale_price->sale_price3;
          $sale_price4 = $material_sale_price->sale_price4;
          $sale_price5 = $material_sale_price->sale_price5;
          $sale_price6 = $material_sale_price->sale_price6;
        }
      }

      $tax_name = '';
      if($row->material_tax_percent!=0){
        $tax_name = $this->config->item('Tax_tax_name');
        $tax_name .= " ".$row->tax_percentage."%";
        if($this->config->item('Tax_tax_splitting')==1){
          $tax_splits = array();
          if($row->tax1_percent!=0){
            $tax_splits[] = $this->config->item('Tax_tax1_name')." ".$row->tax1_percent."%";
          }
          if($row->tax2_percent!=0){
            $tax_splits[] = $this->config->item('Tax_tax2_name')." ".$row->tax2_percent."%";
          }
          if($row->tax3_percent!=0){
            $tax_splits[] = $this->config->item('Tax_tax3_name')." ".$row->tax3_percent."%";
          }
          if(sizeof($tax_splits)>0){
            $tax_name .= " [".implode(', ',$tax_splits)."]";
          }
        }
      }


      $array[$j][]=$row->material_id;
      $array[$j][]=$row->material_name;
      $array[$j][]=ucwords($row->material_type);
      $array[$j][]=ucwords($row->material_section);
      $array[$j][]=$row->material_specification;
      $array[$j][]=$row->item_code;
      $array[$j][]=$row->cat_name;
      $array[$j][]=$row->unit_name;
      if ($this->session->userdata('branch_id') != 0){
        $array[$j][]=$row->material_unit_price_branch;
      }else{
        $array[$j][]=$row->material_unit_price;
      }
      $array[$j][]=$sale_price1;
      $array[$j][]=$sale_price2;
      $array[$j][]=$sale_price3;
      $array[$j][]=$sale_price4;
      $array[$j][]=$sale_price5;
      $array[$j][]=$sale_price6;
      $array[$j][]=$tax_name;
      $array[$j][]=$btn_edit.$btn_delete;
      $array[$j][]=$row->unit;
      $array[$j][]=$row->category;
      $array[$j][]=$row->material_type;
      $array[$j][]=$row->material_branch_id;
      $array[$j][]=$row->material_tax_percent;
      $array[$j][]=$row->material_section;

      $j++;
    endforeach;

    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }
  public function create()
  {
    $json_data = array();
    $data2['material_name'] = $this->security->xss_clean($this->input->post('name'));
    if(stripos($data2['material_name'], "'") === false)
    {
      $data2['unit'] = $this->security->xss_clean($this->input->post('unit'));
      $data2['material_specification'] = $this->security->xss_clean($this->input->post('specification'));
      if($this->input->post('category')){
        $data2['category'] = $this->security->xss_clean($this->input->post('category'));
      }
      $data2['material_unit_price'] = $this->security->xss_clean($this->input->post('price'));
      $data2['item_code'] = $this->security->xss_clean($this->input->post('item_code'));
      if($this->config->item('app_module_vehicle_management')==1){
        $data2['material_type'] = $this->security->xss_clean($this->input->post('material_type'));
      }
      if($this->config->item('app_module_production')==1){
        $data2['material_section'] = $this->security->xss_clean($this->input->post('material_section'));
      }
      if($this->input->post('tax_percent')){
        $data2['material_tax_percent'] = $this->security->xss_clean($this->input->post('tax_percent'));
      }
      $count = $this->Material->select_material("material_id",array('material_name' => $data2['material_name']))->num_rows();
      if($count==0) {
        $result2 = $this->Material->create_material($data2);
        $flash_data['status'] = $result2['status'];
        if ($flash_data['status'] == 1) {
          // Create Sale Price
          if ($this->config->item('app_module_sales_invoice') == 1 && $this->config->item('Material_sale_price_category_enable') == 1){
            $material_price_data['material_id'] = $result2['insert_id'];
            $material_price_data['branch_id'] = $this->session->userdata('branch_id');
            if($this->input->post('sale_price1')){
              $material_price_data['sale_price1'] = $this->security->xss_clean($this->input->post('sale_price1'));
            }
            if($this->input->post('sale_price2')){
              $material_price_data['sale_price2'] = $this->security->xss_clean($this->input->post('sale_price2'));
            }
            if($this->input->post('sale_price3')){
              $material_price_data['sale_price3'] = $this->security->xss_clean($this->input->post('sale_price3'));
            }
            if($this->input->post('sale_price4')){
              $material_price_data['sale_price4'] = $this->security->xss_clean($this->input->post('sale_price4'));
            }
            if($this->input->post('sale_price5')){
              $material_price_data['sale_price5'] = $this->security->xss_clean($this->input->post('sale_price5'));
            }
            if($this->input->post('sale_price6')){
              $material_price_data['sale_price6'] = $this->security->xss_clean($this->input->post('sale_price6'));
            }
            $result3 = $this->Material->create_material_sale_price($material_price_data);
          }

          $flash_data['flashdata_msg'] = 'Material Created Successfully!.';
          $flash_data['flashdata_type'] = 'success';
          $flash_data['alert_type'] = 'success';
          $flash_data['flashdata_title'] = 'Success !';

        } else {
          $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
          $flash_data['flashdata_type'] = 'error';
          $flash_data['alert_type'] = 'danger';
          $flash_data['flashdata_title'] = 'Error !!';
        }
      }else{
        $flash_data['status'] = 2;
        $flash_data['flashdata_msg'] = 'Sorry.. Material with Same Name Already Exist!';
        $flash_data['flashdata_type'] = 'warning';
        $flash_data['alert_type'] = 'warning';
        $flash_data['flashdata_title'] = 'Duplication !!';
      }
    }
    else{
      $flash_data['status'] = 2;
      $flash_data['flashdata_msg'] = 'Sorry.. Material Name Contains single quote ! Please remove it and try again !';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }
    $flash_data['message'] = $flash_data['flashdata_msg'];
    echo(json_encode($flash_data));

  }
  public function update()
  {
    $json_data = array();
    $data2['material_id'] = $this->security->xss_clean($this->input->post('material_id'));
    $material_data = $this->Material->select_material("",$data2)->row();
    if($material_data->material_branch_id==$this->session->userdata('branch_id') || $material_data->material_branch_id==0){
      if($material_data->material_branch_id==$this->session->userdata('branch_id')){
        $data2['material_name'] = $this->security->xss_clean($this->input->post('material_name'));
        $data2['material_specification'] = $this->security->xss_clean($this->input->post('specification'));
        $data2['unit'] = $this->security->xss_clean($this->input->post('unit'));
        if($this->input->post('category')){
          $data2['category'] = $this->security->xss_clean($this->input->post('category'));
        }
        $data2['item_code'] = $this->security->xss_clean($this->input->post('item_code'));
        if($this->config->item('app_module_vehicle_management')==1){
          $data2['material_type'] = $this->security->xss_clean($this->input->post('material_type_edit'));
        }
        if($this->config->item('app_module_production')==1){
          $data2['material_section'] = $this->security->xss_clean($this->input->post('material_section_edit'));
        }
        if($this->input->post('tax_percent')){
          $data2['material_tax_percent'] = $this->security->xss_clean($this->input->post('tax_percent'));
        }
        $count = $this->Material->select_material("material_id",array('material_name' => $data2['material_name'],'material_id !=' => $data2['material_id']))->num_rows();
      }else{
        $count = 0;
      }
      if($this->session->userdata('branch_id')!=0){
        $data2['material_unit_price_branch'] = $this->security->xss_clean($this->input->post('price'));
      }else{
        $data2['material_unit_price'] = $this->security->xss_clean($this->input->post('price'));
      }

      if($count==0) {
        $result2 = $this->Material->update_material($data2);
        $flash_data['status'] = $result2;
        if ($flash_data['status'] == 1) {
          // Update Sale Price
          if ($this->config->item('app_module_sales_invoice') == 1 && $this->config->item('Material_sale_price_category_enable') == 1){
            $material_price_data['material_id'] = $data2['material_id'];
            $material_price_data['branch_id'] = $this->session->userdata('branch_id');
            if($this->input->post('sale_price1')){
              $material_price_data['sale_price1'] = $this->security->xss_clean($this->input->post('sale_price1'));
            }
            if($this->input->post('sale_price2')){
              $material_price_data['sale_price2'] = $this->security->xss_clean($this->input->post('sale_price2'));
            }
            if($this->input->post('sale_price3')){
              $material_price_data['sale_price3'] = $this->security->xss_clean($this->input->post('sale_price3'));
            }
            if($this->input->post('sale_price4')){
              $material_price_data['sale_price4'] = $this->security->xss_clean($this->input->post('sale_price4'));
            }
            if($this->input->post('sale_price5')){
              $material_price_data['sale_price5'] = $this->security->xss_clean($this->input->post('sale_price5'));
            }
            if($this->input->post('sale_price6')){
              $material_price_data['sale_price6'] = $this->security->xss_clean($this->input->post('sale_price6'));
            }
            // Check Data EXIST
            $where_data['mp.material_id'] = $material_price_data['material_id'];
            $where_data['mp.branch_id'] = $material_price_data['branch_id'];
            $material_sale_price = $this->Material->select_material_prices("",$where_data);
            if($material_sale_price->num_rows()==1){
              // Update
              $material_price_data['price_id'] = $material_sale_price->row()->price_id;
              $result3 = $this->Material->update_material_prices($material_price_data);
            }else{
              // Create
              $result3 = $this->Material->create_material_sale_price($material_price_data);
            }

          }

          $flash_data['flashdata_msg'] = 'Material Details Updated Successfully!.';
          $flash_data['flashdata_type'] = 'success';
          $flash_data['alert_type'] = 'success';
          $flash_data['flashdata_title'] = 'Success !';
        } else {
          $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
          $flash_data['flashdata_type'] = 'error';
          $flash_data['alert_type'] = 'danger';
          $flash_data['flashdata_title'] = 'Error !!';
        }
      }else{
        $flash_data['status'] = 2;
        $flash_data['flashdata_msg'] = 'Sorry.. Material with Same Name Already Exist!';
        $flash_data['flashdata_type'] = 'warning';
        $flash_data['alert_type'] = 'warning';
        $flash_data['flashdata_title'] = 'Duplication !!';
      }
    }else{
      $flash_data['status'] = 2;
      $flash_data['flashdata_msg'] = 'Sorry.. Material with Same Name Already Exist!';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }

    echo json_encode($flash_data);

  }
  public function delete()
  {
    $json_data = array();
    $data2['material_id'] = $this->security->xss_clean($this->input->post('material_id'));
    $material_data = $this->Material->select_material("",$data2)->row();
    if($material_data->material_branch_id==$this->session->userdata('branch_id')){
      $data2['delete_status'] = 1;
      $result2 = $this->Material->update_material($data2);
      $flash_data['status'] = $result2;
      if ($flash_data['status'] == 1) {
        $flash_data['flashdata_msg'] = 'Material Deleted Successfully!.';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';

      } else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    }else {
      $flash_data['status'] = 2;
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }

    echo json_encode($flash_data);

  }

  public function select(){
    $data['m.delete_status'] = 0;
    if(isset($_POST['id']) && $_POST['id']!=""){
      $data['m.material_id'] = $_POST['id'];
    }
    if(isset($_POST['section']) && $_POST['section']!=""){
      $data['m.material_section'] = $_POST['section'];
    }
    if(isset($_POST['material_type']) && $_POST['material_type']!=""){
      $data['m.material_type'] = $_POST['material_type'];
    }
    if(isset($_POST['category']) && $_POST['category']!="" && $_POST['category']!="all" && $_POST['category']!="Select Category"){
      $data['m.category'] = $_POST['category'];
    }
    $result	= $this->Material->select_material("",$data);
    if($result->num_rows()>0) {
      foreach ($result->result() as $row):
        $id[] = $row->material_id;
        if($row->material_specification!=''){
          $name[] = $row->material_name." - ".$row->material_specification;
        }else{
          $name[] = $row->material_name;
        }
        $unit[]  = $row->unit;
        $unit_name[]  = $row->unit_name;
        if ($this->session->userdata('branch_id') != 0){
          $unit_price[]  = $row->material_unit_price_branch;
        }else{
          $unit_price[]  = $row->material_unit_price;
        }
        $item_code[]  = $row->item_code;
        $specification[]  = $row->material_specification;

        if ($this->config->item('app_module_sales_invoice') == 1 && $this->config->item('Material_sale_price_category_enable') == 1){
          // Get Sale Prices
          $where_data['mp.material_id'] = $row->material_id;
          $where_data['mp.branch_id'] = $this->session->userdata('branch_id');
          $material_sale_price = $this->Material->select_material_prices("",$where_data);
          if($material_sale_price->num_rows()==1){
            $material_sale_price = $material_sale_price->row();
            $sale_price1[] = $material_sale_price->sale_price1;
            $sale_price2[] = $material_sale_price->sale_price2;
            $sale_price3[] = $material_sale_price->sale_price3;
            $sale_price4[] = $material_sale_price->sale_price4;
            $sale_price5[] = $material_sale_price->sale_price5;
            $sale_price6[] = $material_sale_price->sale_price6;
          }else{
            $sale_price1[] = $sale_price2[] = $sale_price3[] = $sale_price4[] = $sale_price5[] = $sale_price6[] = 0;
          }
        }else{
          $sale_price1[] = $sale_price2[] = $sale_price3[] = $sale_price4[] = $sale_price5[] = $sale_price6[] = 0;
        }
      endforeach;

      echo json_encode(array("count" => $result->num_rows(),"id" => $id,"name" => $name,"specification" => $specification,"unit" => $unit,"unit_name" => $unit_name,"unit_price" => $unit_price,"item_code" => $item_code,"sale_price1" => $sale_price1,"sale_price2" => $sale_price2,"sale_price3" => $sale_price3,"sale_price4" => $sale_price4,"sale_price5" => $sale_price5,"sale_price6" => $sale_price6));
    }else{
      echo json_encode(array("count" => $result->num_rows()));
    }
  }
  public function select_list(){
    $data['m.delete_status'] = 0;
    if(isset($_POST['id']) && $_POST['id']!=""){
      $data['m.material_id'] = $_POST['id'];
    }
    if(isset($_POST['material_type']) && $_POST['material_type']!=""){
      $data['m.material_type'] = $_POST['material_type'];
    }
    if(isset($_POST['category']) && $_POST['category']!="" && $_POST['category']!="all" && $_POST['category']!="Select Category"){
      $data['m.category'] = $_POST['category'];
    }
    $result	= $this->Material->select_material("",$data);
    if($result->num_rows()>0) {
      $material_data = $result->result();
      foreach ($material_data as $key => $value) {
        if ($this->session->userdata('branch_id') != 0){
          $value->material_unit_price = $value->material_unit_price_branch;
        }
        $value->sale_price1 = $value->sale_price2 = $value->sale_price3 = $value->sale_price4 = $value->sale_price5 = $value->sale_price6 = 0;
        if ($this->config->item('app_module_sales_invoice') == 1 && $this->config->item('Material_sale_price_category_enable') == 1){
          // Get Sale Prices
          $where_data['mp.material_id'] = $value->material_id;
          $where_data['mp.branch_id'] = $this->session->userdata('branch_id');
          $material_sale_price = $this->Material->select_material_prices("",$where_data);
          if($material_sale_price->num_rows()==1){
            $material_sale_price = $material_sale_price->row();
            $value->sale_price1 = $material_sale_price->sale_price1;
            $value->sale_price2 = $material_sale_price->sale_price2;
            $value->sale_price3 = $material_sale_price->sale_price3;
            $value->sale_price4 = $material_sale_price->sale_price4;
            $value->sale_price5 = $material_sale_price->sale_price5;
            $value->sale_price6 = $material_sale_price->sale_price6;
          }
        }
      }

      echo json_encode(array("count" => $result->num_rows(),"data" => $material_data));
    }else{
      echo json_encode(array("count" => $result->num_rows()));
    }
  }
  public function select_details(){
    $data['m.delete_status'] = 0;
    if(isset($_POST['id']) && $_POST['id']!=""){
      $data['m.material_id'] = $_POST['id'];
    }
    $result	= $this->Material->select_material("",$data);
    if($result->num_rows()==1) {
      $material_data = $result->row();
      if ($this->session->userdata('branch_id') != 0){
        $material_data->material_unit_price = $material_data->material_unit_price_branch;
      }
      $material_data->sale_price1 = $material_data->sale_price2 = $material_data->sale_price3 = $material_data->sale_price4 = $material_data->sale_price5 = $material_data->sale_price6 = 0;
      if ($this->config->item('app_module_sales_invoice') == 1 && $this->config->item('Material_sale_price_category_enable') == 1){
        // Get Sale Prices
        $where_data['mp.material_id'] = $material_data->material_id;
        $where_data['mp.branch_id'] = $this->session->userdata('branch_id');
        $material_sale_price = $this->Material->select_material_prices("",$where_data);
        if($material_sale_price->num_rows()==1){
          $material_sale_price = $material_sale_price->row();
          $material_data->sale_price1 = $material_sale_price->sale_price1;
          $material_data->sale_price2 = $material_sale_price->sale_price2;
          $material_data->sale_price3 = $material_sale_price->sale_price3;
          $material_data->sale_price4 = $material_sale_price->sale_price4;
          $material_data->sale_price5 = $material_sale_price->sale_price5;
          $material_data->sale_price6 = $material_sale_price->sale_price6;
        }
      }
      echo json_encode(array("count" => $result->num_rows(),"data" => $material_data));
    }else{
      echo json_encode(array("count" => $result->num_rows()));
    }
  }
  // Material Categories
  public function select_material_categories(){

    $json_data=array();
    $j=0;

    $data=array();
    $result	= $this->Material->select_category("",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();

    foreach($result_array as $row):

      $btn_edit='';
      if($this->session->userdata('branch_id') == 0){
        if($this->session->userdata('user_role')!='auditor'){
          $btn_edit='<a style="margin-left: 5px;margin-right: 5px" id="category_edit_btn" href="#category_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
          <i class="la la-edit"></i>
          </a>';
        }
      }
      $array[$j][]=$row->cat_id;
      $array[$j][]=$row->cat_name;
      $array[$j][]=$btn_edit;

      $j++;
    endforeach;

    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }
  public function create_category()
  {
    $json_data = array();
    $data2['cat_name'] = $this->security->xss_clean($this->input->post('name'));
    $count = $this->Material->select_category("cat_id",array('cat_name' => $data2['cat_name']))->num_rows();
    if($count==0){
      $result2 = $this->Material->create_category($data2);
      $flash_data['status'] = $result2['status'];
      if ($flash_data['status'] == 1) {
        $flash_data['flashdata_msg'] = 'Category Created Successfully!.';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';

      } else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    }else {
      $flash_data['status'] = 2;
      $flash_data['flashdata_msg'] = 'Sorry.. Submitted Category Already Exists!';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }
    $flash_data['message'] = $flash_data['flashdata_msg'];
    echo json_encode($flash_data);
  }
  public function update_category()
  {
    $json_data = array();
    $data2['cat_id'] = $this->security->xss_clean($this->input->post('category_id'));
    $data2['cat_name'] = $this->security->xss_clean($this->input->post('category_name'));
    $count = $this->Material->select_category("cat_id",array('cat_name' => $data2['cat_name'],'cat_id !=' => $data2['cat_id']))->num_rows();
    if($count==0) {
      $result2 = $this->Material->update_category($data2);
      $flash_data['status'] = $result2;
      if ($flash_data['status'] == 1) {
        $flash_data['flashdata_msg'] = 'Category Updated Successfully!.';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';

      } else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    }else {
      $flash_data['status'] = 2;
      $flash_data['flashdata_msg'] = 'Sorry.. Submitted Category Already Exists!';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }
    echo json_encode($flash_data);

  }
  public function select_category(){
    $data = array();
    if(isset($_POST['id']) && $_POST['id']!=""){
      $data['mc.cat_id'] = $_POST['id'];
    }
    $result	= $this->Material->select_category("",$data);
    if($result->num_rows()>0) {
      foreach ($result->result() as $row):
        $id[] = $row->cat_id;
        $name[]  = $row->cat_name;
      endforeach;
      echo json_encode(array("count" => $result->num_rows(),"id" => $id,"name" => $name));
    }else{
      echo json_encode(array("count" => $result->num_rows()));
    }
  }
}
?>
