<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Income extends CI_Controller
{
  public $page_data = array();

  function __construct()
  {
    parent::__construct();
    $this->initial();
  }
  public function initial()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");

    $this->load->model('User_model', 'User');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Client_model', 'Client');
    $this->load->model('Account_model', 'Account');
    $this->load->model('Settings_model', 'Settings');
    $this->load->model('Documents_model', 'Documents');
    $this->load->model('Invoices_model', 'Invoices');
    $this->load->library('Bills_management','bills_management');
    $this->load->library('Accounts_management', 'accounts_management');
    $this->load->library('Projects_management','projects_management');

    //        Check User Logged in or Not
    $allowed_user_roles = array("madmin","admin","general_manager","accounts_manager","auditor","supervisor");
    if($this->User->is_logged_in($allowed_user_roles)==false){
      redirect(base_url(), 'refresh');
    }
    //        File Directory
    $this->page_data['directory'] = "income";

  }
  public function index()
  {
    $this->receipts();
  }

  public function receipts()
  {
    $this->page_data['page_name'] = 'income_receipts';

    if($this->session->userdata('user_role')=='supervisor') {
      //          Select Assigned Works Only
      $supervisor_id = $this->session->userdata('user_id');
      $this->db->where("FIND_IN_SET($supervisor_id, w.assigned_users)");
    }
    $this->page_data['work_contracts'] = $this->Work->select_work("*")->result();

    $this->page_data['clients'] = $this->Client->select_client()->result();
    $this->load->view('Index',$this->page_data);
  }

  public function select_income_receipts($page_data_type=""){

    $json_data=array();
    $j=0;
    $sl_no=0;
    $total_amount=0;
    $data=array();
    if(isset($_POST['date']) && $_POST['date']!=''){
      $date=array();
      $date=explode('-',$_POST['date']);
      $start_date=date('Y-m-d', strtotime($date[0]));
      $end_date=date('Y-m-d', strtotime($date[1]));
      $data["STR_TO_DATE(ats.tr_date,'%Y-%m-%d') <="]= $end_date;
      $data["STR_TO_DATE(ats.tr_date,'%Y-%m-%d') >="]= $start_date;
    }
    if(isset($_POST['start_date']) && $_POST['start_date']!=''){
      $data["ats.tr_date >="]= date('Y-m-d', strtotime($_POST['start_date']));
    }
    if(isset($_POST['end_date']) && $_POST['end_date']!=''){
      $data["ats.tr_date <="]= date('Y-m-d', strtotime($_POST['end_date']));
    }
    if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
      $data['ats.tr_work_id'] = $_POST['work'];
    }
    if($this->session->userdata('user_role')=='supervisor') {
      //          Select Assigned Works Only
      $supervisor_id = $this->session->userdata('user_id');
      // $this->db->where("FIND_IN_SET($supervisor_id, wc.assigned_users)");
    }
    if($this->config->item('user_data_access_view_all')!=1){
      $data['ats.created_by'] = $this->session->userdata('user_id');
    }
    if(isset($_POST['project']) && $_POST['project']!='' && $_POST['project']!='all'){
      $data['ats.tr_work_id'] = $_POST['project'];
    }
    if(isset($_POST['created_by']) && $_POST['created_by']!='' && $_POST['created_by']!='all'){
      $data['ats.created_by'] = $_POST['created_by'];
    }
    if(isset($_POST['user_id']) && $_POST['user_id']!='' && $_POST['user_id']!='all'){
      $data['ats.created_by'] = $_POST['user_id'];
    }
    if(isset($_POST['acc_user_id']) && $_POST['acc_user_id']!='' && $_POST['acc_user_id']!='all'){
      $data['ah2.acc_user_id'] = $_POST['acc_user_id'];
    }

    $data['ats.tr_type'] = 'income_receipt_transaction';
    $this->db->where("(ats.reference_type='income_receipt' or (ats.reference_type='client' and ats.invoice_id!=0))");
    $entry_approval = 1;
    if($this->config->item('User_enable_data_entry_approval')==1){//webapp users approval
      $entry_approval = 'all';
    }
    if($page_data_type=='approval_entries'){
      $entry_approval = 'all';
      $data['u1.user_role >'] =2;
      if(isset($_POST['approval_status']) && $_POST['approval_status']!='' && $_POST['approval_status']!='all'){
        $entry_approval = $_POST['approval_status'];
      }
    }

    $result	= $this->Account->select_account_transaction("ats.*,wc.work_name,u1.user_alias as created_user,u2.user_alias as updated_user,ah2.acc_head_name as credit_account,u1.user_role as created_user_role_id",$data,'income_receipt','','','',$entry_approval);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();


    foreach($result_array as $row):
      $transaction_id_column = 1;
      $btn_edit = $btn_delete='';
      if(($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_id')==$row->created_by) && ($this->config->item('User_enable_data_entry_approval')!=1 || $row->tr_entry_approval_status!=1 || $this->session->userdata('user_role')=='admin')) {
        if($row->invoice_id==0){
          $btn_edit = '<a style="margin-left: 5px;margin-right: 5px" id="income_receipt_edit_btn" href="#income_receipt_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
          <i class="la la-edit"></i>
          </a>';
          $btn_delete='<a style="margin-left: 5px;margin-right: 5px" data-form-type="income_receipt" data-tr-type="income_receipt_transaction" data-form-type="income_receipt" data-id-column="'.$transaction_id_column.'" id="btn_delete_transaction"  href="#transaction_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
          <i class="la la-trash"></i>
          </a>';
        }
      }

      if($row->invoice_id!=0){
        $income_under = '<a href="'.base_url().'invoices/profile/'.$row->invoice_id.'">Other Income Invoice #'.$row->invoice_id.' Receipt</a>';
      }else{
        if($row->tr_work_id==0){
          $income_under = 'Office';
        }else{
          $income_under = $row->work_name;
        }
      }

      $btn_approve = $entry_approval_status = '';
      if(($this->session->userdata('user_role')=='admin' || ($this->session->userdata('user_role')=='accounts_manager' && $row->created_user_role_id>2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1){
        $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="other_income" data-approval-status="'.$row->tr_entry_approval_status.'" data-id="'.$row->transaction_id.'" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
        <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
        </a>';
      }
      if(($page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1) || $this->config->item('User_enable_data_entry_approval')==1){
        if($row->tr_entry_approval_status==1){
          $entry_approval_status="<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> Approved</span>";
        }elseif($row->tr_entry_approval_status==2){
          $entry_approval_status="<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> Rejected</span>";
        }else{
          $entry_approval_status="<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> Pending</span>";
        }
      }


      $sl_no++;
      $array[$j][]=$sl_no;
      $array[$j][] = $row->transaction_id;
      $array[$j][] = "#".$row->transaction_id;
      $array[$j][]=date('d-m-Y',strtotime($row->tr_date));
      $array[$j][] = $income_under;
      $array[$j][] = $row->tr_description;
      $array[$j][]=$row->tr_amount;
      $array[$j][]=$row->credit_account;
      $array[$j][] = $row->tr_reference_no;
      $array[$j][] = $row->tr_remarks;
      $array[$j][]=$row->created_user.$entry_approval_status;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]=date('d-m-Y',strtotime($row->created_date));
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$btn_edit.$btn_delete.$btn_approve;
      $array[$j][]=$row->tr_credit_acc;
      $array[$j][]=$row->tr_work_id;
      $array[$j][] = $row->tr_entry_approval_status;

      $total_amount=$total_amount+$row->tr_amount;

      $j++;
    endforeach;
    if($result->num_rows()>0){
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][] = '';
      $array[$j][] = '';
      $array[$j][]="<strong>Total</strong>";
      $array[$j][]="<strong>".$total_amount."</strong>";
      $array[$j][] = '';
      $array[$j][] = '';
      $array[$j][] = '';
      $array[$j][] = '';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][] = '';
      $array[$j][] = '';

    }

    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }

}
?>
