<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Expense extends CI_Controller
{
  public $page_data = array();

  function __construct()
  {
    parent::__construct();
    $this->initial();
  }

  public function initial()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");

    $this->load->model('User_model', 'User');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Client_model', 'Client');
    $this->load->model('Supplier_model', 'Supplier');
    $this->load->model('Account_model', 'Account');
    $this->load->model('Settings_model', 'Settings');
    $this->load->model('Bills_model', 'Bills');
    $this->load->library('Bills_management','bills_management');

    $this->load->library('Projects_management','projects_management');

    //        Check User Logged in or Not
    $allowed_user_roles = array("madmin","admin","supervisor","general_manager","accounts_manager","auditor","purchase_manager","qs","qs_manager","operation_manager");
    if($this->User->is_logged_in($allowed_user_roles)==false){
      redirect(base_url(), 'refresh');
    }
    //      File Directory
    $this->page_data['directory'] = "expenses";

    $user_accounts_where = "ur.role_name='supervisor' or ur.role_name='general_manager'";
    $this->page_data['user_accounts'] = $this->Account->select_account_heads("",$user_accounts_where,"user")->result();
    if($this->config->item('Labour_group_member_payment')==0){
      $this->db->where('(l.labour_type=0 or (l.labour_type=1 and group_position=1))');
    }
    $this->page_data['labours_2'] = $this->Labour->select_labours()->result();
  }
  public function index($param1="")
  {
    $this->view($param1);
  }

  public function view($param1="")
  {
    $this->page_data['selected_start_date'] = $this->page_data['selected_end_date'] = "";
    if (isset($_GET['start_date']) && $_GET['start_date'] != '') {
      $this->page_data['selected_start_date'] = $_GET['start_date'];
    }
    if (isset($_GET['end_date']) && $_GET['end_date'] != '') {
      $this->page_data['selected_end_date'] = $_GET['end_date'];
    }

    $this->page_data['page_name'] = 'expense_bills';

    if($this->session->userdata('user_role')=='supervisor') {
      //          Select Assigned Works Only
      $supervisor_id = $this->session->userdata('user_id');
      $this->db->where("FIND_IN_SET($supervisor_id, w.assigned_users)");
    }
    $this->page_data['work_contracts'] = $this->Work->select_work("*")->result();

    $this->load->view('Index', $this->page_data);
  }

  public function select_expense_bills($page_data_type=''){

    $json_data=array();
    $j=$sl_no=$total_bill_amount=$total_paid_amount=$total_balance_amount=$total_tax_amount=$total_tax1_amount=$total_tax2_amount=$total_tax3_amount=0;
    $data=array();
    if(isset($_POST['date']) && $_POST['date']!=''){
      $date=array();
      $date=explode('-',$_POST['date']);
      $start_date=date('Y-m-d', strtotime($date[0]));
      $end_date=date('Y-m-d', strtotime($date[1]));
      $data["STR_TO_DATE(b.bill_date,'%Y-%m-%d') <="]= $end_date;
      $data["STR_TO_DATE(b.bill_date,'%Y-%m-%d') >="]= $start_date;
    }
    if(isset($_POST['bill_supplier_id']) && $_POST['bill_supplier_id']!='' && $_POST['bill_supplier_id']!='all'){
      $data['b.bill_supplier_id'] = $_POST['bill_supplier_id'];
    }
    if(isset($_POST['expense_head']) && $_POST['expense_head']!='' && $_POST['expense_head']!='all'){
      $data['b.bill_credit_ac'] = $_POST['expense_head'];
    }
    if(isset($_POST['expense_type']) && $_POST['expense_type']!='' && $_POST['expense_type']!='all'){
      $data['b.bill_expense_type'] = $_POST['expense_type'];
    }
    if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
      $data['b.work_id'] = $_POST['work'];
    }
    if(isset($_POST['work_ids']) && $_POST['work_ids']!='' && $_POST['work_ids']!='all'){
      $this->db->where_in('b.work_id',explode(',',$_POST['work_ids']));
    }
    if(isset($_POST['stage_id']) && $_POST['stage_id']!='' && $_POST['stage_id']!='all'){
      $data['b.project_stage_id'] = $_POST['stage_id'];
    }
    if(isset($_POST['user_id']) && $_POST['user_id']!='' && $_POST['user_id']!='all'){
      $data['b.created_by'] = $_POST['user_id'];
    }
    if(isset($_POST['created_by']) && $_POST['created_by']!='' && $_POST['created_by']!='all'){
      $data['b.created_by'] = $_POST['created_by'];
    }
    if(isset($_POST['start_date']) && $_POST['start_date']!='' && $_POST['start_date']!='all'){
      $data['b.bill_date >='] = date('Y-m-d', strtotime($_POST['start_date']));
    }
    if(isset($_POST['end_date']) && $_POST['end_date']!='' && $_POST['end_date']!='all'){
      $data['b.bill_date <='] = date('Y-m-d', strtotime($_POST['end_date']));
    }
    if($this->session->userdata('user_role')=='supervisor') {
      //          Select Assigned Works Only
      $supervisor_id = $this->session->userdata('user_id');
      // $this->db->where("FIND_IN_SET($supervisor_id, wc.assigned_users)");
    }
    if($this->config->item('user_data_access_view_all')!=1){
      $data['b.created_by'] = $this->session->userdata('user_id');
    }
    $entry_approval = $entry_approval_2 = 1;
    if($this->config->item('User_enable_data_entry_approval')==1){//webapp users approval
      $entry_approval = $entry_approval_2 = 'all';
    }
    if($page_data_type=='approval_entries'){
      $entry_approval = 'all';
      $data['u.user_role >'] =2;
      if(isset($_POST['approval_status']) && $_POST['approval_status']!='' && $_POST['approval_status']!='all'){
        $entry_approval = $_POST['approval_status'];
      }
    }
    if($page_data_type=='approval_entries_2_level'){
      $entry_approval_2 = 'all';
      $data['u.user_role >'] =2;
      $data['b.entry_approval_status'] =1;
      if(isset($_POST['approval_status']) && $_POST['approval_status']!='' && $_POST['approval_status']!='all'){
        $entry_approval_2 = $_POST['approval_status'];
      }
    }
    $data['b.bill_type'] = 'expense';
    $result	= $this->Bills->select_bills("b.*,ah1.acc_head_name as expense_head_name,u.user_alias,wc.work_name,u.user_role,tt.tax_percentage,tt.tax1_percent,tt.tax2_percent,tt.tax3_percent,u.user_role as created_user_role_id",$data,'','','',$entry_approval,$entry_approval_2);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();

    foreach($result_array as $row):
      $sl_no++;
      $id=$row->work_id;
      $bill_id_column= 29;//Column Where Bill ID Exist
      $btn_edit = $btn_delete = $btn_add_payment  = '';
      if(($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='general_manager' || $this->session->userdata('user_role')=='accounts_manager' || $this->session->userdata('user_id')==$row->created_by) && ($this->config->item('User_enable_data_entry_approval')!=1 || $row->entry_approval_status!=1 || $this->session->userdata('user_role')=='admin')) {
        if($row->bill_credit_ac==23){//local material purchase
          $btn_edit = '<a style="margin-left: 5px;margin-right: 5px" id="local_material_purchase_bill_edit_btn" href="#local_material_purchase_bill_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
          <i class="la la-edit"></i>
          </a>';
        }else{
          $btn_edit = '<a style="margin-left: 5px;margin-right: 5px" id="expense_bill_edit_btn" href="#expense_bill_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
          <i class="la la-edit"></i>
          </a>';
        }

        $btn_delete = '<a style="margin-left: 5px;margin-right: 5px" data-bill-type="expense_bill" data-bill-id-column="'.$bill_id_column.'" id="btn_delete_bill"  href="#bill_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-trash"></i>
        </a>';
      }
      if($this->session->userdata('user_role')!='auditor' || $this->session->userdata('user_data_permission')['adding']==1){
        if($row->bill_payment_status!=1){
          $btn_add_payment = '<a style="margin-left: 5px;margin-right: 5px" data-bill-type="expense_bill" data-bill-id-column="'.$bill_id_column.'" id="btn_add_bill_payment" href="#bill_payment_add_modal" data-toggle="modal" class="btn btn-focus m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
          <i class="la la-plus-circle"></i>
          </a>';
        }
      }
      $btn_approve = $entry_approval_status = '';
      if(($this->session->userdata('user_role')=='admin' || ($this->session->userdata('user_role')=='accounts_manager' && $row->created_user_role_id>2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1){
        if($this->config->item('User_enable_data_entry_approval_2_level')==0 || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && $row->entry_approval_status_2 == 0)){
          $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="expense_bill" data-approval-status="'.$row->entry_approval_status.'" data-id="'.$row->bill_id.'" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
          <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
          </a>';
        }
      }
      if($this->config->item('User_enable_data_entry_approval_2_level')==1 && $this->session->userdata('user_role')=='admin' && $page_data_type=='approval_entries_2_level'){
        $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="expense_bill" data-approval-status="'.$row->entry_approval_status_2.'" data-id="'.$row->bill_id.'" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
        <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
        </a>';
      }
      if(($page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1) || $this->config->item('User_enable_data_entry_approval')==1){
        $level='';
        if($this->config->item('User_enable_data_entry_approval_2_level')==1){
          $level='1st Level ';
        }
        if($row->entry_approval_status==1){
          $entry_approval_status="<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> ".$level."Approved</span>";
        }elseif($row->entry_approval_status==2){
          $entry_approval_status="<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> ".$level."Rejected</span>";
        }else{
          $entry_approval_status="<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> ".$level."Pending</span>";
        }
        if($this->config->item('User_enable_data_entry_approval_2_level')==1 && $row->entry_approval_status == 1){
          if ($row->entry_approval_status_2 == 1) {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> 2nd Level Approved</span>";
          } elseif ($row->entry_approval_status_2 == 2) {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> 2nd Level Rejected</span>";
          } else {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> 2nd Level Pending</span>";
          }
        }
      }

      $expense_type=ucwords($row->bill_expense_type)." Expense";

      if($row->bill_payment_status==1){
        $bill_payment_status="<span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> Paid</span>";
      }elseif($row->bill_payment_status==2){
        $bill_payment_status="<span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-ellipsis-h'></i> Partially Paid</span>";
      }else{
        $bill_payment_status="<span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-times-circle'></i> Not Paid</span>";
      }
      $bill_attachment = $bill_attachment_url = $bill_attachment_btn = "";
      if($row->bill_attachment!=''){
        $bill_attachment = $row->bill_attachment;
        $bill_attachment_url =  base_url()."uploads/bills/".$bill_attachment;
        $bill_attachment_btn = '<a target="_blank" href="'.$bill_attachment_url.'">View Attachment</a>';
      }

      $bill_items='';
      if($row->bill_items!=''){
        $bill_items = unserialize($row->bill_items);
        $bill_items = json_encode($bill_items);
      }
      $bill_taxable_amount = $row->bill_gross_amount;
      $row->bill_tax1_amount = round($row->bill_gross_amount*$row->tax1_percent/100,$this->config->item('Currency_amount_decimals_2'));
      $row->bill_tax2_amount = round($row->bill_gross_amount*$row->tax2_percent/100,$this->config->item('Currency_amount_decimals_2'));
      $row->bill_tax3_amount = round($row->bill_gross_amount*$row->tax3_percent/100,$this->config->item('Currency_amount_decimals_2'));

      $array[$j][]=$sl_no;
      $array[$j][]='<a id="m_quick_sidebar_toggle" data-type="bill_profile" data-bill-type="expense_bill" data-id="'.$row->bill_id.'" href="javascript:;">#'.$row->bill_id.'</a>';
      $array[$j][]=date('d-m-Y',strtotime($row->bill_date));
      $array[$j][]=$expense_type;
      $array[$j][]=$row->expense_head_name;
      $array[$j][]=$row->bill_no;
      $array[$j][]=$row->bill_consignee_name;
      $array[$j][]=$row->bill_tax_no;
      $array[$j][]=$row->tax_percentage."%";
      $array[$j][]=number_format($row->bill_tax_amount,$this->config->item('Currency_amount_decimals_2'),'.','');
      $array[$j][]=$row->tax1_percent;
      $array[$j][]=number_format($row->bill_tax1_amount,$this->config->item('Currency_amount_decimals_2'),'.','');
      $array[$j][]=$row->tax2_percent;
      $array[$j][]=number_format($row->bill_tax2_amount,$this->config->item('Currency_amount_decimals_2'),'.','');
      $array[$j][]=$row->tax3_percent;
      $array[$j][]=number_format($row->bill_tax3_amount,$this->config->item('Currency_amount_decimals_2'),'.','');
      $array[$j][]=number_format($row->bill_payable_amount,$this->config->item('Currency_amount_decimals_2'),'.','');
      $array[$j][]=number_format($row->bill_total_paid,$this->config->item('Currency_amount_decimals_2'),'.','');
      $array[$j][]=number_format($row->bill_balance_amount,$this->config->item('Currency_amount_decimals_2'),'.','');
      $array[$j][]=$bill_payment_status;
      $array[$j][]=$row->bill_description;
      $array[$j][]=$row->bill_remarks;
      $array[$j][]=$bill_attachment_btn;
      $array[$j][]='<a href="'.base_url().'work/profile/'.$id.'">'.$row->work_name.'</a>';
      $array[$j][]=$row->user_alias.$entry_approval_status;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]=date('d-m-Y',strtotime($row->created_date));
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$btn_add_payment.$btn_edit.$btn_delete.$btn_approve;
      $array[$j][]=$row->bill_credit_ac;
      $array[$j][]=$row->work_id;
      $array[$j][]=$row->bill_id;
      $array[$j][]=$bill_attachment;
      $array[$j][]=$row->bill_tax_percent;
      $array[$j][]=$row->bill_tax_amount;
      $array[$j][]=$bill_items;
      $array[$j][]=$row->entry_approval_status;
      $array[$j][]=$row->entry_approval_status_2;

      $total_tax_amount+=$row->bill_tax_amount;
      $total_tax1_amount+=$row->bill_tax1_amount;
      $total_tax2_amount+=$row->bill_tax2_amount;
      $total_tax3_amount+=$row->bill_tax3_amount;
      $total_bill_amount+=$row->bill_payable_amount;
      $total_paid_amount+=$row->bill_total_paid;
      $total_balance_amount+=$row->bill_balance_amount;
      $j++;
    endforeach;
    if($result->num_rows()>0){
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]="<strong>Total</strong>";
      $array[$j][]='';
      $array[$j][]="<strong>".$this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($total_tax_amount,$this->config->item('Currency_currency_shortname'))."</strong>";
      $array[$j][]='';
      $array[$j][]="<strong>".$this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($total_tax1_amount,$this->config->item('Currency_currency_shortname'))."</strong>";
      $array[$j][]='';
      $array[$j][]="<strong>".$this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($total_tax2_amount,$this->config->item('Currency_currency_shortname'))."</strong>";
      $array[$j][]='';
      $array[$j][]="<strong>".$this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($total_tax3_amount,$this->config->item('Currency_currency_shortname'))."</strong>";
      $array[$j][]="<strong>".$this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($total_bill_amount,$this->config->item('Currency_currency_shortname'))."</strong>";
      $array[$j][]="<strong>".$this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($total_paid_amount,$this->config->item('Currency_currency_shortname'))."</strong>";
      $array[$j][]="<strong>".$this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($total_balance_amount,$this->config->item('Currency_currency_shortname'))."</strong>";
      $array[$j][]="";
      $array[$j][]="";
      $array[$j][]="";
      $array[$j][]="";
      $array[$j][]="";
      $array[$j][]="";
      $array[$j][]="";
      $array[$j][]="";
      $array[$j][]="";
      $array[$j][]="";
      $array[$j][]="";
      $array[$j][]="";
      $array[$j][]="";
      $array[$j][]="";
      $array[$j][]="";
      $array[$j][]="";
      $array[$j][]="";
    }

    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }

  public function select_expense_bill_heads($list_type=''){

    $json_data=array();
    $j=$sl_no=$total_bill_amount=$total_paid_amount=$total_balance_amount=$total_tax_amount=0;
    $data=array();
    if(isset($_POST['date']) && $_POST['date']!=''){
      $date=array();
      $date=explode('-',$_POST['date']);
      $start_date=date('Y-m-d', strtotime($date[0]));
      $end_date=date('Y-m-d', strtotime($date[1]));
      $data["STR_TO_DATE(b.bill_date,'%Y-%m-%d') <="]= $end_date;
      $data["STR_TO_DATE(b.bill_date,'%Y-%m-%d') >="]= $start_date;
    }
    if(isset($_POST['expense_head']) && $_POST['expense_head']!='' && $_POST['expense_head']!='all'){
      $data['b.bill_credit_ac'] = $_POST['expense_head'];
    }
    if(isset($_POST['expense_type']) && $_POST['expense_type']!='' && $_POST['expense_type']!='all'){
      $data['b.bill_expense_type'] = $_POST['expense_type'];
    }
    if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
      $data['b.work_id'] = $_POST['work'];
    }
    if(isset($_POST['work_ids']) && $_POST['work_ids']!='' && $_POST['work_ids']!='all'){
      $this->db->where_in('b.work_id',explode(',',$_POST['work_ids']));
    }
    if(isset($_POST['stage_id']) && $_POST['stage_id']!='' && $_POST['stage_id']!='all'){
      $data['b.project_stage_id'] = $_POST['stage_id'];
    }
    if(isset($_POST['user_id']) && $_POST['user_id']!='' && $_POST['user_id']!='all'){
      $data['b.created_by'] = $_POST['user_id'];
    }
    if(isset($_POST['start_date']) && $_POST['start_date']!='' && $_POST['start_date']!='all'){
      $data['b.bill_date >='] = date('Y-m-d', strtotime($_POST['start_date']));
    }
    if(isset($_POST['end_date']) && $_POST['end_date']!='' && $_POST['end_date']!='all'){
      $data['b.bill_date <='] = date('Y-m-d', strtotime($_POST['end_date']));
    }
    if($this->session->userdata('user_role')=='supervisor') {
      //          Select Assigned Works Only
      $supervisor_id = $this->session->userdata('user_id');
      $this->db->where("FIND_IN_SET($supervisor_id, wc.assigned_users)");
    }
    if($this->config->item('user_data_access_view_all')!=1){
      $data['b.created_by'] = $this->session->userdata('user_id');
    }
    $data['b.bill_type'] = 'expense';
    $result	= $this->Bills->select_bills("ah1.acc_head_name as expense_head_name,COALESCE(SUM(b.bill_tax_amount),0) as sum_tax_amount,COALESCE(SUM(b.bill_payable_amount),0) as sum_payable_amount,COALESCE(SUM(b.bill_total_paid),0) as sum_total_paid,COALESCE(SUM(b.bill_balance_amount),0) as sum_balance_amount",$data,'','','b.bill_credit_ac');
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();

    foreach($result_array as $row):
      $sl_no++;

      $array[$j][]=$sl_no;
      $array[$j][]=$row->expense_head_name;
      $array[$j][]=number_format($row->sum_tax_amount,$this->config->item('Currency_amount_decimals_2'),'.','');
      $array[$j][]=number_format($row->sum_payable_amount,$this->config->item('Currency_amount_decimals_2'),'.','');
      $array[$j][]=number_format($row->sum_total_paid,$this->config->item('Currency_amount_decimals_2'),'.','');
      $array[$j][]=number_format($row->sum_balance_amount,$this->config->item('Currency_amount_decimals_2'),'.','');

      $total_tax_amount+=$row->sum_tax_amount;
      $total_bill_amount+=$row->sum_payable_amount;
      $total_paid_amount+=$row->sum_total_paid;
      $total_balance_amount+=$row->sum_balance_amount;
      $j++;
    endforeach;
    if($result->num_rows()>0){
      $array[$j][]='';
      $array[$j][]="<strong>Total</strong>";
      $array[$j][]="<strong>".$this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($total_tax_amount,$this->config->item('Currency_currency_shortname'))."</strong>";
      $array[$j][]="<strong>".$this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($total_bill_amount,$this->config->item('Currency_currency_shortname'))."</strong>";
      $array[$j][]="<strong>".$this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($total_paid_amount,$this->config->item('Currency_currency_shortname'))."</strong>";
      $array[$j][]="<strong>".$this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($total_balance_amount,$this->config->item('Currency_currency_shortname'))."</strong>";

    }

    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }

}
?>
