<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Enquiries extends CI_Controller {

  public $page_data=array();

  function __construct()
  {
    parent::__construct();
    //Calling Initial Functions
    $this->initial();
  }

  public function initial()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");

    $this->load->model('User_model','User');

    $this->load->model('Customers_model','Customers');
    $this->load->model('Enquiries_model','Enquiries');
    $this->load->model('Services_model','Services');
    $this->load->model('Branches_model', 'Branches');
    $this->load->model('Settings_model', 'Settings');

    //        File Directory
    $this->page_data['directory'] = "enquiries";
    $this->page_data['sales_staffs'] = $this->User->select_user("",array("role_name"=>'sales_staff'))->result();
  }
  public function index()
  {
    $this->view();
  }
  public function view()
  {
    $this->page_data['tax_state_codes'] = $this->Settings->select_tax_state_codes("*")->result();
    //        Check User Logged in or Not
    $allowed_user_roles = array("madmin","admin","sales_manager","sales_staff","auditor","general_manager",'accounts_manager',"operation_manager");
    if($this->User->is_logged_in($allowed_user_roles)==false){
      redirect(base_url(), 'refresh');
    }

    $this->page_data['services'] = $this->Services->select_services("",array('active_status'=>1))->result();
    $this->page_data['service_types'] = $this->Services->select_service_types("")->result();
    $this->page_data['services_all'] = $this->Services->select_services("*")->result();

    $this->page_data['page_name'] = 'enquiries_view';
    $this->load->view('Index',$this->page_data);
  }

  public function profile($id='')
  {
    $this->page_data['service_types'] = $this->Services->select_service_types("")->result();
    $this->page_data['tax_state_codes'] = $this->Settings->select_tax_state_codes("*")->result();
    $this->page_data['services'] = $this->Services->select_services("",array('active_status'=>1))->result();
    $this->page_data['services_all'] = $this->Services->select_services("*")->result();
    if($this->session->userdata('branch_id') != 0){
      $this->db->where('branch_id !=',$this->session->userdata('branch_id'));
    }
    $this->page_data['branches'] = $this->Branches->select_branches("*")->result();

    if($id!="") {
      if($this->session->userdata('branch_id') != 0){
        $data['e.branch_id'] = $this->session->userdata('branch_id');
      }
      $data['e.enquiry_id'] = $id;
      $this->page_data['enquiry_data'] = $this->Enquiries->select_enquiries("*,u1.user_alias as assigned_user", $data);
      if($this->page_data['enquiry_data']->num_rows()==1){
        $this->page_data['enquiry_data'] = $this->page_data['enquiry_data']->row();
        $this->page_data['page_name'] = 'enquiries_profile';
        $this->load->view('Index', $this->page_data);
      }else{
        show_404();
      }
    }
    else{
      show_404();
    }
  }

  public function create()
  {
    $data['enquiry_date']=date('Y-m-d', strtotime($this->security->xss_clean($this->input->post('date'))));
    $data['customer_id']=$this->security->xss_clean($this->input->post('customer'));
    $data['service']=$this->security->xss_clean($this->input->post('service'));
    if($this->config->item('Enquiry_reference_no_format')!=''){
      if($this->config->item('Enquiry_reference_no_format')=='YYMMDDNO'){
        $previous_data = $this->Enquiries->select_enquiries("Max(CAST(enquiry_reference_no as SIGNED)) as enquiry_reference_no",array("enquiry_date"=>$data['enquiry_date']));
        if($previous_data->num_rows()==1 && $previous_data->row()->enquiry_reference_no!=null){
          $data['enquiry_reference_no'] = ($previous_data->row()->enquiry_reference_no)+1;
        }else{
          $date = date('ymd', strtotime($this->security->xss_clean($this->input->post('date'))));
          $no = '01';
          $data['enquiry_reference_no'] = $date.$no;
        }
      }
    }else{
      if($this->input->post('reference_no')){
        $data['enquiry_reference_no'] = $this->security->xss_clean($this->input->post('reference_no'));
      }
    }
    if($this->config->item('Enquiry_duplication_check_by_reference_no')==1){
      $enquiry_where['enquiry_reference_no']=$data['enquiry_reference_no'];
    }else{
      $enquiry_where['enquiry_date']=$data['enquiry_date'];
      $enquiry_where['e.customer_id']=$data['customer_id'];
      $enquiry_where['service']=$data['service'];
    }
    $count = $this->Enquiries->select_enquiries("*",$enquiry_where)->num_rows();
    if($count == 0) {

      $data['enquiry_status'] = $this->security->xss_clean($this->input->post('status'));
      if($this->input->post('assign_to')!=''){
        $data['currently_assigned_to'] = $this->security->xss_clean($this->input->post('assign_to'));
      }
      $data['service_type'] = $this->security->xss_clean($this->input->post('service_type'));

      $data['enq_contact_person'] = $this->security->xss_clean($this->input->post('contact_person'));
      $data['enq_contact_person_mobile'] = $this->security->xss_clean($this->input->post('contact_mobile_no'));
      $data['enq_requested_person'] = $this->security->xss_clean($this->input->post('requested_person'));
      $data['enq_requested_person_mobile'] = $this->security->xss_clean($this->input->post('requested_mobile_no'));
      $data['service_details'] = $this->security->xss_clean($this->input->post('service_details'));
      $data['work_place'] = $this->security->xss_clean($this->input->post('work_place'));
      $data['enquiry_mode'] = $this->security->xss_clean($this->input->post('enquiry_mode'));
      $data['enquiry_priority'] = $this->security->xss_clean($this->input->post('priority'));
      $data['nature_of_enquiry'] = $this->security->xss_clean($this->input->post('nature_of_enquiry'));
      $data['observations'] = $this->security->xss_clean($this->input->post('observations'));
      $data['actions_taken'] = $this->security->xss_clean($this->input->post('actions_taken'));
      $data['nature_of_enquiry'] = $this->security->xss_clean($this->input->post('nature_of_enquiry'));
      $data['remarks'] = $this->security->xss_clean($this->input->post('remarks'));
      $data['created_date'] = date('Y-m-d H:i:s');
      $data['created_by'] = $this->session->userdata('user_id');

      $result = $this->Enquiries->insert_enquiry($data);

      $flash_data['status'] = $result['status'];
      if ($flash_data['status'] == 1) {

        if($this->input->post('assign_to')!=''){
          // Insert Assign Log
          $assign_log['enquiry_id'] = $result['insert_id'];
          $assign_log['assigned_to'] = $data['currently_assigned_to'];
          $assign_log['created_date'] = date('Y-m-d H:i:s');
          $assign_log['created_by'] = $this->session->userdata('user_id');
          $result2 = $this->Enquiries->insert_enquiry_assign_log($assign_log);
        }

        $flash_data['flashdata_msg'] = 'Enquiry Added Successfully!.';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';
      }else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }

    }else {
      $flash_data['status'] = 0;
      if($this->config->item('Enquiry_duplication_check_by_reference_no')==1){
        $flash_data['flashdata_msg'] = 'Sorry.. Enquiry with given Reference No Already Exist!';
      }else{
        $flash_data['flashdata_msg'] = 'Sorry.. Enquiry with given details (Customer, Date, Service) Already Exist!';
      }
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }
    echo(json_encode($flash_data));

  }
  public function update()
  {
    $data['enquiry_date']=date('Y-m-d', strtotime($this->security->xss_clean($this->input->post('date'))));
    $data['customer_id']=$this->security->xss_clean($this->input->post('customer'));
    $data['service']=$this->security->xss_clean($this->input->post('service'));
    $data['enquiry_reference_no'] = $this->security->xss_clean($this->input->post('reference_no'));
    if($this->config->item('Enquiry_duplication_check_by_reference_no')==1){
      $enquiry_where['enquiry_date']=$data['enquiry_date'];
      $enquiry_where['e.customer_id']=$data['customer_id'];
      $enquiry_where['service']=$data['service'];
      $enquiry_where['enquiry_id !='] = $this->security->xss_clean($this->input->post('enquiry_id'));
    }else if($data['enquiry_reference_no']!=''){
      $enquiry_where['enquiry_reference_no']=$data['enquiry_reference_no'];
      $enquiry_where['enquiry_id !='] = $this->security->xss_clean($this->input->post('enquiry_id'));
    }
    $data['enquiry_id'] =  $this->security->xss_clean($this->input->post('enquiry_id'));
    $count = 0;
    if(isset($enquiry_where)){
      $count = $this->Enquiries->select_enquiries("",$enquiry_where)->num_rows();
    }
    if($count == 0) {
      $data['enq_contact_person'] = $this->security->xss_clean($this->input->post('contact_person'));
      $data['enq_contact_person_mobile'] = $this->security->xss_clean($this->input->post('contact_mobile_no'));
      $data['enq_requested_person'] = $this->security->xss_clean($this->input->post('requested_person'));
      $data['enq_requested_person_mobile'] = $this->security->xss_clean($this->input->post('requested_mobile_no'));
      $data['enquiry_status'] = $this->security->xss_clean($this->input->post('status_edit'));
      $data['service_type'] = $this->security->xss_clean($this->input->post('service_type'));
      $data['service_details'] = $this->security->xss_clean($this->input->post('service_details'));
      $data['work_place'] = $this->security->xss_clean($this->input->post('work_place'));
      $data['enquiry_mode'] = $this->security->xss_clean($this->input->post('enquiry_mode'));
      $data['enquiry_priority'] = $this->security->xss_clean($this->input->post('priority_edit'));
      $data['nature_of_enquiry'] = $this->security->xss_clean($this->input->post('nature_of_enquiry'));
      $data['observations'] = $this->security->xss_clean($this->input->post('observations'));
      $data['actions_taken'] = $this->security->xss_clean($this->input->post('actions_taken'));
      $data['nature_of_enquiry'] = $this->security->xss_clean($this->input->post('nature_of_enquiry'));
      $data['remarks'] = $this->security->xss_clean($this->input->post('remarks'));
      $data['updated_date'] = date('Y-m-d H:i:s');
      $data['updated_by'] = $this->session->userdata('user_id');

      $result = $this->Enquiries->update_enquiry($data);

      $flash_data['status'] = $result;
      if ($flash_data['status'] == 1) {
        $flash_data['flashdata_msg'] = 'Enquiry Updated Successfully!.';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';
      }else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }

    }else {
      $flash_data['status'] = 0;
      if($this->config->item('Enquiry_duplication_check_by_reference_no')==1){
        $flash_data['flashdata_msg'] = 'Sorry.. Enquiry with given Reference No Already Exist!';
      }else{
        $flash_data['flashdata_msg'] = 'Sorry.. Enquiry with given details (Customer, Date, Service) Already Exist!';
      }
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }
    echo(json_encode($flash_data));

  }
  public function delete()
  {

    $data['enquiry_id']=$this->security->xss_clean($this->input->post('enquiry_id'));
    $data['delete_status']=1;
    $result = $this->Enquiries->update_enquiry($data);
    $flash_data['status'] = $result;
    if ($result == 1 ) {
      $flash_data['flashdata_msg'] = 'Enquiry Deleted Successfully!';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !!';
    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo(json_encode($flash_data));
  }
  public function select($type='')
  {
    $json_data=array();
    $j=0;
    $sl_no=0;
    $data=array();

    if(isset($_POST['enquiry_id']) && $_POST['enquiry_id']!='' && $_POST['enquiry_id']!='all'){
      $data['e.enquiry_id'] = $_POST['enquiry_id'];
    }
    if(isset($_POST['assigned_to']) && $_POST['assigned_to']!='' && $_POST['assigned_to']!='all'){
      $data['e.currently_assigned_to'] = $_POST['assigned_to'];
    }
    if(isset($_POST['customer_id']) && $_POST['customer_id']!='' && $_POST['customer_id']!='all'){
      $data['e.customer_id'] = $_POST['customer_id'];
    }
    if(isset($_POST['service']) && $_POST['service']!='' && $_POST['service']!='all'){
      $data['e.service'] = $_POST['service'];
    }
    if(isset($_POST['status']) && $_POST['status']!='' && $_POST['status']!='all'){
      $data['e.enquiry_status'] = $_POST['status'];
    }
    if(isset($_POST['branch_id']) && $_POST['branch_id']!='' && $_POST['branch_id']!='all'){
      $data['e.branch_id'] = $_POST['branch_id'];
    }
    // if branch admin is logged in , then only show the enquiries of his branch
    if($this->session->userdata('branch_id') != 0){
      $data['e.branch_id'] = $this->session->userdata('branch_id');
    }

    $result = $this->Enquiries->select_enquiries("e.*,b.branch_name,c.customer_name,c.contact_person,c.customer_phone,c.customer_location,s.service_id,s.service_name,u2.user_alias as created_user,u1.user_alias as assigned_user,st.service_type_name",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();

    foreach($result_array as $row):

      $btn_edit = $btn_delete = $btn_assign = '';

      if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='general_manager') {
        $btn_edit='<a style="margin-left: 5px;margin-right: 5px" data-id="'.$row->enquiry_id.'" id="enquiry_edit_btn" href="#enquiry_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-edit"></i>
        </a>';
        $btn_delete='<a style="margin-left: 5px;margin-right: 5px" id="enquiry_delete_btn" href="#enquiry_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air">
        <i class="la la-trash"></i>
        </a>';
        $btn_assign='<a style="margin-left: 5px;margin-right: 5px" id="enquiry_assign_btn" href="#enquiry_assign_add_modal" data-toggle="modal" class="btn btn-focus m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air">
        <i class="fa fa-user-plus"></i>
        </a>';
      }

      $sl_no++;

      $enquiry_status = "<span class='m-badge m-badge--success m-badge--wide'></i>".$row->enquiry_status."</span>";

      if($row->branch_id==0){
        $default_branch_data = $this->config->item('default_branch_data');
        $row->branch_name = $default_branch_data['branch_name'];
      }
      $customer_data = $row->customer_name;
      if($row->contact_person!=''){
        $customer_data .="<br/>".$row->contact_person;
      }
      $customer_data .="<br/>".$row->customer_phone."<br/>".$row->customer_location;

      if($row->enquiry_priority==1){
        $enquiry_priority="<span class='m-badge m-badge--danger m-badge--wide'> High</span>";
      }elseif($row->enquiry_priority==2){
        $enquiry_priority="<span class='m-badge m-badge--warning m-badge--wide'> Med</span>";
      }else{
        $enquiry_priority="<span class='m-badge m-badge--info m-badge--wide'> Low</span>";
      }

      $array[$j][]=$sl_no;
      $array[$j][]='<a href="'.base_url().'enquiries/profile/'.$row->enquiry_id.'" >#'.$row->enquiry_id.'</a>';;
      $array[$j][]=$row->branch_name;
      $array[$j][]=$row->enquiry_reference_no;
      $array[$j][]=$enquiry_status;
      $array[$j][]=$row->assigned_user;
      $array[$j][]='<a href="'.base_url().'customers/profile/'.$row->customer_id.'" >'.$customer_data.'<a/>';
      $array[$j][]=$row->enq_requested_person."<br/>".$row->enq_requested_person_mobile;
      $array[$j][]=$row->enq_contact_person."<br/>".$row->enq_contact_person_mobile;
      $array[$j][]=date('d-m-Y',strtotime($row->enquiry_date));
      $array[$j][]=$row->service_name;
      $array[$j][]=$row->service_type_name;
      $array[$j][]=$enquiry_priority;
      $array[$j][]=$row->work_place;
      $array[$j][]=$row->enquiry_mode;
      $array[$j][]=$row->nature_of_enquiry;
      $array[$j][]=$row->service_details;
      $array[$j][]=$row->observations;
      $array[$j][]=$row->actions_taken;
      $array[$j][]=$row->remarks;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]='<ul style="padding: .75rem;margin-bottom: 0"><li>Created on : '.date('d-m-Y',strtotime($row->created_date))."</li><li>Created By : ".$row->created_user."</li>";
      }else{
        $array[$j][]='<ul style="padding: .75rem;margin-bottom: 0"><li>Created By : '.$row->created_user.'</li>';
      }
      $array[$j][]=$btn_assign.$btn_edit.$btn_delete;
      $array[$j][]=$row->enquiry_status;
      $array[$j][]= $out[$j][] = $row->customer_id;
      $array[$j][]= $out[$j][] = $row->service_id;
      $array[$j][]=$row->enquiry_id;
      $array[$j][]=$row->currently_assigned_to;
      $array[$j][]=$row->branch_id;


      $j++;
    endforeach;

    $json_data['data']=$array;

    if($type=='list')
    {
      $json_data=$out;
    }
    echo json_encode($json_data);  // send data as json format
  }

  public function select_details(){
    if(isset($_POST['id']) && $_POST['id']!=""){
      $data['enquiry_id'] = $_POST['id'];
    }
    $result	= $this->Enquiries->select_enquiries("e.*,b.branch_name,c.customer_name,c.contact_person,c.customer_phone,c.customer_location,s.service_id,s.service_name,u2.user_alias as created_user,u1.user_alias as assigned_user,st.service_type_name",$data);
    if($result->num_rows()==1) {
      $result = $result->row();
      $result->enquiry_date = date("d-m-Y",strtotime($result->enquiry_date));
      echo json_encode(array("count" => 1,"data" => $result));
    }else{
      echo json_encode(array("count" => $result->num_rows()));
    }
  }
  public function create_assign()
  {
    $data['enquiry_id'] = $this->security->xss_clean($this->input->post('enquiry_id'));
    $data['currently_assigned_to'] = $this->security->xss_clean($this->input->post('assign_to'));
    $result = $this->Enquiries->update_enquiry($data);

    $flash_data['status'] = $result;
    if ($flash_data['status'] == 1) {

      $assign_log['enquiry_id'] = $data['enquiry_id'];
      $assign_log['assigned_to'] = $data['currently_assigned_to'];
      $assign_log['remarks'] = $this->security->xss_clean($this->input->post('remarks'));
      $assign_log['created_date'] = date('Y-m-d H:i:s');
      $assign_log['created_by'] = $this->session->userdata('user_id');
      $result = $this->Enquiries->insert_enquiry_assign_log($assign_log);

      $flash_data['flashdata_msg'] = 'Enquiry Assigned Successfully!.';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    }else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo(json_encode($flash_data));

  }
  public function select_enquiry(){
    $data = array();
    if(isset($_POST['customer_id']) && $_POST['customer_id']!=""){
      $data['e.customer_id'] = $_POST['customer_id'];
    }
    $result	= $this->Enquiries->select_enquiries("*,s.service_name,c.customer_name,c.customer_phone,e.created_date as e_created_date,u2.user_alias",$data);
    if($result->num_rows()>0) {
      echo json_encode(array("count" => $result->num_rows(),"data" => $result->result_array()));
    }else{
      echo json_encode(array("count" => $result->num_rows()));
    }
  }

  public function create_response()
  {
    $data['enquiry_id'] = $this->security->xss_clean($this->input->post('enquiry_id'));
    $data['response'] = $this->security->xss_clean($this->input->post('response'));
    $data['created_date'] = date('Y-m-d H:i:s');
    $data['created_by'] = $this->session->userdata('user_id');

    $result = $this->Enquiries->insert_enquiry_response($data);

    $flash_data['status'] = $result['status'];
    if ($flash_data['status'] == 1) {
      $flash_data['flashdata_msg'] = 'Enquiry Response Added Successfully!.';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    }else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }

    echo(json_encode($flash_data));
  }
  public function update_response()
  {
    $data['response_id'] = $this->security->xss_clean($this->input->post('response_id'));
    $data['response'] = $this->security->xss_clean($this->input->post('response'));
    $result = $this->Enquiries->update_enquiry_response($data);

    $flash_data['status'] = $result;
    if ($flash_data['status'] == 1) {
      $flash_data['flashdata_msg'] = 'Enquiry Response Updated Successfully!.';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    }else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }

    echo(json_encode($flash_data));
  }
  public function delete_response()
  {
    $data['response_id'] = $this->security->xss_clean($this->input->post('response_id'));
    $data['delete_status'] = 1;
    $result = $this->Enquiries->update_enquiry_response($data);

    $flash_data['status'] = $result;
    if ($flash_data['status'] == 1) {
      $flash_data['flashdata_msg'] = 'Enquiry Response Deleted Successfully!.';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    }else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo(json_encode($flash_data));
  }
  public function select_enquiry_responses($type='')
  {
    $json_data=array();
    $j=0;
    $sl_no=0;
    $data=array();

    if(isset($_POST['enquiry_id']) && $_POST['enquiry_id']!='' && $_POST['enquiry_id']!='all'){
      $data['e.enquiry_id'] = $_POST['enquiry_id'];
    }
    if(isset($_POST['customer_id']) && $_POST['customer_id']!='' && $_POST['customer_id']!='all'){
      $data['e.customer_id'] = $_POST['customer_id'];
    }
    $result = $this->Enquiries->select_enquiry_responses("er.*,u.user_alias,c.customer_id,c.customer_name,s.service_name,c.customer_phone,c.customer_location",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();

    foreach($result_array as $row):

      $btn_edit='<a style="margin-left: 5px;margin-right: 5px" id="enquiry_response_edit_btn" href="#enquiry_response_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
      <i class="la la-edit"></i>
      </a>';
      $btn_delete='<a style="margin-left: 5px;margin-right: 5px" id="enquiry_response_delete_btn" href="#enquiry_response_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air">
      <i class="la la-trash"></i>
      </a>';

      $sl_no++;

      $array[$j][]=$sl_no;
      $array[$j][]=$row->response_id;
      $array[$j][]='<a href="'.base_url().'customers/profile/'.$row->customer_id.'" >'.$row->customer_name.'</a>'."<br/>".$row->customer_phone."<br/>".$row->customer_location;
      $array[$j][]='<a href="'.base_url().'enquiries/profile/'.$row->enquiry_id.'" >#'.$row->enquiry_id.'</a>';
      $array[$j][]=$row->service_name;
      $array[$j][]=$row->response;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]='<ul style="padding: .75rem;margin-bottom: 0"><li>Created on : '.date('d-m-Y',strtotime($row->created_date))."</li><li>Created By : ".$row->user_alias."</li>";
      }else{
        $array[$j][]='<ul style="padding: .75rem;margin-bottom: 0"><li>Created By : '.$row->user_alias.'</li>';
      }
      $array[$j][]=$btn_edit.$btn_delete;

      $j++;
    endforeach;

    $json_data['data']=$array;

    if($type=='list')
    {
      $json_data=$out;
    }
    echo json_encode($json_data);  // send data as json format
  }

  public function create_followup()
  {
    $data['enquiry_id'] = $this->security->xss_clean($this->input->post('enquiry_id'));
    $data['followup_date'] = date('Y-m-d H:i',strtotime($this->input->post('followup_date')));
    $data['remarks'] = $this->security->xss_clean($this->input->post('remarks'));
    $data['created_date'] = date('Y-m-d H:i:s');
    $data['created_by'] = $this->session->userdata('user_id');

    $result = $this->Enquiries->insert_enquiry_followup($data);

    $flash_data['status'] = $result['status'];
    if ($flash_data['status'] == 1) {
      $flash_data['flashdata_msg'] = 'Enquiry Followup Added Successfully!.';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    }else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }

    echo(json_encode($flash_data));
  }
  public function update_followup()
  {
    $data['followup_id'] = $this->security->xss_clean($this->input->post('followup_id'));
    // $data['followup_date'] = date('Y-m-d H:i',strtotime($this->input->post('followup_date')));
    $data['remarks'] = $this->security->xss_clean($this->input->post('remarks'));
    $data['followup_status'] = $this->security->xss_clean($this->input->post('followup_status'));
    $data['updated_date'] = date('Y-m-d H:i:s');
    $data['updated_by'] = $this->session->userdata('user_id');
    $result = $this->Enquiries->update_enquiry_followup($data);

    $flash_data['status'] = $result;
    if ($flash_data['status'] == 1) {
      $flash_data['flashdata_msg'] = 'Enquiry Followup Updated Successfully!.';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    }else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }

    echo(json_encode($flash_data));
  }
  public function delete_followup()
  {
    $data['followup_id'] = $this->security->xss_clean($this->input->post('followup_id'));
    $data['delete_status'] = 1;
    $result = $this->Enquiries->update_enquiry_followup($data);

    $flash_data['status'] = $result;
    if ($flash_data['status'] == 1) {
      $flash_data['flashdata_msg'] = 'Enquiry Followup Deleted Successfully!.';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    }else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo(json_encode($flash_data));
  }
  public function select_enquiry_followups($type='')
  {
    $json_data=array();
    $j=0;
    $sl_no=0;
    $data=array();

    if(isset($_POST['enquiry_id']) && $_POST['enquiry_id']!='' && $_POST['enquiry_id']!='all'){
      $data['e.enquiry_id'] = $_POST['enquiry_id'];
    }
    if(isset($_POST['customer_id']) && $_POST['customer_id']!='' && $_POST['customer_id']!='all'){
      $data['e.customer_id'] = $_POST['customer_id'];
    }
    $result = $this->Enquiries->select_enquiry_followups("ef.*,u.user_alias,c.customer_id,c.customer_name,s.service_name,c.customer_phone,c.customer_location",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();

    foreach($result_array as $row):

      $btn_edit='<a style="margin-left: 5px;margin-right: 5px" id="enquiry_followup_edit_btn" href="#enquiry_followup_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
      <i class="la la-edit"></i>
      </a>';
      $btn_delete='<a style="margin-left: 5px;margin-right: 5px" id="enquiry_followup_delete_btn" href="#enquiry_followup_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air">
      <i class="la la-trash"></i>
      </a>';

      $sl_no++;

      if($row->followup_status==1){
        $followup_status="<span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> Done</span>";
      }elseif($row->followup_status==2){
        $followup_status="<span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-times-circle'></i> Cancelled</span>";
      }else{
        $followup_status="<span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-ellipsis-h'></i> Pending</span>";
      }

      $array[$j][]=$sl_no;
      $array[$j][]=$row->followup_id;
      $array[$j][]='<a href="'.base_url().'customers/profile/'.$row->customer_id.'" >'.$row->customer_name.'</a>'."<br/>".$row->customer_phone."<br/>".$row->customer_location;
      $array[$j][]='<a href="'.base_url().'enquiries/profile/'.$row->enquiry_id.'" >#'.$row->enquiry_id.'</a>';
      $array[$j][]=$row->service_name;
      $array[$j][]=date('d-m-Y H:i',strtotime($row->followup_date));
      $array[$j][]=$row->remarks;
      $array[$j][]=$followup_status;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]='<ul style="padding: .75rem;margin-bottom: 0"><li>Created on : '.date('d-m-Y',strtotime($row->created_date))."</li><li>Created By : ".$row->user_alias."</li>";
      }else{
        $array[$j][]='<ul style="padding: .75rem;margin-bottom: 0"><li>Created By : '.$row->user_alias.'</li>';
      }
      $array[$j][]=$btn_edit.$btn_delete;
      $array[$j][]=$row->followup_status;

      $j++;
    endforeach;

    $json_data['data']=$array;

    if($type=='list')
    {
      $json_data=$out;
    }
    echo json_encode($json_data);  // send data as json format
  }

  public function create_transfer()
  {
    $transfer_data['enquiry_id'] = $data['enquiry_id'] = $this->security->xss_clean($this->input->post('enquiry_id'));
    $data['branch_id'] = $this->security->xss_clean($this->input->post('transfer_to_branch_id'));
    $enquiry_data	= $this->Enquiries->select_enquiries("e.*",array("e.enquiry_id"=>$data['enquiry_id']));
    if($enquiry_data->num_rows()==1 && $enquiry_data->row()->branch_id != $data['branch_id']) {
      // Insert Transfer Log
      $transfer_data['transfer_from_branch'] = $enquiry_data->row()->branch_id;
      $transfer_data['transfer_to_branch'] = $data['branch_id'];
      $transfer_data['remarks'] = $this->security->xss_clean($this->input->post('remarks'));
      $transfer_data['created_date'] = date('Y-m-d H:i:s');
      $transfer_data['created_by'] = $this->session->userdata('user_id');
      $result2 = $this->Enquiries->insert_enquiry_transfer_log($transfer_data);
      // Update Enquiry
      $result = $this->Enquiries->update_enquiry($data);
      $flash_data['status'] = $result;
      if ($flash_data['status'] == 1) {
        $flash_data['flashdata_msg'] = 'Enquiry Transferred Successfully!.';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';
      }else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    }else {
      $flash_data['status'] = 2;
      $flash_data['flashdata_msg'] = 'Selected Branch is Not Allowed to Transfer';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Not Allowed !!';
    }

    echo(json_encode($flash_data));
  }
  public function select_enquiry_transfer($type='')
  {
    $json_data=array();
    $j=0;
    $sl_no=0;
    $data=array();

    if(isset($_POST['enquiry_id']) && $_POST['enquiry_id']!='' && $_POST['enquiry_id']!='all'){
      $data['e.enquiry_id'] = $_POST['enquiry_id'];
    }
    if(isset($_POST['customer_id']) && $_POST['customer_id']!='' && $_POST['customer_id']!='all'){
      $data['e.customer_id'] = $_POST['customer_id'];
    }
    $result = $this->Enquiries->select_enquiry_transfer("etl.*,u.user_alias,b1.branch_name as transfer_from_branch_name,b2.branch_name as transfer_to_branch_name",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();

    foreach($result_array as $row):

      $sl_no++;

      $array[$j][]=$sl_no;
      $array[$j][]=$row->transfer_id;
      $array[$j][]=$row->transfer_from_branch_name;
      $array[$j][]=$row->transfer_to_branch_name;
      $array[$j][]=$row->remarks;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]='<ul style="padding: .75rem;margin-bottom: 0"><li>Transferred on : '.date('d-m-Y',strtotime($row->created_date))."</li><li>Transferred By : ".$row->user_alias."</li>";
      }else{
        $array[$j][]='<ul style="padding: .75rem;margin-bottom: 0"><li>Transferred By : '.$row->created_user.'</li>';
      }

      $j++;
    endforeach;

    $json_data['data']=$array;

    if($type=='list')
    {
      $json_data=$out;
    }
    echo json_encode($json_data);  // send data as json format
  }


  public function select_enquiry_assign_logs($type='')
  {
    $json_data=array();
    $j=0;
    $sl_no=0;
    $data=array();

    if(isset($_POST['enquiry_id']) && $_POST['enquiry_id']!='' && $_POST['enquiry_id']!='all'){
      $data['e.enquiry_id'] = $_POST['enquiry_id'];
    }
    if(isset($_POST['customer_id']) && $_POST['customer_id']!='' && $_POST['customer_id']!='all'){
      $data['e.customer_id'] = $_POST['customer_id'];
    }
    $result = $this->Enquiries->select_enquiry_assign_logs("eal.*,u.user_alias,u2.user_alias as assigned_to_user",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();

    foreach($result_array as $row):

      $sl_no++;

      $array[$j][]=$sl_no;
      $array[$j][]=$row->assigned_to_user;
      $array[$j][]=$row->remarks;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]='<ul style="padding: .75rem;margin-bottom: 0"><li>Assigned on : '.date('d-m-Y',strtotime($row->created_date))."</li><li>Assigned By : ".$row->user_alias."</li>";
      }else{
        $array[$j][]='<ul style="padding: .75rem;margin-bottom: 0"><li>Assigned By : '.$row->user_alias.'</li>';
      }

      $j++;
    endforeach;

    $json_data['data']=$array;

    if($type=='list')
    {
      $json_data=$out;
    }
    echo json_encode($json_data);  // send data as json format
  }
}
