<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Download extends CI_Controller {

  public $page_data=array();

  function __construct()
  {
    parent::__construct();
    //Calling Initial Functions
    $this->initial();
  }

  public function initial()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");

    $this->load->model('User_model','User');
    $this->load->model('Sales_quotation_model','Sales_quotation');
    $this->load->model('Work_order_model','Work_order');
    $this->load->model('Employees_model', 'Employee');
    $this->load->model('Settings_model', 'Settings');
    $this->load->model('Sales_estimation_model','Sales_estimation');
    $this->load->library('Accounts_management', 'accounts_management');

    //        File Directory
    $this->page_data['directory'] = "home";

  }
  public function index()
  {

  }
  public function sales_quotation()
  {
    $user_id = $_GET['user'];
    $quotation_id = $_GET['id'];
    $token = $_GET['token'];
    $date = $_GET['date'];
    if($user_id!="" && $quotation_id!="" && $token!="" && $date!="" && $token==md5($user_id.$quotation_id.$user_id)){
      $user_data	= $this->User->select_user("*",array("user_id"=>$user_id));
      if ($user_data->num_rows() == 1) {
        if($user_data->row()->role_id>3){
          $data['sq.created_by'] = $user_id;
        }
        $data['sq.date'] = $date;
        $data['sq.quotation_id'] = $quotation_id;
        $this->page_data['quotation_data'] = $this->Sales_quotation->select_quotations("sq.*,u1.user_alias as prepared_by_name,u1.phone_no as prepared_by_phone,b.*", $data);
        if($this->page_data['quotation_data']->num_rows()==1){
          $this->page_data['quotation_data'] = $this->page_data['quotation_data']->row();
          if($this->page_data['quotation_data']->branch_id==0){
            $default_branch_data = $this->config->item('default_branch_data');
            $this->page_data['quotation_data']->branch_name = $default_branch_data['branch_name'];
            $this->page_data['quotation_data']->quotation_prefix = $default_branch_data['quotation_prefix'];
            $this->page_data['quotation_data']->quotation_header = $default_branch_data['quotation_header'];
            $this->page_data['quotation_data']->quotation_footer = $default_branch_data['quotation_footer'];
          }
          $this->page_data['quotation_data']->receivable_amount_in_words = $this->accounts_management->amount_in_words($this->page_data['quotation_data']->quotation_net_total);
          $this->page_data['items_data'] = $this->Sales_quotation->select_quotation_items("sqi.*,sqt.template_no,mu.unit_name",array("sqi.quotation_id"=>$this->page_data['quotation_data']->quotation_id))->result();

          $this->load->view('modules/sales_quotation/sales_quotation_print_'.$this->config->item('Quotation_template'), $this->page_data);
        }else{
          show_404();
        }
      }else{
        show_404();
      }
    }else{
      show_404();
    }
  }
  public function work_order()
  {
    $user_id = $_GET['user'];
    $order_id = $_GET['id'];
    $token = $_GET['token'];
    $date = $_GET['date'];
    if($user_id!="" && $order_id!="" && $token!="" && $date!="" && $token==md5($user_id.$order_id.$user_id)){
      $user_data	= $this->User->select_user("*",array("user_id"=>$user_id));
      if ($user_data->num_rows() == 1) {
        if($user_data->row()->role_id>3){
          $data['wo.created_by'] = $user_id;
        }
        $data['wo.order_date'] = $date;
        $data['wo.order_id'] = $order_id;
        $this->page_data['order_data'] = $this->Work_order->select_work_orders("wo.*,ba.*,b.*,sq.quotation_no,u2.user_alias as site_coordinator_name", $data);
        if($this->page_data['order_data']->num_rows()==1){
          $this->page_data['order_data'] = $this->page_data['order_data']->row();
          if($this->page_data['order_data']->branch_id==0){
            $default_branch_data = $this->config->item('default_branch_data');
            $this->page_data['order_data']->branch_name = $default_branch_data['branch_name'];
            $this->page_data['order_data']->quotation_prefix = $default_branch_data['quotation_prefix'];
            $this->page_data['order_data']->workorder_prefix = $default_branch_data['workorder_prefix'];
            $this->page_data['order_data']->workorder_header = $default_branch_data['workorder_header'];
            $this->page_data['order_data']->workorder_footer = $default_branch_data['workorder_footer'];
            $this->page_data['order_data']->workorder_logo = $default_branch_data['workorder_logo'];
          }
          $this->page_data['items_data'] = $this->Work_order->select_work_order_items("woi.*",array("woi.order_id"=>$this->page_data['order_data']->order_id))->result();

          $this->load->view('modules/work_order/work_order_print_'.$this->config->item('Work_order_template'), $this->page_data);
        }else{
          show_404();
        }
      }else{
        show_404();
      }
    }else{
      show_404();
    }
  }
  public function sales_estimation()
  {
    $user_id = $_GET['user'];
    $estimation_id = $_GET['id'];
    $token = $_GET['token'];
    $date = $_GET['date'];
    if($user_id!="" && $estimation_id!="" && $token!="" && $date!="" && $token==md5($user_id.$estimation_id.$user_id)){
      $user_data	= $this->User->select_user("*",array("user_id"=>$user_id));
      if ($user_data->num_rows() == 1) {
        if($user_data->row()->role_id>3){
          $data['se.created_by'] = $user_id;
        }
        $data['se.estimation_date'] = $date;
        $data['se.estimation_id'] = $estimation_id;
        $this->page_data['estimation_data'] = $this->Sales_estimation->select_sale_estimation("se.*,ba.*,u.user_alias,c.customer_id,c.customer_name,c.customer_location,tsc.state_name,tsc.state_code,se.branch_id as estimation_branch_id,b.branch_name,b.branch_address,b.workorder_logo", $data);
        if($this->page_data['estimation_data']->num_rows()==1){
          $this->page_data['estimation_data'] = $this->page_data['estimation_data']->row();
          $this->page_data['estimation_data']->receivable_amount_in_words = $this->accounts_management->amount_in_words($this->page_data['estimation_data']->receivable_amount);
          if($this->page_data['estimation_data']->estimation_branch_id==0){
            $default_branch_data = $this->config->item('default_branch_data');
            $this->page_data['estimation_data']->workorder_logo = $default_branch_data['sales_estimation_logo'];
          }

          $this->page_data['estimation_items'] = $this->Sales_estimation->select_estimation_sale_item("material_name,unit_name,sei.quantity,sei.unit_sale_price,sei.discount_amount,sei.taxable_amount,sei.total_amount,tt.*,sei.description,m.item_code",array("se.estimation_id"=>$estimation_id))->result();

          $this->load->view('modules/sales_estimation/sales_estimation_print', $this->page_data);
        }else{
          show_404();
        }
      }else{
        show_404();
      }
    }else{
      show_404();
    }
  }
}
?>
