<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Data extends CI_Controller
{
  public $page_data = array();

  function __construct()
  {
    parent::__construct();
    $this->initial();
  }

  public function initial()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");

    $this->load->model('User_model', 'User');
    $this->load->model('Data_model', 'Data');

    //        Check User Logged in or Not
    $allowed_user_roles = array("auditor","madmin","admin","supervisor","general_manager","accounts_manager","qs","qs_manager");
    if($this->User->is_logged_in($allowed_user_roles)==false){
      redirect(base_url(), 'refresh');
    }
    //        File Directory
    $this->page_data['directory'] = "data";

  }

  public function index()
  {

  }

  public function meters()
  {
    $this->page_data['page_name'] = 'meter_makes';
    $this->load->view('Index', $this->page_data);
  }
  public function select_meter_makes(){

    $json_data=array();
    $j=0;

    $data=array();
    $result	= $this->Data->select_meter_makes("",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();

    foreach($result_array as $row):
      $btn_edit='';
      if($this->session->userdata('user_role')!='auditor'){
        $btn_edit='<a style="margin-left: 5px;margin-right: 5px" id="meter_make_edit_btn" href="#meter_make_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-edit"></i>
        </a>';
      }
      $array[$j][]=$row->meter_id;
      $array[$j][]=$row->meter_name;
      $array[$j][]=$btn_edit;



      $j++;
    endforeach;

    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }
  public function create_meter_make()
  {
    $data['meter_name'] = $this->security->xss_clean($this->input->post('name'));
    $count = $this->Data->select_meter_makes("meter_id",array('meter_name' => $data['meter_name']))->num_rows();
    if($count==0){
      $result =  $this->Data->insert_meter_makes($data);
      $flash_data['status'] = $result['status'];
      if ($result['status'] == 1) {
        $flash_data['flashdata_msg'] = 'New Meter Make Added Successfully!.';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';

      } else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    }else {
      $flash_data['status'] = 2;
      $flash_data['flashdata_msg'] = 'Sorry.. Submitted Mater Make Name Already Exists!';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }
    $flash_data['message'] = $flash_data['flashdata_msg'];
    echo(json_encode($flash_data));

  }
  public function update_meter_make()
  {
    $data['meter_id'] = $this->security->xss_clean($this->input->post('meter_id'));
    $data['meter_name'] = $this->security->xss_clean($this->input->post('name'));
    $count = $this->Data->select_meter_makes("meter_id",array('meter_name' => $data['meter_name'],'meter_id !=' => $data['meter_id']))->num_rows();
    if($count==0){
      $result = $this->Data->update_meter_makes($data);
      $flash_data['status'] = $result;
      if ($result == 1) {
        $flash_data['flashdata_msg'] = 'Meter Updated Successfully!.';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';

      } else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    }else {
      $flash_data['status'] = 0;
      $flash_data['flashdata_msg'] = 'Sorry.. Submitted Mater Make Name Already Exists!';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }

    echo(json_encode($flash_data));

  }
  public function select_meter_makes_list(){
    $data = array();
    $result	= $this->Data->select_meter_makes("",$data);
    if($result->num_rows()>0) {
      echo json_encode(array("count" => $result->num_rows(),"data" =>$result->result()));
    }else{
      echo json_encode(array("count" => $result->num_rows()));
    }
  }

  public function companies()
  {
    $this->page_data['page_name'] = 'companies';
    $this->load->view('Index', $this->page_data);
  }
  public function select_companies(){

    $json_data=array();
    $j=$slno=0;

    $data=array();
    $result	= $this->Data->select_companies("",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();

    foreach($result_array as $row):
      $slno++;
      $btn_edit='';
      if($this->session->userdata('user_role')!='auditor'){
        $btn_edit='<a style="margin-left: 5px;margin-right: 5px" id="company_edit_btn" href="#company_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-edit"></i>
        </a>';
      }
      $array[$j][]=$row->company_id;
      $array[$j][]=$slno;
      $array[$j][]=$row->company_name;
      $array[$j][]=nl2br($row->company_address);
      $array[$j][]=$btn_edit;

      $j++;
    endforeach;

    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }
  public function create_company()
  {
    $data['company_name'] = $this->security->xss_clean($this->input->post('name'));
    $count = $this->Data->select_companies("company_id",$data)->num_rows();
    if($count==0){
      $data['company_address'] = $this->security->xss_clean($this->input->post('address'));
      $result =  $this->Data->insert_companies($data);
      $flash_data['status'] = $result['status'];
      if ($result['status'] == 1) {
        $flash_data['flashdata_msg'] = 'New Company Added Successfully!.';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';

      } else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    }else {
      $flash_data['status'] = 2;
      $flash_data['flashdata_msg'] = 'Sorry.. Submitted Company Name Already Exists!';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }
    $flash_data['message'] = $flash_data['flashdata_msg'];
    echo(json_encode($flash_data));

  }
  public function update_company()
  {
    $data['company_id'] = $this->security->xss_clean($this->input->post('company_id'));
    $data['company_name'] = $this->security->xss_clean($this->input->post('name'));
    $count = $this->Data->select_companies("company_id",array('company_name' => $data['company_name'],'company_id !=' => $data['company_id']))->num_rows();
    if($count==0){
      $data['company_address'] = $this->security->xss_clean($this->input->post('address'));
      $result = $this->Data->update_companies($data);
      $flash_data['status'] = $result;
      if ($result == 1) {
        $flash_data['flashdata_msg'] = 'Company Details Updated Successfully!.';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';

      } else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    }else {
      $flash_data['status'] = 0;
      $flash_data['flashdata_msg'] = 'Sorry.. Submitted Company Name Already Exists!';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }

    echo(json_encode($flash_data));

  }
}
?>
