<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Dashboard extends CI_Controller {

  public $page_data=array();

  function __construct()
  {
    parent::__construct();
    //Calling Initial Functions
    $this->initial();
  }

  public function initial()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");

    $this->load->model('User_model','User');
    $this->load->model('Settings_model', 'Settings');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Client_model', 'Client');
    $this->load->model('Account_model', 'Account');

    //        File Directory
    $this->page_data['directory'] = "home";

  }
  public function index()
  {
    $this->view();

  }
  public function view()
  {

    //        Check User Logged in or Not
    $allowed_user_roles = array("madmin","admin","supervisor","general_manager","purchase_manager","boq_manager","sales_manager","accounts_manager","sales_staff","auditor","qs_manager","qs","procurement_engineer","project_manager","hr_manager","operation_manager");
    if($this->User->is_logged_in($allowed_user_roles)==false){
      redirect(base_url(), 'refresh');
    }

    $this->session->set_userdata(array("dashboard_link"=>base_url()."dashboard"));

    // $this->config->set_item('page_template','_template_8');
    $this->page_data['page_name'] = 'dashboard'.$this->config->item('page_template');
    $this->load->view('Index',$this->page_data);

  }

}
?>
