<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Daily_notes extends CI_Controller
{
  public $page_data = array();

  function __construct()
  {
    parent::__construct();
    $this->initial();
  }

  public function initial()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");

    $this->load->model('User_model', 'User');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Client_model', 'Client');
    $this->load->model('Supplier_model', 'Supplier');
    $this->load->model('Daily_reports_model', 'Daily_reports');

    $this->load->library('Projects_management','projects_management');

    //        Check User Logged in or Not
    $allowed_user_roles = array("madmin","admin","supervisor","general_manager","purchase_manager","sales_manager","boq_manager","auditor","accounts_manager","qs","qs_manager","operation_manager");
    if($this->User->is_logged_in($allowed_user_roles)==false){
      redirect(base_url(), 'refresh');
    }

    //        File Directory
    $this->page_data['directory'] = "daily_note";

  }
  public function index()
  {
    $this->view();
  }

  public function view()
  {
    // Check Module is Enabled or Not
    if($this->config->item('app_module_daily_notes')==0){
      redirect(base_url().'dashboard', 'refresh');
    }

    if($this->session->userdata('user_role')=='supervisor') {
      //          Select Assigned Works Only
      $supervisor_id = $this->session->userdata('user_id');
      $this->db->where("FIND_IN_SET($supervisor_id, w.assigned_users)");
    }
    $this->page_data['work_contracts'] = $this->Work->select_work("*")->result();

    $data['acc_status'] = 1;
    $this->page_data['users'] = $this->User->select_user("",$data)->result();
    $this->page_data['page_name'] = 'daily_notes';
    $this->load->view('Index', $this->page_data);
  }

  public function select_daily_notes($param=""){

    $json_data=array();
    $j=0;
    $sl_no=0;
    $data=array();
    if(isset($_POST['work_id'])){
      $data['dn.work_id'] = $_POST['work_id'];
    }
    if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
      $data['dn.work_id'] = $_POST['work'];
    }
    if(isset($_POST['work_ids']) && $_POST['work_ids']!='' && $_POST['work_ids']!='all'){
      $this->db->where_in('dn.work_id',explode(',',$_POST['work_ids']));
    }
    if(isset($_POST['date']) && $_POST['date']!=''){
      $date=array();
      $date=explode('-',$_POST['date']);
      $start_date=date('Y-m-d', strtotime($date[0]));
      $end_date=date('Y-m-d', strtotime($date[1]));
      $data["STR_TO_DATE(dn.note_date,'%Y-%m-%d') <="]= $end_date;
      $data["STR_TO_DATE(dn.note_date,'%Y-%m-%d') >="]= $start_date;
    }
    if($this->session->userdata('user_role')=='supervisor') {
      $data['dn.created_by'] = $this->session->userdata('user_id');
    }
    if(isset($_POST['user_id']) && $_POST['user_id']!='' && $_POST['user_id']!='all'){
      $data['dn.created_by'] = $_POST['user_id'];
    }
    $result	= $this->Daily_reports->select_daily_notes("dn.*,u.user_alias,wc.work_id,wc.work_name,ua.activity_location_address,ua.activity_location_landmark,ua.activity_location_latitude,ua.activity_location_longitude",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();

    foreach($result_array as $row):
      $id=$row->work_id;
      if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_id')==$row->created_by) {
        $btn_edit = '<a style="margin-left: 5px;margin-right: 5px" id="daily_note_edit_btn" href="#daily_note_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-edit"></i>
        </a>';
        $btn_delete = '<a style="margin-left: 5px;margin-right: 5px" id="daily_note_delete_btn" href="#daily_note_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-trash"></i>
        </a>';
      }else{
        $btn_edit = '';
        $btn_delete = '';
      }
      if($row->activity_location_address!=''){
        $activity_data['location'] = $row->activity_location_address;
        $activity_data['landmark'] = $row->activity_location_landmark;
        $activity_data['latitude'] = $row->activity_location_latitude;
        $activity_data['longitude'] = $row->activity_location_longitude;
        if($activity_data['latitude']!='' && $activity_data['longitude']!=''){
          $activity_data['location'] .= '<br/><a target="_blank" style="margin-left: 5px;margin-right: 5px"  href="https://www.google.com/maps/search/?api=1&map_action=map&query='.$activity_data['latitude'].','.$activity_data['longitude'].'&zoom=16" class="btn btn-info m-btn m-btn--icon  btn-sm m-btn--pill m-btn--air"><i class="fa fa-map-marker"></i> View on Map</a>';
        }
      }else{
        $activity_data['location'] = '';
      }

      if($row->read_status==1){
        $read_status = "<span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check-double'></i> Read</span>";
      }else{
        $read_status = "<span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-times-circle'></i> Unread</span>";
        if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='general_manager'){
          $read_status .= '<br/><a style="margin-top: 5px" id="daily_note_read_btn" href="javascript:;" class="btn btn-warning btn-sm m-btn m-btn--icon  m-btn--pill m-btn--air">
          Mark As Read
          </a>';
        }
      }

      $btn_view='<a style="margin-left: 5px;margin-right: 5px" id="daily_note_view_btn" href="#daily_note_view_modal" data-toggle="modal" class="btn btn-primary m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
      <i class="fa fa-eye"></i>
      </a>';
      $sl_no++;
      $array[$j][]=$sl_no;
      $array[$j][]=$row->note_id;
      $array[$j][]=$row->work_id;
      $array[$j][]=$row->user_alias;
      $array[$j][]='<a href="'.base_url().'work/profile/'.$id.'">'.$row->work_name.'</a>';
      $array[$j][]=$row->title;
      $array[$j][]=date('d-m-Y',strtotime($row->note_date));
      $array[$j][]=$row->description;
      if($row->image !=''){
        $images = '';
        $images_array = explode(',',$row->image);
        foreach ($images_array as $key => $value) {
          $images .= '<a style="margin-left: 5px;margin-right: 5px;" target="_blank" href="'.base_url().'uploads/daily_notes/'.$value.'"><img style="height:50px;width:50px" src="'.base_url().'uploads/daily_notes/'.$value.'" /></a>';
        }
        $array[$j][]=$images;
      }else{
        $array[$j][]="";
      }
      $array[$j][]=$activity_data['location'];
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]=date('d-m-Y H:i:s',strtotime($row->created_date));
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$read_status;
      $array[$j][]=$btn_view.$btn_edit.$btn_delete;
      $array[$j][]=$row->read_status;
      $j++;
    endforeach;

    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }

  public function create()
  {
    $data['work_id'] = $this->security->xss_clean($this->input->post('work_id'));
    $data['note_date'] = date('Y-m-d');
    $data['title'] = $this->security->xss_clean($this->input->post('title'));
    $data['description'] = $this->security->xss_clean($this->input->post('description'));
    $data['created_date'] = date('Y-m-d H:i:s');
    $data['created_by'] = $this->session->userdata('user_id');
    $data['project_stage_id'] = $this->projects_management->get_project_stage_id($data['work_id']);

    $result =  $this->Daily_reports->create_daily_note($data);
    $flash_data['status'] = $result['status'];
    if ($flash_data['status'] == 1) {
      $flash_data['flashdata_type'] = 'success';
      $flash_data['flashdata_msg'] = 'Daily Note Added Succesfully';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    }
    else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    $flash_data['message'] = $flash_data['flashdata_msg'];
    echo json_encode($flash_data);

  }
  public function update()
  {
    $data['work_id'] = $this->security->xss_clean($this->input->post('work_id'));
    $data['note_id'] = $this->security->xss_clean($this->input->post('note_id'));
    $data['title'] = $this->security->xss_clean($this->input->post('title'));
    $data['description'] = $this->security->xss_clean($this->input->post('description'));
    $data['updated_by'] = $this->session->userdata('user_id');
    $data['updated_date'] = date('Y-m-d H:i:s');

    $result =  $this->Daily_reports->update_daily_note($data);
    $flash_data['status'] = $result;
    if ($flash_data['status'] == 1) {
      $flash_data['flashdata_type'] = 'success';
      $flash_data['flashdata_msg'] = 'Daily Note Updated Succesfully';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    }
    else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    $flash_data['message'] = $flash_data['flashdata_msg'];
    echo json_encode($flash_data);

  }
  public function update_read()
  {
    if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='general_manager') {
      $data['note_id'] = $this->security->xss_clean($this->input->post('note_id'));
      $data['read_status'] = 1;
      $result =  $this->Daily_reports->update_daily_note($data);
      $flash_data['status'] = $result;
      if ($flash_data['status'] == 1) {
        $flash_data['flashdata_type'] = 'success';
        $flash_data['flashdata_msg'] = 'Daily Note Marked As Read!.';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';
      }
      else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }
      $flash_data['message'] = $flash_data['flashdata_msg'];
    }else{
      $flash_data['status'] = 0;
    }
    echo json_encode($flash_data);

  }
  public function delete()
  {
    $data['note_id'] = $this->security->xss_clean($this->input->post('note_id'));
    $data['delete_status'] = 1;

    $result =  $this->Daily_reports->update_daily_note($data);
    $flash_data['status'] = $result;
    if ($flash_data['status'] == 1) {
      $flash_data['flashdata_type'] = 'success';
      $flash_data['flashdata_msg'] = 'Daily Note Deleted Succesfully';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    }
    else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    $flash_data['message'] = $flash_data['flashdata_msg'];
    echo json_encode($flash_data);

  }
}
?>
