<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Daily_labour_reports extends CI_Controller
{
  public $page_data = array();

  function __construct()
  {
    parent::__construct();
    $this->initial();
  }

  public function initial()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");

    $this->load->model('User_model', 'User');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Client_model', 'Client');
    $this->load->model('Supplier_model', 'Supplier');
    $this->load->model('Daily_reports_model', 'Daily_reports');
    //        Check User Logged in or Not
    $allowed_user_roles = array("madmin","admin","auditor","supervisor","general_manager","operation_manager");
    if($this->User->is_logged_in($allowed_user_roles)==false){
      redirect(base_url(), 'refresh');
    }

    //        File Directory
    $this->page_data['directory'] = "daily_labour_report";

  }
  public function index()
  {
    $this->view();
  }

  public function view()
  {
    // Check Module is Enabled or Not
    if($this->config->item('app_module_daily_labour_report')==0){
      redirect(base_url().'dashboard', 'refresh');
    }

    if($this->session->userdata('user_role')=='supervisor') {
      //          Select Assigned Works Only
      $supervisor_id = $this->session->userdata('user_id');
      $this->db->where("FIND_IN_SET($supervisor_id, w.assigned_users)");
    }
    $this->page_data['work_contracts'] = $this->Work->select_work("*")->result();
    $this->page_data['page_name'] = 'daily_labour_report';
    $this->load->view('Index', $this->page_data);
  }

  public function select_daily_labour_reports($param=""){

    $json_data=array();
    $j=0;
    $sl_no=0;
    $data=array();
    if(isset($_POST['work_id'])){
      $data['dr.work_id'] = $_POST['work_id'];
    }
    if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
      $data['dr.work_id'] = $_POST['work'];
    }
    if(isset($_POST['date']) && $_POST['date']!=''){
      $date=array();
      $date=explode('-',$_POST['date']);
      $start_date=date('Y-m-d', strtotime($date[0]));
      $end_date=date('Y-m-d', strtotime($date[1]));
      $data["STR_TO_DATE(dr.report_date,'%Y-%m-%d') <="]= $end_date;
      $data["STR_TO_DATE(dr.report_date,'%Y-%m-%d') >="]= $start_date;
    }
    if($this->session->userdata('user_role')=='supervisor') {
      $data['dr.created_by'] = $this->session->userdata('user_id');
    }
    if(isset($_POST['user_id']) && $_POST['user_id']!='' && $_POST['user_id']!='all'){
      $data['dr.created_by'] = $_POST['user_id'];
    }
    $data['dr.report_type'] = 'labour';
    $result	= $this->Daily_reports->select_labour_report("dr.*,l.labour_type,l.labour_name,wt1.type_name,u.user_alias,wc.work_id,wc.work_name",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();

    foreach($result_array as $row):
      $id=$row->work_id;
      if($this->session->userdata('user_role')=='admin' || ($this->session->userdata('user_role')=='supervisor' && $this->session->userdata('user_id')==$row->created_by)) {

        $btn_delete = '<a style="margin-left: 5px;margin-right: 5px" id="daily_report_delete_btn" href="#daily_report_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-trash"></i>
        </a>';
      }else{
        $btn_edit = '';
        $btn_delete = '';
      }
      $btn_view='<a style="margin-left: 5px;margin-right: 5px" id="daily_labour_view_btn" href="#daily_labour_view_modal" data-toggle="modal" class="btn btn-primary m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
      <i class="fa fa-eye"></i>
      </a>';
      if($row->labour_type==0){
        $labour_type = "Individual Person";
      }else{
        $labour_type = "Group of Persons";
      }
      $sl_no++;
      $array[$j][]=$sl_no;
      $array[$j][]=$row->report_id;
      $array[$j][]=$row->work_id;
      $array[$j][]='<a href="'.base_url().'work/profile/'.$id.'">'.$row->work_name.'</a>';
      $array[$j][]=date('d-m-Y',strtotime($row->report_date));
      $array[$j][]=$row->labour_name." (".$labour_type.")";
      $array[$j][]=$row->type_name;
      $array[$j][]=$row->title;
      $array[$j][]=$row->description;
      $array[$j][]=$row->user_alias;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]=date('d-m-Y',strtotime($row->created_date));
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$btn_view.$btn_delete;
      $j++;
    endforeach;

    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }
  public function select_daily_subcontract_reports($param=""){

    $json_data=array();
    $j=0;
    $sl_no=0;
    $data=array();
    if(isset($_POST['work_id'])){
      $data['dr.work_id'] = $_POST['work_id'];
    }
    if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
      $data['dr.work_id'] = $_POST['work'];
    }
    if(isset($_POST['date']) && $_POST['date']!=''){
      $date=array();
      $date=explode('-',$_POST['date']);
      $start_date=date('Y-m-d', strtotime($date[0]));
      $end_date=date('Y-m-d', strtotime($date[1]));
      $data["STR_TO_DATE(dr.report_date,'%Y-%m-%d') <="]= $end_date;
      $data["STR_TO_DATE(dr.report_date,'%Y-%m-%d') >="]= $start_date;
    }
    if($this->session->userdata('user_role')=='supervisor') {
      $data['dr.created_by'] = $this->session->userdata('user_id');
    }
    if(isset($_POST['user_id']) && $_POST['user_id']!='' && $_POST['user_id']!='all'){
      $data['dr.created_by'] = $_POST['user_id'];
    }
    $data['dr.report_type'] = 'subcontract';
    $result	= $this->Daily_reports->select_labour_report("dr.*,c.contractor_name,sc.contractor,sc.sub_work_name,wt2.type_name,u.user_alias,wc.work_id,wc.work_name",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();

    foreach($result_array as $row):
      $id=$row->work_id;
      if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='general_manager' || ($this->session->userdata('user_role')=='supervisor' && $this->session->userdata('user_id')==$row->created_by)) {

        $btn_delete = '<a style="margin-left: 5px;margin-right: 5px" id="daily_report_delete_btn" href="#daily_report_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-trash"></i>
        </a>';
      }else{
        $btn_edit = '';
        $btn_delete = '';
      }
      $btn_view='<a style="margin-left: 5px;margin-right: 5px" id="daily_subcontract_view_btn" href="#daily_subcontract_view_modal" data-toggle="modal" class="btn btn-primary m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
      <i class="fa fa-eye"></i>
      </a>';
      $sl_no++;
      $array[$j][]=$sl_no;
      $array[$j][]=$row->report_id;
      $array[$j][]=$row->work_id;
      $array[$j][]='<a href="'.base_url().'work/profile/'.$id.'">'.$row->work_name.'</a>';
      $array[$j][]=date('d-m-Y',strtotime($row->report_date));
      $array[$j][]=$row->contractor_name;
      $array[$j][]=$row->type_name;
      $array[$j][]=$row->sub_work_name;
      $array[$j][]=$row->title;
      $array[$j][]=$row->description;
      $array[$j][]=$row->user_alias;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]=date('d-m-Y',strtotime($row->created_date));
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$btn_view.$btn_delete;
      $j++;
    endforeach;

    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }
  public function delete()
  {
    $data['report_id'] = $this->security->xss_clean($this->input->post('report_id'));
    $data['delete_status'] = 1;

    $result =  $this->Daily_reports->update_labour_report($data);
    $json_data['status'] = $result;
    if ($json_data['status'] == 1) {
      $json_data['message'] = 'Daily Labour Report Deleted Successfully!.';
    } else {
      $json_data['message'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
    }
    echo json_encode($json_data);

  }
}
?>
