<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Clients extends CI_Controller
{
  public $page_data = array();

  function __construct()
  {
    parent::__construct();
    $this->initial();
  }

  public function initial()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");

    $this->load->model('User_model', 'User');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Client_model', 'Client');
    $this->load->model('Settings_model', 'Settings');
    $this->load->model('Customers_model', 'Customers');

    //        Check User Logged in or Not
    $allowed_user_roles = array("auditor","madmin","admin","accounts_manager","general_manager","qs","qs_manager","operation_manager");
    if($this->User->is_logged_in($allowed_user_roles)==false){
      redirect(base_url(), 'refresh');
    }
    //        File Directory
    $this->page_data['directory'] = "clients";
    $this->page_data['tax_state_codes'] = $this->Settings->select_tax_state_codes("*")->result();
  }

  public function index()
  {
    $this->view();
  }

  public function view()
  {
    $this->page_data['page_name'] = 'client_list';
    $this->load->view('Index',$this->page_data);
  }
  public function select_client(){

    $json_data=array();
    $j=0;

    $data=array();
    $data['delete_status'] = 0;

    if(isset($_POST['branch_id']) && $_POST['branch_id']!='' && $_POST['branch_id']!='all'){
      $data['c.branch_id'] = $_POST['branch_id'];
    }

    $result	= $this->Client->select_client("",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();

    foreach($result_array as $row):
      $btn_edit='';
      if($this->session->userdata('user_role')!='auditor'){
        $btn_edit='<a style="margin-left: 5px;margin-right: 5px" id="client_edit_btn" href="#client_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-edit"></i>
        </a>';
      }

      $btn_delete='';
      if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='madmin'  ) {
        $btn_delete='<a style="margin-left: 5px;margin-right: 5px" id="client_delete_btn" href="#client_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-trash"></i>
        </a>';
      }

      $array[$j][]=$row->client_id;
      $array[$j][]=($row->branch_id==0)?'No Branch':$this->Branches->select_branches('*',array('branch_id'=>$row->branch_id))->row()->branch_name;
      $array[$j][]=$row->client_name;
      $array[$j][]=$row->contact_person;
      $array[$j][]=$row->client_contact;
      $array[$j][]=$row->client_whatsapp;
      $array[$j][]=$row->client_email;
      $array[$j][]=$row->po_box_no;
      $array[$j][]=$row->client_address;
      $array[$j][]=$row->company_name;
      $array[$j][]=$row->group_name;
      $array[$j][]=$row->tax_no;
      $array[$j][]=$row->tax_date;
      $array[$j][]=$row->state_name."-".$row->state_code;
      $array[$j][]=$row->civil_id;
      if($this->config->item('Mobile_App_client_login')==1){
        $array[$j][]=$row->client_password;
      }
      $array[$j][]=$btn_edit.$btn_delete;
      $array[$j][]=$row->tax_state_id;

      $j++;
    endforeach;

    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }
  public function create()
  {
    //      insert client
    $data3['client_name'] = $this->security->xss_clean($this->input->post('name'));
    $data3['client_contact'] = $this->security->xss_clean($this->input->post('phone'));
    $data3['contact_person'] = $this->security->xss_clean($this->input->post('contact_person'));
    $data3['client_whatsapp'] = $this->security->xss_clean($this->input->post('whatsapp_no'));
    $data3['client_email'] = $this->security->xss_clean($this->input->post('email'));
    $data3['po_box_no'] = $this->security->xss_clean($this->input->post('po_box'));
    $data3['client_address'] = $this->security->xss_clean($this->input->post('address'));
    $data3['company_name'] = $this->security->xss_clean($this->input->post('company_name'));
    $data3['group_name'] = $this->security->xss_clean($this->input->post('group_name'));
    $data3['tax_no'] = $this->security->xss_clean($this->input->post('tax_no'));
    $data3['tax_date'] = $this->security->xss_clean($this->input->post('tax_date'));
    $data3['civil_id'] = $this->security->xss_clean($this->input->post('civil_id'));
    if($this->input->post('state_id')){
      $data3['tax_state_id'] = $this->security->xss_clean($this->input->post('state_id'));
    }
    $data3['created_date'] = date('Y-m-d H:i:s');
    $data3['created_by'] = $this->session->userdata('user_id');
    $count = $this->Client->select_client('client_id',array("client_contact"=>$data3['client_contact']));
    if($count->num_rows()==0){
      $result = $this->Client->insert_client($data3);
      $flash_data['status'] = $result['status'];
      if($result['status'] == 1){
        $flash_data['flashdata_msg'] = 'New Client Added Successfully!.';
        $flash_data['flashdata_type'] = 'info';
        $flash_data['alert_type'] = 'info';
        $flash_data['flashdata_title'] = 'Success !';

        // Add User Activity
        $this->User->add_user_activity('Clients',$result['insert_id'],'Client Profile Added');

        // Create Customer
        $data['customer_phone']=$customer_where['customer_phone']=$data3['client_contact'];
        $count = $this->Customers->select_customer("",$customer_where)->num_rows();
        if($count == 0) {
          $data['customer_name'] = $data3['client_name'];
          $data['contact_person'] = $data3['contact_person'];
          $data['customer_location'] = $data3['client_address'];
          $data['customer_email'] = $data3['client_email'];
          $data['customer_tax_no'] = $data3['tax_no'];
          if($this->input->post('state_id')){
            $data['customer_tax_state'] = $this->security->xss_clean($this->input->post('state_id'));
          }
          $data['created_date'] = date('Y-m-d H:i:s');
          $data['created_by'] = $this->session->userdata('user_id');
          if ($this->session->userdata('branch_id') != 0) {
            $data['branch_id'] = $this->session->userdata('branch_id');
          }
          $result2 = $this->Customers->create_customer($data);
          // Update Customer ID in Client
          $update_client_data['client_id'] = $result['insert_id'];
          $update_client_data['customer_id'] = $result2['insert_id'];
          $result3 = $this->Client->update_client($update_client_data);
        }

      }else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    }else{
      $flash_data['status'] = 2;
      $flash_data['flashdata_msg'] = 'Sorry.. A Client With Same Contact No Already Exist!';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }
    $flash_data['message'] = $flash_data['flashdata_msg'];
    echo(json_encode($flash_data));
  }
  public function update()
  {
    $data2['client_id'] = $this->security->xss_clean($this->input->post('client_id'));
    $client_data = $this->Client->select_client('client_id,customer_id',array("client_id"=>$data2['client_id']))->row();
    $data2['client_name'] = $this->security->xss_clean($this->input->post('name'));
    $data2['contact_person'] = $this->security->xss_clean($this->input->post('contact_person'));
    $data2['client_contact'] = $this->security->xss_clean($this->input->post('phone'));
    $data2['client_whatsapp'] = $this->security->xss_clean($this->input->post('whatsapp_no'));
    $data2['client_email'] = $this->security->xss_clean($this->input->post('email'));
    $data2['po_box_no'] = $this->security->xss_clean($this->input->post('po_box'));
    $data2['client_address'] = $this->security->xss_clean($this->input->post('address'));
    $data2['company_name'] = $this->security->xss_clean($this->input->post('company_name'));
    $data2['group_name'] = $this->security->xss_clean($this->input->post('group_name'));
    $data2['tax_no'] = $this->security->xss_clean($this->input->post('tax_no'));
    $data2['tax_date'] = $this->security->xss_clean($this->input->post('tax_date'));
    $data2['civil_id'] = $this->security->xss_clean($this->input->post('civil_id'));
    if($this->input->post('state_id')){
      $data2['tax_state_id'] = $this->security->xss_clean($this->input->post('state_id'));
    }else{
      $data2['tax_state_id'] = 0;
    }
    if($this->config->item('Mobile_App_client_login')==1){
      $data2['client_password'] = $this->security->xss_clean($this->input->post('password'));
    }
    $data2['updated_date'] = date('Y-m-d H:i:s');
    $data2['updated_by'] = $this->session->userdata('user_id');
    $count = $this->Client->select_client('client_id',array("client_contact"=>$data2['client_contact'],"client_id !="=>$data2['client_id'] ));
    if($count->num_rows()==0){
      $result2 = $this->Client->update_client($data2);
      $flash_data['status'] = $result2;
      if($result2== 1){
        $flash_data['flashdata_msg'] = 'Client Details Updated Successfully!.';
        $flash_data['flashdata_type'] = 'info';
        $flash_data['alert_type'] = 'info';
        $flash_data['flashdata_title'] = 'Success !';

        // Add User Activity
        $this->User->add_user_activity('Clients',$data2['client_id'],'Client Details Updated');

        if($client_data->customer_id!=0){
          $data['customer_id'] = $client_data->customer_id;
          $data['customer_name'] = $data2['client_name'];
          $data['contact_person'] = $data2['contact_person'];
          $data['customer_location'] = $data2['client_address'];
          $data['customer_email'] = $data2['client_email'];
          $data['customer_tax_no'] = $data2['tax_no'];
          if($this->input->post('state_id')){
            $data['customer_tax_state'] = $this->security->xss_clean($this->input->post('state_id'));
          }
          $data['updated_date'] = date('Y-m-d H:i:s');
          $data['updated_by'] = $this->session->userdata('user_id');
          $result = $this->Customers->update_customer($data);
        }

      }else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    }else{
      $flash_data['status'] = 2;
      $flash_data['flashdata_msg'] = 'Sorry.. A Client With Same Contact No Already Exist!';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }
    $flash_data['message'] = $flash_data['flashdata_msg'];
    echo(json_encode($flash_data));

  }
  public function delete()
  {
    $data2['client_id'] = $this->security->xss_clean($this->input->post('client_id'));
    $data2['delete_status'] = 1;
    $result2 = $this->Client->update_client($data2);
    $flash_data['status'] = $result2;
    if ($result2 == 1) {
      $flash_data['flashdata_msg'] = 'Client Deleted Successfully!.';
      $flash_data['flashdata_type'] = 'info';
      $flash_data['alert_type'] = 'info';
      $flash_data['flashdata_title'] = 'Success !';

      // Add User Activity
      $this->User->add_user_activity('Clients',$data2['client_id'],'Client Profile Deleted');

    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }

    $flash_data['message'] = $flash_data['flashdata_msg'];
    echo(json_encode($flash_data));

  }

  public function select(){
    $data['delete_status'] = 0;
    if(isset($_POST['id']) && $_POST['id']!=""){
      $data['client_id'] = $_POST['id'];
    }
    $result	= $this->Client->select_client("",$data);
    if($result->num_rows()>0) {
      foreach ($result->result() as $row):
        $id[] = $row->client_id;
        $name[] = $row->client_name;
        $contact[]  = $row->client_contact;
      endforeach;
      echo json_encode(array("count" => $result->num_rows(),"id" => $id,"name" => $name,"contact" => $contact));
    }else{
      echo json_encode(array("count" => $result->num_rows()));
    }
  }
  public function select_details(){
    if(isset($_POST['client_id']) && $_POST['client_id']!=""){
      $data['client_id'] = $_POST['client_id'];
    }
    $result	= $this->Client->select_client("",$data);
    if($result->num_rows()==1) {
      echo json_encode(array("count" => $result->num_rows(),"data" => $result->row()));
    }else{
      echo json_encode(array("count" => $result->num_rows()));
    }
  }

}
?>
