<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Client_payments extends CI_Controller
{
  public $page_data = array();

  function __construct()
  {
    parent::__construct();
    $this->initial();
  }
  public function initial()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");

    $this->load->model('User_model', 'User');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Client_model', 'Client');
    $this->load->model('Account_model', 'Account');
    $this->load->model('Settings_model', 'Settings');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Invoices_model', 'Invoices');

    $this->load->library('Projects_management','projects_management');

    //        Check User Logged in or Not
    $allowed_user_roles = array("madmin","admin","supervisor","general_manager","accounts_manager","auditor","qs","qs_manager");
    if($this->User->is_logged_in($allowed_user_roles)==false){
      redirect(base_url(), 'refresh');
    }
    //        File Directory
    $this->page_data['directory'] = "clients";

  }
  public function index()
  {
    $this->view();
  }

  public function view()
  {
    $this->page_data['page_name'] = 'client_payments';

    $work_data = array();

    if($this->session->userdata('user_role')=='supervisor') {
      //          Select Assigned Works Only
      $supervisor_id = $this->session->userdata('user_id');
      $this->db->where("FIND_IN_SET($supervisor_id, w.assigned_users)");
    }
    $this->page_data['work_contracts'] = $this->Work->select_work("*",$work_data)->result();

    $this->page_data['selected_start_date'] = $this->page_data['selected_end_date'] = "";
    if (isset($_GET['start_date']) && $_GET['start_date'] != '') {
      $this->page_data['selected_start_date'] = $_GET['start_date'];
    }
    if (isset($_GET['end_date']) && $_GET['end_date'] != '') {
      $this->page_data['selected_end_date'] = $_GET['end_date'];
    }

    $entry_approval = 1;
    if($this->config->item('User_enable_data_entry_approval')==1){//webapp users approval
      $entry_approval = 'all';
    }
    $this->page_data['invoices'] = $this->Invoices->select_invoices("*,u1.user_id as i_created_by,u1.user_alias as i_created",'',$entry_approval)->result();


    $this->page_data['clients'] = $this->Client->select_client("")->result();
    $this->load->view('Index',$this->page_data);
  }

  public function schedule()
  {
    $this->page_data['page_name'] = 'client_payments_schedule';

    $work_data = array();

    if($this->session->userdata('user_role')=='supervisor') {
      //          Select Assigned Works Only
      $supervisor_id = $this->session->userdata('user_id');
      $this->db->where("FIND_IN_SET($supervisor_id, w.assigned_users)");
    }
    $this->page_data['work_contracts'] = $this->Work->select_work("*",$work_data)->result();

    $this->page_data['selected_start_date'] = $this->page_data['selected_end_date'] = "";
    if (isset($_GET['start_date']) && $_GET['start_date'] != '') {
      $this->page_data['selected_start_date'] = $_GET['start_date'];
    }
    if (isset($_GET['end_date']) && $_GET['end_date'] != '') {
      $this->page_data['selected_end_date'] = $_GET['end_date'];
    }


    $this->page_data['clients'] = $this->Client->select_client("")->result();
    $this->load->view('Index',$this->page_data);
  }

  public function select_client_payments($page_data_type=""){

    $json_data=array();
    $j=$sl_no=$total_amount=$total_tax_amount=0;
    $data=array();
    if(isset($_POST['date']) && $_POST['date']!=''){
      $date=array();
      $date=explode('-',$_POST['date']);
      $start_date=date('Y-m-d', strtotime($date[0]));
      $end_date=date('Y-m-d', strtotime($date[1]));
      $data["STR_TO_DATE(ats.tr_date,'%Y-%m-%d') <="]= $end_date;
      $data["STR_TO_DATE(ats.tr_date,'%Y-%m-%d') >="]= $start_date;
    }
    if (isset($_POST['acc_head_id']) && $_POST['acc_head_id'] != '' && $_POST['acc_head_id'] != 'all') {
      $acc_head_id = $_POST['acc_head_id'];
      $account_heads_where['ah.acc_head_id'] = $_POST['acc_head_id'];
      $account_heads_data	= $this->Account->select_account_heads("acc_head_id,acc_user_id,acc_employee_id",$account_heads_where)->row();
      $this->db->where('(tr_credit_acc='.$acc_head_id.' or tr_debit_acc='.$acc_head_id.')');
    }
    if(isset($_POST['start_date']) && $_POST['start_date']!=''){
      $data["ats.tr_date >="]= date('Y-m-d', strtotime($_POST['start_date']));
    }
    if(isset($_POST['end_date']) && $_POST['end_date']!=''){
      $data["ats.tr_date <="]= date('Y-m-d', strtotime($_POST['end_date']));
    }
    if(isset($_POST['clients']) && $_POST['clients']!='' && $_POST['clients']!='all'){
      $data['c.client_id'] = $_POST['clients'];
    }
    if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
      $work_id = $_POST['work'];
      $this->db->where("((wc.work_id=$work_id and ats.reference_type='project' and ats.invoice_id=0) or (ci.project_id=$work_id and ats.reference_type='project' and ats.invoice_id!=0))");
    }
    if(isset($_POST['work_ids']) && $_POST['work_ids']!='' && $_POST['work_ids']!='all'){
      $work_ids = $_POST['work_ids'];
      $this->db->where("((wc.work_id IN ('$work_ids') and ats.reference_type='project' and ats.invoice_id=0) or (ci.project_id IN ('$work_ids') and ats.reference_type='project' and ats.invoice_id!=0))");
    }
    if(isset($_POST['stage_id']) && $_POST['stage_id']!='' && $_POST['stage_id']!='all'){
      $data['ats.tr_project_stage_id'] = $_POST['stage_id'];
    }
    if($this->session->userdata('user_role')=='supervisor') {
      //          Select Assigned Works Only
      $supervisor_id = $this->session->userdata('user_id');
      $this->db->where("FIND_IN_SET($supervisor_id, wc.assigned_users)");
    }
    if($this->config->item('user_data_access_view_all')!=1){
      $data['ats.created_by'] = $this->session->userdata('user_id');
    }
    if($this->session->userdata('user_role')=='general_manager' && $this->config->item('User_general_manager_client_payment_view_all')==0){
      $data['ats.created_by'] = $this->session->userdata('user_id');
    }
    if(isset($_POST['created_by']) && $_POST['created_by']!='' && $_POST['created_by']!='all'){
      $this->db->where("ats.created_by",$_POST['created_by']);
    }
    if(isset($_POST['payment_type']) && $_POST['payment_type']!='' && $_POST['payment_type']!='all' && $_POST['payment_type']=='invoice'){
      $data['ats.invoice_id !='] = 0;
    }
    if(isset($_POST['start_month']) && $_POST['start_month']!='' && $_POST['start_month']!='all'){
      $start_date=date('Y-m-d', strtotime("01-".$_POST['start_month']));
      $this->db->where("ats.tr_date >=",$start_date);
    }
    if(isset($_POST['end_month']) && $_POST['end_month']!='' && $_POST['end_month']!='all'){
      $end_date=date('Y-m-t', strtotime("01-".$_POST['end_month']));
      $this->db->where("ats.tr_date <=",$end_date);
    }

    if(isset($_POST['branch_id']) && $_POST['branch_id']!='' && $_POST['branch_id']!='all'){
      $data['wc.branch_id'] = $_POST['branch_id'];
    }
    if(isset($_POST['acc_user_id']) && $_POST['acc_user_id']!='' && $_POST['acc_user_id']!='all'){
      $data['ah2.acc_user_id'] = $_POST['acc_user_id'];
    }

    $data['ats.tr_type'] = 'client_payment_transaction';
    $data['ats.reference_type'] = 'project';
    $entry_approval = 1;
    if($this->config->item('User_enable_data_entry_approval')==1){//webapp users approval
      $entry_approval = 'all';
    }
    if($page_data_type=='approval_entries'){
      $entry_approval = 'all';
      $data['u1.user_role >'] =2;
      if(isset($_POST['approval_status']) && $_POST['approval_status']!='' && $_POST['approval_status']!='all'){
        $entry_approval = $_POST['approval_status'];
      }
    }

    $result	= $this->Account->select_account_transaction("ats.*,c.client_contact,c.client_email,c.client_id,c.client_name,wc.work_id,wc.work_name,u1.user_alias as created_user,u2.user_alias as updated_user,ah2.acc_head_name as credit_account,u1.user_role as created_user_role_id",$data,'client_payment','','','',$entry_approval);

    $result_array=$result->result();
    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();


    foreach($result_array as $row):
      $transaction_id_column = 1;
      $btn_print = $btn_edit = $btn_delete = $btn_send = $btn_whatsapp_send = '';
      if($this->session->userdata('user_role')=='accounts_manager' ||  $this->session->userdata('user_role')=='admin' || ($this->session->userdata('user_role')!='admin' && $this->session->userdata('user_id')==$row->created_by)) {
        if($row->tr_entry_approval_status==1){
          $btn_send='<a style="margin-left: 5px;margin-right: 5px" id="send_email_btn" href="#send_email_modal" data-toggle="modal" class="btn btn-warning m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air">
          <i class="la la-envelope"></i>
          </a>';
          $btn_print='<button style="margin-left: 5px;margin-right: 5px" id="btn_print_client_receipt" class="btn btn-success m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air">
          <i class="la la-print"></i>
          </button>';
          if($this->config->item('Client_Payment_receipt_send_whatsapp')==1){
            $btn_whatsapp_send='<a style="margin-left: 5px;margin-right: 5px;background-color: #075E54 !important;border-color: #075E54 !important;" id="send_whatsapp_btn" href="#send_whatsapp_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air">
            <i class="la la-whatsapp"></i>
            </a>';
          }
        }
      }
      if($this->session->userdata('user_role')!='accounts_manager' && ($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_id')==$row->created_by) && ($this->config->item('User_enable_data_entry_approval')!=1 || $row->tr_entry_approval_status!=1 || $this->session->userdata('user_role')=='admin')) {
        $btn_edit = '<a style="margin-left: 5px;margin-right: 5px" id="client_payment_edit_btn" href="#client_payment_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-edit"></i>
        </a>';
        $btn_delete='<a style="margin-left: 5px;margin-right: 5px" data-form-type="client_payment" data-tr-type="client_payment_transaction" data-form-type="client_payment" data-id-column="'.$transaction_id_column.'" id="btn_delete_transaction"  href="#transaction_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-trash"></i>
        </a>';
      }
      $btn_approve = $entry_approval_status = '';
      if(($this->session->userdata('user_role')=='admin' || ($this->session->userdata('user_role')=='accounts_manager' && $row->created_user_role_id>2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1){
        $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="client_payment" data-approval-status="'.$row->tr_entry_approval_status.'" data-id="'.$row->transaction_id.'" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
        <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
        </a>';
      }
      if(($page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1) || $this->config->item('User_enable_data_entry_approval')==1){
        if($row->tr_entry_approval_status==1){
          $entry_approval_status="<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> Approved</span>";
        }elseif($row->tr_entry_approval_status==2){
          $entry_approval_status="<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> Rejected</span>";
        }else{
          $entry_approval_status="<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> Pending</span>";
        }
      }

      $invoice_details = "<span class='m-badge m-badge--warning m-badge--wide'>Non Invoice Payment</span>";
      if($row->invoice_id != 0){
        $invoice_details = "<span class='m-badge m-badge--success m-badge--wide'><a href='".base_url()."invoices/profile/".$row->invoice_id."' style='color: #000; text-decoration: none;'>Invoice Payment  #".$row->invoice_id."</a></span>";
      }
      $file_attachment='';
      if($row->tr_file_attachment != ''){
        $file_attachment = "<a target='_blank' href='".base_url()."uploads/transaction/".$row->tr_file_attachment."'>Click Here</a>";
      }

      $id=$row->work_id;

      $sl_no++;
      $array[$j][] = $sl_no;
      $array[$j][] = $row->transaction_id;
      $array[$j][] = "#".$row->transaction_id;
      $array[$j][] = $invoice_details;
      $array[$j][] = date('d-m-Y',strtotime($row->tr_date));
      $array[$j][] = $row->client_name;
      $array[$j][] = '<a href="' . base_url() . 'work/profile/' . $id . '">' . $row->work_name . '</a>';
      $array[$j][]=number_format($row->taxable_amount,$this->config->item('Currency_amount_decimals_2'),'.','');
      $array[$j][] = $row->tax_percent.'%';
      $array[$j][]=number_format($row->tax_amount,$this->config->item('Currency_amount_decimals_2'),'.','');
      $array[$j][]=number_format($row->tr_amount,$this->config->item('Currency_amount_decimals_2'),'.','');
      $array[$j][] = $row->credit_account;
      $array[$j][] = $row->tr_reference_no;
      $array[$j][] = $row->tr_remarks;
      $array[$j][] = $row->tr_other_data;
      $array[$j][] = $file_attachment;
      $array[$j][]=$row->created_user.$entry_approval_status;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]=date('d-m-Y',strtotime($row->created_date));
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$btn_print.$btn_send.$btn_whatsapp_send.$btn_edit.$btn_delete.$btn_approve;
      $array[$j][]=$row->updated_user;
      if($row->updated_date!='0000-00-00 00:00:00'){
        $array[$j][]=date('d-m-Y',strtotime($row->updated_date));
      }else{
        $array[$j][]='';
      }
      $array[$j][] = $row->work_id;
      $array[$j][] = $row->client_id;
      $array[$j][] = $row->tr_credit_acc;
      $array[$j][] = $row->client_email;
      $array[$j][] = $row->tax_inclusive;
      $array[$j][] = $row->invoice_id;
      $array[$j][] = $row->client_contact;
      $array[$j][] = $row->tr_entry_approval_status;
      $array[$j][] = $row->tr_file_attachment;

      $total_amount+=$row->tr_amount;
      $total_tax_amount+=$row->tax_amount;

      $j++;
    endforeach;
    if($result->num_rows()>0){
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][] = '';
      $array[$j][]="<strong>Total</strong>";
      $array[$j][]="<strong>".$this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($total_tax_amount,$this->config->item('Currency_currency_shortname'))."</strong>";
      $array[$j][]="<strong>".$this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($total_amount,$this->config->item('Currency_currency_shortname'))."</strong>";
      $array[$j][] = '';
      $array[$j][] = '';
      $array[$j][] = '';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';

    }

    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }
  public function print_receipt($transaction_id='')
  {
    $tr_data['transaction_id'] = $transaction_id;
    $result	= $this->Account->select_account_transaction("ats.*,c.client_address,c.client_email,c.client_id,c.client_name,wc.work_id,wc.work_name,u1.user_alias as created_user,u2.user_alias as updated_user,ah2.acc_head_name as credit_account",$tr_data,'client_payment');
    if($result->num_rows()==1 || $transaction_id!='') {
      $result = $result->row();
      ##Send Mail
      $data5['subject'] = "Payment Receipt";
      $company_account_detials = ' ';
      if($this->config->item('company_account_details')!=''){
        $company_account_detials = '<div class="notices">
        <div>Account Details:</div>
        <div class="notice">'.$this->config->item('company_account_details').'</div>
        </div>';
      }
      $client_address = nl2br($result->client_address);
      $message = file_get_contents(base_url() . 'template/email/payment_receipt_print.html');
      if($this->config->item('company_letter_head')!=''){
        $message = str_replace("#header", base_url() . 'uploads/company/'.$this->config->item('company_letter_head'), $message);
      }
      $message = str_replace("#clientname", $result->client_name, $message);
      $message = str_replace("#clientaddress",$client_address, $message);
      $message = str_replace("#clientemail", $result->client_email, $message);
      $message = str_replace("#receiptid", $result->transaction_id, $message);
      $message = str_replace("#receiptdate", date('d-m-Y',strtotime($result->tr_date)), $message);
      $message = str_replace("#receivedfrom", $result->tr_other_data, $message);
      $message = str_replace("#receivedby", $result->created_user, $message);
      $message = str_replace("#remarks", $result->tr_remarks, $message);
      $message = str_replace("#description", $result->work_name, $message);
      $message = str_replace("#quantity", 1, $message);
      $message = str_replace("#price", $this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($result->tr_amount,$this->config->item('Currency_currency_shortname')), $message);
      $message = str_replace("#total", $this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($result->tr_amount,$this->config->item('Currency_currency_shortname')), $message);
      $message = str_replace("#account_details", $company_account_detials, $message);
      // $message = str_replace("#company_address", $this->config->item('company_address'), $message);
      $message = str_replace("#base_url", base_url(), $message);
      $this->page_data['receipt_content'] = $message;

      $this->page_data['page_name'] = 'client_payment_print';
      $this->load->view('Index',$this->page_data);
    }else{
      show_404();
    }
  }
  public function send_receipt($type='')
  {
    if($type=='whatsapp'){
      $data['client_id']=$this->security->xss_clean($this->input->post('client_id'));
      $data['mobile']=$this->security->xss_clean($this->input->post('whatsapp'));
      $data['transaction_id']=$this->security->xss_clean($this->input->post('transaction_id'));
      $flash_data['url'] = $this->send_whatsapp($data, "receipt");
      $flash_data['status'] = 1;
      $flash_data['flashdata_msg'] = "";
      $flash_data['flashdata_type'] = '';
      $flash_data['alert_type'] = '';
      $flash_data['flashdata_title'] = '';
    }else{
      // email
      $redirect_url=$this->security->xss_clean($this->input->post('redirect_url'));
      $data['client_id']=$this->security->xss_clean($this->input->post('client_id'));
      $data['email']=$this->security->xss_clean($this->input->post('email'));
      $data['transaction_id']=$this->security->xss_clean($this->input->post('transaction_id'));
      $email_status = $this->send_email($data, "receipt");
      $flash_data['status'] = $email_status;
      if ($email_status == 1) {

        // Add User Activity
        $this->User->add_user_activity('Client Payment',$data['transaction_id'],'Receipt Email Sent');

        $flash_data['flashdata_msg'] = "Receipt Email Sent Successfully";
        $flash_data['flashdata_type'] = 'success';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';
      } else {
        $flash_data['flashdata_msg'] = "Receipt Email Sending Failed!!";
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'error';
        $flash_data['flashdata_title'] = 'Failed !!';
      }

      // $this->session->set_flashdata($flash_data);
      // redirect($redirect_url,'refresh');
    }
    echo(json_encode($flash_data));
  }
  public function send_email($data,$email_type){

    if($email_type == 'receipt') {
      $tr_data['transaction_id'] = $data['transaction_id'];
      $result	= $this->Account->select_account_transaction("ats.*,c.client_address,c.client_email,c.client_id,c.client_name,wc.work_id,wc.work_name,u1.user_alias as created_user,u2.user_alias as updated_user,ah2.acc_head_name as credit_account",$tr_data,'client_payment');
      if($result->num_rows()==1) {
        $result = $result->row();
        ##Send Mail
        $data5['subject'] = "Payment Receipt";
        $company_account_detials = ' ';
        if($this->config->item('company_account_details')!=''){
          $company_account_detials = '<div class="notices">
          <div>Account Details:</div>
          <div class="notice">'.$this->config->item('company_account_details').'</div>
          </div>';
        }
        $client_address = nl2br($result->client_address);
        $message = file_get_contents(base_url() . 'template/email/payment_receipt_2.html');
        $message = str_replace("#logo", base_url() . 'uploads/company/logo.png', $message);
        $message = str_replace("#clientname", $result->client_name, $message);
        $message = str_replace("#clientaddress",$client_address, $message);
        $message = str_replace("#clientemail", $result->client_email, $message);
        $message = str_replace("#receiptid", $result->transaction_id, $message);
        $message = str_replace("#receiptdate", date('d-m-Y',strtotime($result->tr_date)), $message);
        $message = str_replace("#receivedfrom", $result->tr_other_data, $message);
        $message = str_replace("#receivedby", $result->created_user, $message);
        $message = str_replace("#remarks", $result->tr_remarks, $message);
        $message = str_replace("#description", $result->work_name, $message);
        $message = str_replace("#quantity", 1, $message);
        $message = str_replace("#price", $this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($result->tr_amount,$this->config->item('Currency_currency_shortname')), $message);
        $message = str_replace("#total", $this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($result->tr_amount,$this->config->item('Currency_currency_shortname')), $message);
        $message = str_replace("#account_details", $company_account_detials, $message);
        $message = str_replace("#company_address", $this->config->item('company_address'), $message);
        $message = str_replace("#base_url", base_url(), $message);
        $data5['message'] = $message;
        $data5['to'] = $data['email'];
        $result4 = $this->Account->send_email($data5);
        if($result4 == 1){
          return 1;
        }else{
          return 0;
        }
      }else{
        return 0;
      }
    }else{
      return 0;
    }
  }
  public function send_whatsapp($data,$type){
    if($type == 'receipt') {
      $tr_data['transaction_id'] = $data['transaction_id'];
      $result	= $this->Account->select_account_transaction("ats.*,c.client_address,c.client_email,c.client_id,c.client_name,wc.work_id,wc.work_name,u1.user_alias as created_user,u2.user_alias as updated_user,ah2.acc_head_name as credit_account",$tr_data,'client_payment');
      if($result->num_rows()==1) {

        $result = $result->row();

        $client_address = nl2br($result->client_address);

        $company_address = $this->config->item('company_address');
        $company_address = str_replace('<br />','\n',$company_address);
        $company_address = str_replace('<br/>','\n',$company_address);
        $company_address = str_replace('<br>','\n',$company_address);

        $message = '*Payment Receipt : #'. $data['transaction_id'] . '*\n'. '*( Project: ' . $result->work_name  . ' )*\n\n';
        $message .= '\nReceived Amount : * INR '.$this->config->item('currency_format')->formatCurrency($result->tr_amount,$this->config->item('Currency_currency_shortname')) . '*\n';
        $message .= '\nReceived Date : *' .date('d-m-Y',strtotime($result->tr_date)). '*\n';
        $message .= '\nReceived From: *' .$result->client_name . '*\n';

        if($client_address!=''){
          $message .= '\nAddress: *' .$client_address . '*\n\n';
        }

        $message .=  '* Thanks and Regards From: *\n';
        $message .=  $company_address. '\n';

        $url =base64_encode("https://api.whatsapp.com/send?phone=" . preg_replace('/\s+/', '', $data['mobile']) ."&text=" . str_replace('%5Cn','%0A',urlencode($message)));
        return $url;
      }else{
        return 0;
      }
    }else{
      return 0;
    }
  }
}
?>
