<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Attendance extends CI_Controller
{
  public $page_data = array();

  function __construct()
  {
    parent::__construct();
    $this->initial();
  }

  public function initial()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");

    $this->load->model('User_model', 'User');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Attendance_model', 'Attendance');
    $this->load->model('Settings_model', 'Settings');
    $this->load->model('Employees_model', 'Employee');
    $this->load->library('Push_notification','push_notification');

    //        Check User Logged in or Not
    // $allowed_user_roles = array("madmin","admin","supervisor","general_manager");
    // if($this->User->is_logged_in($allowed_user_roles)==false){
    //   redirect(base_url(), 'refresh');
    // }

    //        File Directory
    $this->page_data['directory'] = "attendance";

  }
  public function index()
  {
    $this->view();
  }

  public function view($view_type='day')
  {
    if($view_type=='month'){
      $allowed_user_roles = array("madmin","admin","general_manager","accounts_manager","hr_manager","operation_manager");
      if($this->User->is_logged_in($allowed_user_roles)==false){
        redirect(base_url(), 'refresh');
      }
    }else{
      $allowed_user_roles = array("madmin","admin","supervisor","general_manager","purchase_manager","boq_manager","accounts_manager","auditor","qs","qs_manager","procurement_engineer","project_manager","operation_manager","hr_manager");
      if($this->User->is_logged_in($allowed_user_roles)==false){
        redirect(base_url(), 'refresh');
      }
    }
    $this->page_data['leave_types'] = $this->Employee->select_leave_types("")->result();

    // Check Module is Enabled or Not
    if($this->config->item('app_module_app_user_attendance')==0){
      redirect(base_url().'dashboard', 'refresh');
    }

    if($this->session->userdata('user_role')=='supervisor') {
      //          Select Assigned Works Only
      $supervisor_id = $this->session->userdata('user_id');
      $this->db->where("FIND_IN_SET($supervisor_id, w.assigned_users)");
    }
    $this->page_data['work_contracts'] = $this->Work->select_work("*")->result();

    if($this->session->userdata('user_role')!='admin' && $this->config->item('User_attendance_mark_by_self_only')==1){
      $this->db->where("user_id",$this->session->userdata('user_id'));
    }elseif($this->config->item('User_attendance_mark_by_self_only')==0 && $this->session->userdata('user_role')!='admin' && $this->session->userdata('user_role')!='general_manager' && $this->session->userdata('user_role')!='hr_manager' && $this->session->userdata('user_role')!='accounts_manager' && $this->session->userdata('user_role')!='operation_manager') {
      $this->db->where("user_id",$this->session->userdata('user_id'));
    }
    // $data['ur.mobile_app_access'] = 1;
    $data['acc_status'] = 1;
    $this->page_data['users'] = $this->User->select_user("",$data)->result();

    if($view_type=='month'){
      $this->page_data['page_name'] = 'attendance_view_month';
    }else{
      $this->page_data['page_name'] = 'attendance_view_day';
    }
    $this->load->view('Index', $this->page_data);
  }

  public function select_attendance($param=""){

    $attendance_status =  0;
    if(isset($_POST['attendance_status']) && $_POST['attendance_status']!='' && $_POST['attendance_status']!='all'){
      $attendance_status = $_POST['attendance_status'];
    }

    $json_data=array();
    $j=0;
    $sl_no=0;
    $array=array();
    $data=array();
    if(isset($_POST['user']) && $_POST['user']!='' && $_POST['user']!='all'){
      $data['user_id'] = $_POST['user'];
    }
    if($this->session->userdata('user_role')!='accounts_manager' && $this->session->userdata('user_role')!='accounts_manager' && $this->session->userdata('user_role')!='hr_manager' && $this->session->userdata('user_role')!='admin' && $this->session->userdata('user_role')!='general_manager' && $this->session->userdata('user_role')!='operation_manager' && $this->session->userdata('user_role_id')!=20) {
      $data['user_id'] = $this->session->userdata('user_id');
    }elseif($this->session->userdata('user_role_id')==20) {
      // Select Assigned Users of project manager assigned projects
      $user_id = $this->session->userdata('user_id');
      $this->db->where("FIND_IN_SET($user_id, w.assigned_users)");
      $assigned_users_array = array();
      $assigned_users_string = '';
      $assigned_users = $this->Work->select_work("w.assigned_users")->result();
      foreach ($assigned_users as $key2 => $value2) {
        if($value2->assigned_users!=''){
          $assigned_users_string .= $value2->assigned_users.",";
        }
      }
      if($assigned_users_string!=''){
        $assigned_users_array = explode(',',$assigned_users_string);
        $assigned_users_array = array_unique($assigned_users_array);
        $assigned_users_string = implode(',',$assigned_users_array);
        $assigned_users_string = rtrim($assigned_users_string, ',');
        $this->db->where('user_id IN('.$assigned_users_string.')');
      }
    }
    // $data['ur.mobile_app_access'] = 1;
    $data['acc_status'] = 1;
    $users	= $this->User->select_user("",$data)->result();
    $show_attendance= 0;

    if(isset($_POST['date']) && $_POST['date']!=''){
      $date=array();
      $date=explode('-',$_POST['date']);
      $start_date=date('Y-m-d', strtotime($date[0]));
      $end_date=date('Y-m-d', strtotime($date[1]));
      // of period 1 day
      $interval = new DateInterval('P1D');
      $realEnd = new DateTime($end_date);
      $realEnd->add($interval);
      $date_period = new DatePeriod(new DateTime($start_date), $interval, $realEnd);

      foreach ($date_period as $key => $value) {
        $marked_data=$not_marked_data = array();
        $i=$k=0;
        foreach($users as $row):
          $attendance_data = array();
          $btn_delete = '';
          // Check Attendece Exist ot Not
          $where['uat.user_id'] = $row->user_id;
          $where['uat.attendance_date'] = $value->format('Y-m-d');
          $where['uat.delete_status'] = 0;
          $attendance = $this->Attendance->select_attendance('uat.*,u2.user_alias as created_user,ua1.activity_location_address as signed_in_location,ua1.activity_location_landmark as signed_in_landmark,ua1.activity_location_latitude as signed_in_latitude,ua1.activity_location_longitude as signed_in_longitude,ua1.activity_device as signed_in_device,ua1.activity_through as sign_in_activity_through,
          ua2.activity_location_address as signed_off_location,ua2.activity_location_latitude as signed_off_latitude,ua2.activity_location_longitude as signed_off_longitude,ua2.activity_location_landmark as signed_off_landmark,ua2.activity_through as sign_off_activity_through,ua2.activity_device as signed_off_device,lt.leave_type_name,lt.leave_paid',$where);

          $holiday = 0;
          $holiday_name = '';
          if($this->config->item('Attendance_sunday_holiday')==1 && date('l',strtotime($value->format('Y-m-d')))=='Sunday'){
            $holiday = 1;
            $holiday_name = 'Sunday';
          }
          $holiday_count = $this->Settings->select_holidays("",array("holiday_date"=>$value->format('Y-m-d')));
          if($holiday_count->num_rows()>0){
            $holiday = 1;
            $holiday_name = "Holiday - ".$holiday_count->row()->holiday_name;
          }

          if($attendance->num_rows()>0){
            $attendance = $attendance->row();
            if($attendance->attendance_status==1 && ($attendance_status==0 || $attendance_status==1)){

              $marked_data[$i] = array("attendance_id"=>'',"attendance_status"=>'',"signed_in_time"=>'',"signed_in_from"=>'',"signed_in_landmark"=>'',"signed_in_latitude"=>'',"signed_in_longitude"=>'',
              "signed_off_time"=>'',"signed_off_from"=>'',"signed_off_latitude"=>'',"signed_off_longitude"=>'',
              "leave_marked_time"=>'',"leave_marked_from"=>'',"leave_marked_latitude"=>'',"leave_marked_longitude"=>'',"attendance"=>'',"actions"=>'',"status"=>'');


              $marked_data[$i]['date'] = $value->format('d-m-Y');
              $marked_data[$i]['day'] = date('l',strtotime($value->format('Y-m-d')));
              $marked_data[$i]['user_alias'] = $row->user_alias;
              $marked_data[$i]['user_id'] = $row->user_id;
              $marked_data[$i]['attendance_id'] = $attendance->attendance_id;
              $marked_data[$i]['status'] = $attendance->attendance_status;
              $marked_data[$i]['attendance_status'] = "<span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check-circle'></i> Marked</span>";
              if($attendance->created_by!=$row->user_id){
                $marked_data[$i]['attendance_status'] .="<br/><span style='margin-top: 5px' class='m-badge m-badge--warning m-badge--wide'> Marked By ".$attendance->created_user."</span>";
              }
              if($holiday==1){
                $marked_data[$i]['attendance_status'] .="<br/><span style='margin-top: 5px' class='m-badge m-badge--focus m-badge--wide'>".$holiday_name."</span>";
              }

              $marked_data[$i]['attendance'] = "<span style='margin-top: 5px' class='m-badge m-badge--primary m-badge--wide'><i class='la la-calendar-check-o'></i> Marked As on Duty</span>";

              if(date('H:i',strtotime($attendance->signed_in_time)) > date('H:i',strtotime($row->duty_start_time))){
                $signed_in_time_1 = new DateTime(date('Y-m-d') . ' ' . date("h:i:s A", strtotime($attendance->signed_in_time)));
                $duty_start_time_1 = new DateTime(date('Y-m-d') . ' ' . date("h:i:s A", strtotime($row->duty_start_time)));
                $late_in = $signed_in_time_1->diff($duty_start_time_1);
                $late_in = $late_in->format('%H') . " h : " . $late_in->format('%I')." m";
                $marked_data[$i]['attendance'] .="<br/><span style='margin-top: 5px' class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-times-circle'></i> Signed In Late (".$late_in.")</span>";
              }elseif(date('H:i',strtotime($attendance->signed_in_time)) < date('H:i',strtotime($row->duty_start_time))){
                $signed_in_time_12 = new DateTime(date('Y-m-d') . ' ' . date("h:i:s A", strtotime($attendance->signed_in_time)));
                $duty_start_time_12 = new DateTime(date('Y-m-d') . ' ' . date("h:i:s A", strtotime($row->duty_start_time)));
                $early_in = $signed_in_time_12->diff($duty_start_time_12);
                $early_in = $early_in->format('%H') . " h : " . $early_in->format('%I')." m";
                $marked_data[$i]['attendance'] .="<br/><span style='margin-top: 5px' class='m-badge m-badge--info m-badge--wide'><i class='fa fa-check'></i> Signed In Early (".$early_in.")</span>";
              }else{
                $marked_data[$i]['attendance'] .="<br/><span style='margin-top: 5px' class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> Signed In On Time</span>";
              }

              $sign_in_device = $attendance->signed_in_device;
              $sign_out_device = $attendance->signed_off_device;
              $marked_data[$i]['signed_in_time'] = $attendance->signed_in_time;
              // $marked_data[$i]['signed_in_from'] = str_replace(',','<br/>',$attendance->signed_in_location);
              $marked_data[$i]['signed_in_from'] = ($attendance->signed_in_location!='') ? $attendance->signed_in_location:"Device Location Not Accessible";
              $marked_data[$i]['signed_in_landmark'] = $attendance->signed_in_landmark;
              $marked_data[$i]['signed_in_latitude'] = $attendance->signed_in_latitude;
              $marked_data[$i]['signed_in_longitude'] = $attendance->signed_in_longitude;
              if($marked_data[$i]['signed_in_latitude']!='' && $marked_data[$i]['signed_in_longitude']!=''){
                $marked_data[$i]['signed_in_from'] .= '<br/><a target="_blank" style="margin-left: 5px;margin-right: 5px"  href="https://www.google.com/maps/search/?api=1&map_action=map&query='.$marked_data[$i]['signed_in_latitude'].','.$marked_data[$i]['signed_in_longitude'].'&zoom=16" class="btn btn-info m-btn m-btn--icon  btn-sm m-btn--pill m-btn--air"><i class="fa fa-map-marker"></i> View on Map</a>';
              }
              if($sign_in_device!=''){
                $marked_data[$i]['signed_in_from'] .= "<br/><span style='margin-top: 5px' class='m-badge m-badge--success m-badge--wide'><i class='fa	fa-mobile-alt'></i> Device: ".$sign_in_device."</span>";
              }
              $marked_data[$i]['signed_in_from'] .='<br/>(Landmark :'.$attendance->signed_in_landmark.')';
              if($attendance->sign_in_activity_through=='Web App' || $attendance->sign_in_activity_through=='webapp'){
                $marked_data[$i]['signed_in_from'] .="<br/><span style='margin-top: 5px' class='m-badge m-badge--focus m-badge--wide'> Marked From Web App </span>";
              }
              if($attendance->signed_off_time!='00:00:00'){
                $marked_data[$i]['signed_off_time'] = $attendance->signed_off_time;
                // $marked_data[$i]['signed_off_from'] = str_replace(',','<br/>',$attendance->signed_off_location);
                $marked_data[$i]['signed_off_from'] = ($attendance->signed_off_location!='') ? $attendance->signed_off_location:"Device Location Not Accessible";
                $marked_data[$i]['signed_off_landmark'] = $attendance->signed_off_landmark;
                $marked_data[$i]['signed_off_latitude'] = $attendance->signed_off_latitude;
                $marked_data[$i]['signed_off_longitude'] = $attendance->signed_off_longitude;
                if($marked_data[$i]['signed_off_latitude']!='' && $marked_data[$i]['signed_off_longitude']!=''){
                  $marked_data[$i]['signed_off_from'] .= '<br/><a target="_blank" style="margin-left: 5px;margin-right: 5px"  href="https://www.google.com/maps/search/?api=1&map_action=map&query='.$marked_data[$i]['signed_off_latitude'].','.$marked_data[$i]['signed_off_longitude'].'&zoom=16" class="btn btn-info m-btn m-btn--icon btn-sm m-btn--pill m-btn--air"><i class="fa fa-map-marker"></i> View on Map</a>';
                }
                if($sign_out_device!=''){
                  if($sign_out_device==$sign_in_device){
                    $marked_data[$i]['signed_off_from'] .= "<br/><span style='margin-top: 5px' class='m-badge m-badge--success m-badge--wide'><i class='fa fa-mobile-alt'></i> Device: ".$sign_out_device."</span>";
                  }else{
                    $marked_data[$i]['signed_off_from'] .= "<br/><span style='margin-top: 5px' class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-mobile-alt'></i> Device: ".$sign_out_device."<br/>Signed Out From Different Device</span>";
                  }
                }
                $marked_data[$i]['signed_off_from'] .='<br/>(Landmark :'.$attendance->signed_off_landmark.')';
                if($attendance->sign_off_activity_through=='Web App' || $attendance->sign_off_activity_through=='webapp'){
                  $marked_data[$i]['signed_off_from'] .="<br/><span style='margin-top: 5px' class='m-badge m-badge--focus m-badge--wide'> Marked From Web App </span>";
                }

                if(date('H:i',strtotime($attendance->signed_off_time)) > date('H:i',strtotime($row->duty_end_time))){
                  $signed_off_time_1 = new DateTime(date('Y-m-d') . ' ' . date("h:i:s A", strtotime($attendance->signed_off_time)));
                  $duty_end_time_1 = new DateTime(date('Y-m-d') . ' ' . date("h:i:s A", strtotime($row->duty_end_time)));
                  $late_out = $signed_off_time_1->diff($duty_end_time_1);
                  $late_out = $late_out->format('%H') . " h : " . $late_out->format('%I')." m";
                  $marked_data[$i]['attendance'] .="<br/><span style='margin-top: 5px' class='m-badge m-badge--info m-badge--wide'><i class='fa fa-check'></i> Signed Off Late (".$late_out.")</span>";
                }elseif(date('H:i',strtotime($attendance->signed_off_time)) < date('H:i',strtotime($row->duty_end_time))){
                  $signed_off_time_12 = new DateTime(date('Y-m-d') . ' ' . date("h:i:s A", strtotime($attendance->signed_off_time)));
                  $duty_end_time_12 = new DateTime(date('Y-m-d') . ' ' . date("h:i:s A", strtotime($row->duty_end_time)));
                  $early_out = $signed_off_time_12->diff($duty_end_time_12);
                  $early_out = $early_out->format('%H') . " h : " . $early_out->format('%I')." m";
                  $marked_data[$i]['attendance'] .="<br/><span style='margin-top: 5px' class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-times-circle'></i> Signed Off Early (".$early_out.")</span>";
                }else{
                  $marked_data[$i]['attendance'] .="<br/><span style='margin-top: 5px' class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> Signed Off On Time</span>";
                }
              }else{
                $marked_data[$i]['signed_off_time'] = '';
                $marked_data[$i]['signed_off_from'] = '';
                $marked_data[$i]['signed_off_latitude'] = '';
                $marked_data[$i]['signed_off_longitude'] = '';
              }

              if($this->session->userdata('user_role')=='admin') {
                $marked_data[$i]['actions'] = '<a style="margin-left: 5px;margin-right: 5px" data-attendance-status="'.$attendance->attendance_status.'" id="attendance_edit_btn" href="#attendance_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air"><i class="la la-edit"></i></a>';
                $marked_data[$i]['actions'] .= '<a style="margin-left: 5px;margin-right: 5px" id="daily_attendance_delete_btn" href="#daily_attendance_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air"><i class="la la-trash"></i></a>';
              }
              $marked_data[$i]['leave_type'] = $attendance->leave_type;
              $i++;
            }elseif($attendance->attendance_status==2 && ($attendance_status==0 || $attendance_status==2)){

              $marked_data[$i] = array("attendance_id"=>'',"attendance_status"=>'',"signed_in_time"=>'',"signed_in_from"=>'',"signed_in_landmark"=>'',"signed_in_latitude"=>'',"signed_in_longitude"=>'',
              "signed_off_time"=>'',"signed_off_from"=>'',"signed_off_latitude"=>'',"signed_off_longitude"=>'',
              "leave_marked_time"=>'',"leave_marked_from"=>'',"leave_marked_latitude"=>'',"leave_marked_longitude"=>'',"attendance"=>'',"actions"=>'',"status"=>'');

              $marked_data[$i]['date'] = $value->format('d-m-Y');
              $marked_data[$i]['day'] = date('l',strtotime($value->format('Y-m-d')));
              $marked_data[$i]['user_alias'] = $row->user_alias;
              $marked_data[$i]['user_id'] = $row->user_id;
              $marked_data[$i]['status'] = $attendance->attendance_status;
              $marked_data[$i]['attendance_id'] = $attendance->attendance_id;
              $marked_data[$i]['attendance_status'] = "<span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check-circle'></i> Marked</span>";
              if($attendance->created_by!=$row->user_id){
                $marked_data[$i]['attendance_status'] .="<br/><span style='margin-top: 5px' class='m-badge m-badge--warning m-badge--wide'> Marked By ".$attendance->created_user."</span>";
              }
              if($holiday==1){
                $marked_data[$i]['attendance_status'] .="<br/><span style='margin-top: 5px' class='m-badge m-badge--focus m-badge--wide'> Holiday </span>";
              }
              $marked_data[$i]['attendance'] = "<span class='m-badge m-badge--warning m-badge--wide'><i class='la la-calendar-times-o'></i> Marked As Leave</span>";
              if($attendance->leave_type!=0){
                $leave_type = $attendance->leave_type_name;
                if($attendance->leave_paid==1){
                  $leave_type .= " [Paid]";
                }else{
                  $leave_type .= " [UnPaid]";
                }
                $marked_data[$i]['attendance'] .= "<br/><span style='margin-top: 5px' class='m-badge m-badge--info m-badge--wide'><i class='la la-check-circle'></i> ".$leave_type."</span>";
              }
              $marked_data[$i]['signed_in_time'] = $attendance->signed_in_time;
              $marked_data[$i]['leave_marked_time'] = $attendance->signed_in_time;
              $marked_data[$i]['leave_marked_landmark'] = $attendance->signed_in_landmark;
              // $marked_data[$i]['leave_marked_from'] = str_replace(',','<br/>',$attendance->signed_in_location);
              $marked_data[$i]['leave_marked_from'] = ($attendance->signed_in_location!='') ? $attendance->signed_in_location:"Device Location Not Accessible";
              $marked_data[$i]['leave_marked_landmark'] = $attendance->signed_in_landmark;
              $marked_data[$i]['leave_marked_latitude'] = $attendance->signed_in_latitude;
              $marked_data[$i]['leave_marked_longitude'] = $attendance->signed_in_longitude;
              if($marked_data[$i]['leave_marked_latitude']!='' && $marked_data[$i]['leave_marked_longitude']!=''){
                $marked_data[$i]['leave_marked_from'] .= '<br/><a target="_blank" style="margin-left: 5px;margin-right: 5px"  href="https://www.google.com/maps/search/?api=1&map_action=map&query='.$marked_data[$i]['leave_marked_latitude'].','.$marked_data[$i]['leave_marked_longitude'].'&zoom=16" class="btn btn-info m-btn m-btn--icon btn-sm m-btn--pill m-btn--air"><i class="fa fa-map-marker"></i> View on Map</a>';
              }
              $marked_data[$i]['leave_marked_from'] .='<br/>(Landmark :'.$attendance->signed_in_landmark.')';
              if($this->session->userdata('user_role')=='admin') {
                $marked_data[$i]['actions'] = '<a style="margin-left: 5px;margin-right: 5px" data-attendance-status="'.$attendance->attendance_status.'" id="attendance_edit_btn" href="#attendance_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air"><i class="la la-edit"></i></a>';
                $marked_data[$i]['actions'] .= '<a style="margin-left: 5px;margin-right: 5px" id="daily_attendance_delete_btn" href="#daily_attendance_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
                <i class="la la-trash"></i>
                </a>';
              }
              $marked_data[$i]['leave_type'] = $attendance->leave_type;
              $i++;
            }
          }else{
            if($attendance_status==0 || $attendance_status==3){
              $not_marked_data[$k]['date'] = $value->format('d-m-Y');
              $not_marked_data[$k]['day'] = date('l',strtotime($value->format('Y-m-d')));
              $not_marked_data[$k]['user_alias'] = $row->user_alias;
              $not_marked_data[$k]['user_id'] = $row->user_id;
              $not_marked_data[$k]['holiday'] = $holiday;
              $not_marked_data[$k]['holiday_name'] = $holiday_name;
              $k++;
            }
          }
        endforeach;

        // Sort By Signed In Time
        usort($marked_data, function($a, $b) {
          // return $a['date'] <=> $b['date'];
          if (date('H:i:s',strtotime($a['signed_in_time'])) == date('H:i:s',strtotime($b['signed_in_time']))) return 0;
          return date('H:i:s',strtotime($a['signed_in_time'])) < date('H:i:s',strtotime($b['signed_in_time'])) ? -1 : 1;
        });

        foreach ($marked_data as $key => $value) {
          $sl_no++;
          $array[$j][]=$sl_no;
          $array[$j][]=$marked_data[$key]['attendance_id'];
          $array[$j][]=$marked_data[$key]['date'];
          $array[$j][]=$marked_data[$key]['day'];
          $array[$j][]='<a href="' . base_url() . 'user/profile/' . $marked_data[$key]['user_id'] . '">' . $marked_data[$key]['user_alias'] . '</a>';
          $array[$j][]=$marked_data[$key]['attendance_status'];
          $array[$j][]=$marked_data[$key]['attendance'];

          if($marked_data[$key]['status']==1){
            $array[$j][]=date("h:i A",strtotime($marked_data[$key]['signed_in_time']));
          }else{
            $array[$j][]="";
          }
          if($marked_data[$key]['signed_off_time']!=''){
            $array[$j][]=date("h:i A",strtotime($marked_data[$key]['signed_off_time']));
          }else{
            $array[$j][]="";
          }

          if($marked_data[$key]['signed_in_time']!='' && $marked_data[$key]['signed_off_time']!=''){
            $work_start_time = new DateTime(date('Y-m-d').' '.date("h:i:s A",strtotime($marked_data[$key]['signed_in_time'])));
            $work_end_time = new DateTime(date('Y-m-d').' '.date("h:i:s A",strtotime($marked_data[$key]['signed_off_time'])));
            $actual_worked_time = $work_start_time->diff($work_end_time);
            $actual_worked_time = $actual_worked_time->format('%H').":".$actual_worked_time->format('%I');
            $array[$j][] = $actual_worked_time;

            if($row->duty_start_time!='' && $row->duty_start_time!='00:00:00' && $row->duty_end_time!='' && $row->duty_end_time!='00:00:00' ){
              $duty_start_time_normal = new DateTime(date('Y-m-d').' '.date("h:i:s A",strtotime($row->duty_start_time)));
              $duty_end_time_normal = new DateTime(date('Y-m-d').' '.date("h:i:s A",strtotime($row->duty_end_time)));
              $normal_work_time = $duty_start_time_normal->diff($duty_end_time_normal);
              $normal_work_time = $normal_work_time->format('%H').":".$normal_work_time->format('%I');

              $normal_work_time_1 = new DateTime($normal_work_time.":00");
              $actual_worked_time_1 = new DateTime($actual_worked_time.":00");
              if($actual_worked_time_1>$normal_work_time_1){
                $overtime = $normal_work_time_1->diff($actual_worked_time_1);
                $overtime =  $overtime->format('%H').":".$overtime->format('%I');
              }else{
                $overtime = "00:00";
              }
              $array[$j][]=$overtime;
            }else{
              $array[$j][]=0;
            }
          }else{
            $array[$j][]="";
            $array[$j][]=0;
          }

          $array[$j][]=$marked_data[$key]['signed_in_from'];
          // $array[$j][]=$marked_data[$key]['signed_in_landmark'];
          $array[$j][]=$marked_data[$key]['signed_off_from'];
          if($marked_data[$key]['leave_marked_time']!=''){
            $array[$j][]=date("h:i A",strtotime($marked_data[$key]['leave_marked_time']));
          }else{
            $array[$j][]="";
          }
          $array[$j][]=$marked_data[$key]['leave_marked_from'];
          $array[$j][]=$marked_data[$key]['actions'];
          $array[$j][]=$marked_data[$key]['leave_type'];
          $j++;
        }
        foreach ($not_marked_data as $key => $value) {
          $sl_no++;
          $array[$j][]=$sl_no;
          $array[$j][]='';
          $array[$j][]=$not_marked_data[$key]['date'];
          $array[$j][]=$not_marked_data[$key]['day'];
          $array[$j][]='<a href="' . base_url() . 'user/profile/' . $not_marked_data[$key]['user_id'] . '">' . $not_marked_data[$key]['user_alias'] . '</a>';
          if($not_marked_data[$key]['holiday']==0){
            $array[$j][]="<span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-times-circle'></i> Not Marked</span>";
            $array[$j][]="<span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-times-circle'></i> Absent</span>";
          }else{
            $array[$j][]="<span style='margin-top: 5px' class='m-badge m-badge--focus m-badge--wide'> ".$not_marked_data[$key]['holiday_name']." </span>";
            $array[$j][]='';
          }
          $array[$j][]='';
          $array[$j][]='';
          $array[$j][]='';
          $array[$j][]='';
          // $array[$j][]=$attendance_data['signed_in_landmark'];
          $array[$j][]='';
          $array[$j][]='';
          $array[$j][]='';
          $array[$j][]='';
          $array[$j][]='';
          $array[$j][]='';
          $j++;
        }
      }
    }
    $json_data['draw']=5;
    $json_data['recordsTotal']=sizeof($array);
    $json_data['recordsFiltered']=sizeof($array);
    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }

  public function select_attendance_monthly($param=""){


    $json_data=array();
    $j=0;
    $sl_no=0;
    $array=array();
    $data=array();
    if(isset($_POST['user']) && $_POST['user']!='' && $_POST['user']!='all'){
      $data['e.user_id'] = $_POST['user'];
    }
    if(isset($_POST['salary_type']) && $_POST['salary_type']!='' && $_POST['salary_type']!='all'){
      $data['e.basic_wage_type'] = $_POST['salary_type'];
    }
    if($this->session->userdata('user_role')!='auditor' && $this->session->userdata('user_role')!='admin' && $this->session->userdata('user_role')!='general_manager' && $this->session->userdata('user_role')!='accounts_manager' && $this->session->userdata('user_role_id')!=20) {
      $data['e.user_id'] = $this->session->userdata('user_id');
    }elseif($this->session->userdata('user_role_id')==20) {
      // Select Assigned Users of project manager assigned projects
      $user_id = $this->session->userdata('user_id');
      $this->db->where("FIND_IN_SET($user_id, w.assigned_users)");
      $assigned_users_array = array();
      $assigned_users_string = '';
      $assigned_users = $this->Work->select_work("w.assigned_users")->result();
      foreach ($assigned_users as $key2 => $value2) {
        if($value2->assigned_users!=''){
          $assigned_users_string .= $value2->assigned_users.",";
        }
      }
      if($assigned_users_string!=''){
        $assigned_users_array = explode(',',$assigned_users_string);
        $assigned_users_array = array_unique($assigned_users_array);
        $assigned_users_string = implode(',',$assigned_users_array);
        $assigned_users_string = rtrim($assigned_users_string, ',');
        $this->db->where('e.user_id IN('.$assigned_users_string.')');
      }
    }
    // $data['ur.mobile_app_access'] = 1;
    $data['u.acc_status'] = 1;
    $users	= $this->Employee->select_employee("e.*,ed.department_name,u.*",$data)->result();
    $show_attendance= 0;

    if(isset($_POST['start_date']) && $_POST['start_date']!='' && isset($_POST['end_date']) && $_POST['end_date']!=''){

      $date1 = new DateTime (date('Y-m-d', strtotime($_POST['start_date'])));
      $date2 = new DateTime (date('Y-m-d', strtotime($_POST['end_date'])));
      $interval = $date1 -> diff ($date2);
      $days = $interval -> days+1;

      $sundays_array = $holidays_array = array();
      while ($date1 <= $date2) {
        if ($date1->format('w') == 0) {
          $sundays_array[] = $date1->format('Y-m-d');
        }
        $date1->modify('+1 day');
      }
      // Check Holiday Counts
      $holidays = $this->Settings->select_holidays("",array("holiday_date >="=>date('Y-m-d', strtotime($_POST['start_date'])),"holiday_date <="=>date('Y-m-d', strtotime($_POST['end_date']))))->result();
      foreach ($holidays as $key => $value) {
        $holidays_array[] = $value->holiday_date;
      }

      foreach ($users as $key => $value) {
        $sunday_worked = $holiday_worked = 0;
        $basic_wage = $salary_type = "";
        $basic_wage = $value->basic_wage;
        $salary_type = $value->basic_wage_type;
        if($value->basic_wage_fixed==1){
          $salary_type .= ' (Fixed)';
        }else{
          $salary_type .= ' (Not Fixed)';
        }

        if($value->basic_wage_type=='Monthly'){
          $pay_for_day = round($basic_wage/$days,$this->config->item('Currency_amount_decimals_2'));
        }else{
          $pay_for_day = $value->basic_wage;
        }

        // Check Attendece Exist ot Not
        $attendance_marked_where['uat.user_id'] = $value->user_id;
        $attendance_marked_where['uat.attendance_date >='] = date('Y-m-d', strtotime($_POST['start_date']));
        $attendance_marked_where['uat.attendance_date <='] = date('Y-m-d', strtotime($_POST['end_date']));
        $attendance_marked_where['uat.attendance_status'] = 1;
        $attendance_marked_where['uat.delete_status'] = 0;
        $attendance_marked = $this->Attendance->select_attendance('uat.attendance_id',$attendance_marked_where)->num_rows();

        $holiday_attendance_marked = $sunday_attendance_marked = 0;
        if(sizeof($holidays_array)>0){
          $holidays = "'" . implode ( "', '", $holidays_array ) . "'";
          $this->db->where("uat.attendance_date IN (".$holidays.")");
          $holiday_attendance_marked = $this->Attendance->select_attendance('uat.attendance_id',$attendance_marked_where)->num_rows();
        }
        if(sizeof($sundays_array)>0){
          $sundays = "'" . implode ( "', '", $sundays_array ) . "'";
          $this->db->where("uat.attendance_date IN (".$sundays.")");
          $sunday_attendance_marked = $this->Attendance->select_attendance('uat.attendance_id',$attendance_marked_where)->num_rows();
        }

        $leave_marked_where = $attendance_marked_where;
        $leave_marked_where['uat.attendance_status'] = 2;
        $leave_marked = $this->Attendance->select_attendance('uat.attendance_id',$leave_marked_where)->num_rows();

        $no_of_days_eligible_for_salary = $attendance_marked+sizeof($sundays_array)-$sunday_attendance_marked;

        $sl_no++;
        $array[$j][]=$sl_no;
        $array[$j][]=$value->user_alias;
        $array[$j][]=$value->user_designation;
        $array[$j][]=$basic_wage;
        $array[$j][]=$salary_type;
        $array[$j][]=$days;
        $array[$j][]=sizeof($sundays_array);
        $array[$j][]=sizeof($holidays_array);
        $array[$j][]=$pay_for_day;
        $array[$j][]=$leave_marked;
        $array[$j][]=$sunday_attendance_marked;
        $array[$j][]=$holiday_attendance_marked;
        $array[$j][]='';
        $array[$j][]=$attendance_marked;
        $array[$j][]=$no_of_days_eligible_for_salary;
        $array[$j][]=round($no_of_days_eligible_for_salary*$pay_for_day);
        $array[$j][]=$days-$attendance_marked-$leave_marked-(sizeof($sundays_array)-$sunday_attendance_marked);

        $j++;
      }
    }

    $json_data['draw']=5;
    $json_data['recordsTotal']=sizeof($array);
    $json_data['recordsFiltered']=sizeof($array);
    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }
  public function select_attendance_projectwise($param=""){

    $json_data=array();
    $j=0;
    $sl_no=0;
    $array=array();
    $data=array();
    if(isset($_POST['user']) && $_POST['user']!='' && $_POST['user']!='all'){
      $data['uat.user_id'] = $_POST['user'];
    }
    if(isset($_POST['project']) && $_POST['project']!='' && $_POST['project']!='all'){
      $data['project_id'] = $_POST['project'];
    }
    if(isset($_POST['date']) && $_POST['date']!=''){
      $date=array();
      $date=explode('-',$_POST['date']);
      $start_date=date('Y-m-d', strtotime($date[0]));
      $end_date=date('Y-m-d', strtotime($date[1]));
      $data["STR_TO_DATE(uat.attendance_date,'%Y-%m-%d') <="]= $end_date;
      $data["STR_TO_DATE(uat.attendance_date,'%Y-%m-%d') >="]= $start_date;
    }
    if($this->session->userdata('user_role')!='admin' && $this->session->userdata('user_role')!='general_manager') {
      $data['uat.user_id'] = $this->session->userdata('user_id');
    }
    $data['u.acc_status'] = 1;
    $result	= $this->Attendance->select_attendance_projectwise('uat.*,work_name,u.user_alias,ua1.activity_location_address as signed_in_location,ua1.activity_location_landmark as signed_in_landmark,ua1.activity_location_latitude as signed_in_latitude,ua1.activity_location_longitude as signed_in_longitude,
    ua2.activity_location_address as signed_off_location,ua2.activity_location_latitude as signed_off_latitude,ua2.activity_location_longitude as signed_off_longitude,',$data);
    $result = $result->result();
    foreach ($result as $key => $value) {

      $signed_in_from = ($value->signed_in_location!='') ? $value->signed_in_location:"Device Location Not Accessible";
      $signed_in_landmark = $value->signed_in_landmark;
      $signed_in_latitude = $value->signed_in_latitude;
      $signed_in_longitude = $value->signed_in_longitude;
      if($signed_in_latitude!='' && $signed_in_longitude!=''){
        $signed_in_from .= '<br/><a target="_blank" style="margin-left: 5px;margin-right: 5px"  href="https://www.google.com/maps/search/?api=1&map_action=map&query='.$signed_in_latitude.','.$signed_in_longitude.'&zoom=16" class="btn btn-info m-btn m-btn--icon  btn-sm m-btn--pill m-btn--air"><i class="fa fa-map-marker"></i> View on Map</a>';
      }
      $signed_in_from .='<br/>(Landmark :'.$value->signed_in_landmark.')';
      if($value->signed_off_time!='00:00:00'){
        $signed_off_time = $value->signed_off_time;
        $signed_off_from = ($value->signed_off_location!='') ? $value->signed_off_location:"Device Location Not Accessible";
        $signed_off_latitude = $value->signed_off_latitude;
        $signed_off_longitude = $value->signed_off_longitude;
        if($signed_off_latitude!='' && $signed_off_longitude!=''){
          $signed_off_from .= '<br/><a target="_blank" style="margin-left: 5px;margin-right: 5px"  href="https://www.google.com/maps/search/?api=1&map_action=map&query='.$signed_off_latitude.','.$signed_off_longitude.'&zoom=16" class="btn btn-info m-btn m-btn--icon btn-sm m-btn--pill m-btn--air"><i class="fa fa-map-marker"></i> View on Map</a>';
        }
      }

      $sl_no++;
      $array[$j][]=$sl_no;
      $array[$j][]=$value->attendance_id;
      $array[$j][]=date('d-m-Y',strtotime($value->attendance_date));
      $array[$j][]=date('l',strtotime($value->attendance_date));
      $array[$j][]='<a href="' . base_url() . 'user/profile/' . $value->user_id . '">' . $value->user_alias . '</a>';
      $array[$j][]=$value->work_name;
      if($value->signed_in_time!='00:00:00'){
        $array[$j][]=date("h:i A",strtotime($value->signed_in_time));
      }else{
        $array[$j][]="";
      }
      if($value->signed_off_time!='00:00:00'){
        $array[$j][]=date("h:i A",strtotime($value->signed_off_time));
      }else{
        $array[$j][]="";
      }

      $array[$j][]=$signed_in_from;
      $array[$j][]=$signed_off_from;

      $j++;
    }

    $json_data['draw']=5;
    $json_data['recordsTotal']=sizeof($array);
    $json_data['recordsFiltered']=sizeof($array);
    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }

  public function create()
  {
    $data['user_id'] = $this->security->xss_clean($this->input->post('user'));
    if($this->input->post('date')){
      $data['attendance_date'] = date("Y-m-d",strtotime($this->security->xss_clean($this->input->post('date'))));
    }else{
      $data['attendance_date'] = date("Y-m-d");
    }
    $data['attendance_status'] = 1;
    $attendance_type = $this->security->xss_clean($this->input->post('attendance_type'));
    if($attendance_type=='sign_in'){
      if($this->input->post('sign_in_time')){
        $data['signed_in_time'] = date("H:i:s",strtotime($this->security->xss_clean($this->input->post('sign_in_time'))));
      }else{
        $data['signed_in_time'] = date("H:i:s");
      }
      $data['created_date'] = date('Y-m-d H:i:s');
      $data['created_by'] = $this->session->userdata('user_id');
      //          Check Already Exist
      $where['uat.user_id'] = $data['user_id'];
      $where['uat.attendance_date'] = $data['attendance_date'];
      $where['uat.delete_status'] = 0;
      $count = $this->Attendance->select_attendance('attendance_id',$where);
      if($count->num_rows()==0){
        $result = $this->Attendance->insert_attendance($data);
        $flash_data['status'] = $result['status'];
        if ($result['status'] == 1) {
          $actvity_data['user_id'] = $data['user_id'];
          $actvity_data['activity_type'] = 'Attendance';
          $actvity_data['activity_through'] = 'Web App';
          $actvity_data['activity_date'] = date('Y-m-d H:i:s');
          $actvity_data['activity_description'] = 'Signed In';
          $actvity_data['activity_location_address'] = '';
          $actvity_data['activity_location_landmark'] = $this->security->xss_clean($this->input->post('landmark'));
          $actvity_data['activity_location_latitude'] = "";
          $actvity_data['activity_location_longitude'] =  "";
          $actvity_data['reference_id'] = $result['insert_id'];
          $result2 = $this->User->insert_activity($actvity_data);

          $update_data['sign_in_activity_id'] = $result2['insert_id'];
          $update_data['attendance_id'] = $result['insert_id'];
          $this->Attendance->update_attendance($update_data);

          $flash_data['flashdata_msg'] = 'Attendance (Sign In) Added Successfully!';
          $flash_data['flashdata_type'] = 'success';
          $flash_data['alert_type'] = 'success';
          $flash_data['flashdata_title'] = 'Success !!';

        }else{
          $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
          $flash_data['flashdata_type'] = 'error';
          $flash_data['alert_type'] = 'danger';
          $flash_data['flashdata_title'] = 'Error !!';
        }
      }else{
        $flash_data['status'] = 0;
        $flash_data['flashdata_msg'] = 'Sorry.. Attendance of Selected User on Today Already Exits!';
        $flash_data['flashdata_type'] = 'warning';
        $flash_data['alert_type'] = 'warning';
        $flash_data['flashdata_title'] = 'Already Exist !!';
      }
    }elseif($attendance_type=='sign_off'){
      if($this->input->post('sign_off_time')){
        $data2['signed_off_time'] = date("H:i:s",strtotime($this->security->xss_clean($this->input->post('sign_off_time'))));
      }else{
        $data2['signed_off_time'] = date("H:i:s");
      }
      //          Check Already Exist
      $where['uat.user_id'] = $data['user_id'];
      $where['uat.attendance_date'] = $data['attendance_date'];
      $where['uat.delete_status'] = 0;
      $attendance = $this->Attendance->select_attendance('attendance_id',$where);
      if($attendance->num_rows()==1){
        $data2['attendance_id'] = $attendance->row()->attendance_id;
        $result = $this->Attendance->update_attendance($data2);
        $flash_data['status'] = $result;
        if ($result == 1) {
          $actvity_data['reference_id'] = $data2['attendance_id'];
          $actvity_data['user_id'] = $data['user_id'];
          $actvity_data['activity_type'] = 'Attendance';
          $actvity_data['activity_through'] = 'Web App';
          $actvity_data['activity_date'] = date('Y-m-d H:i:s');
          $actvity_data['activity_description'] = 'Signed Off';
          $actvity_data['activity_location_address'] = '';
          $actvity_data['activity_location_landmark'] = '';
          $actvity_data['activity_location_latitude'] = "";
          $actvity_data['activity_location_longitude'] =  "";
          $result2 = $this->User->insert_activity($actvity_data);

          $update_data['sign_off_activity_id'] = $result2['insert_id'];
          $update_data['attendance_id'] = $data2['attendance_id'];
          $this->Attendance->update_attendance($update_data);

          $flash_data['flashdata_msg'] = 'Attendance (Sign Off) Updated Successfully!';
          $flash_data['flashdata_type'] = 'success';
          $flash_data['alert_type'] = 'success';
          $flash_data['flashdata_title'] = 'Success !!';
        }else{
          $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
          $flash_data['flashdata_type'] = 'error';
          $flash_data['alert_type'] = 'danger';
          $flash_data['flashdata_title'] = 'Error !!';
        }
      }else{
        $flash_data['status'] = 0;
        $flash_data['flashdata_msg'] = 'Sorry.. User Not Signed In. Please Sign In First';
        $flash_data['flashdata_type'] = 'warning';
        $flash_data['alert_type'] = 'warning';
        $flash_data['flashdata_title'] = 'Already Exist !!';
      }
    }elseif($attendance_type=='leave'){
      $data['leave_type'] = $this->security->xss_clean($this->input->post('leave_type'));
      $data['attendance_status'] = 2;
      $data['created_date'] = date('Y-m-d H:i:s');
      $data['created_by'] = $this->session->userdata('user_id');
      //          Check Already Exist
      $where['uat.user_id'] = $data['user_id'];
      $where['uat.attendance_date'] = $data['attendance_date'];
      $where['uat.delete_status'] = 0;
      $count = $this->Attendance->select_attendance('attendance_id',$where);
      if($count->num_rows()==0){
        $result = $this->Attendance->insert_attendance($data);
        $flash_data['status'] = $result['status'];
        if ($result['status'] == 1) {
          $actvity_data['user_id'] = $data['user_id'];
          $actvity_data['activity_type'] = 'Attendance';
          $actvity_data['activity_through'] = 'Web App';
          $actvity_data['activity_date'] = date('Y-m-d H:i:s');
          $actvity_data['activity_description'] = 'Marked as Leave';
          $actvity_data['activity_location_address'] = '';
          $actvity_data['activity_location_landmark'] = '';
          $actvity_data['activity_location_latitude'] = "";
          $actvity_data['activity_location_longitude'] =  "";
          $actvity_data['reference_id'] = $result['insert_id'];
          $result2 = $this->User->insert_activity($actvity_data);

          $update_data['sign_in_activity_id'] = $result2['insert_id'];
          $update_data['attendance_id'] = $result['insert_id'];
          $this->Attendance->update_attendance($update_data);

          $flash_data['flashdata_msg'] = 'Attendance (Leave Marked) Added Successfully!';
          $flash_data['flashdata_type'] = 'success';
          $flash_data['alert_type'] = 'success';
          $flash_data['flashdata_title'] = 'Success !!';

        }else{
          $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
          $flash_data['flashdata_type'] = 'error';
          $flash_data['alert_type'] = 'danger';
          $flash_data['flashdata_title'] = 'Error !!';
        }
      }else{
        $flash_data['status'] = 0;
        $flash_data['flashdata_msg'] = 'Sorry.. Attendance of Selected User on Today Already Exits!';
        $flash_data['flashdata_type'] = 'warning';
        $flash_data['alert_type'] = 'warning';
        $flash_data['flashdata_title'] = 'Already Exist !!';
      }
    }
    echo(json_encode($flash_data));

  }
  public function update()
  {
    $data['attendance_id'] = $this->security->xss_clean($this->input->post('attendance_id'));
    if($this->input->post('sign_in_time')!=''){
      $data['signed_in_time'] = date("H:i:s",strtotime($this->security->xss_clean($this->input->post('sign_in_time'))));
    }
    if($this->input->post('sign_off_time')!=''){
      $data['signed_off_time'] = date("H:i:s",strtotime($this->security->xss_clean($this->input->post('sign_off_time'))));
    }
    if($this->input->post('leave_type')!=''){
      $data['leave_type'] = $this->security->xss_clean($this->input->post('leave_type'));
    }
    $result =  $this->Attendance->update_attendance($data);
    $flash_data['status'] = $result;
    if ($result == 1 ) {
      $flash_data['flashdata_msg'] = 'Attendance Details Updated Successfully!';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !!';
    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo(json_encode($flash_data));
  }
  public function delete()
  {
    $data['attendance_id'] = $this->security->xss_clean($this->input->post('attendance_id'));
    $attendance_type = $this->security->xss_clean($this->input->post('attendance_type_delete'));
    if($attendance_type=='1' || $attendance_type=='3'){
      $data['delete_status'] = 1;
    }else{
      $data['signed_off_time'] = "00:00:00";
      $data['sign_off_activity_id'] = "0";
    }
    $result =  $this->Attendance->update_attendance($data);
    $flash_data['status'] = $result;
    if ($result == 1 ) {
      $flash_data['flashdata_msg'] = 'Attendance Deleted Successfully!';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !!';
    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo(json_encode($flash_data));
  }

  public function send_notifications($param="",$param2='',$user_id='',$message=''){
    $date = date('Y-m-d');
    // check date=sunday or exist in Holidays
    $holiday = $this->Settings->select_holidays('',array("holiday_date"=>$date));
    if($holiday->num_rows()==0 && date('l')!='Sunday'){
      $data['ur.mobile_app_access'] = 1;
      $data['acc_status'] = 1;
      if($param=='sign_in'){
        if($param2=='1'){
          $data['duty_start_time'] = "08:30:00";
        }elseif($param2=='2'){
          $data['duty_start_time'] = "09:00:00";
        }elseif($param2=='3'){
          $data['duty_start_time'] = "09:30:00";
        }else{
          $data['duty_start_time'] = "00:00:00";
        }
        $message="This is to Remind Your Duty Sign in Within Half an Hour.";
        $message_title='Duty Sign In';
      }elseif($param=='sign_off'){
        $data['duty_end_time'] = "17:00:00";
        $message="This is to Remind Your Duty Sign Off Now.";
        $message_title='Duty Sign Off';
      }else{
        $message_title = $message;
      }
      if($user_id!=''){
        $data['user_id'] = $user_id;
      }
      $users	= $this->User->select_user("",$data)->result();
      foreach($users as $row){
        $this->push_notification->send_notification($row->user_id,$message,$message_title,'');
      }
    }

  }
}
?>
