#
# TABLE STRUCTURE FOR: account_heads
#

DROP TABLE IF EXISTS `account_heads`;

CREATE TABLE `account_heads` (
  `acc_head_id` int(11) NOT NULL AUTO_INCREMENT,
  `acc_head_branch_id` int(11) NOT NULL,
  `acc_head_name` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `account_type` int(11) NOT NULL,
  `op_balance` double NOT NULL,
  `op_balance_date` date NOT NULL,
  `acc_user_id` int(11) NOT NULL,
  `acc_employee_id` int(11) NOT NULL,
  `acc_supplier_id` int(11) NOT NULL,
  `head_editable` int(11) NOT NULL,
  `delete_status` int(11) NOT NULL,
  `created_date` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_date` datetime NOT NULL,
  `updated_by` int(11) NOT NULL,
  PRIMARY KEY (`acc_head_id`),
  KEY `acc_head_id` (`acc_head_id`,`acc_user_id`,`acc_employee_id`,`acc_supplier_id`,`created_by`,`updated_by`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=218 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (1, 0, 'Cash Account', 32, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (2, 0, 'Client Payment Receipts', 2, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (3, 0, 'Investments', 37, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (4, 0, 'Purchase Bill Commissions', 2, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (5, 0, 'Purchase Bill Payments', 12, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (6, 0, 'Purchase Order Payments', 12, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (7, 0, 'Labour Wage Payments', 12, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (8, 0, 'SubContract Payments', 12, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (9, 0, 'User Payments', 12, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '2019-02-19 08:08:02', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (10, 0, 'Salary Payments', 12, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '2019-02-19 08:08:02', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (11, 0, 'Sales Invoice Receipts', 2, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '2019-02-19 08:08:02', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (12, 0, 'Vehicle Payments', 12, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '2019-02-19 08:08:02', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (13, 0, 'Loan Payments', 12, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '2019-02-19 08:08:02', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (14, 0, 'Other Income Receipts', 2, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '2019-02-19 08:08:02', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (49, 0, 'Administrator\'s Account', 32, '0', '2020-04-12', 1, 1, 0, 0, 0, '2020-04-12 12:00:00', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (15, 0, 'Loan Receipt', 38, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '2019-02-19 08:08:02', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (16, 0, 'Employee Payments', 12, '0', '2019-02-19', 0, 0, 0, 0, 0, '2019-02-19 08:08:02', 1, '2019-02-19 08:08:02', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (17, 0, 'Tool Purchase Payments', 12, '0', '2019-02-19', 0, 0, 0, 0, 0, '2019-02-19 08:08:02', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (18, 0, 'Tool Payments', 12, '0', '2019-02-19', 0, 0, 0, 0, 0, '2019-02-19 08:08:02', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (19, 0, 'Material Loading/Unloading Charges', 11, '0', '2019-02-19', 0, 0, 0, 0, 0, '2019-02-19 08:08:02', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (20, 0, 'Material Transportation Charges', 11, '0', '2019-02-19', 0, 0, 0, 0, 0, '2019-02-19 08:08:02', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (21, 0, 'User Project Commission Payment', 12, '0', '2020-09-16', 0, 0, 0, 0, 0, '2020-09-16 12:00:00', 1, '2020-09-16 12:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (22, 0, 'User TA Payments', 12, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '2019-02-19 08:08:02', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (23, 0, 'Local Material Purchase', 11, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (24, 0, 'Labour Insurance FD Payments', 12, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (25, 0, 'Project Management Fees', 11, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (26, 0, 'Project Supervision Charge', 11, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (27, 0, 'Purchase Return Refund', 2, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (28, 0, 'Office Income/Expense Type', 2, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (29, 0, 'Marketing Expense Type', 2, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (30, 0, 'Project Expense Type', 2, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (31, 0, 'Payment Modes Head', 2, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (32, 0, 'Project Overhead - Office Income', 11, '0', '2020-04-12', 0, 0, 0, 0, 0, '2020-04-12 12:00:00', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (175, 0, 'DOCUMENTATION CHARGE', 11, '0', '1970-01-01', 0, 0, 0, 1, 0, '2024-02-09 10:39:07', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (176, 0, 'JCB WORK', 11, '0', '1970-01-01', 0, 0, 0, 1, 0, '2024-02-09 10:41:02', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (177, 0, 'GENERAL LABOUR', 11, '0', '1970-01-01', 0, 0, 0, 1, 0, '2024-02-09 10:43:03', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (178, 0, '108 PURCHASE\'s Account', 12, '0', '0000-00-00', 0, 0, 1, 0, 0, '2024-02-09 11:35:39', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (179, 0, 'FUEL EXPENSE', 11, '0', '1970-01-01', 0, 0, 0, 1, 0, '2024-02-13 10:33:08', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (180, 0, 'SITE VISITING FUEL N FOOD', 11, '0', '1970-01-01', 0, 0, 0, 1, 0, '2024-02-13 10:33:14', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (181, 0, 'ROOM RENT', 11, '0', '1970-01-01', 0, 0, 0, 1, 0, '2024-02-13 10:36:45', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (182, 0, 'TOOLS RENT', 11, '0', '1970-01-01', 0, 0, 0, 1, 0, '2024-02-13 10:48:15', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (183, 0, 'TRANSPORTATION', 11, '0', '1970-01-01', 0, 0, 0, 1, 0, '2024-02-13 11:11:54', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (184, 0, 'LOADING/UNLOADING CHARGE', 11, '0', '1970-01-01', 0, 0, 0, 1, 0, '2024-02-13 11:13:14', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (185, 0, '104 PURCHASE\'s Account', 12, '0', '0000-00-00', 0, 0, 2, 0, 0, '2024-02-13 11:16:19', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (186, 0, '106 DHARMASHALA, KANNUR\'s Account', 12, '0', '0000-00-00', 0, 0, 3, 0, 0, '2024-02-13 12:07:49', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (187, 0, '109 PURCHASE\'s Account', 12, '0', '0000-00-00', 0, 0, 4, 0, 0, '2024-02-13 12:13:29', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (188, 0, '107 ALUVA\'s Account', 12, '0', '0000-00-00', 0, 0, 5, 0, 0, '2024-02-13 14:31:35', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (189, 0, 'SHAMSUDHEEN \'s Account', 32, '700000', '0000-00-00', 52, 2, 0, 0, 1, '2024-02-14 11:41:48', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (190, 0, 'SHABU V R (APPU)\'s Account', 32, '0', '0000-00-00', 53, 3, 0, 0, 0, '2024-02-14 12:11:44', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (191, 0, 'ZAINBUILDERS PVT LTD\'s Account', 32, '700000', '0000-00-00', 54, 4, 0, 0, 0, '2024-02-19 14:30:32', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (192, 0, 'OFFICE STATIONERY', 11, '0', '1970-01-01', 0, 0, 0, 1, 0, '2024-02-20 10:11:26', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (193, 0, 'ZAIN BUILDERERS PVT LTD\'s Account', 32, '700000', '0000-00-00', 55, 5, 0, 0, 1, '2024-02-22 16:38:00', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (194, 0, 'SHAMSUDHEEN CK \'s Account', 32, '0', '0000-00-00', 56, 6, 0, 0, 0, '2024-02-22 16:41:21', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (195, 0, 'ASSET', 11, '0', '1970-01-01', 0, 0, 0, 1, 0, '2024-02-29 11:21:43', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (196, 0, 'PURCHASE', 11, '0', '1970-01-01', 0, 0, 0, 1, 0, '2024-03-02 16:16:29', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (197, 0, 'VILAYOOR FARM\'s Account', 12, '0', '0000-00-00', 0, 0, 6, 0, 0, '2024-03-05 11:37:38', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (198, 0, '112 PURCHASE \'s Account', 12, '0', '0000-00-00', 0, 0, 7, 0, 0, '2024-03-05 11:42:25', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (199, 0, 'VEHICLE MAINTENANCE', 11, '0', '1970-01-01', 0, 0, 0, 1, 0, '2024-03-05 15:49:52', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (200, 0, '111 PURCHASE\'s Account', 12, '0', '0000-00-00', 0, 0, 8, 0, 0, '2024-03-07 15:52:23', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (201, 0, 'GENERAL EXPENSE', 11, '0', '1970-01-01', 0, 0, 0, 1, 0, '2024-03-13 15:20:36', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (202, 0, 'FOOD EXPENSE', 11, '0', '1970-01-01', 0, 0, 0, 1, 0, '2024-03-14 15:29:28', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (203, 0, '116 PURCHASE\'s Account', 12, '0', '0000-00-00', 0, 0, 9, 0, 0, '2024-03-15 10:01:45', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (204, 0, 'YASAR BANGALORE STONE\'s Account', 12, '0', '0000-00-00', 0, 0, 10, 0, 0, '2024-03-15 11:15:31', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (205, 0, '114 PURCHASE\'s Account', 12, '0', '0000-00-00', 0, 0, 11, 0, 0, '2024-03-19 10:14:33', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (206, 0, 'SUPERVISING', 11, '0', '1970-01-01', 0, 0, 0, 1, 0, '2024-03-25 14:34:25', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (207, 0, 'MUBARAK\'s Account', 32, '0', '0000-00-00', 0, 7, 0, 0, 0, '2024-04-06 16:06:19', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (208, 0, '117 PURCHASE\'s Account', 12, '0', '0000-00-00', 0, 0, 12, 0, 0, '2024-04-16 16:54:37', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (209, 0, '121 PURCHASE\'s Account', 12, '0', '0000-00-00', 0, 0, 13, 0, 0, '2024-04-27 14:08:34', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (210, 0, 'AJAY\'s Account', 32, '0', '0000-00-00', 0, 8, 0, 0, 0, '2024-04-30 14:39:03', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (211, 0, '113 PURCHASE\'s Account', 12, '0', '0000-00-00', 0, 0, 14, 0, 0, '2024-05-03 10:53:55', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (212, 0, '105 PURCHASE\'s Account', 12, '0', '0000-00-00', 0, 0, 15, 0, 0, '2024-05-09 16:51:31', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (213, 0, 'VISHNU\'s Account', 32, '0', '0000-00-00', 0, 9, 0, 0, 0, '2024-05-10 16:23:16', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (214, 0, '124 PURCHASE\'s Account', 12, '0', '0000-00-00', 0, 0, 16, 0, 0, '2024-05-11 15:01:50', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (215, 0, 'RENT', 11, '0', '1970-01-01', 0, 0, 0, 1, 0, '2024-05-14 12:03:26', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (216, 0, '126 PURCHASE\'s Account', 12, '0', '0000-00-00', 0, 0, 17, 0, 0, '2024-06-20 16:35:29', 1, '0000-00-00 00:00:00', 0);
INSERT INTO `account_heads` (`acc_head_id`, `acc_head_branch_id`, `acc_head_name`, `account_type`, `op_balance`, `op_balance_date`, `acc_user_id`, `acc_employee_id`, `acc_supplier_id`, `head_editable`, `delete_status`, `created_date`, `created_by`, `updated_date`, `updated_by`) VALUES (217, 0, 'INSENTIVE', 11, '0', '1970-01-01', 0, 0, 0, 1, 0, '2024-06-26 15:21:18', 1, '0000-00-00 00:00:00', 0);


#
# TABLE STRUCTURE FOR: account_transactions
#

DROP TABLE IF EXISTS `account_transactions`;

CREATE TABLE `account_transactions` (
  `transaction_id` int(11) NOT NULL AUTO_INCREMENT,
  `tr_branch_id` int(11) NOT NULL,
  `tr_type` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `reference_id` int(11) NOT NULL,
  `reference_type` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `invoice_id` int(11) NOT NULL,
  `tr_date` date NOT NULL,
  `tr_debit_acc` int(11) NOT NULL,
  `tr_credit_acc` int(11) NOT NULL,
  `tr_description` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `tr_amount` double NOT NULL,
  `tr_payment_part` int(11) NOT NULL,
  `tr_mode` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `tr_reference_no` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `tr_reference_date` date NOT NULL,
  `tr_remarks` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `tr_work_id` int(11) NOT NULL,
  `tr_project_stage_id` int(11) NOT NULL,
  `tr_other_data` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `tr_copy_from` int(11) NOT NULL,
  `tr_group_id` int(11) NOT NULL,
  `tax_inclusive` int(11) NOT NULL,
  `taxable_amount` double NOT NULL,
  `tax_percent` double NOT NULL,
  `tax_amount` double NOT NULL,
  `tr_file_attachment` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `temporary_transaction` int(11) NOT NULL,
  `created_date` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_date` datetime NOT NULL,
  `updated_by` int(11) NOT NULL,
  `tr_entry_approval_status` int(11) NOT NULL DEFAULT '1',
  `tr_entry_approval_status_2` int(11) NOT NULL DEFAULT '1',
  `delete_status` int(11) NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `transaction_id` (`transaction_id`,`tr_type`,`reference_id`,`reference_type`,`invoice_id`,`tr_debit_acc`,`tr_credit_acc`,`tr_work_id`,`created_by`,`updated_by`)
) ENGINE=MyISAM AUTO_INCREMENT=1493 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1, 0, 'client_payment_transaction', 1, 'project', 0, '2024-02-07', 2, 1, 'Client Payment Transaction', '160000', 0, '', '', '0000-00-00', '', 0, 1, '', 0, 0, 0, '160000', '0', '0', '', 0, '2024-02-07 12:02:20', 1, '2024-02-19 14:33:29', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (2, 0, 'client_payment_transaction', 2, 'project', 0, '2024-02-08', 2, 1, 'Client Payment Transaction', '25001', 0, '', '', '0000-00-00', '', 0, 2, '', 0, 0, 0, '25001', '0', '0', '', 0, '2024-02-07 12:08:43', 1, '2024-02-20 11:50:22', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (3, 0, 'client_payment_transaction', 3, 'project', 0, '2024-02-09', 2, 1, 'Client Payment Transaction', '20000', 0, '', '', '0000-00-00', '', 0, 3, '', 0, 0, 0, '20000', '0', '0', '', 0, '2024-02-07 12:10:35', 1, '2024-02-20 11:50:41', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (4, 0, 'client_payment_transaction', 4, 'project', 0, '2024-02-10', 2, 1, 'Client Payment Transaction', '10000', 0, '', '', '0000-00-00', '', 0, 4, '', 0, 0, 0, '10000', '0', '0', '', 0, '2024-02-07 12:12:21', 1, '2024-02-20 11:50:57', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (5, 0, 'client_payment_transaction', 5, 'project', 0, '2024-02-12', 2, 1, 'Client Payment Transaction', '10000', 0, '', '', '0000-00-00', '', 0, 5, '', 0, 0, 0, '10000', '0', '0', '', 0, '2024-02-07 12:22:01', 1, '2024-02-20 11:51:19', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (6, 0, 'client_payment_transaction', 6, 'project', 0, '2024-02-13', 2, 1, 'Client Payment Transaction', '110000', 0, '', '', '0000-00-00', '', 0, 6, '', 0, 0, 0, '110000', '0', '0', '', 0, '2024-02-07 12:25:44', 1, '2024-02-20 11:51:34', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (7, 0, 'client_payment_transaction', 4, 'project', 0, '2024-02-17', 2, 1, 'Client Payment Transaction', '708330', 0, '', '', '0000-00-00', '', 0, 4, '', 0, 0, 0, '708330', '0', '0', '', 0, '2024-02-19 14:16:10', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (8, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-02-17', 1, 190, 'User Payment Receipt Transaction', '708330', 0, 'CASH', '', '0000-00-00', '107', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-19 14:17:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (9, 0, 'user_payment_receipt_transaction', 189, 'user_account_head', 0, '2024-02-19', 1, 189, 'User Payment Receipt Transaction', '400000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-19 14:22:48', 1, '2024-02-19 15:01:34', 1, 1, 1, 1);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (10, 0, 'user_payment_return_transaction', 190, 'user_account_head', 0, '2024-02-19', 190, 1, 'User Payment Return Transaction', '400000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-19 14:23:46', 1, '2024-02-19 15:01:19', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (11, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-02-10', 1, 190, 'User Payment Receipt Transaction', '300000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-19 14:31:03', 1, '2024-02-20 12:12:52', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (12, 0, 'user_payment_return_transaction', 191, 'user_account_head', 0, '2024-02-10', 191, 1, 'User Payment Return Transaction', '300000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-19 14:31:25', 1, '2024-02-20 12:19:53', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (13, 0, 'client_payment_transaction', 1, 'project', 0, '2024-02-15', 2, 1, 'Client Payment Transaction', '100000', 0, '', '', '0000-00-00', '', 0, 1, '', 0, 0, 0, '100000', '0', '0', '', 0, '2024-02-19 14:57:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (14, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-02-07', 1, 190, 'User Payment Receipt Transaction', '160000', 0, 'CASH', '', '0000-00-00', '104', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-19 14:58:31', 1, '2024-02-19 14:59:51', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (15, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-02-15', 1, 190, 'User Payment Receipt Transaction', '100000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-19 14:58:54', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (16, 0, 'user_payment_receipt_transaction', 189, 'user_account_head', 0, '2024-02-15', 1, 189, 'User Payment Receipt Transaction', '90000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-19 14:59:26', 1, '0000-00-00 00:00:00', 0, 1, 1, 1);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (17, 0, 'user_payment_return_transaction', 190, 'user_account_head', 0, '2024-02-15', 190, 1, 'User Payment Return Transaction', '90000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-19 14:59:42', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (18, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-02-08', 1, 190, 'User Payment Receipt Transaction', '25001', 0, 'CASH', '', '0000-00-00', '105', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 11:52:03', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (19, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-02-09', 1, 190, 'User Payment Receipt Transaction', '20000', 0, 'CASH', '', '0000-00-00', '106', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 11:52:28', 1, '2024-02-20 11:52:38', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (20, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-02-10', 1, 190, 'User Payment Receipt Transaction', '10000', 0, 'CASH', '', '0000-00-00', '107', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 11:54:07', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (21, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-02-13', 1, 190, 'User Payment Receipt Transaction', '110000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 11:54:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (22, 0, 'client_payment_transaction', 6, 'project', 0, '2024-02-14', 2, 1, 'Client Payment Transaction', '100000', 0, '', '', '0000-00-00', '', 0, 6, '', 0, 0, 0, '100000', '0', '0', '', 0, '2024-02-20 11:55:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (23, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-02-14', 1, 190, 'User Payment Receipt Transaction', '100000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 11:55:47', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (24, 0, 'user_payment_receipt_transaction', 189, 'user_account_head', 0, '2024-02-14', 1, 189, 'User Payment Receipt Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 11:56:02', 1, '0000-00-00 00:00:00', 0, 1, 1, 1);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (25, 0, 'user_payment_return_transaction', 190, 'user_account_head', 0, '2024-02-14', 190, 1, 'User Payment Return Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 11:56:27', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (26, 0, 'purchase_bill_transaction', 15, 'purchase_bill', 0, '2024-02-17', 194, 5, 'Purchase Bill Transaction', '42000', 1, 'CASH', '', '0000-00-00', '', 0, 6, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 12:00:36', 1, '2024-02-22 16:43:34', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (27, 0, 'purchase_bill_transaction', 16, 'purchase_bill', 0, '2024-02-17', 194, 5, 'Purchase Bill Transaction', '42000', 1, 'CASH', '', '0000-00-00', '', 0, 5, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 12:01:49', 1, '2024-02-22 16:43:01', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (28, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-02-03', 1, 190, 'User Payment Receipt Transaction', '200000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 12:19:16', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (29, 0, 'user_payment_return_transaction', 191, 'user_account_head', 0, '2024-02-03', 191, 1, 'User Payment Return Transaction', '200000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 12:20:11', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (30, 0, 'user_payment_return_transaction', 191, 'user_account_head', 0, '2024-01-27', 191, 1, 'User Payment Return Transaction', '200000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 12:20:44', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (31, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-01-27', 1, 190, 'User Payment Receipt Transaction', '200000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 12:21:02', 1, '2024-02-20 12:21:17', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (32, 0, 'expense_bill_transaction', 87, 'expense_bill', 0, '2024-01-12', 190, 177, 'Expense Bill Transaction', '7200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:21:47', 1, '2024-02-20 15:22:51', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (33, 0, 'expense_bill_transaction', 89, 'expense_bill', 0, '2024-01-12', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:22:08', 1, '2024-02-20 15:23:03', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (34, 0, 'expense_bill_transaction', 92, 'expense_bill', 0, '2024-01-13', 190, 177, 'Expense Bill Transaction', '7200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:22:37', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (35, 0, 'expense_bill_transaction', 93, 'expense_bill', 0, '2024-01-13', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:23:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (36, 0, 'expense_bill_transaction', 94, 'expense_bill', 0, '2024-01-14', 190, 177, 'Expense Bill Transaction', '7200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:23:52', 1, '2024-02-20 15:40:20', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (37, 0, 'expense_bill_transaction', 96, 'expense_bill', 0, '2024-01-14', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:24:09', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (38, 0, 'expense_bill_transaction', 98, 'expense_bill', 0, '2024-01-15', 190, 177, 'Expense Bill Transaction', '7200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:24:33', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (39, 0, 'expense_bill_transaction', 99, 'expense_bill', 0, '2024-01-15', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:24:55', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (40, 0, 'expense_bill_transaction', 100, 'expense_bill', 0, '2024-01-19', 190, 177, 'Expense Bill Transaction', '2400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:25:16', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (41, 0, 'expense_bill_transaction', 101, 'expense_bill', 0, '2024-01-19', 190, 179, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:25:33', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (42, 0, 'expense_bill_transaction', 102, 'expense_bill', 0, '2024-01-20', 190, 177, 'Expense Bill Transaction', '2400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:25:54', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (43, 0, 'expense_bill_transaction', 103, 'expense_bill', 0, '2024-01-20', 190, 179, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:26:09', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (44, 0, 'expense_bill_transaction', 7, 'expense_bill', 0, '2024-01-21', 190, 176, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:27:10', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (45, 0, 'expense_bill_transaction', 8, 'expense_bill', 0, '2024-01-22', 190, 176, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:27:47', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (46, 0, 'expense_bill_transaction', 10, 'expense_bill', 0, '2024-01-22', 190, 175, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:28:08', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (47, 0, 'expense_bill_transaction', 12, 'expense_bill', 0, '2024-01-22', 190, 179, 'Expense Bill Transaction', '800', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:28:32', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (48, 0, 'expense_bill_transaction', 1, 'expense_bill', 0, '2024-01-23', 190, 175, 'Expense Bill Transaction', '500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:29:10', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (49, 0, 'expense_bill_transaction', 9, 'expense_bill', 0, '2024-01-23', 190, 176, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:30:13', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (50, 0, 'expense_bill_transaction', 11, 'expense_bill', 0, '2024-01-23', 190, 179, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:30:32', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (51, 0, 'expense_bill_transaction', 14, 'expense_bill', 0, '2024-01-23', 190, 181, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:31:03', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (52, 0, 'expense_bill_transaction', 16, 'expense_bill', 0, '2024-01-23', 190, 182, 'Expense Bill Transaction', '1300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:31:27', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (53, 0, 'expense_bill_transaction', 17, 'expense_bill', 0, '2024-01-23', 190, 184, 'Expense Bill Transaction', '1400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:31:52', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (54, 0, 'expense_bill_transaction', 18, 'expense_bill', 0, '2024-01-23', 190, 181, 'Expense Bill Transaction', '4000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:32:24', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (55, 0, 'expense_bill_transaction', 157, 'expense_bill', 0, '2024-01-23', 190, 183, 'Expense Bill Transaction', '800', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:32:50', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (56, 0, 'expense_bill_transaction', 158, 'expense_bill', 0, '2024-01-23', 190, 183, 'Expense Bill Transaction', '1800', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:33:15', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (57, 0, 'expense_bill_transaction', 159, 'expense_bill', 0, '2024-01-23', 190, 183, 'Expense Bill Transaction', '2200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:33:38', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (58, 0, 'expense_bill_transaction', 2, 'expense_bill', 0, '2024-01-24', 190, 176, 'Expense Bill Transaction', '10000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:34:03', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (59, 0, 'expense_bill_transaction', 3, 'expense_bill', 0, '2024-01-24', 190, 177, 'Expense Bill Transaction', '2050', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:34:37', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (60, 0, 'expense_bill_transaction', 13, 'expense_bill', 0, '2024-01-25', 190, 179, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:34:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (61, 0, 'expense_bill_transaction', 160, 'expense_bill', 0, '2024-01-25', 190, 183, 'Expense Bill Transaction', '7400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:35:14', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (62, 0, 'expense_bill_transaction', 4, 'expense_bill', 0, '2024-01-26', 190, 177, 'Expense Bill Transaction', '3200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:35:29', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (63, 0, 'expense_bill_transaction', 15, 'expense_bill', 0, '2024-01-26', 190, 176, 'Expense Bill Transaction', '2300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:35:50', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (64, 0, 'expense_bill_transaction', 161, 'expense_bill', 0, '2024-01-26', 190, 183, 'Expense Bill Transaction', '6100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:36:17', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (65, 0, 'expense_bill_transaction', 5, 'expense_bill', 0, '2024-01-27', 190, 177, 'Expense Bill Transaction', '3200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:45:24', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (66, 0, 'expense_bill_transaction', 26, 'expense_bill', 0, '2024-01-27', 190, 176, 'Expense Bill Transaction', '2300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:45:41', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (67, 0, 'expense_bill_transaction', 162, 'expense_bill', 0, '2024-01-27', 190, 183, 'Expense Bill Transaction', '700', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:45:56', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (68, 0, 'expense_bill_transaction', 163, 'expense_bill', 0, '2024-01-29', 190, 183, 'Expense Bill Transaction', '4700', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:46:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (69, 0, 'expense_bill_transaction', 164, 'expense_bill', 0, '2024-01-30', 190, 183, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:46:46', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (70, 0, 'expense_bill_transaction', 165, 'expense_bill', 0, '2024-01-30', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:47:07', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (71, 0, 'expense_bill_transaction', 166, 'expense_bill', 0, '2024-01-30', 190, 192, 'Expense Bill Transaction', '6700', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:47:31', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (72, 0, 'expense_bill_transaction', 19, 'expense_bill', 0, '2024-01-31', 190, 177, 'Expense Bill Transaction', '6300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:47:50', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (73, 0, 'expense_bill_transaction', 30, 'expense_bill', 0, '2024-01-31', 190, 176, 'Expense Bill Transaction', '2500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:48:08', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (74, 0, 'expense_bill_transaction', 37, 'expense_bill', 0, '2024-01-31', 190, 177, 'Expense Bill Transaction', '500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:48:27', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (75, 0, 'expense_bill_transaction', 167, 'expense_bill', 0, '2024-01-31', 190, 183, 'Expense Bill Transaction', '3500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:48:42', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (76, 0, 'expense_bill_transaction', 169, 'expense_bill', 0, '2024-01-31', 190, 183, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:49:01', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (77, 0, 'purchase_bill_transaction', 1, 'purchase_bill', 0, '2024-01-27', 190, 5, 'Purchase Bill Transaction', '9090', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 15:50:30', 1, '2024-02-23 12:05:37', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (78, 0, 'purchase_bill_transaction', 15, 'purchase_bill', 0, '2024-02-20', 194, 5, 'Purchase Bill Transaction', '15000', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:07:38', 1, '2024-02-22 16:43:26', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (79, 0, 'purchase_bill_transaction', 16, 'purchase_bill', 0, '2024-02-20', 194, 5, 'Purchase Bill Transaction', '15000', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:07:49', 1, '2024-02-22 16:42:52', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (80, 0, 'expense_bill_transaction', 177, 'expense_bill', 0, '2024-02-20', 194, 184, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:08:52', 1, '2024-02-22 16:44:06', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (81, 0, 'expense_bill_transaction', 178, 'expense_bill', 0, '2024-02-20', 194, 184, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:10:40', 1, '2024-02-22 16:43:55', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (82, 0, 'expense_bill_transaction', 20, 'expense_bill', 0, '2024-02-01', 190, 177, 'Expense Bill Transaction', '6300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:13:11', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (83, 0, 'expense_bill_transaction', 31, 'expense_bill', 0, '2024-02-01', 190, 177, 'Expense Bill Transaction', '17900', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:13:36', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (84, 0, 'expense_bill_transaction', 32, 'expense_bill', 0, '2024-02-01', 190, 183, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:13:49', 1, '2024-02-23 12:22:00', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (85, 0, 'expense_bill_transaction', 38, 'expense_bill', 0, '2024-02-01', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:14:03', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (86, 0, 'expense_bill_transaction', 42, 'expense_bill', 0, '2024-02-01', 190, 183, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:14:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (87, 0, 'expense_bill_transaction', 44, 'expense_bill', 0, '2024-02-01', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:14:35', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (88, 0, 'expense_bill_transaction', 49, 'expense_bill', 0, '2024-02-01', 190, 177, 'Expense Bill Transaction', '3400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:14:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (89, 0, 'expense_bill_transaction', 68, 'expense_bill', 0, '2024-02-01', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:15:13', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (90, 0, 'expense_bill_transaction', 69, 'expense_bill', 0, '2024-02-01', 190, 184, 'Expense Bill Transaction', '200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:15:28', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (91, 0, 'expense_bill_transaction', 70, 'expense_bill', 0, '2024-02-01', 190, 183, 'Expense Bill Transaction', '500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:15:47', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (92, 0, 'expense_bill_transaction', 168, 'expense_bill', 0, '2024-02-01', 190, 183, 'Expense Bill Transaction', '14000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:16:03', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (93, 0, 'purchase_bill_transaction', 4, 'purchase_bill', 0, '2024-02-01', 190, 5, 'Purchase Bill Transaction', '11000', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:16:41', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (94, 0, 'purchase_bill_transaction', 8, 'purchase_bill', 0, '2024-02-01', 190, 5, 'Purchase Bill Transaction', '20000', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:16:55', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (95, 0, 'expense_bill_transaction', 21, 'expense_bill', 0, '2024-02-02', 190, 177, 'Expense Bill Transaction', '6300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:21:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (96, 0, 'expense_bill_transaction', 33, 'expense_bill', 0, '2024-02-02', 190, 177, 'Expense Bill Transaction', '7800', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:21:34', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (97, 0, 'expense_bill_transaction', 34, 'expense_bill', 0, '2024-02-02', 190, 177, 'Expense Bill Transaction', '6600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:22:56', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (98, 0, 'expense_bill_transaction', 35, 'expense_bill', 0, '2024-02-02', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:23:07', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (99, 0, 'expense_bill_transaction', 36, 'expense_bill', 0, '2024-02-02', 190, 179, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:23:19', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (100, 0, 'expense_bill_transaction', 40, 'expense_bill', 0, '2024-02-02', 190, 183, 'Expense Bill Transaction', '250', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:24:11', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (101, 0, 'expense_bill_transaction', 41, 'expense_bill', 0, '2024-02-02', 190, 182, 'Expense Bill Transaction', '300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:25:13', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (102, 0, 'expense_bill_transaction', 43, 'expense_bill', 0, '2024-02-02', 190, 179, 'Expense Bill Transaction', '300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:25:29', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (103, 0, 'expense_bill_transaction', 52, 'expense_bill', 0, '2024-02-02', 190, 177, 'Expense Bill Transaction', '3400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:25:44', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (104, 0, 'expense_bill_transaction', 53, 'expense_bill', 0, '2024-02-02', 190, 179, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:25:57', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (105, 0, 'expense_bill_transaction', 71, 'expense_bill', 0, '2024-02-02', 190, 177, 'Expense Bill Transaction', '16000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:26:15', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (106, 0, 'expense_bill_transaction', 83, 'expense_bill', 0, '2024-02-02', 190, 177, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:26:28', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (107, 0, 'expense_bill_transaction', 84, 'expense_bill', 0, '2024-02-02', 190, 180, 'Expense Bill Transaction', '1700', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:26:42', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (108, 0, 'expense_bill_transaction', 85, 'expense_bill', 0, '2024-02-02', 190, 179, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:27:00', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (109, 0, 'expense_bill_transaction', 170, 'expense_bill', 0, '2024-02-02', 190, 183, 'Expense Bill Transaction', '3500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:27:20', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (110, 0, 'purchase_bill_transaction', 14, 'purchase_bill', 0, '2024-02-02', 190, 5, 'Purchase Bill Transaction', '4550', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:27:42', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (111, 0, 'expense_bill_transaction', 6, 'expense_bill', 0, '2024-02-03', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:32:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (112, 0, 'expense_bill_transaction', 22, 'expense_bill', 0, '2024-02-03', 190, 179, 'Expense Bill Transaction', '4000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:32:43', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (113, 0, 'expense_bill_transaction', 27, 'expense_bill', 0, '2024-02-03', 190, 183, 'Expense Bill Transaction', '3500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:33:09', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (114, 0, 'expense_bill_transaction', 28, 'expense_bill', 0, '2024-02-03', 190, 184, 'Expense Bill Transaction', '2500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:33:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (115, 0, 'expense_bill_transaction', 29, 'expense_bill', 0, '2024-02-03', 190, 177, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:33:34', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (116, 0, 'expense_bill_transaction', 45, 'expense_bill', 0, '2024-02-03', 190, 177, 'Expense Bill Transaction', '7800', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:35:12', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (117, 0, 'expense_bill_transaction', 46, 'expense_bill', 0, '2024-02-03', 190, 177, 'Expense Bill Transaction', '6600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:35:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (118, 0, 'expense_bill_transaction', 47, 'expense_bill', 0, '2024-02-03', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:35:38', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (119, 0, 'expense_bill_transaction', 48, 'expense_bill', 0, '2024-02-03', 190, 179, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:35:50', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (120, 0, 'expense_bill_transaction', 50, 'expense_bill', 0, '2024-02-03', 190, 180, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:36:01', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (121, 0, 'expense_bill_transaction', 51, 'expense_bill', 0, '2024-02-03', 190, 182, 'Expense Bill Transaction', '275', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:36:12', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (122, 0, 'expense_bill_transaction', 54, 'expense_bill', 0, '2024-02-03', 190, 177, 'Expense Bill Transaction', '3400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:36:23', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (123, 0, 'expense_bill_transaction', 55, 'expense_bill', 0, '2024-02-03', 190, 179, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:36:36', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (124, 0, 'expense_bill_transaction', 72, 'expense_bill', 0, '2024-02-03', 190, 180, 'Expense Bill Transaction', '3200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:36:47', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (125, 0, 'expense_bill_transaction', 73, 'expense_bill', 0, '2024-02-03', 190, 179, 'Expense Bill Transaction', '6000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:37:00', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (126, 0, 'expense_bill_transaction', 86, 'expense_bill', 0, '2024-02-03', 190, 180, 'Expense Bill Transaction', '1700', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:37:12', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (127, 0, 'expense_bill_transaction', 88, 'expense_bill', 0, '2024-02-03', 190, 179, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:37:24', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (128, 0, 'expense_bill_transaction', 90, 'expense_bill', 0, '2024-02-03', 190, 180, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:37:35', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (129, 0, 'expense_bill_transaction', 91, 'expense_bill', 0, '2024-02-03', 190, 177, 'Expense Bill Transaction', '7500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:37:50', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (130, 0, 'expense_bill_transaction', 95, 'expense_bill', 0, '2024-02-03', 190, 179, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:38:02', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (131, 0, 'expense_bill_transaction', 104, 'expense_bill', 0, '2024-02-03', 190, 177, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:38:18', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (132, 0, 'expense_bill_transaction', 171, 'expense_bill', 0, '2024-02-03', 190, 183, 'Expense Bill Transaction', '4400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:38:32', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (133, 0, 'purchase_bill_transaction', 2, 'purchase_bill', 0, '2024-02-03', 190, 5, 'Purchase Bill Transaction', '44000', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:39:39', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (134, 0, 'purchase_bill_transaction', 3, 'purchase_bill', 0, '2024-02-03', 190, 5, 'Purchase Bill Transaction', '21250', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:39:50', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (135, 0, 'purchase_bill_transaction', 9, 'purchase_bill', 0, '2024-02-03', 190, 5, 'Purchase Bill Transaction', '4300', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:40:03', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (136, 0, 'purchase_bill_transaction', 11, 'purchase_bill', 0, '2024-02-03', 190, 5, 'Purchase Bill Transaction', '2300', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:40:19', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (137, 0, 'purchase_bill_transaction', 12, 'purchase_bill', 0, '2024-02-03', 190, 5, 'Purchase Bill Transaction', '2800', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:40:32', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (138, 0, 'expense_bill_transaction', 56, 'expense_bill', 0, '2024-02-04', 190, 177, 'Expense Bill Transaction', '3200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:41:44', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (139, 0, 'expense_bill_transaction', 57, 'expense_bill', 0, '2024-02-04', 190, 179, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:41:55', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (140, 0, 'expense_bill_transaction', 58, 'expense_bill', 0, '2024-02-04', 190, 183, 'Expense Bill Transaction', '700', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:42:08', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (141, 0, 'expense_bill_transaction', 74, 'expense_bill', 0, '2024-02-04', 190, 177, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:42:23', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (142, 0, 'expense_bill_transaction', 75, 'expense_bill', 0, '2024-02-04', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:42:38', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (143, 0, 'expense_bill_transaction', 76, 'expense_bill', 0, '2024-02-04', 190, 183, 'Expense Bill Transaction', '500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:42:51', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (144, 0, 'expense_bill_transaction', 77, 'expense_bill', 0, '2024-02-04', 190, 183, 'Expense Bill Transaction', '7300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:43:05', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (145, 0, 'expense_bill_transaction', 97, 'expense_bill', 0, '2024-02-04', 190, 180, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:43:19', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (146, 0, 'expense_bill_transaction', 80, 'expense_bill', 0, '2024-02-04', 190, 183, 'Expense Bill Transaction', '7200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:43:33', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (147, 0, 'expense_bill_transaction', 79, 'expense_bill', 0, '2024-02-04', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:43:46', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (148, 0, 'expense_bill_transaction', 78, 'expense_bill', 0, '2024-02-04', 190, 177, 'Expense Bill Transaction', '6500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:43:59', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (149, 0, 'purchase_bill_transaction', 6, 'purchase_bill', 0, '2024-02-04', 190, 5, 'Purchase Bill Transaction', '11100', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-20 16:44:38', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (150, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-02-12', 1, 190, 'User Payment Receipt Transaction', '10000', 0, 'CASH', '', '0000-00-00', '108', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:10:03', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (151, 0, 'expense_bill_transaction', 115, 'expense_bill', 0, '2024-02-07', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:26:15', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (152, 0, 'expense_bill_transaction', 114, 'expense_bill', 0, '2024-02-07', 190, 177, 'Expense Bill Transaction', '8200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:26:30', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (153, 0, 'expense_bill_transaction', 113, 'expense_bill', 0, '2024-02-07', 190, 177, 'Expense Bill Transaction', '5100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:26:45', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (154, 0, 'expense_bill_transaction', 112, 'expense_bill', 0, '2024-02-06', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:26:58', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (155, 0, 'expense_bill_transaction', 111, 'expense_bill', 0, '2024-02-06', 190, 180, 'Expense Bill Transaction', '8200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:27:11', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (156, 0, 'expense_bill_transaction', 110, 'expense_bill', 0, '2024-02-06', 190, 177, 'Expense Bill Transaction', '4000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:27:24', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (157, 0, 'expense_bill_transaction', 109, 'expense_bill', 0, '2024-02-06', 190, 177, 'Expense Bill Transaction', '5100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:27:38', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (158, 0, 'expense_bill_transaction', 172, 'expense_bill', 0, '2024-02-05', 190, 183, 'Expense Bill Transaction', '4500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:27:51', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (159, 0, 'expense_bill_transaction', 108, 'expense_bill', 0, '2024-02-05', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:28:07', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (160, 0, 'expense_bill_transaction', 107, 'expense_bill', 0, '2024-02-05', 190, 177, 'Expense Bill Transaction', '4200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:28:20', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (161, 0, 'expense_bill_transaction', 82, 'expense_bill', 0, '2024-02-05', 190, 177, 'Expense Bill Transaction', '4000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:28:33', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (162, 0, 'expense_bill_transaction', 81, 'expense_bill', 0, '2024-02-05', 190, 177, 'Expense Bill Transaction', '5100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:28:47', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (163, 0, 'expense_bill_transaction', 60, 'expense_bill', 0, '2024-02-05', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:28:59', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (164, 0, 'expense_bill_transaction', 59, 'expense_bill', 0, '2024-02-05', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:29:11', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (165, 0, 'purchase_bill_transaction', 10, 'purchase_bill', 0, '2024-02-05', 190, 5, 'Purchase Bill Transaction', '38500', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:30:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (166, 0, 'expense_bill_transaction', 122, 'expense_bill', 0, '2024-02-09', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:32:07', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (167, 0, 'expense_bill_transaction', 121, 'expense_bill', 0, '2024-02-09', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:32:20', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (168, 0, 'expense_bill_transaction', 120, 'expense_bill', 0, '2024-02-09', 190, 177, 'Expense Bill Transaction', '3100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:32:32', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (169, 0, 'expense_bill_transaction', 66, 'expense_bill', 0, '2024-02-09', 190, 177, 'Expense Bill Transaction', '6200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:32:45', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (170, 0, 'expense_bill_transaction', 65, 'expense_bill', 0, '2024-02-09', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:32:57', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (171, 0, 'expense_bill_transaction', 119, 'expense_bill', 0, '2024-02-08', 190, 177, 'Expense Bill Transaction', '3100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:33:13', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (172, 0, 'expense_bill_transaction', 118, 'expense_bill', 0, '2024-02-08', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:33:28', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (173, 0, 'expense_bill_transaction', 117, 'expense_bill', 0, '2024-02-08', 190, 177, 'Expense Bill Transaction', '5200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:33:40', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (174, 0, 'expense_bill_transaction', 116, 'expense_bill', 0, '2024-02-08', 190, 177, 'Expense Bill Transaction', '5100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:33:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (175, 0, 'expense_bill_transaction', 64, 'expense_bill', 0, '2024-02-08', 190, 183, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:34:05', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (176, 0, 'expense_bill_transaction', 63, 'expense_bill', 0, '2024-02-08', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:34:17', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (177, 0, 'expense_bill_transaction', 62, 'expense_bill', 0, '2024-02-08', 190, 179, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:34:33', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (178, 0, 'expense_bill_transaction', 61, 'expense_bill', 0, '2024-02-08', 190, 177, 'Expense Bill Transaction', '6200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:34:45', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (179, 0, 'purchase_bill_transaction', 7, 'purchase_bill', 0, '2024-02-08', 190, 5, 'Purchase Bill Transaction', '1500', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:37:19', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (180, 0, 'expense_bill_transaction', 67, 'expense_bill', 0, '2024-02-10', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:39:44', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (181, 0, 'expense_bill_transaction', 123, 'expense_bill', 0, '2024-02-10', 190, 177, 'Expense Bill Transaction', '5100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:40:57', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (182, 0, 'expense_bill_transaction', 124, 'expense_bill', 0, '2024-02-10', 190, 177, 'Expense Bill Transaction', '4200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:41:11', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (183, 0, 'expense_bill_transaction', 125, 'expense_bill', 0, '2024-02-10', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:41:23', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (184, 0, 'expense_bill_transaction', 126, 'expense_bill', 0, '2024-02-10', 190, 177, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:41:36', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (185, 0, 'expense_bill_transaction', 127, 'expense_bill', 0, '2024-02-10', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:41:48', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (186, 0, 'expense_bill_transaction', 128, 'expense_bill', 0, '2024-02-10', 190, 179, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:42:08', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (187, 0, 'expense_bill_transaction', 129, 'expense_bill', 0, '2024-02-10', 190, 177, 'Expense Bill Transaction', '7200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:42:23', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (188, 0, 'client_payment_transaction', 8, 'project', 0, '2024-02-21', 2, 1, 'Client Payment Transaction', '5001', 0, '', '', '0000-00-00', '', 0, 8, '', 0, 0, 0, '5001', '0', '0', '', 0, '2024-02-21 11:42:23', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (189, 0, 'expense_bill_transaction', 130, 'expense_bill', 0, '2024-02-10', 190, 180, 'Expense Bill Transaction', '260', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:42:35', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (190, 0, 'user_payment_receipt_transaction', 189, 'user_account_head', 0, '2024-02-21', 1, 189, 'User Payment Receipt Transaction', '5001', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:42:39', 1, '0000-00-00 00:00:00', 0, 1, 1, 1);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (191, 0, 'expense_bill_transaction', 131, 'expense_bill', 0, '2024-02-10', 190, 192, 'Expense Bill Transaction', '390', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:42:48', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (192, 0, 'expense_bill_transaction', 132, 'expense_bill', 0, '2024-02-11', 190, 177, 'Expense Bill Transaction', '12800', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:43:02', 1, '2024-02-21 11:43:37', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (193, 0, 'expense_bill_transaction', 133, 'expense_bill', 0, '2024-02-11', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:43:18', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (194, 0, 'expense_bill_transaction', 134, 'expense_bill', 0, '2024-02-11', 190, 177, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:44:33', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (195, 0, 'expense_bill_transaction', 135, 'expense_bill', 0, '2024-02-11', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:44:47', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (196, 0, 'expense_bill_transaction', 136, 'expense_bill', 0, '2024-02-12', 190, 177, 'Expense Bill Transaction', '4400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:45:01', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (197, 0, 'expense_bill_transaction', 137, 'expense_bill', 0, '2024-02-12', 190, 177, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:45:14', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (198, 0, 'expense_bill_transaction', 138, 'expense_bill', 0, '2024-02-12', 190, 177, 'Expense Bill Transaction', '4000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:45:28', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (199, 0, 'expense_bill_transaction', 139, 'expense_bill', 0, '2024-02-12', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:45:41', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (200, 0, 'purchase_bill_transaction', 13, 'purchase_bill', 0, '2024-02-10', 190, 5, 'Purchase Bill Transaction', '1475', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:46:59', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (201, 0, 'expense_bill_transaction', 140, 'expense_bill', 0, '2024-02-13', 190, 177, 'Expense Bill Transaction', '4400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:48:57', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (202, 0, 'expense_bill_transaction', 141, 'expense_bill', 0, '2024-02-13', 190, 177, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:49:11', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (203, 0, 'expense_bill_transaction', 142, 'expense_bill', 0, '2024-02-13', 190, 177, 'Expense Bill Transaction', '4000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:49:33', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (204, 0, 'expense_bill_transaction', 143, 'expense_bill', 0, '2024-02-13', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:49:49', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (205, 0, 'expense_bill_transaction', 144, 'expense_bill', 0, '2024-02-13', 190, 177, 'Expense Bill Transaction', '4400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:50:02', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (206, 0, 'expense_bill_transaction', 145, 'expense_bill', 0, '2024-02-14', 190, 177, 'Expense Bill Transaction', '4000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:50:16', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (207, 0, 'expense_bill_transaction', 146, 'expense_bill', 0, '2024-02-14', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:50:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (208, 0, 'expense_bill_transaction', 147, 'expense_bill', 0, '2024-02-14', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:51:10', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (209, 0, 'expense_bill_transaction', 154, 'expense_bill', 0, '2024-02-14', 190, 177, 'Expense Bill Transaction', '5600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:51:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (210, 0, 'expense_bill_transaction', 148, 'expense_bill', 0, '2024-02-15', 190, 177, 'Expense Bill Transaction', '7000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:51:39', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (211, 0, 'expense_bill_transaction', 149, 'expense_bill', 0, '2024-02-15', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:51:51', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (212, 0, 'expense_bill_transaction', 155, 'expense_bill', 0, '2024-02-15', 190, 177, 'Expense Bill Transaction', '6600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:52:08', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (213, 0, 'expense_bill_transaction', 156, 'expense_bill', 0, '2024-02-16', 190, 177, 'Expense Bill Transaction', '4600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:53:40', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (214, 0, 'expense_bill_transaction', 151, 'expense_bill', 0, '2024-02-16', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:53:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (215, 0, 'expense_bill_transaction', 150, 'expense_bill', 0, '2024-02-16', 190, 177, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:54:07', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (216, 0, 'expense_bill_transaction', 176, 'expense_bill', 0, '2024-02-19', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:55:26', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (217, 0, 'expense_bill_transaction', 175, 'expense_bill', 0, '2024-02-19', 190, 177, 'Expense Bill Transaction', '7200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:55:40', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (218, 0, 'expense_bill_transaction', 174, 'expense_bill', 0, '2024-02-19', 190, 177, 'Expense Bill Transaction', '5300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:55:52', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (219, 0, 'expense_bill_transaction', 173, 'expense_bill', 0, '2024-02-19', 190, 177, 'Expense Bill Transaction', '2500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 11:58:08', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (220, 0, 'expense_bill_transaction', 153, 'expense_bill', 0, '2024-02-17', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 12:02:48', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (221, 0, 'expense_bill_transaction', 152, 'expense_bill', 0, '2024-02-17', 190, 177, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 12:03:01', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (222, 0, 'expense_bill_transaction', 181, 'expense_bill', 0, '2024-02-21', 190, 177, 'Expense Bill Transaction', '6300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 13:58:38', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (223, 0, 'expense_bill_transaction', 180, 'expense_bill', 0, '2024-02-21', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 13:58:50', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (224, 0, 'expense_bill_transaction', 179, 'expense_bill', 0, '2024-02-21', 190, 177, 'Expense Bill Transaction', '3200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 13:59:00', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (225, 0, 'expense_bill_transaction', 182, 'expense_bill', 0, '2024-02-21', 190, 177, 'Expense Bill Transaction', '6300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 13:59:34', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (226, 0, 'expense_bill_transaction', 183, 'expense_bill', 0, '2024-02-21', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-21 13:59:59', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (227, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-02-21', 1, 194, 'User Payment Receipt Transaction', '5001', 0, 'CASH', '', '0000-00-00', '111', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-22 16:44:40', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (228, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-02-19', 1, 194, 'User Payment Receipt Transaction', '400000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-22 16:45:07', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (229, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-02-15', 1, 194, 'User Payment Receipt Transaction', '90000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-22 16:45:31', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (230, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-02-14', 1, 194, 'User Payment Receipt Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-22 16:46:03', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (231, 0, 'client_payment_transaction', 6, 'project', 0, '2024-02-23', 2, 1, 'Client Payment Transaction', '100000', 0, '', '', '0000-00-00', '', 0, 6, '', 0, 0, 0, '100000', '0', '0', '', 0, '2024-02-24 12:04:18', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (232, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-02-23', 1, 190, 'User Payment Receipt Transaction', '100000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-24 12:14:09', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (233, 0, 'expense_bill_transaction', 184, 'expense_bill', 0, '2024-02-24', 190, 177, 'Expense Bill Transaction', '5100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-24 12:15:59', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (234, 0, 'expense_bill_transaction', 185, 'expense_bill', 0, '2024-02-24', 190, 177, 'Expense Bill Transaction', '5100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-24 12:18:34', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (235, 0, 'expense_bill_transaction', 186, 'expense_bill', 0, '2024-02-24', 190, 177, 'Expense Bill Transaction', '4300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-24 12:35:37', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (236, 0, 'expense_bill_transaction', 187, 'expense_bill', 0, '2024-02-24', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-24 12:38:06', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (237, 0, 'expense_bill_transaction', 188, 'expense_bill', 0, '2024-02-24', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-24 12:38:31', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (238, 0, 'expense_bill_transaction', 189, 'expense_bill', 0, '2024-02-24', 190, 177, 'Expense Bill Transaction', '6300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-24 12:39:06', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (239, 0, 'expense_bill_transaction', 190, 'expense_bill', 0, '2024-02-23', 190, 177, 'Expense Bill Transaction', '2100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-26 12:13:55', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (240, 0, 'expense_bill_transaction', 191, 'expense_bill', 0, '2024-02-23', 190, 177, 'Expense Bill Transaction', '2200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-26 12:14:21', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (241, 0, 'expense_bill_transaction', 192, 'expense_bill', 0, '2024-02-23', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-26 12:14:56', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (242, 0, 'expense_bill_transaction', 193, 'expense_bill', 0, '2024-02-23', 190, 179, 'Expense Bill Transaction', '200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-26 12:16:40', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (243, 0, 'expense_bill_transaction', 194, 'expense_bill', 0, '2024-02-23', 190, 182, 'Expense Bill Transaction', '250', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-26 12:17:14', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (244, 0, 'expense_bill_transaction', 195, 'expense_bill', 0, '2024-02-23', 190, 177, 'Expense Bill Transaction', '7400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-26 12:17:35', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (245, 0, 'expense_bill_transaction', 196, 'expense_bill', 0, '2024-02-23', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-26 12:18:08', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (246, 0, 'expense_bill_transaction', 197, 'expense_bill', 0, '2024-02-23', 190, 182, 'Expense Bill Transaction', '350', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-26 12:25:54', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (247, 0, 'expense_bill_transaction', 204, 'expense_bill', 0, '2024-02-23', 190, 177, 'Expense Bill Transaction', '5200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-27 16:47:40', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (248, 0, 'expense_bill_transaction', 205, 'expense_bill', 0, '2024-02-23', 190, 177, 'Expense Bill Transaction', '5100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-27 16:48:04', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (249, 0, 'expense_bill_transaction', 206, 'expense_bill', 0, '2024-02-25', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-27 16:49:02', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (250, 0, 'expense_bill_transaction', 207, 'expense_bill', 0, '2024-02-25', 190, 177, 'Expense Bill Transaction', '5200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-27 16:49:27', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (251, 0, 'expense_bill_transaction', 208, 'expense_bill', 0, '2024-02-28', 190, 177, 'Expense Bill Transaction', '2300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-29 10:50:28', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (252, 0, 'expense_bill_transaction', 209, 'expense_bill', 0, '2024-02-28', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-29 10:52:07', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (253, 0, 'expense_bill_transaction', 210, 'expense_bill', 0, '2024-02-28', 190, 177, 'Expense Bill Transaction', '3100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-29 10:53:09', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (254, 0, 'expense_bill_transaction', 211, 'expense_bill', 0, '2024-02-28', 190, 177, 'Expense Bill Transaction', '8100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-29 10:54:03', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (255, 0, 'expense_bill_transaction', 212, 'expense_bill', 0, '2024-02-28', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-29 10:54:30', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (256, 0, 'expense_bill_transaction', 213, 'expense_bill', 0, '2024-02-28', 190, 177, 'Expense Bill Transaction', '3300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-29 10:54:48', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (257, 0, 'expense_bill_transaction', 201, 'expense_bill', 0, '2024-02-27', 190, 177, 'Expense Bill Transaction', '6300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-29 10:59:16', 1, '2024-02-29 10:59:30', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (258, 0, 'expense_bill_transaction', 199, 'expense_bill', 0, '2024-02-27', 190, 177, 'Expense Bill Transaction', '5200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-29 11:00:24', 1, '2024-02-29 11:01:04', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (259, 0, 'expense_bill_transaction', 200, 'expense_bill', 0, '2024-02-27', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-29 11:00:48', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (260, 0, 'expense_bill_transaction', 198, 'expense_bill', 0, '2024-02-27', 190, 177, 'Expense Bill Transaction', '6600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-29 11:01:30', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (261, 0, 'expense_bill_transaction', 203, 'expense_bill', 0, '2024-02-27', 190, 177, 'Expense Bill Transaction', '5300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-29 11:09:57', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (262, 0, 'expense_bill_transaction', 202, 'expense_bill', 0, '2024-02-27', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-29 11:10:10', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (263, 0, 'client_payment_transaction', 10, 'project', 0, '2024-03-01', 2, 1, 'Client Payment Transaction', '20000', 0, '', '', '0000-00-00', '', 0, 10, '', 0, 0, 0, '20000', '0', '0', '', 0, '2024-02-29 11:31:09', 1, '2024-03-05 11:30:10', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (264, 0, 'client_payment_transaction', 5, 'project', 0, '2024-03-01', 2, 1, 'Client Payment Transaction', '50000', 0, '', '', '0000-00-00', '', 0, 5, '', 0, 0, 0, '50000', '0', '0', '', 0, '2024-02-29 11:31:29', 1, '2024-03-05 11:30:04', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (265, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-03-01', 1, 194, 'User Payment Receipt Transaction', '20000', 0, 'CASH', '', '0000-00-00', '113', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-29 11:32:36', 1, '2024-03-05 11:30:28', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (266, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-03-01', 1, 194, 'User Payment Receipt Transaction', '50000', 0, 'CASH', '', '0000-00-00', '108', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-29 11:32:57', 1, '2024-03-05 11:30:21', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (267, 0, 'expense_bill_transaction', 214, 'expense_bill', 0, '2024-02-27', 190, 195, 'Expense Bill Transaction', '4630', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-29 11:59:35', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (268, 0, 'expense_bill_transaction', 215, 'expense_bill', 0, '2024-02-29', 190, 177, 'Expense Bill Transaction', '2300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-29 15:30:59', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (269, 0, 'expense_bill_transaction', 216, 'expense_bill', 0, '2024-02-29', 190, 177, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-29 15:31:51', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (270, 0, 'expense_bill_transaction', 217, 'expense_bill', 0, '2024-02-29', 190, 177, 'Expense Bill Transaction', '2300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-29 15:32:24', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (271, 0, 'expense_bill_transaction', 218, 'expense_bill', 0, '2024-02-29', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-29 15:32:57', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (272, 0, 'expense_bill_transaction', 219, 'expense_bill', 0, '2024-02-29', 190, 195, 'Expense Bill Transaction', '7860', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-29 15:34:28', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (273, 0, 'expense_bill_transaction', 220, 'expense_bill', 0, '2024-02-29', 190, 177, 'Expense Bill Transaction', '6100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-29 15:35:01', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (274, 0, 'expense_bill_transaction', 221, 'expense_bill', 0, '2024-02-29', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-02-29 15:36:37', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (275, 0, 'expense_bill_transaction', 222, 'expense_bill', 0, '2024-03-01', 190, 177, 'Expense Bill Transaction', '2300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-01 14:57:12', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (276, 0, 'expense_bill_transaction', 223, 'expense_bill', 0, '2024-03-01', 190, 177, 'Expense Bill Transaction', '6000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-01 14:57:41', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (277, 0, 'expense_bill_transaction', 224, 'expense_bill', 0, '2024-03-01', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-01 14:58:09', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (278, 0, 'expense_bill_transaction', 225, 'expense_bill', 0, '2024-03-01', 190, 177, 'Expense Bill Transaction', '8100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-01 14:58:31', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (279, 0, 'expense_bill_transaction', 226, 'expense_bill', 0, '2024-03-01', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-01 14:59:16', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (280, 0, 'expense_bill_transaction', 227, 'expense_bill', 0, '2024-03-01', 190, 177, 'Expense Bill Transaction', '1100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-01 15:06:29', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (281, 0, 'expense_bill_transaction', 228, 'expense_bill', 0, '2024-03-02', 190, 177, 'Expense Bill Transaction', '6000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-02 16:10:10', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (282, 0, 'expense_bill_transaction', 229, 'expense_bill', 0, '2024-03-02', 190, 177, 'Expense Bill Transaction', '400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-02 16:11:06', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (283, 0, 'expense_bill_transaction', 230, 'expense_bill', 0, '2024-03-02', 190, 184, 'Expense Bill Transaction', '20000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-02 16:14:57', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (284, 0, 'expense_bill_transaction', 231, 'expense_bill', 0, '2024-03-02', 190, 196, 'Expense Bill Transaction', '15000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-02 16:17:14', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (285, 0, 'expense_bill_transaction', 232, 'expense_bill', 0, '2024-03-02', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-02 16:19:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (286, 0, 'expense_bill_transaction', 233, 'expense_bill', 0, '2024-03-02', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-02 16:19:52', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (287, 0, 'expense_bill_transaction', 234, 'expense_bill', 0, '2024-03-02', 190, 177, 'Expense Bill Transaction', '4600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-02 16:20:29', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (288, 0, 'expense_bill_transaction', 235, 'expense_bill', 0, '2024-03-02', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-02 16:20:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (289, 0, 'expense_bill_transaction', 236, 'expense_bill', 0, '2024-03-02', 190, 177, 'Expense Bill Transaction', '6400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-02 16:22:48', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (290, 0, 'expense_bill_transaction', 237, 'expense_bill', 0, '2024-03-02', 190, 196, 'Expense Bill Transaction', '18400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-02 16:24:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (291, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-02-26', 1, 194, 'User Payment Receipt Transaction', '5000', 0, 'CASH', '', '0000-00-00', '112', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:31:28', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (292, 0, 'client_payment_transaction', 9, 'project', 0, '2024-02-26', 2, 1, 'Client Payment Transaction', '5000', 0, '', '', '0000-00-00', '', 0, 9, '', 0, 0, 0, '5000', '0', '0', '', 0, '2024-03-05 11:31:54', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (293, 0, 'purchase_bill_transaction', 17, 'purchase_bill', 0, '2024-02-22', 194, 5, 'Purchase Bill Transaction', '10520', 1, 'CASH', '', '0000-00-00', '', 0, 5, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:34:54', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (294, 0, 'purchase_bill_transaction', 18, 'purchase_bill', 0, '2024-02-23', 194, 5, 'Purchase Bill Transaction', '4440', 1, 'CASH', '', '0000-00-00', '', 0, 5, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:36:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (295, 0, 'purchase_bill_transaction', 19, 'purchase_bill', 0, '2024-02-24', 194, 5, 'Purchase Bill Transaction', '41200', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:39:28', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (296, 0, 'purchase_bill_transaction', 20, 'purchase_bill', 0, '2024-02-26', 194, 5, 'Purchase Bill Transaction', '35000', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:40:42', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (297, 0, 'purchase_bill_transaction', 21, 'purchase_bill', 0, '2024-02-28', 194, 5, 'Purchase Bill Transaction', '4400', 1, 'CASH', '', '0000-00-00', '', 0, 5, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:41:59', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (298, 0, 'purchase_bill_transaction', 22, 'purchase_bill', 0, '2024-02-28', 194, 5, 'Purchase Bill Transaction', '55600', 1, 'CASH', '', '0000-00-00', '', 0, 9, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:43:03', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (299, 0, 'purchase_bill_transaction', 23, 'purchase_bill', 0, '2024-03-03', 194, 5, 'Purchase Bill Transaction', '2050', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:43:54', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (300, 0, 'purchase_bill_transaction', 24, 'purchase_bill', 0, '2024-03-03', 194, 5, 'Purchase Bill Transaction', '9600', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:44:36', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (301, 0, 'purchase_bill_transaction', 25, 'purchase_bill', 0, '2024-03-03', 194, 5, 'Purchase Bill Transaction', '2050', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:45:13', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (302, 0, 'purchase_bill_transaction', 26, 'purchase_bill', 0, '2024-03-03', 194, 5, 'Purchase Bill Transaction', '62500', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:46:07', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (303, 0, 'expense_bill_transaction', 238, 'expense_bill', 0, '2024-03-03', 194, 182, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:46:52', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (304, 0, 'expense_bill_transaction', 239, 'expense_bill', 0, '2024-03-03', 194, 176, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:47:23', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (305, 0, 'expense_bill_transaction', 240, 'expense_bill', 0, '2024-03-03', 194, 177, 'Expense Bill Transaction', '18000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:47:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (306, 0, 'expense_bill_transaction', 241, 'expense_bill', 0, '2024-03-03', 194, 177, 'Expense Bill Transaction', '5300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:48:46', 1, '2024-03-05 11:57:13', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (307, 0, 'expense_bill_transaction', 242, 'expense_bill', 0, '2024-03-02', 194, 177, 'Expense Bill Transaction', '5300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:49:26', 1, '2024-03-05 11:57:05', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (308, 0, 'expense_bill_transaction', 243, 'expense_bill', 0, '2024-03-02', 194, 177, 'Expense Bill Transaction', '18000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:49:52', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (309, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-02-25', 1, 190, 'User Payment Receipt Transaction', '10000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:50:15', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (310, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-02-26', 1, 190, 'User Payment Receipt Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:50:33', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (311, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-03-01', 1, 190, 'User Payment Receipt Transaction', '95002', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:50:55', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (312, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-03-04', 1, 190, 'User Payment Receipt Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:51:13', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (313, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-02-25', 194, 1, 'User Payment Return Transaction', '10000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:51:31', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (314, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-02-26', 1, 194, 'User Payment Receipt Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:51:54', 1, '0000-00-00 00:00:00', 0, 1, 1, 1);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (315, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-03-01', 1, 194, 'User Payment Receipt Transaction', '95002', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:52:10', 1, '0000-00-00 00:00:00', 0, 1, 1, 1);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (316, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-03-04', 194, 1, 'User Payment Return Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:52:26', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (317, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-03-01', 194, 1, 'User Payment Return Transaction', '95002', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:54:44', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (318, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-02-26', 194, 1, 'User Payment Return Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 11:55:16', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (319, 0, 'expense_bill_transaction', 244, 'expense_bill', 0, '2024-03-04', 190, 177, 'Expense Bill Transaction', '2100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 15:11:24', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (320, 0, 'expense_bill_transaction', 245, 'expense_bill', 0, '2024-03-04', 190, 179, 'Expense Bill Transaction', '100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 15:14:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (321, 0, 'expense_bill_transaction', 246, 'expense_bill', 0, '2024-03-04', 190, 177, 'Expense Bill Transaction', '4000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 15:14:52', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (322, 0, 'expense_bill_transaction', 247, 'expense_bill', 0, '2024-03-04', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 15:15:18', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (323, 0, 'expense_bill_transaction', 248, 'expense_bill', 0, '2024-03-05', 190, 177, 'Expense Bill Transaction', '3500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 15:16:03', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (324, 0, 'expense_bill_transaction', 249, 'expense_bill', 0, '2024-03-05', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 15:16:30', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (325, 0, 'expense_bill_transaction', 250, 'expense_bill', 0, '2024-03-05', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 15:17:10', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (326, 0, 'expense_bill_transaction', 251, 'expense_bill', 0, '2024-03-05', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 15:19:52', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (327, 0, 'expense_bill_transaction', 252, 'expense_bill', 0, '2024-03-04', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 15:25:16', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (328, 0, 'expense_bill_transaction', 253, 'expense_bill', 0, '2024-03-04', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 15:25:43', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (329, 0, 'expense_bill_transaction', 254, 'expense_bill', 0, '2024-02-11', 190, 181, 'Expense Bill Transaction', '6000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 15:49:05', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (330, 0, 'expense_bill_transaction', 255, 'expense_bill', 0, '2024-02-11', 190, 181, 'Expense Bill Transaction', '7500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 15:49:26', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (331, 0, 'expense_bill_transaction', 256, 'expense_bill', 0, '2024-02-11', 190, 199, 'Expense Bill Transaction', '19500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 15:50:17', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (332, 0, 'expense_bill_transaction', 257, 'expense_bill', 0, '2024-02-11', 190, 199, 'Expense Bill Transaction', '500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-05 15:50:44', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (333, 0, 'expense_bill_transaction', 259, 'expense_bill', 0, '2024-03-06', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-06 15:43:55', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (334, 0, 'expense_bill_transaction', 260, 'expense_bill', 0, '2024-03-06', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-06 15:45:06', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (335, 0, 'expense_bill_transaction', 261, 'expense_bill', 0, '2024-03-06', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-06 15:46:00', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (336, 0, 'expense_bill_transaction', 262, 'expense_bill', 0, '2024-03-06', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-06 15:46:42', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (337, 0, 'expense_bill_transaction', 263, 'expense_bill', 0, '2024-02-29', 190, 177, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-06 15:47:32', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (338, 0, 'expense_bill_transaction', 258, 'expense_bill', 0, '2024-03-04', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-06 15:47:57', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (339, 0, 'expense_bill_transaction', 264, 'expense_bill', 0, '2024-03-07', 190, 183, 'Expense Bill Transaction', '150', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-07 15:47:24', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (340, 0, 'expense_bill_transaction', 265, 'expense_bill', 0, '2024-03-07', 190, 177, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-07 15:48:09', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (341, 0, 'expense_bill_transaction', 266, 'expense_bill', 0, '2024-03-07', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-07 15:48:48', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (342, 0, 'expense_bill_transaction', 267, 'expense_bill', 0, '2024-03-07', 190, 177, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-07 15:49:33', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (343, 0, 'expense_bill_transaction', 268, 'expense_bill', 0, '2024-03-07', 190, 180, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-07 15:50:21', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (344, 0, 'expense_bill_transaction', 269, 'expense_bill', 0, '2024-03-07', 190, 183, 'Expense Bill Transaction', '4800', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-07 15:51:30', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (345, 0, 'purchase_bill_transaction', 27, 'purchase_bill', 0, '2024-03-07', 190, 5, 'Purchase Bill Transaction', '36800', 1, 'CASH', '', '0000-00-00', '', 0, 8, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-07 15:53:21', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (346, 0, 'expense_bill_transaction', 270, 'expense_bill', 0, '2024-03-06', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-07 15:54:27', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (347, 0, 'expense_bill_transaction', 271, 'expense_bill', 0, '2024-03-06', 190, 183, 'Expense Bill Transaction', '1300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-07 15:55:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (348, 0, 'expense_bill_transaction', 272, 'expense_bill', 0, '2024-03-07', 190, 177, 'Expense Bill Transaction', '4600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-07 16:00:28', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (349, 0, 'expense_bill_transaction', 273, 'expense_bill', 0, '2024-03-06', 190, 177, 'Expense Bill Transaction', '3300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-07 16:04:38', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (350, 0, 'client_payment_transaction', 14, 'project', 0, '2024-03-06', 2, 1, 'Client Payment Transaction', '200000', 0, '', '', '0000-00-00', '', 0, 14, '', 0, 0, 0, '200000', '0', '0', '', 0, '2024-03-07 16:11:16', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (351, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-03-06', 1, 194, 'User Payment Receipt Transaction', '200000', 0, 'CASH', '', '0000-00-00', '116', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-07 16:11:36', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (352, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-03-06', 1, 190, 'User Payment Receipt Transaction', '30000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-07 16:11:52', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (353, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-03-07', 1, 190, 'User Payment Receipt Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-07 16:12:32', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (354, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-03-06', 194, 1, 'User Payment Return Transaction', '30000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-07 16:13:17', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (355, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-03-07', 194, 1, 'User Payment Return Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-07 16:13:37', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (356, 0, 'expense_bill_transaction', 274, 'expense_bill', 0, '2024-03-08', 190, 177, 'Expense Bill Transaction', '4600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-08 15:42:56', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (357, 0, 'expense_bill_transaction', 275, 'expense_bill', 0, '2024-03-08', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-08 15:45:37', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (358, 0, 'expense_bill_transaction', 276, 'expense_bill', 0, '2024-03-08', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-08 15:46:21', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (359, 0, 'expense_bill_transaction', 277, 'expense_bill', 0, '2024-03-08', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-08 15:47:02', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (360, 0, 'client_payment_transaction', 12, 'project', 0, '2024-03-06', 2, 1, 'Client Payment Transaction', '100000', 0, '', '', '0000-00-00', '', 0, 12, '', 0, 0, 0, '100000', '0', '0', '', 0, '2024-03-13 09:59:12', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (361, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-03-06', 1, 190, 'User Payment Receipt Transaction', '100000', 0, 'CASH', '', '0000-00-00', '114', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 10:00:54', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (362, 0, 'expense_bill_transaction', 278, 'expense_bill', 0, '2024-03-07', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 10:27:03', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (363, 0, 'expense_bill_transaction', 279, 'expense_bill', 0, '2024-03-07', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 10:27:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (364, 0, 'expense_bill_transaction', 280, 'expense_bill', 0, '2024-03-07', 190, 177, 'Expense Bill Transaction', '6000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 10:28:08', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (365, 0, 'expense_bill_transaction', 281, 'expense_bill', 0, '2024-03-07', 190, 184, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 10:30:17', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (366, 0, 'purchase_bill_transaction', 28, 'purchase_bill', 0, '2024-03-12', 190, 5, 'Purchase Bill Transaction', '4630', 1, 'CASH', '', '0000-00-00', '', 0, 8, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 10:54:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 1);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (367, 0, 'client_payment_transaction', 14, 'project', 0, '2024-03-07', 2, 1, 'Client Payment Transaction', '50000', 0, '', '', '0000-00-00', '', 0, 14, '', 0, 0, 0, '50000', '0', '0', '', 0, '2024-03-13 14:26:42', 1, '2024-04-20 15:17:35', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (368, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-03-07', 1, 190, 'User Payment Receipt Transaction', '100000', 0, 'CASH', '', '0000-00-00', '50000+50000 JOB 116', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 14:27:08', 1, '2024-04-20 15:19:25', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (369, 0, 'expense_bill_transaction', 282, 'expense_bill', 0, '2024-03-08', 190, 177, 'Expense Bill Transaction', '3450', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 14:32:34', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (370, 0, 'expense_bill_transaction', 283, 'expense_bill', 0, '2024-03-08', 190, 177, 'Expense Bill Transaction', '10500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 14:43:41', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (371, 0, 'expense_bill_transaction', 284, 'expense_bill', 0, '2024-03-08', 190, 177, 'Expense Bill Transaction', '11700', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 14:44:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (372, 0, 'expense_bill_transaction', 285, 'expense_bill', 0, '2024-03-08', 190, 177, 'Expense Bill Transaction', '9900', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 14:45:10', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (373, 0, 'expense_bill_transaction', 286, 'expense_bill', 0, '2024-03-09', 190, 177, 'Expense Bill Transaction', '3450', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 14:51:17', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (374, 0, 'expense_bill_transaction', 287, 'expense_bill', 0, '2024-03-09', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 14:52:16', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (375, 0, 'expense_bill_transaction', 288, 'expense_bill', 0, '2024-03-09', 190, 177, 'Expense Bill Transaction', '15300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 14:55:12', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (376, 0, 'expense_bill_transaction', 289, 'expense_bill', 0, '2024-03-10', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 14:56:10', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (377, 0, 'expense_bill_transaction', 290, 'expense_bill', 0, '2024-03-11', 190, 177, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 15:03:56', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (378, 0, 'expense_bill_transaction', 291, 'expense_bill', 0, '2024-03-11', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 15:04:41', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (379, 0, 'expense_bill_transaction', 292, 'expense_bill', 0, '2024-03-11', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 15:16:13', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (380, 0, 'expense_bill_transaction', 293, 'expense_bill', 0, '2024-03-11', 190, 177, 'Expense Bill Transaction', '2900', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 15:17:27', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (381, 0, 'expense_bill_transaction', 294, 'expense_bill', 0, '2024-03-11', 190, 199, 'Expense Bill Transaction', '54870', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 15:19:56', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (382, 0, 'expense_bill_transaction', 295, 'expense_bill', 0, '2024-03-11', 190, 201, 'Expense Bill Transaction', '812', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 15:24:19', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (383, 0, 'expense_bill_transaction', 296, 'expense_bill', 0, '2024-03-11', 190, 179, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 15:24:51', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (384, 0, 'expense_bill_transaction', 297, 'expense_bill', 0, '2024-03-12', 190, 177, 'Expense Bill Transaction', '8200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 15:36:42', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (385, 0, 'expense_bill_transaction', 298, 'expense_bill', 0, '2024-03-12', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 15:37:23', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (386, 0, 'expense_bill_transaction', 299, 'expense_bill', 0, '2024-03-12', 190, 177, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 15:37:54', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (387, 0, 'expense_bill_transaction', 300, 'expense_bill', 0, '2024-03-12', 190, 177, 'Expense Bill Transaction', '11780', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-13 16:00:05', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (388, 0, 'expense_bill_transaction', 301, 'expense_bill', 0, '2024-03-14', 190, 177, 'Expense Bill Transaction', '2600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-14 15:23:47', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (389, 0, 'expense_bill_transaction', 302, 'expense_bill', 0, '2024-03-14', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-14 15:24:37', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (390, 0, 'expense_bill_transaction', 303, 'expense_bill', 0, '2024-03-14', 190, 180, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-14 15:25:20', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (391, 0, 'expense_bill_transaction', 304, 'expense_bill', 0, '2024-03-14', 190, 177, 'Expense Bill Transaction', '3900', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-14 15:26:30', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (392, 0, 'expense_bill_transaction', 305, 'expense_bill', 0, '2024-03-14', 190, 201, 'Expense Bill Transaction', '5200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-14 15:27:28', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (393, 0, 'expense_bill_transaction', 306, 'expense_bill', 0, '2024-03-14', 190, 177, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-14 15:28:05', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (394, 0, 'expense_bill_transaction', 307, 'expense_bill', 0, '2024-03-14', 190, 201, 'Expense Bill Transaction', '580', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-14 15:31:21', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (395, 0, 'expense_bill_transaction', 308, 'expense_bill', 0, '2024-03-13', 190, 201, 'Expense Bill Transaction', '1057', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-14 15:34:14', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (396, 0, 'expense_bill_transaction', 309, 'expense_bill', 0, '2024-03-13', 190, 181, 'Expense Bill Transaction', '1800', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-14 15:34:49', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (397, 0, 'expense_bill_transaction', 310, 'expense_bill', 0, '2024-03-14', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-14 15:36:29', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (398, 0, 'expense_bill_transaction', 311, 'expense_bill', 0, '2024-03-14', 190, 177, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-14 15:37:23', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (399, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-02-28', 1, 190, 'User Payment Receipt Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-14 16:59:16', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (400, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-03-02', 1, 190, 'User Payment Receipt Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-14 16:59:38', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (401, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-03-02', 194, 1, 'User Payment Return Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-14 16:59:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (402, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-02-28', 194, 1, 'User Payment Return Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-14 17:00:11', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (403, 0, 'purchase_bill_transaction', 29, 'purchase_bill', 0, '2024-03-14', 190, 5, 'Purchase Bill Transaction', '1955', 1, 'CASH', '', '0000-00-00', '', 0, 14, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-15 10:02:55', 1, '2024-03-19 10:13:33', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (404, 0, 'purchase_bill_transaction', 30, 'purchase_bill', 0, '2024-03-06', 194, 5, 'Purchase Bill Transaction', '133900', 1, 'CASH', '', '0000-00-00', '', 0, 12, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-15 11:27:21', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (405, 0, 'purchase_bill_transaction', 22, 'purchase_bill', 0, '2024-03-06', 194, 5, 'Purchase Bill Transaction', '26100', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-15 11:35:14', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (406, 0, 'expense_bill_transaction', 312, 'expense_bill', 0, '2024-03-08', 194, 199, 'Expense Bill Transaction', '8000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-15 15:00:38', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (407, 0, 'expense_bill_transaction', 313, 'expense_bill', 0, '2024-03-08', 194, 201, 'Expense Bill Transaction', '21000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-15 15:02:17', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (408, 0, 'purchase_bill_transaction', 32, 'purchase_bill', 0, '2024-03-08', 194, 5, 'Purchase Bill Transaction', '2100', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-15 15:04:42', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (409, 0, 'purchase_bill_transaction', 33, 'purchase_bill', 0, '2024-03-08', 194, 5, 'Purchase Bill Transaction', '2100', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-15 15:05:21', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (410, 0, 'expense_bill_transaction', 314, 'expense_bill', 0, '2024-03-08', 194, 177, 'Expense Bill Transaction', '5300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-15 15:06:05', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (411, 0, 'expense_bill_transaction', 315, 'expense_bill', 0, '2024-03-08', 194, 201, 'Expense Bill Transaction', '240', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-15 15:07:19', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (412, 0, 'expense_bill_transaction', 316, 'expense_bill', 0, '2024-03-10', 194, 177, 'Expense Bill Transaction', '5300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-15 15:09:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (413, 0, 'expense_bill_transaction', 317, 'expense_bill', 0, '2024-03-10', 194, 176, 'Expense Bill Transaction', '2500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-15 15:09:58', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (414, 0, 'expense_bill_transaction', 318, 'expense_bill', 0, '2024-03-11', 194, 177, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-15 15:14:02', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (415, 0, 'expense_bill_transaction', 319, 'expense_bill', 0, '2024-03-12', 194, 177, 'Expense Bill Transaction', '5300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-15 15:14:49', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (416, 0, 'expense_bill_transaction', 320, 'expense_bill', 0, '2024-03-14', 194, 177, 'Expense Bill Transaction', '5300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-15 15:15:47', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (417, 0, 'purchase_bill_transaction', 34, 'purchase_bill', 0, '2024-03-11', 194, 5, 'Purchase Bill Transaction', '47450', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-15 15:16:55', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (418, 0, 'purchase_bill_transaction', 35, 'purchase_bill', 0, '2024-03-12', 194, 5, 'Purchase Bill Transaction', '2050', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-15 15:18:01', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (419, 0, 'purchase_bill_transaction', 36, 'purchase_bill', 0, '2024-03-14', 194, 5, 'Purchase Bill Transaction', '6850', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-15 15:19:02', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (420, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-03-13', 1, 190, 'User Payment Receipt Transaction', '100000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-15 15:19:59', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (421, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-03-14', 1, 190, 'User Payment Receipt Transaction', '100000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-15 15:20:36', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (422, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-03-13', 194, 1, 'User Payment Return Transaction', '100000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-15 15:21:26', 1, '2024-03-15 15:21:37', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (423, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-03-14', 194, 1, 'User Payment Return Transaction', '100000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-15 15:21:56', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (424, 0, 'expense_bill_transaction', 321, 'expense_bill', 0, '2024-03-06', 190, 176, 'Expense Bill Transaction', '24530', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-18 10:05:19', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (425, 0, 'purchase_bill_transaction', 37, 'purchase_bill', 0, '2024-03-06', 190, 5, 'Purchase Bill Transaction', '40800', 1, 'CASH', '', '0000-00-00', '', 0, 14, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-18 10:06:36', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (426, 0, 'purchase_bill_transaction', 38, 'purchase_bill', 0, '2024-03-06', 190, 5, 'Purchase Bill Transaction', '14400', 1, 'CASH', '', '0000-00-00', '', 0, 14, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-18 10:08:23', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (427, 0, 'purchase_bill_transaction', 39, 'purchase_bill', 0, '2024-03-07', 190, 5, 'Purchase Bill Transaction', '4630', 1, 'CASH', '', '0000-00-00', '', 0, 8, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-18 10:34:20', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (428, 0, 'purchase_bill_transaction', 40, 'purchase_bill', 0, '2024-03-07', 190, 5, 'Purchase Bill Transaction', '1200', 1, 'CASH', '', '0000-00-00', '', 0, 14, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-18 10:35:00', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (429, 0, 'purchase_bill_transaction', 41, 'purchase_bill', 0, '2024-03-07', 190, 5, 'Purchase Bill Transaction', '400', 1, 'CASH', '', '0000-00-00', '', 0, 14, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-18 10:36:46', 1, '2024-03-18 10:38:23', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (430, 0, 'purchase_bill_transaction', 42, 'purchase_bill', 0, '2024-03-08', 190, 5, 'Purchase Bill Transaction', '6800', 1, 'CASH', '', '0000-00-00', '', 0, 14, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-18 10:42:16', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (431, 0, 'purchase_bill_transaction', 43, 'purchase_bill', 0, '2024-03-08', 190, 5, 'Purchase Bill Transaction', '6800', 1, 'CASH', '', '0000-00-00', '', 0, 14, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-18 10:44:04', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (432, 0, 'client_payment_transaction', 12, 'project', 0, '2024-03-16', 2, 1, 'Client Payment Transaction', '150000', 0, '', '', '0000-00-00', '', 0, 12, '', 0, 0, 0, '150000', '0', '0', '', 0, '2024-03-18 11:57:36', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (433, 0, 'client_payment_transaction', 10, 'project', 0, '2024-03-16', 2, 1, 'Client Payment Transaction', '200000', 0, '', '', '0000-00-00', '', 0, 10, '', 0, 0, 0, '200000', '0', '0', '', 0, '2024-03-18 11:57:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (434, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-03-16', 1, 190, 'User Payment Receipt Transaction', '25000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-18 11:58:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 1);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (435, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-03-16', 194, 1, 'User Payment Return Transaction', '25000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-18 11:58:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (436, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-03-16', 1, 194, 'User Payment Receipt Transaction', '150000', 0, 'CASH', '', '0000-00-00', '114', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-18 11:59:27', 1, '2024-03-18 11:59:35', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (437, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-03-16', 1, 194, 'User Payment Receipt Transaction', '200000', 0, 'CASH', '', '0000-00-00', '113', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-18 11:59:59', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (438, 0, 'purchase_bill_transaction', 21, 'purchase_bill', 0, '2024-03-16', 194, 5, 'Purchase Bill Transaction', '500', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-18 12:06:30', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (439, 0, 'purchase_bill_transaction', 22, 'purchase_bill', 0, '2024-03-16', 194, 5, 'Purchase Bill Transaction', '1500', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-18 12:06:47', 1, '2024-03-18 12:13:45', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (440, 0, 'purchase_bill_transaction', 30, 'purchase_bill', 0, '2024-03-16', 194, 5, 'Purchase Bill Transaction', '5500', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-18 12:07:23', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (441, 0, 'purchase_bill_transaction', 44, 'purchase_bill', 0, '2024-03-16', 194, 5, 'Purchase Bill Transaction', '180000', 1, 'CASH', '', '0000-00-00', '', 0, 14, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-18 12:08:06', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (442, 0, 'purchase_bill_transaction', 45, 'purchase_bill', 0, '2024-03-16', 194, 5, 'Purchase Bill Transaction', '20000', 1, 'CASH', '', '0000-00-00', '', 0, 12, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-18 12:09:50', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (443, 0, 'purchase_bill_transaction', 46, 'purchase_bill', 0, '2024-03-10', 190, 5, 'Purchase Bill Transaction', '6800', 1, 'CASH', '', '0000-00-00', '', 0, 14, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-18 12:26:50', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (444, 0, 'purchase_bill_transaction', 47, 'purchase_bill', 0, '2024-03-11', 190, 5, 'Purchase Bill Transaction', '6800', 1, 'CASH', '', '0000-00-00', '', 0, 14, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-18 12:27:50', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (445, 0, 'expense_bill_transaction', 322, 'expense_bill', 0, '2024-03-12', 190, 181, 'Expense Bill Transaction', '3360', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-18 13:30:58', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (446, 0, 'expense_bill_transaction', 323, 'expense_bill', 0, '2024-03-12', 190, 201, 'Expense Bill Transaction', '900', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-18 13:31:18', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (447, 0, 'expense_bill_transaction', 324, 'expense_bill', 0, '2024-03-13', 190, 177, 'Expense Bill Transaction', '10680', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-19 09:55:41', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (448, 0, 'expense_bill_transaction', 325, 'expense_bill', 0, '2024-03-13', 190, 177, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-19 09:57:49', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (449, 0, 'expense_bill_transaction', 326, 'expense_bill', 0, '2024-03-13', 190, 177, 'Expense Bill Transaction', '4450', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-19 10:03:57', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (450, 0, 'expense_bill_transaction', 327, 'expense_bill', 0, '2024-03-13', 190, 180, 'Expense Bill Transaction', '750', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-19 10:04:21', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (451, 0, 'purchase_bill_transaction', 48, 'purchase_bill', 0, '2024-03-14', 190, 5, 'Purchase Bill Transaction', '35000', 1, 'CASH', '', '0000-00-00', '', 0, 12, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-19 10:15:51', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (452, 0, 'purchase_bill_transaction', 49, 'purchase_bill', 0, '2024-03-14', 190, 5, 'Purchase Bill Transaction', '34100', 1, 'CASH', '', '0000-00-00', '', 0, 12, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-19 10:28:24', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (453, 0, 'purchase_bill_transaction', 50, 'purchase_bill', 0, '2024-03-14', 190, 5, 'Purchase Bill Transaction', '3650', 1, 'CASH', '', '0000-00-00', '', 0, 12, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-19 10:32:49', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (454, 0, 'client_payment_transaction', 14, 'project', 0, '2024-03-19', 2, 1, 'Client Payment Transaction', '200000', 0, '', '', '0000-00-00', '', 0, 14, '', 0, 0, 0, '200000', '0', '0', '', 0, '2024-03-19 14:59:52', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (455, 0, 'client_payment_transaction', 10, 'project', 0, '2024-03-18', 2, 1, 'Client Payment Transaction', '50000', 0, '', '', '0000-00-00', '', 0, 10, '', 0, 0, 0, '50000', '0', '0', '', 0, '2024-03-19 15:00:19', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (456, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-03-19', 1, 194, 'User Payment Receipt Transaction', '200000', 0, 'CASH', '', '0000-00-00', '116', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-19 15:00:39', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (457, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-03-18', 1, 194, 'User Payment Receipt Transaction', '50000', 0, 'CASH', '', '0000-00-00', '113', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-19 15:00:57', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (458, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-03-18', 1, 190, 'User Payment Receipt Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-19 15:01:12', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (459, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-03-18', 194, 1, 'User Payment Return Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-19 15:01:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (460, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-03-19', 1, 190, 'User Payment Receipt Transaction', '200000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-19 15:01:42', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (461, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-03-19', 194, 1, 'User Payment Return Transaction', '200000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-19 15:02:00', 1, '2024-03-19 15:02:17', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (462, 0, 'purchase_bill_transaction', 30, 'purchase_bill', 0, '2024-03-19', 194, 5, 'Purchase Bill Transaction', '50000', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-19 15:03:13', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (463, 0, 'purchase_bill_transaction', 51, 'purchase_bill', 0, '2024-03-20', 194, 5, 'Purchase Bill Transaction', '50000', 1, 'CASH', '', '0000-00-00', '', 0, 12, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-20 15:36:47', 1, '0000-00-00 00:00:00', 0, 1, 1, 1);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (464, 0, 'purchase_bill_transaction', 51, 'purchase_bill', 0, '2024-03-20', 194, 5, 'Purchase Bill Transaction', '50000', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-22 10:06:42', 1, '0000-00-00 00:00:00', 0, 1, 1, 1);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (465, 0, 'purchase_bill_transaction', 51, 'purchase_bill', 0, '2024-03-20', 194, 5, 'Purchase Bill Transaction', '3000', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-22 10:06:55', 1, '0000-00-00 00:00:00', 0, 1, 1, 1);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (466, 0, 'purchase_bill_transaction', 51, 'purchase_bill', 0, '2024-03-21', 194, 5, 'Purchase Bill Transaction', '27000', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-22 10:07:11', 1, '0000-00-00 00:00:00', 0, 1, 1, 1);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (467, 0, 'purchase_bill_transaction', 31, 'purchase_bill', 0, '2024-03-20', 194, 5, 'Purchase Bill Transaction', '5500', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-23 15:11:11', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (468, 0, 'purchase_bill_transaction', 22, 'purchase_bill', 0, '2024-03-20', 194, 5, 'Purchase Bill Transaction', '3300', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-23 15:11:26', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (469, 0, 'purchase_bill_transaction', 30, 'purchase_bill', 0, '2024-03-20', 194, 5, 'Purchase Bill Transaction', '25100', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-23 15:11:39', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (470, 0, 'purchase_bill_transaction', 45, 'purchase_bill', 0, '2024-03-20', 194, 5, 'Purchase Bill Transaction', '19000', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-23 15:12:35', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (471, 0, 'purchase_bill_transaction', 51, 'purchase_bill', 0, '2024-03-20', 194, 5, 'Purchase Bill Transaction', '50100', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-23 15:13:01', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (472, 0, 'purchase_bill_transaction', 51, 'purchase_bill', 0, '2024-03-21', 194, 5, 'Purchase Bill Transaction', '27000', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-23 15:13:12', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (473, 0, 'expense_bill_transaction', 328, 'expense_bill', 0, '2024-03-14', 190, 177, 'Expense Bill Transaction', '2600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:14:39', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (474, 0, 'expense_bill_transaction', 329, 'expense_bill', 0, '2024-03-14', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:16:02', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (475, 0, 'expense_bill_transaction', 330, 'expense_bill', 0, '2024-03-14', 190, 177, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:17:07', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (476, 0, 'expense_bill_transaction', 331, 'expense_bill', 0, '2024-03-14', 190, 177, 'Expense Bill Transaction', '10680', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:17:56', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (477, 0, 'expense_bill_transaction', 332, 'expense_bill', 0, '2024-03-15', 190, 177, 'Expense Bill Transaction', '10600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:30:37', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (478, 0, 'expense_bill_transaction', 333, 'expense_bill', 0, '2024-03-15', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:31:44', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (479, 0, 'expense_bill_transaction', 334, 'expense_bill', 0, '2024-03-15', 190, 177, 'Expense Bill Transaction', '11400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:32:35', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (480, 0, 'expense_bill_transaction', 335, 'expense_bill', 0, '2024-03-15', 190, 180, 'Expense Bill Transaction', '2250', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:33:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (481, 0, 'expense_bill_transaction', 336, 'expense_bill', 0, '2024-03-15', 190, 206, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:35:27', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (482, 0, 'expense_bill_transaction', 337, 'expense_bill', 0, '2024-03-15', 190, 181, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:36:09', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (483, 0, 'expense_bill_transaction', 338, 'expense_bill', 0, '2024-03-15', 190, 177, 'Expense Bill Transaction', '8200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:37:02', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (484, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-03-16', 1, 190, 'User Payment Receipt Transaction', '25000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:40:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (485, 0, 'expense_bill_transaction', 339, 'expense_bill', 0, '2024-03-16', 190, 179, 'Expense Bill Transaction', '5010', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:41:34', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (486, 0, 'expense_bill_transaction', 340, 'expense_bill', 0, '2024-03-16', 190, 206, 'Expense Bill Transaction', '960', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:42:13', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (487, 0, 'expense_bill_transaction', 341, 'expense_bill', 0, '2024-03-16', 190, 181, 'Expense Bill Transaction', '700', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:43:08', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (488, 0, 'expense_bill_transaction', 342, 'expense_bill', 0, '2024-03-16', 190, 181, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:43:51', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (489, 0, 'expense_bill_transaction', 343, 'expense_bill', 0, '2024-03-16', 190, 177, 'Expense Bill Transaction', '4000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:44:42', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (490, 0, 'expense_bill_transaction', 344, 'expense_bill', 0, '2024-03-16', 190, 177, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:45:44', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (491, 0, 'expense_bill_transaction', 345, 'expense_bill', 0, '2024-03-16', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:46:50', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (492, 0, 'expense_bill_transaction', 346, 'expense_bill', 0, '2024-03-16', 190, 181, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:47:50', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (493, 0, 'expense_bill_transaction', 347, 'expense_bill', 0, '2024-03-16', 190, 177, 'Expense Bill Transaction', '9600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:48:35', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (494, 0, 'expense_bill_transaction', 348, 'expense_bill', 0, '2024-03-16', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:49:31', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (495, 0, 'expense_bill_transaction', 349, 'expense_bill', 0, '2024-03-16', 190, 177, 'Expense Bill Transaction', '8200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:50:31', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (496, 0, 'expense_bill_transaction', 350, 'expense_bill', 0, '2024-03-16', 190, 183, 'Expense Bill Transaction', '300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:51:37', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (497, 0, 'expense_bill_transaction', 351, 'expense_bill', 0, '2024-03-16', 190, 183, 'Expense Bill Transaction', '500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:52:32', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (498, 0, 'expense_bill_transaction', 352, 'expense_bill', 0, '2024-03-16', 190, 179, 'Expense Bill Transaction', '5010', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:53:44', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (499, 0, 'expense_bill_transaction', 353, 'expense_bill', 0, '2024-03-16', 190, 206, 'Expense Bill Transaction', '960', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:54:52', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (500, 0, 'expense_bill_transaction', 354, 'expense_bill', 0, '2024-03-16', 190, 181, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:55:48', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (501, 0, 'expense_bill_transaction', 355, 'expense_bill', 0, '2024-03-17', 190, 181, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:56:55', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (502, 0, 'expense_bill_transaction', 356, 'expense_bill', 0, '2024-03-17', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:58:02', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (503, 0, 'expense_bill_transaction', 357, 'expense_bill', 0, '2024-03-17', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:59:04', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (504, 0, 'expense_bill_transaction', 358, 'expense_bill', 0, '2024-03-17', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 14:59:52', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (505, 0, 'expense_bill_transaction', 359, 'expense_bill', 0, '2024-03-17', 190, 181, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:00:45', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (506, 0, 'expense_bill_transaction', 360, 'expense_bill', 0, '2024-03-17', 190, 183, 'Expense Bill Transaction', '300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:01:27', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (507, 0, 'expense_bill_transaction', 361, 'expense_bill', 0, '2024-03-17', 190, 183, 'Expense Bill Transaction', '500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:02:30', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (508, 0, 'expense_bill_transaction', 362, 'expense_bill', 0, '2024-03-17', 190, 183, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:03:47', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (509, 0, 'expense_bill_transaction', 363, 'expense_bill', 0, '2024-03-17', 190, 181, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:04:39', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (510, 0, 'expense_bill_transaction', 364, 'expense_bill', 0, '2024-03-17', 190, 206, 'Expense Bill Transaction', '510', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:05:37', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (511, 0, 'expense_bill_transaction', 365, 'expense_bill', 0, '2024-03-18', 190, 177, 'Expense Bill Transaction', '7600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:10:08', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (512, 0, 'expense_bill_transaction', 366, 'expense_bill', 0, '2024-03-18', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:11:05', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (513, 0, 'expense_bill_transaction', 367, 'expense_bill', 0, '2024-03-18', 190, 177, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:12:01', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (514, 0, 'expense_bill_transaction', 368, 'expense_bill', 0, '2024-03-18', 190, 177, 'Expense Bill Transaction', '3900', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:13:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (515, 0, 'expense_bill_transaction', 369, 'expense_bill', 0, '2024-03-18', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:14:42', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (516, 0, 'expense_bill_transaction', 370, 'expense_bill', 0, '2024-03-18', 190, 181, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:15:49', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (517, 0, 'expense_bill_transaction', 371, 'expense_bill', 0, '2024-03-18', 190, 181, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:16:51', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (518, 0, 'expense_bill_transaction', 372, 'expense_bill', 0, '2024-03-18', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:17:46', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (519, 0, 'expense_bill_transaction', 373, 'expense_bill', 0, '2024-03-18', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:19:12', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (520, 0, 'expense_bill_transaction', 374, 'expense_bill', 0, '2024-03-18', 190, 181, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:20:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (521, 0, 'expense_bill_transaction', 375, 'expense_bill', 0, '2024-03-18', 190, 183, 'Expense Bill Transaction', '300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:21:41', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (522, 0, 'expense_bill_transaction', 376, 'expense_bill', 0, '2024-03-18', 190, 183, 'Expense Bill Transaction', '500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:23:06', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (523, 0, 'expense_bill_transaction', 377, 'expense_bill', 0, '2024-03-18', 190, 177, 'Expense Bill Transaction', '22400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:25:12', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (524, 0, 'expense_bill_transaction', 378, 'expense_bill', 0, '2024-03-18', 190, 206, 'Expense Bill Transaction', '3600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:26:06', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (525, 0, 'expense_bill_transaction', 379, 'expense_bill', 0, '2024-03-18', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:27:01', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (526, 0, 'expense_bill_transaction', 380, 'expense_bill', 0, '2024-03-19', 190, 177, 'Expense Bill Transaction', '7600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:28:00', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (527, 0, 'expense_bill_transaction', 381, 'expense_bill', 0, '2024-03-19', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:29:08', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (528, 0, 'expense_bill_transaction', 382, 'expense_bill', 0, '2024-03-19', 190, 177, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:30:04', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (529, 0, 'expense_bill_transaction', 383, 'expense_bill', 0, '2024-03-19', 190, 177, 'Expense Bill Transaction', '300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:31:08', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (530, 0, 'expense_bill_transaction', 384, 'expense_bill', 0, '2024-03-19', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:32:21', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (531, 0, 'expense_bill_transaction', 385, 'expense_bill', 0, '2024-03-19', 190, 181, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:33:18', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (532, 0, 'expense_bill_transaction', 386, 'expense_bill', 0, '2024-03-19', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:34:15', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (533, 0, 'expense_bill_transaction', 387, 'expense_bill', 0, '2024-03-19', 190, 181, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:35:08', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (534, 0, 'expense_bill_transaction', 388, 'expense_bill', 0, '2024-03-19', 190, 177, 'Expense Bill Transaction', '8200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:35:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (535, 0, 'expense_bill_transaction', 389, 'expense_bill', 0, '2024-03-19', 190, 206, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:36:40', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (536, 0, 'expense_bill_transaction', 390, 'expense_bill', 0, '2024-03-19', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:37:56', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (537, 0, 'expense_bill_transaction', 391, 'expense_bill', 0, '2024-03-19', 190, 183, 'Expense Bill Transaction', '300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:39:03', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (538, 0, 'expense_bill_transaction', 392, 'expense_bill', 0, '2024-03-19', 190, 183, 'Expense Bill Transaction', '500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:39:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (539, 0, 'expense_bill_transaction', 393, 'expense_bill', 0, '2024-03-20', 190, 177, 'Expense Bill Transaction', '7600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:47:27', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (540, 0, 'expense_bill_transaction', 394, 'expense_bill', 0, '2024-03-20', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:48:34', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (541, 0, 'expense_bill_transaction', 395, 'expense_bill', 0, '2024-03-20', 190, 177, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:49:32', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (542, 0, 'expense_bill_transaction', 396, 'expense_bill', 0, '2024-03-20', 190, 177, 'Expense Bill Transaction', '3600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:50:32', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (543, 0, 'expense_bill_transaction', 397, 'expense_bill', 0, '2024-03-20', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:51:21', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (544, 0, 'expense_bill_transaction', 398, 'expense_bill', 0, '2024-03-20', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:52:29', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (545, 0, 'expense_bill_transaction', 399, 'expense_bill', 0, '2024-03-20', 190, 181, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:53:16', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (546, 0, 'expense_bill_transaction', 400, 'expense_bill', 0, '2024-03-20', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:54:10', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (547, 0, 'expense_bill_transaction', 401, 'expense_bill', 0, '2024-03-20', 190, 181, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:54:59', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (548, 0, 'expense_bill_transaction', 402, 'expense_bill', 0, '2024-03-20', 190, 177, 'Expense Bill Transaction', '10200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:57:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (549, 0, 'expense_bill_transaction', 403, 'expense_bill', 0, '2024-03-20', 190, 206, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:58:59', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (550, 0, 'expense_bill_transaction', 404, 'expense_bill', 0, '2024-03-20', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 15:59:57', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (551, 0, 'expense_bill_transaction', 405, 'expense_bill', 0, '2024-03-20', 190, 183, 'Expense Bill Transaction', '300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:00:41', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (552, 0, 'expense_bill_transaction', 406, 'expense_bill', 0, '2024-03-20', 190, 183, 'Expense Bill Transaction', '500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:02:03', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (553, 0, 'expense_bill_transaction', 407, 'expense_bill', 0, '2024-03-21', 190, 177, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:03:00', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (554, 0, 'expense_bill_transaction', 408, 'expense_bill', 0, '2024-03-21', 190, 177, 'Expense Bill Transaction', '4600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:04:06', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (555, 0, 'expense_bill_transaction', 409, 'expense_bill', 0, '2024-03-21', 190, 177, 'Expense Bill Transaction', '7300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:05:08', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (556, 0, 'client_payment_transaction', 14, 'project', 0, '2024-03-24', 2, 1, 'Client Payment Transaction', '150000', 0, '', '', '0000-00-00', '', 0, 14, '', 0, 0, 0, '150000', '0', '0', '', 0, '2024-03-25 16:05:55', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (557, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-03-24', 1, 194, 'User Payment Receipt Transaction', '150000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:06:12', 1, '0000-00-00 00:00:00', 0, 1, 1, 1);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (558, 0, 'expense_bill_transaction', 410, 'expense_bill', 0, '2024-03-21', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:10:29', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (559, 0, 'expense_bill_transaction', 411, 'expense_bill', 0, '2024-03-21', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:11:16', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (560, 0, 'expense_bill_transaction', 412, 'expense_bill', 0, '2024-03-21', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:12:40', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (561, 0, 'expense_bill_transaction', 413, 'expense_bill', 0, '2024-03-21', 190, 181, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:14:14', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (562, 0, 'expense_bill_transaction', 414, 'expense_bill', 0, '2024-03-21', 190, 177, 'Expense Bill Transaction', '8200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:17:14', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (563, 0, 'expense_bill_transaction', 415, 'expense_bill', 0, '2024-03-21', 190, 206, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:18:06', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (564, 0, 'expense_bill_transaction', 416, 'expense_bill', 0, '2024-03-21', 190, 177, 'Expense Bill Transaction', '4500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:19:06', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (565, 0, 'expense_bill_transaction', 417, 'expense_bill', 0, '2024-03-21', 190, 180, 'Expense Bill Transaction', '2250', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:20:21', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (566, 0, 'expense_bill_transaction', 418, 'expense_bill', 0, '2024-03-21', 190, 181, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:26:33', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (567, 0, 'expense_bill_transaction', 419, 'expense_bill', 0, '2024-03-21', 190, 183, 'Expense Bill Transaction', '300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:27:27', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (568, 0, 'expense_bill_transaction', 420, 'expense_bill', 0, '2024-03-21', 190, 183, 'Expense Bill Transaction', '300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:29:41', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (569, 0, 'expense_bill_transaction', 421, 'expense_bill', 0, '2024-03-22', 190, 177, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:30:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (570, 0, 'expense_bill_transaction', 422, 'expense_bill', 0, '2024-03-22', 190, 177, 'Expense Bill Transaction', '6300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:31:07', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (571, 0, 'expense_bill_transaction', 423, 'expense_bill', 0, '2024-03-22', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:32:05', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (572, 0, 'expense_bill_transaction', 424, 'expense_bill', 0, '2024-03-22', 190, 177, 'Expense Bill Transaction', '4900', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:33:04', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (573, 0, 'expense_bill_transaction', 425, 'expense_bill', 0, '2024-03-22', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:33:50', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (574, 0, 'expense_bill_transaction', 426, 'expense_bill', 0, '2024-03-22', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:35:58', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (575, 0, 'expense_bill_transaction', 427, 'expense_bill', 0, '2024-03-22', 190, 181, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:36:44', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (576, 0, 'expense_bill_transaction', 428, 'expense_bill', 0, '2024-03-22', 190, 177, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:37:46', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (577, 0, 'expense_bill_transaction', 429, 'expense_bill', 0, '2024-03-22', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-25 16:38:37', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (578, 0, 'expense_bill_transaction', 430, 'expense_bill', 0, '2024-03-22', 190, 181, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:04:56', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (579, 0, 'expense_bill_transaction', 431, 'expense_bill', 0, '2024-03-22', 190, 177, 'Expense Bill Transaction', '3800', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:05:30', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (580, 0, 'expense_bill_transaction', 432, 'expense_bill', 0, '2024-03-22', 190, 183, 'Expense Bill Transaction', '300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:06:13', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (581, 0, 'expense_bill_transaction', 433, 'expense_bill', 0, '2024-03-22', 190, 183, 'Expense Bill Transaction', '300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:06:37', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (582, 0, 'expense_bill_transaction', 434, 'expense_bill', 0, '2024-03-22', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:07:04', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (583, 0, 'expense_bill_transaction', 435, 'expense_bill', 0, '2024-03-22', 190, 180, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:07:31', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (584, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-03-22', 1, 190, 'User Payment Receipt Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:09:10', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (585, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-03-22', 194, 1, 'User Payment Return Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:09:31', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (586, 0, 'expense_bill_transaction', 436, 'expense_bill', 0, '2024-03-23', 190, 177, 'Expense Bill Transaction', '8600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:14:03', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (587, 0, 'expense_bill_transaction', 438, 'expense_bill', 0, '2024-03-23', 190, 183, 'Expense Bill Transaction', '300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:16:46', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (588, 0, 'expense_bill_transaction', 437, 'expense_bill', 0, '2024-03-23', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:17:08', 1, '2024-03-26 14:58:12', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (589, 0, 'expense_bill_transaction', 439, 'expense_bill', 0, '2024-03-23', 190, 183, 'Expense Bill Transaction', '300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:17:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (590, 0, 'expense_bill_transaction', 440, 'expense_bill', 0, '2024-03-23', 190, 177, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:19:44', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (591, 0, 'expense_bill_transaction', 441, 'expense_bill', 0, '2024-03-23', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:20:26', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (592, 0, 'expense_bill_transaction', 442, 'expense_bill', 0, '2024-03-23', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:20:58', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (593, 0, 'expense_bill_transaction', 443, 'expense_bill', 0, '2024-03-23', 190, 181, 'Expense Bill Transaction', '1400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:21:46', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (594, 0, 'expense_bill_transaction', 444, 'expense_bill', 0, '2024-03-23', 190, 181, 'Expense Bill Transaction', '600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:23:10', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (595, 0, 'expense_bill_transaction', 445, 'expense_bill', 0, '2024-03-23', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:23:54', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (596, 0, 'expense_bill_transaction', 446, 'expense_bill', 0, '2024-03-23', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:24:43', 1, '2024-03-26 15:01:51', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (597, 0, 'expense_bill_transaction', 447, 'expense_bill', 0, '2024-03-23', 190, 177, 'Expense Bill Transaction', '8700', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:25:31', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (598, 0, 'expense_bill_transaction', 448, 'expense_bill', 0, '2024-03-23', 190, 180, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:26:14', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (599, 0, 'expense_bill_transaction', 449, 'expense_bill', 0, '2024-03-23', 190, 180, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:27:30', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (600, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-03-23', 1, 190, 'User Payment Receipt Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:31:36', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (601, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-03-23', 194, 1, 'User Payment Return Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:33:29', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (602, 0, 'expense_bill_transaction', 450, 'expense_bill', 0, '2024-03-24', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:34:11', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (603, 0, 'expense_bill_transaction', 451, 'expense_bill', 0, '2024-03-24', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:34:40', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (604, 0, 'expense_bill_transaction', 452, 'expense_bill', 0, '2024-03-24', 190, 181, 'Expense Bill Transaction', '700', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:35:05', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (605, 0, 'expense_bill_transaction', 453, 'expense_bill', 0, '2024-03-24', 190, 177, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:35:33', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (606, 0, 'purchase_bill_transaction', 51, 'purchase_bill', 0, '2024-03-26', 194, 5, 'Purchase Bill Transaction', '20400', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:35:43', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (607, 0, 'expense_bill_transaction', 454, 'expense_bill', 0, '2024-03-24', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:36:11', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (608, 0, 'expense_bill_transaction', 455, 'expense_bill', 0, '2024-03-24', 190, 181, 'Expense Bill Transaction', '700', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:36:58', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (609, 0, 'expense_bill_transaction', 456, 'expense_bill', 0, '2024-03-24', 190, 177, 'Expense Bill Transaction', '14600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:37:35', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (610, 0, 'expense_bill_transaction', 457, 'expense_bill', 0, '2024-03-24', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:38:13', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (611, 0, 'expense_bill_transaction', 458, 'expense_bill', 0, '2024-03-24', 190, 177, 'Expense Bill Transaction', '7300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:38:45', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (612, 0, 'expense_bill_transaction', 459, 'expense_bill', 0, '2024-03-24', 190, 180, 'Expense Bill Transaction', '600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:39:19', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (613, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-03-24', 1, 190, 'User Payment Receipt Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:39:40', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (614, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-03-24', 194, 1, 'User Payment Return Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:40:46', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (615, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-03-24', 1, 190, 'User Payment Receipt Transaction', '60000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:41:33', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (616, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-03-24', 194, 1, 'User Payment Return Transaction', '60000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:41:51', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (617, 0, 'expense_bill_transaction', 460, 'expense_bill', 0, '2024-03-25', 190, 177, 'Expense Bill Transaction', '12600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:42:56', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (618, 0, 'expense_bill_transaction', 461, 'expense_bill', 0, '2024-03-25', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:43:21', 1, '0000-00-00 00:00:00', 0, 1, 1, 1);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (619, 0, 'expense_bill_transaction', 461, 'expense_bill', 0, '2024-03-25', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:44:25', 1, '2024-03-26 14:55:43', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (620, 0, 'expense_bill_transaction', 462, 'expense_bill', 0, '2024-03-25', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:44:58', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (621, 0, 'expense_bill_transaction', 463, 'expense_bill', 0, '2024-03-25', 190, 177, 'Expense Bill Transaction', '6600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:45:35', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (622, 0, 'expense_bill_transaction', 464, 'expense_bill', 0, '2024-03-25', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:46:15', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (623, 0, 'expense_bill_transaction', 465, 'expense_bill', 0, '2024-03-25', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:46:43', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (624, 0, 'expense_bill_transaction', 466, 'expense_bill', 0, '2024-03-25', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 14:47:13', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (625, 0, 'expense_bill_transaction', 467, 'expense_bill', 0, '2024-03-25', 190, 177, 'Expense Bill Transaction', '9100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 15:15:35', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (626, 0, 'expense_bill_transaction', 468, 'expense_bill', 0, '2024-03-25', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 15:16:40', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (627, 0, 'expense_bill_transaction', 469, 'expense_bill', 0, '2024-03-25', 190, 206, 'Expense Bill Transaction', '2900', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 15:17:05', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (628, 0, 'expense_bill_transaction', 470, 'expense_bill', 0, '2024-03-25', 190, 183, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 16:29:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (629, 0, 'expense_bill_transaction', 471, 'expense_bill', 0, '2024-03-25', 190, 206, 'Expense Bill Transaction', '400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 16:29:50', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (630, 0, 'expense_bill_transaction', 472, 'expense_bill', 0, '2024-03-25', 190, 183, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 16:30:28', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (631, 0, 'expense_bill_transaction', 473, 'expense_bill', 0, '2024-03-25', 190, 183, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 16:31:09', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (632, 0, 'expense_bill_transaction', 474, 'expense_bill', 0, '2024-03-25', 190, 206, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 16:31:48', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (633, 0, 'expense_bill_transaction', 475, 'expense_bill', 0, '2024-03-25', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-26 16:32:24', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (634, 0, 'user_payment_receipt_transaction', 191, 'user_account_head', 0, '2024-03-25', 1, 191, 'User Payment Receipt Transaction', '465000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-28 16:24:58', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (635, 0, 'expense_bill_transaction', 476, 'expense_bill', 0, '2024-03-25', 191, 195, 'Expense Bill Transaction', '465000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-28 16:26:03', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (636, 0, 'expense_bill_transaction', 477, 'expense_bill', 0, '2024-03-14', 194, 177, 'Expense Bill Transaction', '5300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-28 16:37:08', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (637, 0, 'expense_bill_transaction', 478, 'expense_bill', 0, '2024-03-15', 194, 181, 'Expense Bill Transaction', '7500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-28 16:37:55', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (638, 0, 'expense_bill_transaction', 479, 'expense_bill', 0, '2024-03-15', 194, 181, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-28 16:42:56', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (639, 0, 'expense_bill_transaction', 480, 'expense_bill', 0, '2024-03-15', 194, 177, 'Expense Bill Transaction', '4350', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-28 16:43:16', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (640, 0, 'purchase_bill_transaction', 52, 'purchase_bill', 0, '2024-03-15', 194, 5, 'Purchase Bill Transaction', '2950', 1, 'CASH', '', '0000-00-00', '', 0, 12, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-28 16:44:52', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (641, 0, 'expense_bill_transaction', 481, 'expense_bill', 0, '2024-03-16', 194, 176, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-28 16:45:42', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (642, 0, 'expense_bill_transaction', 482, 'expense_bill', 0, '2024-03-19', 194, 177, 'Expense Bill Transaction', '4400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-28 16:47:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (643, 0, 'purchase_bill_transaction', 53, 'purchase_bill', 0, '2024-03-19', 194, 5, 'Purchase Bill Transaction', '2050', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-28 16:48:06', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (644, 0, 'purchase_bill_transaction', 54, 'purchase_bill', 0, '2024-03-21', 194, 5, 'Purchase Bill Transaction', '4800', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-28 16:49:38', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (645, 0, 'purchase_bill_transaction', 55, 'purchase_bill', 0, '2024-03-21', 194, 5, 'Purchase Bill Transaction', '2050', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-28 16:50:12', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (646, 0, 'expense_bill_transaction', 483, 'expense_bill', 0, '2024-03-21', 194, 176, 'Expense Bill Transaction', '27000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-28 16:50:48', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (647, 0, 'expense_bill_transaction', 484, 'expense_bill', 0, '2024-03-21', 194, 181, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-28 16:51:04', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (648, 0, 'expense_bill_transaction', 485, 'expense_bill', 0, '2024-03-22', 194, 177, 'Expense Bill Transaction', '4400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-28 16:52:01', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (649, 0, 'expense_bill_transaction', 486, 'expense_bill', 0, '2024-01-27', 190, 183, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 09:42:21', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (650, 0, 'expense_bill_transaction', 487, 'expense_bill', 0, '2024-01-27', 190, 206, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 09:43:00', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (651, 0, 'expense_bill_transaction', 488, 'expense_bill', 0, '2024-01-28', 190, 183, 'Expense Bill Transaction', '680', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 09:43:45', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (652, 0, 'expense_bill_transaction', 489, 'expense_bill', 0, '2024-01-29', 190, 183, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 09:44:38', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (653, 0, 'expense_bill_transaction', 490, 'expense_bill', 0, '2024-01-29', 190, 206, 'Expense Bill Transaction', '1890', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 09:45:11', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (654, 0, 'expense_bill_transaction', 491, 'expense_bill', 0, '2024-01-29', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 09:45:46', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (655, 0, 'expense_bill_transaction', 492, 'expense_bill', 0, '2024-01-29', 190, 181, 'Expense Bill Transaction', '2800', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 09:46:21', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (656, 0, 'expense_bill_transaction', 493, 'expense_bill', 0, '2024-01-29', 190, 201, 'Expense Bill Transaction', '4110', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 09:47:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (657, 0, 'expense_bill_transaction', 494, 'expense_bill', 0, '2024-01-29', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 09:48:08', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (658, 0, 'expense_bill_transaction', 495, 'expense_bill', 0, '2024-01-30', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 09:49:09', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (659, 0, 'expense_bill_transaction', 496, 'expense_bill', 0, '2024-01-30', 190, 206, 'Expense Bill Transaction', '1390', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 09:49:43', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (660, 0, 'expense_bill_transaction', 497, 'expense_bill', 0, '2024-01-30', 190, 183, 'Expense Bill Transaction', '3390', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 09:50:20', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (661, 0, 'expense_bill_transaction', 498, 'expense_bill', 0, '2024-01-31', 190, 177, 'Expense Bill Transaction', '7500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 09:50:50', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (662, 0, 'expense_bill_transaction', 499, 'expense_bill', 0, '2024-02-12', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:04:50', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (663, 0, 'expense_bill_transaction', 500, 'expense_bill', 0, '2024-02-12', 190, 179, 'Expense Bill Transaction', '4000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:05:27', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (664, 0, 'expense_bill_transaction', 501, 'expense_bill', 0, '2024-02-12', 190, 206, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:06:06', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (665, 0, 'expense_bill_transaction', 502, 'expense_bill', 0, '2024-02-12', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:06:38', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (666, 0, 'expense_bill_transaction', 503, 'expense_bill', 0, '2024-02-12', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:07:11', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (667, 0, 'expense_bill_transaction', 504, 'expense_bill', 0, '2024-02-12', 190, 177, 'Expense Bill Transaction', '4500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:07:54', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (668, 0, 'expense_bill_transaction', 505, 'expense_bill', 0, '2024-02-12', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:08:26', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (669, 0, 'expense_bill_transaction', 506, 'expense_bill', 0, '2024-02-12', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:09:54', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (670, 0, 'expense_bill_transaction', 507, 'expense_bill', 0, '2024-02-12', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:10:32', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (671, 0, 'expense_bill_transaction', 508, 'expense_bill', 0, '2024-02-12', 190, 206, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:12:11', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (672, 0, 'expense_bill_transaction', 509, 'expense_bill', 0, '2024-02-12', 190, 177, 'Expense Bill Transaction', '2400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:12:47', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (673, 0, 'expense_bill_transaction', 510, 'expense_bill', 0, '2024-02-13', 190, 177, 'Expense Bill Transaction', '7500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:25:26', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (674, 0, 'expense_bill_transaction', 511, 'expense_bill', 0, '2024-02-13', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:26:12', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (675, 0, 'expense_bill_transaction', 512, 'expense_bill', 0, '2024-02-13', 190, 177, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:27:10', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (676, 0, 'expense_bill_transaction', 513, 'expense_bill', 0, '2024-02-13', 190, 179, 'Expense Bill Transaction', '500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:27:48', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (677, 0, 'expense_bill_transaction', 514, 'expense_bill', 0, '2024-02-13', 190, 179, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:29:07', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (678, 0, 'expense_bill_transaction', 515, 'expense_bill', 0, '2024-02-13', 190, 177, 'Expense Bill Transaction', '7500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:30:14', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (679, 0, 'expense_bill_transaction', 516, 'expense_bill', 0, '2024-02-13', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:30:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (680, 0, 'expense_bill_transaction', 517, 'expense_bill', 0, '2024-02-14', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:31:37', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (681, 0, 'expense_bill_transaction', 518, 'expense_bill', 0, '2024-02-14', 190, 177, 'Expense Bill Transaction', '4500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:32:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (682, 0, 'expense_bill_transaction', 519, 'expense_bill', 0, '2024-02-14', 190, 177, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:33:04', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (683, 0, 'expense_bill_transaction', 520, 'expense_bill', 0, '2024-02-19', 190, 179, 'Expense Bill Transaction', '10000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:35:16', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (684, 0, 'expense_bill_transaction', 521, 'expense_bill', 0, '2024-02-19', 190, 206, 'Expense Bill Transaction', '2200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:35:48', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (685, 0, 'expense_bill_transaction', 522, 'expense_bill', 0, '2024-02-19', 190, 181, 'Expense Bill Transaction', '2200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:36:21', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (686, 0, 'purchase_bill_transaction', 56, 'purchase_bill', 0, '2024-02-19', 190, 5, 'Purchase Bill Transaction', '10000', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:38:00', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (687, 0, 'expense_bill_transaction', 523, 'expense_bill', 0, '2024-03-23', 194, 177, 'Expense Bill Transaction', '5400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:38:44', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (688, 0, 'purchase_bill_transaction', 57, 'purchase_bill', 0, '2024-03-23', 194, 5, 'Purchase Bill Transaction', '3950', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:40:07', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (689, 0, 'purchase_bill_transaction', 58, 'purchase_bill', 0, '2024-03-23', 194, 5, 'Purchase Bill Transaction', '60600', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:40:50', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (690, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-03-26', 1, 190, 'User Payment Receipt Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:43:36', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (691, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-03-26', 1, 190, 'User Payment Receipt Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:43:51', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (692, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-03-26', 194, 1, 'User Payment Return Transaction', '55000', 0, 'CASH', '', '0000-00-00', '5000+50000', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 10:44:24', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (693, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-03-24', 1, 194, 'User Payment Receipt Transaction', '150000', 0, 'CASH', '', '0000-00-00', '116', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-29 11:09:08', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (694, 0, 'expense_bill_transaction', 524, 'expense_bill', 0, '2024-02-19', 190, 20, 'Expense Bill Transaction', '7500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 12:10:49', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (695, 0, 'purchase_bill_transaction', 59, 'purchase_bill', 0, '2024-02-19', 190, 5, 'Purchase Bill Transaction', '163450', 1, 'CASH', '', '0000-00-00', '', 0, 4, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 12:14:24', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (696, 0, 'purchase_bill_transaction', 60, 'purchase_bill', 0, '2024-02-19', 190, 5, 'Purchase Bill Transaction', '51700', 1, 'CASH', '', '0000-00-00', '', 0, 4, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 12:16:35', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (697, 0, 'purchase_bill_transaction', 61, 'purchase_bill', 0, '2024-02-19', 190, 5, 'Purchase Bill Transaction', '11000', 1, 'CASH', '', '0000-00-00', '', 0, 4, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 12:18:46', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (698, 0, 'purchase_bill_transaction', 62, 'purchase_bill', 0, '2024-02-19', 190, 5, 'Purchase Bill Transaction', '33600', 1, 'CASH', '', '0000-00-00', '', 0, 4, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 12:20:43', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (699, 0, 'purchase_bill_transaction', 63, 'purchase_bill', 0, '2024-02-19', 190, 5, 'Purchase Bill Transaction', '7300', 1, 'CASH', '', '0000-00-00', '', 0, 4, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 12:21:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (700, 0, 'purchase_bill_transaction', 64, 'purchase_bill', 0, '2024-02-19', 190, 5, 'Purchase Bill Transaction', '11300', 1, 'CASH', '', '0000-00-00', '', 0, 4, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 12:24:09', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (701, 0, 'expense_bill_transaction', 525, 'expense_bill', 0, '2024-02-19', 190, 179, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 12:25:36', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (702, 0, 'expense_bill_transaction', 526, 'expense_bill', 0, '2024-02-19', 190, 20, 'Expense Bill Transaction', '3500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 12:27:12', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (703, 0, 'expense_bill_transaction', 527, 'expense_bill', 0, '2024-02-19', 190, 201, 'Expense Bill Transaction', '500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 12:28:17', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (704, 0, 'purchase_bill_transaction', 65, 'purchase_bill', 0, '2024-02-19', 190, 5, 'Purchase Bill Transaction', '1850', 1, 'CASH', '', '0000-00-00', '', 0, 4, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 12:31:36', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (705, 0, 'expense_bill_transaction', 528, 'expense_bill', 0, '2024-02-21', 190, 183, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:10:56', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (706, 0, 'expense_bill_transaction', 529, 'expense_bill', 0, '2024-02-21', 190, 192, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:12:02', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (707, 0, 'expense_bill_transaction', 530, 'expense_bill', 0, '2024-02-21', 190, 179, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:13:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (708, 0, 'expense_bill_transaction', 531, 'expense_bill', 0, '2024-02-21', 190, 206, 'Expense Bill Transaction', '350', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:19:26', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (709, 0, 'expense_bill_transaction', 532, 'expense_bill', 0, '2024-02-21', 190, 181, 'Expense Bill Transaction', '1800', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:20:43', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (710, 0, 'expense_bill_transaction', 533, 'expense_bill', 0, '2024-02-21', 190, 192, 'Expense Bill Transaction', '40', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:21:45', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (711, 0, 'expense_bill_transaction', 534, 'expense_bill', 0, '2024-02-21', 190, 206, 'Expense Bill Transaction', '1090', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:22:15', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (712, 0, 'expense_bill_transaction', 535, 'expense_bill', 0, '2024-02-21', 190, 181, 'Expense Bill Transaction', '1800', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:22:45', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (713, 0, 'expense_bill_transaction', 536, 'expense_bill', 0, '2024-02-21', 190, 201, 'Expense Bill Transaction', '200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:23:32', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (714, 0, 'expense_bill_transaction', 537, 'expense_bill', 0, '2024-02-21', 190, 206, 'Expense Bill Transaction', '140', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:24:13', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (715, 0, 'expense_bill_transaction', 538, 'expense_bill', 0, '2024-02-23', 190, 179, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:30:37', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (716, 0, 'expense_bill_transaction', 539, 'expense_bill', 0, '2024-02-23', 190, 183, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:32:02', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (717, 0, 'expense_bill_transaction', 540, 'expense_bill', 0, '2024-02-23', 190, 206, 'Expense Bill Transaction', '1420', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:32:42', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (718, 0, 'purchase_bill_transaction', 66, 'purchase_bill', 0, '2024-02-23', 190, 5, 'Purchase Bill Transaction', '500', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:36:28', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (719, 0, 'purchase_bill_transaction', 67, 'purchase_bill', 0, '2024-02-23', 190, 5, 'Purchase Bill Transaction', '8640', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:38:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (720, 0, 'expense_bill_transaction', 541, 'expense_bill', 0, '2024-03-26', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:46:43', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (721, 0, 'expense_bill_transaction', 542, 'expense_bill', 0, '2024-03-26', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:47:29', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (722, 0, 'expense_bill_transaction', 543, 'expense_bill', 0, '2024-03-26', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:48:19', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (723, 0, 'expense_bill_transaction', 544, 'expense_bill', 0, '2024-03-26', 190, 177, 'Expense Bill Transaction', '14000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:49:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (724, 0, 'expense_bill_transaction', 545, 'expense_bill', 0, '2024-03-26', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:50:49', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (725, 0, 'expense_bill_transaction', 546, 'expense_bill', 0, '2024-03-26', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:51:32', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (726, 0, 'expense_bill_transaction', 547, 'expense_bill', 0, '2024-03-27', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:53:11', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (727, 0, 'expense_bill_transaction', 548, 'expense_bill', 0, '2024-03-27', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:54:40', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (728, 0, 'expense_bill_transaction', 549, 'expense_bill', 0, '2024-03-27', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:55:24', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (729, 0, 'expense_bill_transaction', 550, 'expense_bill', 0, '2024-03-27', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:56:18', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (730, 0, 'expense_bill_transaction', 551, 'expense_bill', 0, '2024-03-27', 190, 181, 'Expense Bill Transaction', '700', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:58:24', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (731, 0, 'expense_bill_transaction', 552, 'expense_bill', 0, '2024-03-27', 190, 177, 'Expense Bill Transaction', '12000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 15:59:33', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (732, 0, 'expense_bill_transaction', 553, 'expense_bill', 0, '2024-03-27', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 16:00:35', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (733, 0, 'expense_bill_transaction', 554, 'expense_bill', 0, '2024-03-28', 190, 177, 'Expense Bill Transaction', '12000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 16:02:34', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (734, 0, 'expense_bill_transaction', 555, 'expense_bill', 0, '2024-03-28', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 16:03:24', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (735, 0, 'expense_bill_transaction', 556, 'expense_bill', 0, '2024-03-28', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 16:04:31', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (736, 0, 'expense_bill_transaction', 557, 'expense_bill', 0, '2024-03-29', 190, 180, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 16:05:18', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (737, 0, 'expense_bill_transaction', 558, 'expense_bill', 0, '2024-03-29', 190, 180, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 16:06:00', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (738, 0, 'expense_bill_transaction', 559, 'expense_bill', 0, '2024-03-29', 190, 177, 'Expense Bill Transaction', '6000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 16:06:49', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (739, 0, 'expense_bill_transaction', 560, 'expense_bill', 0, '2024-03-29', 190, 177, 'Expense Bill Transaction', '11300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 16:07:34', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (740, 0, 'expense_bill_transaction', 561, 'expense_bill', 0, '2024-03-29', 190, 177, 'Expense Bill Transaction', '8000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 16:08:12', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (741, 0, 'expense_bill_transaction', 562, 'expense_bill', 0, '2024-03-29', 190, 180, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-03-30 16:09:17', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (742, 0, 'expense_bill_transaction', 563, 'expense_bill', 0, '2024-03-24', 194, 177, 'Expense Bill Transaction', '5400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-01 16:31:11', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (743, 0, 'expense_bill_transaction', 564, 'expense_bill', 0, '2024-03-25', 194, 177, 'Expense Bill Transaction', '6600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-01 16:32:39', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (744, 0, 'expense_bill_transaction', 565, 'expense_bill', 0, '2024-03-25', 194, 176, 'Expense Bill Transaction', '14700', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-01 16:33:05', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (745, 0, 'expense_bill_transaction', 566, 'expense_bill', 0, '2024-03-28', 194, 177, 'Expense Bill Transaction', '3200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-01 16:33:28', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (746, 0, 'purchase_bill_transaction', 68, 'purchase_bill', 0, '2024-03-24', 194, 5, 'Purchase Bill Transaction', '7600', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-01 16:35:06', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (747, 0, 'purchase_bill_transaction', 69, 'purchase_bill', 0, '2024-03-24', 194, 5, 'Purchase Bill Transaction', '4800', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-01 16:37:57', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (748, 0, 'purchase_bill_transaction', 70, 'purchase_bill', 0, '2024-03-24', 194, 5, 'Purchase Bill Transaction', '34040', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-01 16:38:41', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (749, 0, 'purchase_bill_transaction', 71, 'purchase_bill', 0, '2024-03-24', 194, 5, 'Purchase Bill Transaction', '3500', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-01 16:39:15', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (750, 0, 'purchase_bill_transaction', 72, 'purchase_bill', 0, '2024-03-25', 194, 5, 'Purchase Bill Transaction', '3850', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-01 16:41:05', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (751, 0, 'purchase_bill_transaction', 73, 'purchase_bill', 0, '2024-03-28', 194, 5, 'Purchase Bill Transaction', '11500', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-01 16:41:44', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (752, 0, 'client_payment_transaction', 1, 'project', 0, '2024-03-31', 2, 1, 'Client Payment Transaction', '50000', 0, '', '', '0000-00-00', '', 0, 1, '', 0, 0, 0, '50000', '0', '0', '', 0, '2024-04-01 16:42:07', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (753, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-03-31', 1, 194, 'User Payment Receipt Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-01 16:42:28', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (754, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-04-01', 1, 190, 'User Payment Receipt Transaction', '10000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-06 15:59:15', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (755, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-04-01', 194, 1, 'User Payment Return Transaction', '10000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-06 16:00:13', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (756, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-04-04', 1, 190, 'User Payment Receipt Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-06 16:01:14', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (757, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-04-04', 194, 1, 'User Payment Return Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-06 16:01:59', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (758, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-04-05', 1, 190, 'User Payment Receipt Transaction', '10000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-06 16:02:38', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (759, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-04-05', 194, 1, 'User Payment Return Transaction', '10000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-06 16:03:40', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (760, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-04-06', 1, 190, 'User Payment Receipt Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-06 16:04:05', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (761, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-04-06', 194, 1, 'User Payment Return Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-06 16:04:27', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (762, 0, 'salary_slip_transaction', 1, 'salary_slip', 0, '2024-04-04', 194, 10, 'Salary Slip Transaction', '15000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-06 16:07:38', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (763, 0, 'client_payment_transaction', 12, 'project', 0, '2024-04-05', 2, 1, 'Client Payment Transaction', '150000', 0, '', '', '0000-00-00', '', 0, 12, '', 0, 0, 0, '150000', '0', '0', '', 0, '2024-04-06 16:08:54', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (764, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-04-05', 1, 194, 'User Payment Receipt Transaction', '150000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-06 16:09:23', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (765, 0, 'user_payment_receipt_transaction', 191, 'user_account_head', 0, '2024-04-08', 1, 191, 'User Payment Receipt Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-08 16:54:15', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (766, 0, 'expense_bill_transaction', 567, 'expense_bill', 0, '2024-04-08', 191, 195, 'Expense Bill Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-08 16:54:43', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (767, 0, 'client_payment_transaction', 9, 'project', 0, '2024-04-08', 2, 1, 'Client Payment Transaction', '70000', 0, '', '', '0000-00-00', '', 0, 9, '', 0, 0, 0, '70000', '0', '0', '', 0, '2024-04-08 16:55:20', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (768, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-04-08', 1, 194, 'User Payment Receipt Transaction', '70000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-08 16:55:36', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (769, 0, 'purchase_bill_transaction', 74, 'purchase_bill', 0, '2024-04-07', 194, 5, 'Purchase Bill Transaction', '47500', 1, 'CASH', '', '0000-00-00', '', 0, 15, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-08 16:56:14', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (770, 0, 'client_payment_transaction', 14, 'project', 0, '2024-04-13', 2, 1, 'Client Payment Transaction', '200000', 0, '', '', '0000-00-00', '', 0, 14, '', 0, 0, 0, '200000', '0', '0', '', 0, '2024-04-13 11:14:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (771, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-04-13', 1, 194, 'User Payment Receipt Transaction', '200000', 0, 'CASH', '', '0000-00-00', '116', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 11:14:40', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (772, 0, 'expense_bill_transaction', 568, 'expense_bill', 0, '2024-03-29', 190, 180, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 11:46:39', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (773, 0, 'expense_bill_transaction', 569, 'expense_bill', 0, '2024-03-29', 190, 180, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 11:47:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (774, 0, 'expense_bill_transaction', 570, 'expense_bill', 0, '2024-03-29', 190, 177, 'Expense Bill Transaction', '6000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 11:48:24', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (775, 0, 'expense_bill_transaction', 571, 'expense_bill', 0, '2024-03-29', 190, 180, 'Expense Bill Transaction', '11300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 11:49:05', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (776, 0, 'expense_bill_transaction', 572, 'expense_bill', 0, '2024-03-29', 190, 180, 'Expense Bill Transaction', '8000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 11:49:35', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (777, 0, 'expense_bill_transaction', 573, 'expense_bill', 0, '2024-03-29', 190, 180, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 11:50:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (778, 0, 'client_payment_transaction', 6, 'project', 0, '2024-03-29', 2, 1, 'Client Payment Transaction', '34300', 0, '', '', '0000-00-00', 'ADDITIONAL PAID BY CLIENT', 0, 6, '', 0, 0, 0, '34300', '0', '0', '', 0, '2024-04-13 11:52:49', 1, '2024-04-13 15:20:57', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (779, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-03-29', 1, 190, 'User Payment Receipt Transaction', '34300', 0, 'CASH', '', '0000-00-00', '109 ADDITIONAL PAID BY CLIENT', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 11:53:39', 1, '2024-04-13 15:25:22', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (780, 0, 'expense_bill_transaction', 574, 'expense_bill', 0, '2024-03-29', 190, 177, 'Expense Bill Transaction', '4600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 11:56:04', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (781, 0, 'expense_bill_transaction', 575, 'expense_bill', 0, '2024-03-29', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 11:56:59', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (782, 0, 'expense_bill_transaction', 576, 'expense_bill', 0, '2024-03-29', 190, 177, 'Expense Bill Transaction', '6500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 11:57:44', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (783, 0, 'expense_bill_transaction', 577, 'expense_bill', 0, '2024-03-29', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 11:58:42', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (784, 0, 'expense_bill_transaction', 578, 'expense_bill', 0, '2024-03-30', 190, 177, 'Expense Bill Transaction', '900', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 12:12:00', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (785, 0, 'expense_bill_transaction', 579, 'expense_bill', 0, '2024-03-30', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 12:12:46', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (786, 0, 'expense_bill_transaction', 580, 'expense_bill', 0, '2024-03-30', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 14:51:59', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (787, 0, 'expense_bill_transaction', 581, 'expense_bill', 0, '2024-03-30', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 14:52:43', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (788, 0, 'expense_bill_transaction', 582, 'expense_bill', 0, '2024-03-30', 190, 177, 'Expense Bill Transaction', '4600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 14:53:29', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (789, 0, 'expense_bill_transaction', 583, 'expense_bill', 0, '2024-03-30', 190, 180, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 14:54:27', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (790, 0, 'expense_bill_transaction', 584, 'expense_bill', 0, '2024-03-30', 190, 180, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 14:55:34', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (791, 0, 'expense_bill_transaction', 585, 'expense_bill', 0, '2024-03-30', 190, 177, 'Expense Bill Transaction', '6000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 14:56:55', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (792, 0, 'expense_bill_transaction', 586, 'expense_bill', 0, '2024-03-30', 190, 180, 'Expense Bill Transaction', '11300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 14:57:39', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (793, 0, 'expense_bill_transaction', 587, 'expense_bill', 0, '2024-03-30', 190, 180, 'Expense Bill Transaction', '8000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 14:58:36', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (794, 0, 'expense_bill_transaction', 588, 'expense_bill', 0, '2024-03-30', 190, 180, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 14:59:32', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (795, 0, 'expense_bill_transaction', 589, 'expense_bill', 0, '2024-03-31', 190, 177, 'Expense Bill Transaction', '55200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 15:00:21', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (796, 0, 'expense_bill_transaction', 590, 'expense_bill', 0, '2024-03-31', 190, 180, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 15:01:00', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (797, 0, 'expense_bill_transaction', 591, 'expense_bill', 0, '2024-04-01', 190, 177, 'Expense Bill Transaction', '3900', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 15:01:52', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (798, 0, 'expense_bill_transaction', 592, 'expense_bill', 0, '2024-04-01', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 15:02:41', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (799, 0, 'expense_bill_transaction', 593, 'expense_bill', 0, '2024-04-01', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 15:03:55', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (800, 0, 'expense_bill_transaction', 594, 'expense_bill', 0, '2024-04-01', 190, 177, 'Expense Bill Transaction', '57000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 15:05:10', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (801, 0, 'expense_bill_transaction', 595, 'expense_bill', 0, '2024-04-01', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 15:05:50', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (802, 0, 'expense_bill_transaction', 596, 'expense_bill', 0, '2024-04-01', 190, 206, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 15:08:26', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (803, 0, 'expense_bill_transaction', 597, 'expense_bill', 0, '2024-04-01', 190, 177, 'Expense Bill Transaction', '16000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 15:09:18', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (804, 0, 'expense_bill_transaction', 598, 'expense_bill', 0, '2024-04-01', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 15:10:11', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (805, 0, 'expense_bill_transaction', 599, 'expense_bill', 0, '2024-04-02', 190, 177, 'Expense Bill Transaction', '26400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 15:11:47', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (806, 0, 'expense_bill_transaction', 600, 'expense_bill', 0, '2024-04-02', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 15:13:02', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (807, 0, 'expense_bill_transaction', 601, 'expense_bill', 0, '2024-04-02', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 15:14:51', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (808, 0, 'expense_bill_transaction', 602, 'expense_bill', 0, '2024-04-02', 190, 206, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 15:15:52', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (809, 0, 'client_payment_transaction', 6, 'project', 0, '2024-03-30', 2, 1, 'Client Payment Transaction', '34300', 0, '', '', '0000-00-00', 'ADDITIONAL PAID BY CLIENT', 0, 6, '', 0, 0, 0, '34300', '0', '0', '', 0, '2024-04-13 15:22:17', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (810, 0, 'client_payment_transaction', 6, 'project', 0, '2024-03-31', 2, 1, 'Client Payment Transaction', '58200', 0, '', '', '0000-00-00', 'ADDITIONAL PAID BY CLIENT', 0, 6, '', 0, 0, 0, '58200', '0', '0', '', 0, '2024-04-13 15:22:52', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (811, 0, 'client_payment_transaction', 6, 'project', 0, '2024-04-01', 2, 1, 'Client Payment Transaction', '81000', 0, '', '', '0000-00-00', 'ADDITIONAL PAID BY CLIENT', 0, 6, '', 0, 0, 0, '81000', '0', '0', '', 0, '2024-04-13 15:23:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (812, 0, 'client_payment_transaction', 6, 'project', 0, '2024-04-02', 2, 1, 'Client Payment Transaction', '34400', 0, '', '', '0000-00-00', 'ADDITIONAL PAID BY CLIENT', 0, 6, '', 0, 0, 0, '34400', '0', '0', '', 0, '2024-04-13 15:24:04', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (813, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-03-30', 1, 190, 'User Payment Receipt Transaction', '34300', 0, 'CASH', '', '0000-00-00', '109 ADDITIONAL PAID BY CLIENT', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 15:27:12', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (814, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-03-31', 1, 190, 'User Payment Receipt Transaction', '58200', 0, 'CASH', '', '0000-00-00', '109 ADDITIONAL PAID BY CLIENT', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 15:28:17', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (815, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-04-01', 1, 190, 'User Payment Receipt Transaction', '81000', 0, 'CASH', '', '0000-00-00', '109 ADDITIONAL PAID BY CLIENT', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 15:28:59', 1, '2024-04-13 15:29:56', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (816, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-04-02', 1, 190, 'User Payment Receipt Transaction', '34400', 0, 'CASH', '', '0000-00-00', '109 ADDITIONAL PAID BY CLIENT', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-13 15:29:41', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (817, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-04-13', 1, 190, 'User Payment Receipt Transaction', '10000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-16 12:28:28', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (818, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-04-13', 1, 190, 'User Payment Receipt Transaction', '100000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-16 12:28:46', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (819, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-04-13', 194, 1, 'User Payment Return Transaction', '110000', 0, 'CASH', '', '0000-00-00', '100000+10000', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-16 12:29:08', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (820, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-04-15', 1, 190, 'User Payment Receipt Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-16 12:29:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (821, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-04-15', 194, 1, 'User Payment Return Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-16 12:29:41', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (822, 0, 'user_payment_receipt_transaction', 191, 'user_account_head', 0, '2024-04-13', 1, 191, 'User Payment Receipt Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-16 12:41:36', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (823, 0, 'expense_bill_transaction', 603, 'expense_bill', 0, '2024-04-13', 191, 195, 'Expense Bill Transaction', '50000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-16 12:42:41', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (824, 0, 'purchase_bill_transaction', 75, 'purchase_bill', 0, '2024-03-30', 194, 5, 'Purchase Bill Transaction', '23000', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-16 12:57:32', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (825, 0, 'expense_bill_transaction', 604, 'expense_bill', 0, '2024-03-30', 194, 177, 'Expense Bill Transaction', '6600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-16 12:59:15', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (826, 0, 'expense_bill_transaction', 605, 'expense_bill', 0, '2024-04-01', 194, 176, 'Expense Bill Transaction', '19000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-16 13:00:55', 1, '2024-04-27 14:35:33', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (827, 0, 'expense_bill_transaction', 606, 'expense_bill', 0, '2024-04-01', 194, 176, 'Expense Bill Transaction', '19000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-16 16:51:41', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (828, 0, 'expense_bill_transaction', 607, 'expense_bill', 0, '2024-04-01', 194, 181, 'Expense Bill Transaction', '7500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-16 16:52:15', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (829, 0, 'purchase_bill_transaction', 76, 'purchase_bill', 0, '2024-04-01', 194, 5, 'Purchase Bill Transaction', '1200', 1, 'CASH', '', '0000-00-00', '', 0, 11, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-16 16:53:04', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (830, 0, 'client_payment_transaction', 14, 'project', 0, '2024-03-07', 2, 1, 'Client Payment Transaction', '50000', 0, '', '', '0000-00-00', '', 0, 14, '', 0, 0, 0, '50000', '0', '0', '', 0, '2024-04-20 15:17:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (831, 0, 'expense_bill_transaction', 608, 'expense_bill', 0, '2024-04-03', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:29:05', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (832, 0, 'expense_bill_transaction', 609, 'expense_bill', 0, '2024-04-03', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:29:49', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (833, 0, 'expense_bill_transaction', 610, 'expense_bill', 0, '2024-04-03', 190, 177, 'Expense Bill Transaction', '20500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:30:48', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (834, 0, 'expense_bill_transaction', 611, 'expense_bill', 0, '2024-04-03', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:32:16', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (835, 0, 'expense_bill_transaction', 612, 'expense_bill', 0, '2024-04-03', 190, 206, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:33:13', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (836, 0, 'expense_bill_transaction', 613, 'expense_bill', 0, '2024-04-03', 190, 177, 'Expense Bill Transaction', '26900', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:33:56', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (837, 0, 'expense_bill_transaction', 614, 'expense_bill', 0, '2024-04-03', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:34:42', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (838, 0, 'expense_bill_transaction', 615, 'expense_bill', 0, '2024-04-03', 190, 177, 'Expense Bill Transaction', '16200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:35:26', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (839, 0, 'expense_bill_transaction', 616, 'expense_bill', 0, '2024-04-05', 190, 177, 'Expense Bill Transaction', '18700', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:36:12', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (840, 0, 'expense_bill_transaction', 617, 'expense_bill', 0, '2024-04-05', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:36:50', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (841, 0, 'expense_bill_transaction', 618, 'expense_bill', 0, '2024-04-05', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:37:32', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (842, 0, 'expense_bill_transaction', 619, 'expense_bill', 0, '2024-04-05', 190, 177, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:38:20', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (843, 0, 'expense_bill_transaction', 620, 'expense_bill', 0, '2024-04-05', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:39:04', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (844, 0, 'expense_bill_transaction', 621, 'expense_bill', 0, '2024-04-05', 190, 177, 'Expense Bill Transaction', '14800', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:39:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (845, 0, 'expense_bill_transaction', 622, 'expense_bill', 0, '2024-04-05', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:40:59', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (846, 0, 'expense_bill_transaction', 623, 'expense_bill', 0, '2024-04-05', 190, 177, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:41:47', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (847, 0, 'expense_bill_transaction', 624, 'expense_bill', 0, '2024-04-05', 190, 206, 'Expense Bill Transaction', '1600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:42:43', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (848, 0, 'expense_bill_transaction', 625, 'expense_bill', 0, '2024-04-05', 190, 181, 'Expense Bill Transaction', '10000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:43:40', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (849, 0, 'expense_bill_transaction', 626, 'expense_bill', 0, '2024-04-06', 190, 177, 'Expense Bill Transaction', '18700', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:44:45', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (850, 0, 'expense_bill_transaction', 627, 'expense_bill', 0, '2024-04-06', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:46:55', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (851, 0, 'expense_bill_transaction', 628, 'expense_bill', 0, '2024-04-06', 190, 177, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:47:54', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (852, 0, 'expense_bill_transaction', 629, 'expense_bill', 0, '2024-04-06', 190, 177, 'Expense Bill Transaction', '18000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:49:10', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (853, 0, 'expense_bill_transaction', 630, 'expense_bill', 0, '2024-04-06', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:49:59', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (854, 0, 'expense_bill_transaction', 631, 'expense_bill', 0, '2024-04-06', 190, 206, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:50:51', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (855, 0, 'expense_bill_transaction', 632, 'expense_bill', 0, '2024-04-06', 190, 177, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:51:57', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (856, 0, 'expense_bill_transaction', 633, 'expense_bill', 0, '2024-04-06', 190, 196, 'Expense Bill Transaction', '4100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 15:53:40', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (857, 0, 'client_payment_transaction', 6, 'project', 0, '2024-04-03', 2, 1, 'Client Payment Transaction', '71300', 0, '', '', '0000-00-00', 'ADDITIONAL PAYMENT FROM CLIENT', 0, 6, '', 0, 0, 0, '71300', '0', '0', '', 0, '2024-04-20 15:55:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (858, 0, 'client_payment_transaction', 6, 'project', 0, '2024-04-05', 2, 1, 'Client Payment Transaction', '6500', 0, '', '', '0000-00-00', 'ADDITIONAL PAYMENT FROM CLIENT', 0, 6, '', 0, 0, 0, '6500', '0', '0', '', 0, '2024-04-20 15:56:36', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (859, 0, 'client_payment_transaction', 14, 'project', 0, '2024-04-05', 2, 1, 'Client Payment Transaction', '50000', 0, '', '', '0000-00-00', '', 0, 14, '', 0, 0, 0, '50000', '0', '0', '', 0, '2024-04-20 15:57:26', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (860, 0, 'client_payment_transaction', 6, 'project', 0, '2024-04-06', 2, 1, 'Client Payment Transaction', '20700', 0, '', '', '0000-00-00', 'ADDITIONAL PAYMENT FROM CLIENT', 0, 6, '', 0, 0, 0, '20700', '0', '0', '', 0, '2024-04-20 15:58:48', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (861, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-04-03', 1, 190, 'User Payment Receipt Transaction', '71300', 0, 'CASH', '', '0000-00-00', '109 ADDITIONAL PAYMENT FROM CLIENT', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 16:04:00', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (862, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-04-05', 1, 190, 'User Payment Receipt Transaction', '50000', 0, 'CASH', '', '0000-00-00', '116', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 16:04:49', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (863, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-04-06', 1, 190, 'User Payment Receipt Transaction', '20700', 0, 'CASH', '', '0000-00-00', '109 ADDITIONAL PAYMENT FROM CLIENT', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 16:05:57', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (864, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-04-05', 1, 190, 'User Payment Receipt Transaction', '6500', 0, 'CASH', '', '0000-00-00', '109 ADDITIONAL PAYMENT FROM CLIENT', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-20 16:07:14', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (865, 0, 'expense_bill_transaction', 634, 'expense_bill', 0, '2024-04-06', 190, 183, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 15:20:20', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (866, 0, 'expense_bill_transaction', 635, 'expense_bill', 0, '2024-04-07', 190, 177, 'Expense Bill Transaction', '7700', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:28:10', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (867, 0, 'expense_bill_transaction', 636, 'expense_bill', 0, '2024-04-07', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:29:35', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (868, 0, 'expense_bill_transaction', 637, 'expense_bill', 0, '2024-04-07', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:30:17', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (869, 0, 'expense_bill_transaction', 638, 'expense_bill', 0, '2024-04-08', 190, 177, 'Expense Bill Transaction', '6900', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:30:57', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (870, 0, 'expense_bill_transaction', 639, 'expense_bill', 0, '2024-04-08', 190, 206, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:31:36', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (871, 0, 'expense_bill_transaction', 640, 'expense_bill', 0, '2024-04-08', 190, 177, 'Expense Bill Transaction', '11900', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:32:20', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (872, 0, 'expense_bill_transaction', 641, 'expense_bill', 0, '2024-04-08', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:33:06', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (873, 0, 'expense_bill_transaction', 642, 'expense_bill', 0, '2024-04-08', 190, 177, 'Expense Bill Transaction', '20700', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:33:50', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (874, 0, 'expense_bill_transaction', 643, 'expense_bill', 0, '2024-04-08', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:34:38', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (875, 0, 'expense_bill_transaction', 644, 'expense_bill', 0, '2024-04-08', 190, 177, 'Expense Bill Transaction', '15900', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:35:34', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (876, 0, 'expense_bill_transaction', 645, 'expense_bill', 0, '2024-04-08', 190, 206, 'Expense Bill Transaction', '2700', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:36:27', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (877, 0, 'expense_bill_transaction', 646, 'expense_bill', 0, '2024-04-08', 190, 177, 'Expense Bill Transaction', '21300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:37:08', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (878, 0, 'expense_bill_transaction', 647, 'expense_bill', 0, '2024-04-08', 190, 206, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:37:59', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (879, 0, 'expense_bill_transaction', 648, 'expense_bill', 0, '2024-04-08', 190, 177, 'Expense Bill Transaction', '4900', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:38:48', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (880, 0, 'expense_bill_transaction', 649, 'expense_bill', 0, '2024-04-08', 190, 206, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:39:40', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (881, 0, 'expense_bill_transaction', 650, 'expense_bill', 0, '2024-04-08', 190, 206, 'Expense Bill Transaction', '980', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:40:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (882, 0, 'expense_bill_transaction', 651, 'expense_bill', 0, '2024-04-08', 190, 177, 'Expense Bill Transaction', '11900', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:41:54', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (883, 0, 'expense_bill_transaction', 652, 'expense_bill', 0, '2024-04-08', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:42:42', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (884, 0, 'expense_bill_transaction', 653, 'expense_bill', 0, '2024-04-08', 190, 206, 'Expense Bill Transaction', '1230', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:45:21', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (885, 0, 'expense_bill_transaction', 654, 'expense_bill', 0, '2024-04-09', 190, 177, 'Expense Bill Transaction', '13400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:46:02', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (886, 0, 'expense_bill_transaction', 655, 'expense_bill', 0, '2024-04-09', 190, 181, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:46:36', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (887, 0, 'expense_bill_transaction', 656, 'expense_bill', 0, '2024-04-09', 190, 183, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:48:03', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (888, 0, 'expense_bill_transaction', 657, 'expense_bill', 0, '2024-04-10', 190, 183, 'Expense Bill Transaction', '4000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:48:40', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (889, 0, 'expense_bill_transaction', 658, 'expense_bill', 0, '2024-04-10', 190, 206, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:49:17', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (890, 0, 'expense_bill_transaction', 659, 'expense_bill', 0, '2024-04-10', 190, 177, 'Expense Bill Transaction', '3300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:49:49', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (891, 0, 'expense_bill_transaction', 660, 'expense_bill', 0, '2024-04-10', 190, 206, 'Expense Bill Transaction', '450', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:50:18', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (892, 0, 'expense_bill_transaction', 661, 'expense_bill', 0, '2024-04-11', 190, 177, 'Expense Bill Transaction', '3300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:50:54', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (893, 0, 'expense_bill_transaction', 662, 'expense_bill', 0, '2024-04-11', 190, 206, 'Expense Bill Transaction', '480', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:51:28', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (894, 0, 'purchase_bill_transaction', 77, 'purchase_bill', 0, '2024-04-09', 190, 5, 'Purchase Bill Transaction', '3200', 1, 'CASH', '', '0000-00-00', '', 0, 15, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:52:48', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (895, 0, 'client_payment_transaction', 6, 'project', 0, '2024-04-08', 2, 1, 'Client Payment Transaction', '63000', 0, '', '', '0000-00-00', 'ADDITIONAL PAYMENT FROM CLIENT', 0, 6, '', 0, 0, 0, '63000', '0', '0', '', 0, '2024-04-25 16:54:24', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (896, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-04-08', 1, 190, 'User Payment Receipt Transaction', '63000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-25 16:55:27', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (897, 0, 'client_payment_transaction', 5, 'project', 0, '2024-04-24', 2, 1, 'Client Payment Transaction', '46000', 0, '', '', '0000-00-00', '', 0, 5, '', 0, 0, 0, '46000', '0', '0', '', 0, '2024-04-27 13:53:45', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (898, 0, 'client_payment_transaction', 19, 'project', 0, '2024-04-25', 2, 1, 'Client Payment Transaction', '100000', 0, '', '', '0000-00-00', '', 0, 19, '', 0, 0, 0, '100000', '0', '0', '', 0, '2024-04-27 14:05:12', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (899, 0, 'client_payment_transaction', 14, 'project', 0, '2024-04-21', 2, 1, 'Client Payment Transaction', '200000', 0, '', '', '0000-00-00', '', 0, 14, '', 0, 0, 0, '200000', '0', '0', '', 0, '2024-04-27 14:05:41', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (900, 0, 'client_payment_transaction', 15, 'project', 0, '2024-04-26', 2, 1, 'Client Payment Transaction', '195000', 0, '', '', '0000-00-00', '', 0, 15, '', 0, 0, 0, '195000', '0', '0', '', 0, '2024-04-27 14:05:56', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (901, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-04-25', 1, 194, 'User Payment Receipt Transaction', '100000', 0, 'CASH', '', '0000-00-00', '121', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 14:06:24', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (902, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-04-24', 1, 194, 'User Payment Receipt Transaction', '46000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 14:06:48', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (903, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-04-21', 1, 194, 'User Payment Receipt Transaction', '200000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 14:07:43', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (904, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-04-26', 1, 194, 'User Payment Receipt Transaction', '195000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 14:08:09', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (905, 0, 'purchase_bill_transaction', 78, 'purchase_bill', 0, '2024-04-26', 194, 5, 'Purchase Bill Transaction', '200000', 1, 'CASH', '', '0000-00-00', '', 0, 19, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 14:09:11', 1, '2024-06-05 16:48:42', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (906, 0, 'expense_bill_transaction', 663, 'expense_bill', 0, '2024-04-12', 190, 177, 'Expense Bill Transaction', '5300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 14:43:04', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (907, 0, 'expense_bill_transaction', 664, 'expense_bill', 0, '2024-04-13', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 14:44:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (908, 0, 'expense_bill_transaction', 665, 'expense_bill', 0, '2024-04-13', 190, 177, 'Expense Bill Transaction', '5300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 14:46:48', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (909, 0, 'expense_bill_transaction', 666, 'expense_bill', 0, '2024-04-13', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 14:47:27', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (910, 0, 'expense_bill_transaction', 667, 'expense_bill', 0, '2024-04-13', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 14:48:11', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (911, 0, 'expense_bill_transaction', 668, 'expense_bill', 0, '2024-04-13', 190, 180, 'Expense Bill Transaction', '600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 14:49:05', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (912, 0, 'expense_bill_transaction', 669, 'expense_bill', 0, '2024-04-13', 190, 177, 'Expense Bill Transaction', '1950', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 14:50:35', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (913, 0, 'expense_bill_transaction', 670, 'expense_bill', 0, '2024-04-14', 190, 177, 'Expense Bill Transaction', '1950', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 14:54:48', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (914, 0, 'expense_bill_transaction', 671, 'expense_bill', 0, '2024-04-14', 190, 180, 'Expense Bill Transaction', '600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 14:55:46', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (915, 0, 'expense_bill_transaction', 672, 'expense_bill', 0, '2024-04-14', 190, 176, 'Expense Bill Transaction', '22000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 14:56:19', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (916, 0, 'expense_bill_transaction', 673, 'expense_bill', 0, '2024-04-15', 190, 177, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 14:57:42', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (917, 0, 'expense_bill_transaction', 674, 'expense_bill', 0, '2024-04-15', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 14:58:31', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (918, 0, 'expense_bill_transaction', 675, 'expense_bill', 0, '2024-04-15', 190, 177, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 14:59:43', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (919, 0, 'expense_bill_transaction', 676, 'expense_bill', 0, '2024-04-15', 190, 177, 'Expense Bill Transaction', '3900', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 15:00:44', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (920, 0, 'expense_bill_transaction', 677, 'expense_bill', 0, '2024-04-15', 190, 206, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 15:01:34', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (921, 0, 'expense_bill_transaction', 678, 'expense_bill', 0, '2024-04-15', 190, 206, 'Expense Bill Transaction', '960', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 15:02:11', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (922, 0, 'expense_bill_transaction', 679, 'expense_bill', 0, '2024-04-16', 190, 177, 'Expense Bill Transaction', '13400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 15:03:01', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (923, 0, 'expense_bill_transaction', 680, 'expense_bill', 0, '2024-04-16', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 15:04:08', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (924, 0, 'expense_bill_transaction', 681, 'expense_bill', 0, '2024-04-16', 190, 177, 'Expense Bill Transaction', '2100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 15:04:49', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (925, 0, 'expense_bill_transaction', 682, 'expense_bill', 0, '2024-04-16', 190, 180, 'Expense Bill Transaction', '3400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 15:05:24', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (926, 0, 'expense_bill_transaction', 683, 'expense_bill', 0, '2024-04-16', 190, 180, 'Expense Bill Transaction', '800', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 15:06:05', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (927, 0, 'expense_bill_transaction', 684, 'expense_bill', 0, '2024-04-16', 190, 177, 'Expense Bill Transaction', '3300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 15:06:42', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (928, 0, 'expense_bill_transaction', 686, 'expense_bill', 0, '2024-04-16', 190, 180, 'Expense Bill Transaction', '800', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 15:08:50', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (929, 0, 'expense_bill_transaction', 687, 'expense_bill', 0, '2024-04-16', 190, 177, 'Expense Bill Transaction', '3300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 15:09:29', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (930, 0, 'expense_bill_transaction', 688, 'expense_bill', 0, '2024-04-16', 190, 180, 'Expense Bill Transaction', '800', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 15:10:28', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (931, 0, 'expense_bill_transaction', 689, 'expense_bill', 0, '2024-04-17', 190, 177, 'Expense Bill Transaction', '7800', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 15:11:13', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (932, 0, 'expense_bill_transaction', 690, 'expense_bill', 0, '2024-04-17', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 15:11:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (933, 0, 'expense_bill_transaction', 691, 'expense_bill', 0, '2024-04-17', 190, 177, 'Expense Bill Transaction', '2100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 15:13:04', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (934, 0, 'expense_bill_transaction', 692, 'expense_bill', 0, '2024-04-17', 190, 177, 'Expense Bill Transaction', '10100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 15:13:51', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (935, 0, 'expense_bill_transaction', 693, 'expense_bill', 0, '2024-04-17', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 15:14:58', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (936, 0, 'expense_bill_transaction', 694, 'expense_bill', 0, '2024-04-17', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 15:15:40', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (937, 0, 'expense_bill_transaction', 695, 'expense_bill', 0, '2024-04-17', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 15:22:26', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (938, 0, 'expense_bill_transaction', 696, 'expense_bill', 0, '2024-04-18', 190, 177, 'Expense Bill Transaction', '13100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 15:23:07', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (939, 0, 'expense_bill_transaction', 697, 'expense_bill', 0, '2024-04-18', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 15:24:30', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (940, 0, 'expense_bill_transaction', 698, 'expense_bill', 0, '2024-04-18', 190, 177, 'Expense Bill Transaction', '11200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 15:25:13', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (941, 0, 'expense_bill_transaction', 699, 'expense_bill', 0, '2024-04-18', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-27 15:26:01', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (942, 0, 'expense_bill_transaction', 700, 'expense_bill', 0, '2024-04-19', 190, 177, 'Expense Bill Transaction', '1600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 11:07:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (943, 0, 'expense_bill_transaction', 701, 'expense_bill', 0, '2024-04-19', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 11:08:45', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (944, 0, 'expense_bill_transaction', 702, 'expense_bill', 0, '2024-04-19', 190, 177, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 11:09:40', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (945, 0, 'expense_bill_transaction', 703, 'expense_bill', 0, '2024-04-19', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 11:10:32', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (946, 0, 'expense_bill_transaction', 704, 'expense_bill', 0, '2024-04-19', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 11:11:11', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (947, 0, 'expense_bill_transaction', 705, 'expense_bill', 0, '2024-04-20', 190, 177, 'Expense Bill Transaction', '4000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 11:12:06', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (948, 0, 'expense_bill_transaction', 706, 'expense_bill', 0, '2024-04-20', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 11:14:03', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (949, 0, 'expense_bill_transaction', 707, 'expense_bill', 0, '2024-04-20', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 11:15:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (950, 0, 'expense_bill_transaction', 708, 'expense_bill', 0, '2024-04-20', 190, 177, 'Expense Bill Transaction', '9200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 11:15:59', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (951, 0, 'expense_bill_transaction', 709, 'expense_bill', 0, '2024-04-20', 190, 180, 'Expense Bill Transaction', '2400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 11:16:55', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (952, 0, 'expense_bill_transaction', 710, 'expense_bill', 0, '2024-04-20', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 11:18:46', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (953, 0, 'expense_bill_transaction', 711, 'expense_bill', 0, '2024-04-20', 190, 206, 'Expense Bill Transaction', '650', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 11:19:44', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (954, 0, 'expense_bill_transaction', 712, 'expense_bill', 0, '2024-04-22', 190, 177, 'Expense Bill Transaction', '4000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 12:20:09', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (955, 0, 'expense_bill_transaction', 713, 'expense_bill', 0, '2024-04-22', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 12:22:12', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (956, 0, 'expense_bill_transaction', 714, 'expense_bill', 0, '2024-04-22', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 12:22:51', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (957, 0, 'expense_bill_transaction', 715, 'expense_bill', 0, '2024-04-22', 190, 177, 'Expense Bill Transaction', '2600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 12:24:03', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (958, 0, 'expense_bill_transaction', 716, 'expense_bill', 0, '2024-04-22', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 12:24:45', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (959, 0, 'expense_bill_transaction', 717, 'expense_bill', 0, '2024-04-22', 190, 177, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 12:25:46', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (960, 0, 'expense_bill_transaction', 718, 'expense_bill', 0, '2024-04-22', 190, 180, 'Expense Bill Transaction', '2400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 12:27:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (961, 0, 'expense_bill_transaction', 719, 'expense_bill', 0, '2024-04-22', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 12:28:33', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (962, 0, 'expense_bill_transaction', 720, 'expense_bill', 0, '2024-04-22', 190, 180, 'Expense Bill Transaction', '2400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 12:29:26', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (963, 0, 'expense_bill_transaction', 721, 'expense_bill', 0, '2024-04-23', 190, 177, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 12:30:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (964, 0, 'expense_bill_transaction', 722, 'expense_bill', 0, '2024-04-23', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 12:31:11', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (965, 0, 'expense_bill_transaction', 723, 'expense_bill', 0, '2024-04-23', 190, 177, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 12:32:10', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (966, 0, 'expense_bill_transaction', 724, 'expense_bill', 0, '2024-04-23', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 14:15:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (967, 0, 'expense_bill_transaction', 725, 'expense_bill', 0, '2024-04-23', 190, 177, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 14:16:05', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (968, 0, 'expense_bill_transaction', 726, 'expense_bill', 0, '2024-04-23', 190, 177, 'Expense Bill Transaction', '3900', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 14:16:48', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (969, 0, 'expense_bill_transaction', 727, 'expense_bill', 0, '2024-04-23', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 14:17:28', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (970, 0, 'expense_bill_transaction', 728, 'expense_bill', 0, '2024-04-24', 190, 199, 'Expense Bill Transaction', '1800', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 14:20:21', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (971, 0, 'expense_bill_transaction', 729, 'expense_bill', 0, '2024-04-24', 190, 199, 'Expense Bill Transaction', '5435', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 14:21:14', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (972, 0, 'purchase_bill_transaction', 79, 'purchase_bill', 0, '2024-04-24', 190, 5, 'Purchase Bill Transaction', '4291', 1, 'CASH', '', '0000-00-00', '', 0, 15, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 14:24:19', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (973, 0, 'expense_bill_transaction', 730, 'expense_bill', 0, '2024-04-24', 190, 177, 'Expense Bill Transaction', '5400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 14:25:07', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (974, 0, 'expense_bill_transaction', 731, 'expense_bill', 0, '2024-04-24', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 14:25:45', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (975, 0, 'expense_bill_transaction', 732, 'expense_bill', 0, '2024-04-24', 190, 177, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 14:26:45', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (976, 0, 'expense_bill_transaction', 733, 'expense_bill', 0, '2024-04-24', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 14:27:26', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (977, 0, 'expense_bill_transaction', 734, 'expense_bill', 0, '2024-04-25', 190, 177, 'Expense Bill Transaction', '7900', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 14:28:05', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (978, 0, 'expense_bill_transaction', 735, 'expense_bill', 0, '2024-04-25', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 14:29:18', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (979, 0, 'expense_bill_transaction', 736, 'expense_bill', 0, '2024-04-25', 190, 177, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 14:30:28', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (980, 0, 'expense_bill_transaction', 737, 'expense_bill', 0, '2024-04-25', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 14:31:28', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (981, 0, 'expense_bill_transaction', 738, 'expense_bill', 0, '2024-04-25', 190, 177, 'Expense Bill Transaction', '6400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 14:32:34', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (982, 0, 'expense_bill_transaction', 739, 'expense_bill', 0, '2024-04-25', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 14:33:12', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (983, 0, 'expense_bill_transaction', 740, 'expense_bill', 0, '2024-04-25', 190, 177, 'Expense Bill Transaction', '4900', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 14:34:08', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (984, 0, 'expense_bill_transaction', 741, 'expense_bill', 0, '2024-04-25', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 14:35:00', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (985, 0, 'expense_bill_transaction', 742, 'expense_bill', 0, '2024-04-25', 190, 181, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 14:35:40', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (986, 0, 'expense_bill_transaction', 743, 'expense_bill', 0, '2024-04-25', 190, 199, 'Expense Bill Transaction', '11850', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 14:36:35', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (987, 0, 'salary_slip_transaction', 2, 'salary_slip', 0, '2024-04-13', 190, 10, 'Salary Slip Transaction', '7500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-04-30 14:39:55', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (988, 0, 'client_payment_transaction', 2, 'project', 0, '2024-05-01', 2, 1, 'Client Payment Transaction', '250000', 0, '', '', '0000-00-00', '', 0, 2, '', 0, 0, 0, '250000', '0', '0', '', 0, '2024-05-03 10:02:02', 1, '2024-05-03 10:02:50', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (989, 0, 'client_payment_transaction', 15, 'project', 0, '2024-04-29', 2, 1, 'Client Payment Transaction', '20000', 0, '', '', '0000-00-00', '', 0, 15, '', 0, 0, 0, '20000', '0', '0', '', 0, '2024-05-03 10:04:06', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (990, 0, 'client_payment_transaction', 15, 'project', 0, '2024-04-29', 2, 1, 'Client Payment Transaction', '200000', 0, '', '', '0000-00-00', '', 0, 15, '', 0, 0, 0, '200000', '0', '0', '', 0, '2024-05-03 10:04:29', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (991, 0, 'client_payment_transaction', 19, 'project', 0, '2024-04-25', 2, 1, 'Client Payment Transaction', '100000', 0, '', '', '0000-00-00', '', 0, 19, '', 0, 0, 0, '100000', '0', '0', '', 0, '2024-05-03 10:05:05', 1, '0000-00-00 00:00:00', 0, 1, 1, 1);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (992, 0, 'client_payment_transaction', 5, 'project', 0, '2024-04-24', 2, 1, 'Client Payment Transaction', '46000', 0, '', '', '0000-00-00', '', 0, 5, '', 0, 0, 0, '46000', '0', '0', '', 0, '2024-05-03 10:05:38', 1, '0000-00-00 00:00:00', 0, 1, 1, 1);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (993, 0, 'client_payment_transaction', 16, 'project', 0, '2024-04-21', 2, 1, 'Client Payment Transaction', '50000', 0, '', '', '0000-00-00', '', 0, 16, '', 0, 0, 0, '50000', '0', '0', '', 0, '2024-05-03 10:08:42', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (994, 0, 'client_payment_transaction', 20, 'project', 0, '2024-04-19', 2, 1, 'Client Payment Transaction', '10000', 0, '', '', '0000-00-00', '', 0, 20, '', 0, 0, 0, '10000', '0', '0', '', 0, '2024-05-03 10:09:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (995, 0, 'client_payment_transaction', 17, 'project', 0, '2024-04-15', 2, 1, 'Client Payment Transaction', '45000', 0, '', '', '0000-00-00', '', 0, 17, '', 0, 0, 0, '45000', '0', '0', '', 0, '2024-05-03 10:10:08', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (996, 0, 'client_payment_transaction', 6, 'project', 0, '2024-04-17', 2, 1, 'Client Payment Transaction', '200000', 0, '', '', '0000-00-00', '', 0, 6, '', 0, 0, 0, '200000', '0', '0', '', 0, '2024-05-03 10:10:55', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (997, 0, 'client_payment_transaction', 18, 'project', 0, '2024-04-16', 2, 1, 'Client Payment Transaction', '100000', 0, '', '', '0000-00-00', '', 0, 18, '', 0, 0, 0, '100000', '0', '0', '', 0, '2024-05-03 10:11:37', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (998, 0, 'client_payment_transaction', 16, 'project', 0, '2024-04-12', 2, 1, 'Client Payment Transaction', '20870', 0, '', '', '0000-00-00', '', 0, 16, '', 0, 0, 0, '20870', '0', '0', '', 0, '2024-05-03 10:12:28', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (999, 0, 'expense_bill_transaction', 744, 'expense_bill', 0, '2024-03-18', 190, 206, 'Expense Bill Transaction', '200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-03 10:25:45', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1000, 0, 'expense_bill_transaction', 745, 'expense_bill', 0, '2024-03-18', 190, 181, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-03 10:26:21', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1001, 0, 'expense_bill_transaction', 746, 'expense_bill', 0, '2024-03-19', 190, 206, 'Expense Bill Transaction', '450', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-03 10:29:07', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1002, 0, 'purchase_bill_transaction', 80, 'purchase_bill', 0, '2024-03-19', 190, 5, 'Purchase Bill Transaction', '46430', 1, 'CASH', '', '0000-00-00', '', 0, 9, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-03 10:31:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1003, 0, 'purchase_bill_transaction', 81, 'purchase_bill', 0, '2024-03-19', 190, 5, 'Purchase Bill Transaction', '4110', 1, 'CASH', '', '0000-00-00', '', 0, 14, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-03 10:33:07', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1004, 0, 'expense_bill_transaction', 747, 'expense_bill', 0, '2024-03-20', 190, 181, 'Expense Bill Transaction', '2100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-03 10:49:54', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1005, 0, 'expense_bill_transaction', 748, 'expense_bill', 0, '2024-03-20', 190, 183, 'Expense Bill Transaction', '300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-03 10:50:47', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1006, 0, 'expense_bill_transaction', 749, 'expense_bill', 0, '2024-03-21', 190, 206, 'Expense Bill Transaction', '1350', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-03 10:51:44', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1007, 0, 'expense_bill_transaction', 750, 'expense_bill', 0, '2024-03-21', 190, 183, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-03 10:52:33', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1008, 0, 'purchase_bill_transaction', 82, 'purchase_bill', 0, '2024-03-20', 190, 5, 'Purchase Bill Transaction', '2750', 1, 'CASH', '', '0000-00-00', '', 0, 10, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-03 10:55:16', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1009, 0, 'purchase_bill_transaction', 83, 'purchase_bill', 0, '2024-03-20', 190, 5, 'Purchase Bill Transaction', '1400', 1, 'CASH', '', '0000-00-00', '', 0, 9, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-03 10:56:18', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1010, 0, 'purchase_bill_transaction', 84, 'purchase_bill', 0, '2024-03-21', 190, 5, 'Purchase Bill Transaction', '3000', 1, 'CASH', '', '0000-00-00', '', 0, 10, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-03 11:00:20', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1011, 0, 'purchase_bill_transaction', 85, 'purchase_bill', 0, '2024-03-21', 190, 5, 'Purchase Bill Transaction', '47000', 1, 'CASH', '', '0000-00-00', '', 0, 9, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-03 11:02:05', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1012, 0, 'client_payment_transaction', 17, 'project', 0, '2024-04-13', 2, 1, 'Client Payment Transaction', '25000', 0, '', '', '0000-00-00', '', 0, 17, '', 0, 0, 0, '25000', '0', '0', '', 0, '2024-05-03 12:08:34', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1013, 0, 'expense_bill_transaction', 751, 'expense_bill', 0, '2024-03-19', 190, 206, 'Expense Bill Transaction', '450', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 10:33:40', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1014, 0, 'purchase_bill_transaction', 86, 'purchase_bill', 0, '2024-03-19', 190, 5, 'Purchase Bill Transaction', '46430', 1, 'CASH', '', '0000-00-00', '', 0, 9, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 10:37:15', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1015, 0, 'purchase_bill_transaction', 87, 'purchase_bill', 0, '2024-03-19', 190, 5, 'Purchase Bill Transaction', '4110', 1, 'CASH', '', '0000-00-00', '', 0, 14, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 10:38:41', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1016, 0, 'purchase_bill_transaction', 88, 'purchase_bill', 0, '2024-03-20', 190, 5, 'Purchase Bill Transaction', '2750', 1, 'CASH', '', '0000-00-00', '', 0, 10, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 10:40:43', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1017, 0, 'purchase_bill_transaction', 89, 'purchase_bill', 0, '2024-03-20', 190, 5, 'Purchase Bill Transaction', '1400', 1, 'CASH', '', '0000-00-00', '', 0, 9, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 10:41:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 1);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1018, 0, 'purchase_bill_transaction', 89, 'purchase_bill', 0, '2024-03-20', 190, 5, 'Purchase Bill Transaction', '1700', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 10:43:54', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1019, 0, 'expense_bill_transaction', 752, 'expense_bill', 0, '2024-03-27', 190, 206, 'Expense Bill Transaction', '885', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 10:56:30', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1020, 0, 'expense_bill_transaction', 753, 'expense_bill', 0, '2024-03-27', 190, 180, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 10:57:02', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1021, 0, 'expense_bill_transaction', 754, 'expense_bill', 0, '2024-03-28', 190, 206, 'Expense Bill Transaction', '160', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 10:57:45', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1022, 0, 'expense_bill_transaction', 755, 'expense_bill', 0, '2024-03-28', 190, 206, 'Expense Bill Transaction', '3175', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 11:05:06', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1023, 0, 'purchase_bill_transaction', 90, 'purchase_bill', 0, '2024-03-28', 190, 5, 'Purchase Bill Transaction', '7825', 1, 'CASH', '', '0000-00-00', '', 0, 9, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 11:05:56', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1024, 0, 'purchase_bill_transaction', 91, 'purchase_bill', 0, '2024-03-29', 190, 5, 'Purchase Bill Transaction', '230', 1, 'CASH', '', '0000-00-00', '', 0, 6, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 11:09:59', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1025, 0, 'expense_bill_transaction', 756, 'expense_bill', 0, '2024-03-29', 190, 206, 'Expense Bill Transaction', '550', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 11:10:34', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1026, 0, 'expense_bill_transaction', 757, 'expense_bill', 0, '2024-03-29', 190, 183, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 11:11:06', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1027, 0, 'expense_bill_transaction', 758, 'expense_bill', 0, '2024-03-29', 190, 199, 'Expense Bill Transaction', '500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 11:11:42', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1028, 0, 'expense_bill_transaction', 759, 'expense_bill', 0, '2024-03-29', 190, 181, 'Expense Bill Transaction', '3350', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 11:12:12', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1029, 0, 'expense_bill_transaction', 760, 'expense_bill', 0, '2024-03-29', 190, 199, 'Expense Bill Transaction', '180', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 11:12:46', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1030, 0, 'expense_bill_transaction', 761, 'expense_bill', 0, '2024-03-29', 190, 206, 'Expense Bill Transaction', '1750', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 11:13:33', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1031, 0, 'purchase_bill_transaction', 92, 'purchase_bill', 0, '2024-03-29', 190, 5, 'Purchase Bill Transaction', '3500', 1, 'CASH', '', '0000-00-00', '', 0, 9, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 11:15:06', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1032, 0, 'purchase_bill_transaction', 93, 'purchase_bill', 0, '2024-03-30', 190, 5, 'Purchase Bill Transaction', '5085', 1, 'CASH', '', '0000-00-00', '', 0, 14, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 11:18:19', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1033, 0, 'purchase_bill_transaction', 94, 'purchase_bill', 0, '2024-03-31', 190, 5, 'Purchase Bill Transaction', '1400', 1, 'CASH', '', '0000-00-00', '', 0, 9, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 11:19:31', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1034, 0, 'expense_bill_transaction', 762, 'expense_bill', 0, '2024-03-31', 190, 206, 'Expense Bill Transaction', '160', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 11:20:21', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1035, 0, 'expense_bill_transaction', 763, 'expense_bill', 0, '2024-04-01', 190, 183, 'Expense Bill Transaction', '2500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 11:21:15', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1036, 0, 'expense_bill_transaction', 764, 'expense_bill', 0, '2024-04-01', 190, 199, 'Expense Bill Transaction', '180', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 11:23:47', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1037, 0, 'purchase_bill_transaction', 95, 'purchase_bill', 0, '2024-04-01', 190, 5, 'Purchase Bill Transaction', '5000', 1, 'CASH', '', '0000-00-00', '', 0, 14, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 11:26:05', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1038, 0, 'expense_bill_transaction', 765, 'expense_bill', 0, '2024-04-01', 190, 206, 'Expense Bill Transaction', '160', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 11:26:44', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1039, 0, 'expense_bill_transaction', 766, 'expense_bill', 0, '2024-04-01', 190, 181, 'Expense Bill Transaction', '2100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 11:27:29', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1040, 0, 'expense_bill_transaction', 767, 'expense_bill', 0, '2024-04-19', 190, 183, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 11:30:42', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1041, 0, 'purchase_bill_transaction', 96, 'purchase_bill', 0, '2024-04-20', 190, 5, 'Purchase Bill Transaction', '1835', 1, 'CASH', '', '0000-00-00', '', 0, 15, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-07 12:03:46', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1042, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-04-28', 1, 194, 'User Payment Receipt Transaction', '100000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 15:45:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1043, 0, 'client_payment_transaction', 15, 'project', 0, '2024-04-28', 2, 1, 'Client Payment Transaction', '100000', 0, '', '', '0000-00-00', '', 0, 15, '', 0, 0, 0, '100000', '0', '0', '', 0, '2024-05-09 15:46:23', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1044, 0, 'purchase_bill_transaction', 97, 'purchase_bill', 0, '2024-04-29', 194, 5, 'Purchase Bill Transaction', '100000', 1, 'CASH', '', '0000-00-00', '', 0, 16, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 15:54:53', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1045, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-04-29', 1, 190, 'User Payment Receipt Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 15:55:26', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1046, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-04-29', 1, 190, 'User Payment Receipt Transaction', '45000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 15:55:42', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1047, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-04-29', 194, 1, 'User Payment Return Transaction', '50000', 0, 'CASH', '', '0000-00-00', '45000+5000', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 15:56:01', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1048, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-04-29', 1, 194, 'User Payment Receipt Transaction', '20000', 0, 'CASH', '', '0000-00-00', '117', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 15:58:35', 1, '2024-05-09 16:04:03', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1049, 0, 'client_payment_transaction', 15, 'project', 0, '2024-04-29', 2, 1, 'Client Payment Transaction', '20000', 0, '', '', '0000-00-00', '', 0, 15, '', 0, 0, 0, '20000', '0', '0', '', 0, '2024-05-09 15:59:07', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1050, 0, 'user_payment_receipt_transaction', 190, 'user_account_head', 0, '2024-04-30', 1, 190, 'User Payment Receipt Transaction', '100000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 15:59:44', 1, '2024-05-09 16:03:38', 1, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1051, 0, 'user_payment_return_transaction', 194, 'user_account_head', 0, '2024-04-30', 194, 1, 'User Payment Return Transaction', '100000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:03:27', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1052, 0, 'user_payment_receipt_transaction', 194, 'user_account_head', 0, '2024-05-02', 1, 194, 'User Payment Receipt Transaction', '150000', 0, 'CASH', '', '0000-00-00', '118', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:04:33', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1053, 0, 'purchase_bill_transaction', 98, 'purchase_bill', 0, '2024-04-21', 190, 5, 'Purchase Bill Transaction', '7670', 1, 'CASH', '', '0000-00-00', '', 0, 15, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:04:49', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1054, 0, 'purchase_bill_transaction', 97, 'purchase_bill', 0, '2024-05-02', 194, 5, 'Purchase Bill Transaction', '100000', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:06:23', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1055, 0, 'expense_bill_transaction', 768, 'expense_bill', 0, '2024-04-24', 190, 183, 'Expense Bill Transaction', '9100', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:26:26', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1056, 0, 'expense_bill_transaction', 769, 'expense_bill', 0, '2024-04-24', 190, 183, 'Expense Bill Transaction', '2500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:27:01', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1057, 0, 'purchase_bill_transaction', 99, 'purchase_bill', 0, '2024-04-25', 190, 5, 'Purchase Bill Transaction', '30000', 1, 'CASH', '', '0000-00-00', '', 0, 14, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:32:55', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1058, 0, 'expense_bill_transaction', 770, 'expense_bill', 0, '2024-04-25', 190, 179, 'Expense Bill Transaction', '2000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:34:02', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1059, 0, 'purchase_bill_transaction', 100, 'purchase_bill', 0, '2024-04-26', 190, 5, 'Purchase Bill Transaction', '4850', 1, 'CASH', '', '0000-00-00', '', 0, 15, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:37:26', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1060, 0, 'expense_bill_transaction', 771, 'expense_bill', 0, '2024-04-26', 190, 199, 'Expense Bill Transaction', '10400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:38:37', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1061, 0, 'expense_bill_transaction', 772, 'expense_bill', 0, '2024-04-27', 190, 177, 'Expense Bill Transaction', '10400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:40:38', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1062, 0, 'expense_bill_transaction', 773, 'expense_bill', 0, '2024-04-27', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:41:24', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1063, 0, 'expense_bill_transaction', 774, 'expense_bill', 0, '2024-04-27', 190, 201, 'Expense Bill Transaction', '470', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:42:01', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1064, 0, 'expense_bill_transaction', 775, 'expense_bill', 0, '2024-04-27', 190, 206, 'Expense Bill Transaction', '3538', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:42:40', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1065, 0, 'expense_bill_transaction', 776, 'expense_bill', 0, '2024-04-27', 190, 179, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:43:13', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1066, 0, 'expense_bill_transaction', 777, 'expense_bill', 0, '2024-04-27', 190, 181, 'Expense Bill Transaction', '2400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:43:42', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1067, 0, 'expense_bill_transaction', 778, 'expense_bill', 0, '2024-04-28', 190, 199, 'Expense Bill Transaction', '90', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:44:49', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1068, 0, 'expense_bill_transaction', 779, 'expense_bill', 0, '2024-04-28', 190, 199, 'Expense Bill Transaction', '700', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:45:31', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1069, 0, 'expense_bill_transaction', 780, 'expense_bill', 0, '2024-04-28', 190, 206, 'Expense Bill Transaction', '1840', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:45:59', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1070, 0, 'expense_bill_transaction', 781, 'expense_bill', 0, '2024-04-28', 190, 179, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:46:32', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1071, 0, 'expense_bill_transaction', 782, 'expense_bill', 0, '2024-04-29', 190, 206, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:47:17', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1072, 0, 'expense_bill_transaction', 783, 'expense_bill', 0, '2024-04-29', 190, 179, 'Expense Bill Transaction', '5000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:48:05', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1073, 0, 'expense_bill_transaction', 784, 'expense_bill', 0, '2024-04-29', 190, 181, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:48:46', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1074, 0, 'expense_bill_transaction', 785, 'expense_bill', 0, '2024-04-30', 190, 177, 'Expense Bill Transaction', '10400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:49:37', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1075, 0, 'expense_bill_transaction', 786, 'expense_bill', 0, '2024-04-30', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:50:22', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1076, 0, 'expense_bill_transaction', 787, 'expense_bill', 0, '2024-04-30', 190, 183, 'Expense Bill Transaction', '600', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:50:52', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1077, 0, 'purchase_bill_transaction', 101, 'purchase_bill', 0, '2024-04-30', 190, 5, 'Purchase Bill Transaction', '11055', 1, 'CASH', '', '0000-00-00', '', 0, 2, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-09 16:52:26', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1078, 0, 'expense_bill_transaction', 788, 'expense_bill', 0, '2024-05-01', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-10 11:18:39', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1079, 0, 'expense_bill_transaction', 789, 'expense_bill', 0, '2024-05-01', 190, 180, 'Expense Bill Transaction', '1500', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-10 11:19:41', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1080, 0, 'expense_bill_transaction', 790, 'expense_bill', 0, '2024-05-01', 190, 183, 'Expense Bill Transaction', '4000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-10 11:20:19', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1081, 0, 'expense_bill_transaction', 791, 'expense_bill', 0, '2024-05-01', 190, 183, 'Expense Bill Transaction', '1000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-10 11:20:49', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1082, 0, 'expense_bill_transaction', 792, 'expense_bill', 0, '2024-05-02', 190, 177, 'Expense Bill Transaction', '3000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-10 11:21:23', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1083, 0, 'expense_bill_transaction', 793, 'expense_bill', 0, '2024-05-02', 190, 177, 'Expense Bill Transaction', '8000', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-10 11:22:00', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1084, 0, 'expense_bill_transaction', 794, 'expense_bill', 0, '2024-05-02', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-10 11:22:43', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1085, 0, 'expense_bill_transaction', 795, 'expense_bill', 0, '2024-05-02', 190, 177, 'Expense Bill Transaction', '9400', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-10 11:23:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1086, 0, 'expense_bill_transaction', 796, 'expense_bill', 0, '2024-05-02', 190, 180, 'Expense Bill Transaction', '1200', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-10 11:24:11', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1087, 0, 'expense_bill_transaction', 797, 'expense_bill', 0, '2024-04-07', 190, 192, 'Expense Bill Transaction', '300', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-10 15:16:18', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1088, 0, 'expense_bill_transaction', 798, 'expense_bill', 0, '2024-04-08', 190, 181, 'Expense Bill Transaction', '2756', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-10 15:17:25', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1089, 0, 'expense_bill_transaction', 799, 'expense_bill', 0, '2024-04-08', 190, 181, 'Expense Bill Transaction', '2756', 0, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-10 15:18:20', 1, '0000-00-00 00:00:00', 0, 1, 1, 0);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1090, 0, 'purchase_bill_transaction', 102, 'purchase_bill', 0, '2024-04-08', 190, 5, 'Purchase Bill Transaction', '3270', 1, 'CASH', '', '0000-00-00', '', 0, 14, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-10 15:29:17', 1, '0000-00-00 00:00:00', 0, 1, 1, 1);
INSERT INTO `account_transactions` (`transaction_id`, `tr_branch_id`, `tr_type`, `reference_id`, `reference_type`, `invoice_id`, `tr_date`, `tr_debit_acc`, `tr_credit_acc`, `tr_description`, `tr_amount`, `tr_payment_part`, `tr_mode`, `tr_reference_no`, `tr_reference_date`, `tr_remarks`, `tr_work_id`, `tr_project_stage_id`, `tr_other_data`, `tr_copy_from`, `tr_group_id`, `tax_inclusive`, `taxable_amount`, `tax_percent`, `tax_amount`, `tr_file_attachment`, `temporary_transaction`, `created_date`, `created_by`, `updated_date`, `updated_by`, `tr_entry_approval_status`, `tr_entry_approval_status_2`, `delete_status`) VALUES (1091, 0, 'purchase_bill_transaction', 102, 'purchase_bill', 0, '2024-04-08', 190, 5, 'Purchase Bill Transaction', '4620', 2, 'CASH', '', '0000-00-00', '', 0, 0, '', 0, 0, 0, '0', '0', '0', '', 0, '2024-05-10 15